<?php
// ------------------------------------------------ 
// ---------- Options Framework Theme -------------
// ------------------------------------------------
 require_once ('admin/index.php'); 

// ---------------------------------------------- 
// --------------- Load Custom Widgets ----------
// ----------------------------------------------
 include( get_template_directory() . '/functions/widgets.php');
 include( get_template_directory() . '/functions/widgets/widget-tags.php');
 include( get_template_directory() . '/functions/widgets/widget-posts.php');
 include( get_template_directory() . '/functions/widgets/widget-top-posts.php');
 include( get_template_directory() . '/functions/widgets/widget-cat.php');
 include( get_template_directory() . '/functions/widgets/widget-feedburner.php');
 include( get_template_directory() . '/functions/widgets/widget-review.php');
 include( get_template_directory() . '/functions/widgets/widget-review-rand.php');
 include( get_template_directory() . '/functions/widgets/widget-review-recent.php');
 include( get_template_directory() . '/functions/widgets/widget-categories.php');
 include( get_template_directory() . '/functions/widgets/widget-banner.php');
 include( get_template_directory() . '/functions/widgets/widget-top-posts-30days.php');

// ----------------------------------------------
// --------------- Load Custom ------------------
// ---------------------------------------------- 
 include( get_template_directory() . '/functions/custom/comments.php');
  
// ----------------------------------------------
// ------ Content width -------------------------
// ----------------------------------------------
if ( ! isset( $content_width ) ) $content_width = 950;

// ----------------------------------------------
// ------ Theme setup ---------------------------
// ----------------------------------------------
add_action( 'after_setup_theme', 'multicote_wp_theme_setup' );
if ( !function_exists('multicote_wp_theme_setup') ) {

    function multicote_wp_theme_setup() {
    
        // Register navigation menu
        register_nav_menus(
            array(
                'multicote-wp-primary-menu' => esc_html__( 'Header Navigation', 'multicote-wp' ),
                'multicote-wp-secondary-menu' => esc_html__( 'Categories Navigation', 'multicote-wp' ),
                'multicote-wp-tertiary-menu' => esc_html__( 'Categories Carousel Navigation', 'multicote-wp' )
            )
        );
        
        // Localization support
        load_theme_textdomain( 'multicote-wp', get_template_directory() . '/languages' );
        
        // Feed Links
        add_theme_support( 'automatic-feed-links' );
        
        // Title Tag
        add_theme_support( 'title-tag' );

        // Post thumbnails
        add_theme_support( 'post-thumbnails' );
        add_image_size( 'multicote-wp-thumbnail-blog-small', 180, 180, true ); // Blog thumbnails home small
        add_image_size( 'multicote-wp-thumbnail-blog-big', 620, 280, true ); // Blog thumbnails home big
        add_image_size( 'multicote-wp-thumbnail-blog-featured', 275, 150, true ); // Blog thumbnails home featured posts
        add_image_size( 'multicote-wp-thumbnail-blog-masonry', 250, '', true ); // Blog thumbnails home masonry style
        add_image_size( 'multicote-wp-thumbnail-widget', 250, 130, true ); // Sidebar Widget thumbnails
        add_image_size( 'multicote-wp-thumbnail-widget-small', 55, 55, true ); // Sidebar Widget thumbnails small
        add_image_size( 'multicote-wp-thumbnail-single-image', 950, '', true ); // Single thumbnails
    }
}

// ----------------------------------------------
// ------------ JavaScrips Files ----------------
// ----------------------------------------------
if( !function_exists( 'multicote_wp_enqueue_scripts' ) ) {
    function multicote_wp_enqueue_scripts() {

        // Register css files
        wp_enqueue_style( 'multicote-wp-style', get_stylesheet_uri(), '', '3.3');
        wp_enqueue_style( 'multicote-wp-default', get_template_directory_uri() . '/css/colors/default.css', array( 'multicote-wp-style' ), '3.3' );
        wp_enqueue_style( 'multicote-wp-responsive', get_template_directory_uri() . '/css/responsive.css', array( 'multicote-wp-style' ), '3.3' );
        wp_enqueue_style( 'fontawesome', get_template_directory_uri() . '/css/fontawesome-free-5.14.0-web/css/all.min.css', array(), '5.14.0' );
        wp_enqueue_style( 'icofont', get_template_directory_uri() . '/css/icofont/icofont.min.css', array(), '1.0.1' );
        wp_enqueue_style( 'jquery-owl-carousel', get_template_directory_uri() . '/owl-carousel/owl.carousel.css', array(), '2.0.0' );

        // Register scripts
        wp_enqueue_script( 'multicote-wp-customjs', get_template_directory_uri() . '/js/custom.js', array( 'jquery' ), '1.0', true );
        wp_enqueue_script( 'jquery-masonry',  get_template_directory_uri() . '/js/masonry.pkgd.js', array( 'jquery' ), '3.1.2', true );
        wp_enqueue_script( 'jquery-bxslider',  get_template_directory_uri() . '/js/jquery.bxslider.js', array( 'jquery' ), '4.2.12', true );
        wp_enqueue_script( 'jquery-owl-carousel', get_template_directory_uri() . '/owl-carousel/owl.carousel.min.js', array( 'jquery' ), '2.0', true );
        $multicote_wp_js_custom = array( 'template_url' => get_template_directory_uri('template_url') ); wp_localize_script( 'multicote-wp-customjs', 'multicote_wp_js_custom', $multicote_wp_js_custom );

        // Load Comments & .js files.
        if( is_single() ) {
            wp_enqueue_script( 'fslightbox-basic', get_template_directory_uri() . '/functions/fslightbox-basic-3.2.1/fslightbox.js', array( 'jquery' ), '3.2.1', true );  
            wp_enqueue_script( 'comment-reply' );
         }

// ----------------------------------------------
// Register Fonts: https://gist.github.com/kailoon/e2dc2a04a8bd5034682c
// ----------------------------------------------
        function multicote_wp_fonts_url() {
            $multicote_wp_font_url_google = '';
            
            /*
            Translators: If there are characters in your language that are not supported
            by chosen font(s), translate this to 'off'. Do not translate into your own language.
             */
            if ( 'off' !== _x( 'on', 'Google font: on or off', 'multicote-wp' ) ) {
                $multicote_wp_font_url_google = add_query_arg( 'family', urlencode( 'Ruda:400,700|Baloo Bhaina' ), "//fonts.googleapis.com/css" );
            }
            return $multicote_wp_font_url_google;
        }
        /* -- Enqueue styles -- */
        wp_enqueue_style( 'multicote_wp_fonts', multicote_wp_fonts_url(), array(), '1.0.0' );
  

    }
    add_action('wp_enqueue_scripts', 'multicote_wp_enqueue_scripts');
}

// ----------------------------------------------
// ---------- Declaring WooCommerce -------------
// ----------------------------------------------
function multicote_wp_add_woocommerce_support() {
    add_theme_support( 'woocommerce' );
}
add_action( 'after_setup_theme', 'multicote_wp_add_woocommerce_support' );
 

// ----------------------------------------------
// ---------- excerpt length adjust -------------
// ----------------------------------------------
function multicote_wp_excerpt($str, $length, $minword = 3) {
    $sub = '';
    $len = 0;
    foreach (explode(' ', $str) as $word) {
        $part = (($sub != '') ? ' ' : '') . $word;
        $sub .= $part;
        $len += strlen($part);
        if (strlen($word) > $minword && strlen($sub) >= $length) { break; }
    }
    return $sub . (($len < strlen($str)) ? ' ..' : '');
}


// ------------------------------------------------ 
// ------------ Notice ----------------------------
// ------------------------------------------------
function themes_admin_notice(){
    global $pagenow;
    if ( $pagenow == 'themes.php' ) {
         echo '<div class="notice notice-info is-dismissible" style="box-shadow: 0 1px 5px rgba(0,0,0,0.2); ">
             <p><a class="button" href="https://anthemes.com/" target="_blank">Anthemes.com</a> <a class="button activate" href="https://themeforest.net/item/multicote-magazine-and-woocommerce-wordpress-theme/21534270" target="_blank">Multicote Theme</a> <a class="button activate" href="https://themeforest.net/item/multicote-magazine-and-woocommerce-wordpress-theme/21534270/support" target="_blank">Get Support</a></p>
         </div>';
    }
}
add_action('admin_notices', 'themes_admin_notice');


// ------------------------------------------------ 
// ---------- TGM_Plugin_Activation -------------
// ------------------------------------------------ 
 include( get_template_directory() . '/functions/custom/class-tgm-plugin-activation.php');
 add_action( 'tgmpa_register', 'multicote_wp_register_required_plugins' );

function multicote_wp_register_required_plugins() {

    $plugins = array(
        array(
            'name'                  => esc_html__( 'Multicote Theme Core', 'multicote-wp' ), // The plugin name
            'slug'                  => 'multicote-wp-options', // The plugin slug (typically the folder name)
            'source'                => get_template_directory() . '/plugins/multicote-wp-options.zip', // The plugin source
            'required'              => true, // If false, the plugin is only 'recommended' instead of required
            'version'               => '1.1', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
            'force_activation'      => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
            'force_deactivation'    => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
            'external_url'          => '', // If set, overrides default API URL and points to an external URL
        ),

         array(
            'name'                  => esc_html__( 'Shortcodes', 'multicote-wp' ), // The plugin name
            'slug'                  => 'anthemes-shortcodes', // The plugin slug (typically the folder name)
            'source'                => get_template_directory() . '/plugins/anthemes-shortcodes.zip', // The plugin source
            'required'              => false, // If false, the plugin is only 'recommended' instead of required
            'version'               => '1.2', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
            'force_activation'      => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
            'force_deactivation'    => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
            'external_url'          => '', // If set, overrides default API URL and points to an external URL
        ),

        array(
            'name'                  => esc_html__( 'Reviews', 'multicote-wp' ), // The plugin name
            'slug'                  => 'anthemes-reviews', // The plugin slug (typically the folder name)
            'source'                => get_template_directory() . '/plugins/anthemes-reviews.zip', // The plugin source
            'required'              => false, // If false, the plugin is only 'recommended' instead of required
            'version'               => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
            'force_activation'      => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
            'force_deactivation'    => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
            'external_url'          => '', // If set, overrides default API URL and points to an external URL
        ),

        array(
            'name'                  => esc_html__( 'Thumbs Likes System', 'multicote-wp' ), // The plugin name
            'slug'                  => 'thumbs-rating', // The plugin slug (typically the folder name)
            'source'                => get_template_directory() . '/plugins/thumbs-rating.zip', // The plugin source
            'required'              => false, // If false, the plugin is only 'recommended' instead of required
            'version'               => '10.1', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
            'force_activation'      => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
            'force_deactivation'    => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
            'external_url'          => '', // If set, overrides default API URL and points to an external URL
        ),

        array(
            'name'                  => esc_html__( 'Responsive Menu', 'multicote-wp' ), // The plugin name
            'slug'                  => 'responsive-menu', // The plugin slug (typically the folder name)
            'source'                => get_template_directory() . '/plugins/responsive-menu.zip', // The plugin source
            'required'              => false, // If false, the plugin is only 'recommended' instead of required
            'version'               => '6.1.4', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
            'force_activation'      => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
            'force_deactivation'    => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
            'external_url'          => '', // If set, overrides default API URL and points to an external URL
        ),

        array(
            'name'                  => esc_html__( 'Meta Box', 'multicote-wp' ),
            'slug'                  => 'meta-box',
            'required'              => true,
            'version'               => '',
        ),

        array(
            'name'                  => esc_html__( 'Custom Sidebars', 'multicote-wp' ),
            'slug'                  => 'custom-sidebars',
            'required'              => false,
            'version'               => '',
        ),

        array(
            'name'                  => esc_html__( 'Daves WordPress Live Search', 'multicote-wp' ),
            'slug'                  => 'daves-wordpress-live-search',
            'required'              => false,
            'version'               => '',
        ),

        array(
            'name'                  => esc_html__( 'Multi-column Tag Map', 'multicote-wp' ),
            'slug'                  => 'multi-column-tag-map',
            'required'              => false,
            'version'               => '',
        ), 

        array(
            'name'                  => esc_html__( 'Cresta Social Share Counter', 'multicote-wp' ),
            'slug'                  => 'cresta-social-share-counter',
            'required'              => false,
            'version'               => '',
        ),

        array(
            'name'                  => esc_html__( 'AccessPress Anonymous Post', 'multicote-wp' ),
            'slug'                  => 'accesspress-anonymous-post',
            'required'              => false,
            'version'               => '',
        ),
        
        array(
            'name'                  => esc_html__( 'WP-PageNavi', 'multicote-wp' ),
            'slug'                  => 'wp-pagenavi',
            'required'              => false,
            'version'               => '',
        ),

        array(
            'name'                  => esc_html__( 'WooCommerce', 'multicote-wp' ),
            'slug'                  => 'woocommerce',
            'required'              => false,
            'version'               => '',
        ),
 
    );

    $config = array(
        'id'           => 'tgmpa',                 // Unique ID for hashing notices for multiple instances of TGMPA.
        'default_path' => '',                      // Default absolute path to bundled plugins.
        'menu'         => 'tgmpa-install-plugins', // Menu slug.
        'parent_slug'  => 'themes.php',            // Parent menu slug.
        'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
        'has_notices'  => true,                    // Show admin notices or not.
        'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false,                   // Automatically activate plugins after installation or not.
        'message'      => '',                      // Message to output right before the plugins table.

    );

    tgmpa( $plugins, $config );

}

?>