<?php
$options   = [];
$options[] = array(
	'default'     => '',
	'label'       => __( 'JSON API File', 'soledad' ),
	'description' => __( 'This plugin uses the Google Cloud Text-to-Speech API Key File. Set up your <a target="_blank" href="https://console.cloud.google.com/cloud-resource-manager">Google Cloud Platform</a> project before the start.', 'soledad' ),
	'id'          => 'penci_texttospeech_api_key',
	'type'        => 'soledad-fw-upload',
	'priority'    => 1,
);
$options[] = array(
	'id'       => 'penci_texttospeech_enabled_post_types',
	'sanitize' => 'penci_sanitize_multiple_checkbox',
	'label'    => __( 'Enable Support in Post Types', 'soledad' ),
	'type'     => 'soledad-fw-select',
	'multiple' => 999,
	'choices'  => call_user_func( function () {
		$types      = array();
		$exclude    = array(
			'attachment',
			'revision',
			'nav_menu_item',
			'safecss',
			'penci-block',
			'penci_builder',
			'custom-post-template',
			'archive-template',
		);
		$registered = get_post_types( [ 'show_in_nav_menus' => true ], 'objects' );


		foreach ( $registered as $post ) {

			if ( in_array( $post->name, $exclude ) ) {

				continue;
			}

			$types[ $post->name ] = $post->label;
		}

		return $types;
	} )
);

$options[] = array(
	'default'     => 'en-US-Standard-D',
	'label'       => __( 'Voices', 'soledad' ),
	'description' => __( 'The list includes Standard, WaveNet and Neural2 voice types <a href="https://cloud.google.com/text-to-speech/docs/wavenet" target="_blank" title="voice types">voice types</a>. WaveNet and Neural2 voices are higher quality voices at a different <a href="https://cloud.google.com/text-to-speech/pricing" target="_blank" title="pricing">pricing</a>.', 'soledad' ),
	'id'          => 'penci_texttospeech_language_name',
	'type'        => 'soledad-fw-select',
	'priority'    => 1,
	'choices'     => [
		'ro-RO-Wavenet-A'   => 'Romanian (Română) - WaveNet - A - Female',
		'ar-XA-Wavenet-A'   => 'Arabic (العربية) - WaveNet - A - Female',
		'ar-XA-Wavenet-B'   => 'Arabic (العربية) - WaveNet - B - Male',
		'ar-XA-Wavenet-C'   => 'Arabic (العربية) - WaveNet - C - Male',
		'ar-XA-Wavenet-D'   => 'Arabic (العربية) - WaveNet - D - Female',
		'bn-IN-Wavenet-A'   => 'Bengali (বাংলা) - WaveNet - A - Female',
		'bn-IN-Wavenet-B'   => 'Bengali (বাংলা) - WaveNet - B - Male',
		'en-GB-Wavenet-A'   => 'English (UK) - WaveNet - A - Female',
		'en-GB-Wavenet-B'   => 'English (UK) - WaveNet - B - Male',
		'en-GB-Wavenet-C'   => 'English (UK) - WaveNet - C - Female',
		'en-GB-Wavenet-D'   => 'English (UK) - WaveNet - D - Male',
		'en-GB-Wavenet-F'   => 'English (UK) - WaveNet - F - Female',
		'fr-CA-Wavenet-A'   => 'French Canada (Français) - WaveNet - A - Female',
		'fr-CA-Wavenet-B'   => 'French Canada (Français) - WaveNet - B - Male',
		'fr-CA-Wavenet-C'   => 'French Canada (Français) - WaveNet - C - Female',
		'fr-CA-Wavenet-D'   => 'French Canada (Français) - WaveNet - D - Male',
		'en-US-Wavenet-G'   => 'English (US) - WaveNet - G - Female',
		'en-US-Wavenet-H'   => 'English (US) - WaveNet - H - Female',
		'en-US-Wavenet-I'   => 'English (US) - WaveNet - I - Male',
		'en-US-Wavenet-J'   => 'English (US) - WaveNet - J - Male',
		'en-US-Wavenet-A'   => 'English (US) - WaveNet - A - Male',
		'en-US-Wavenet-B'   => 'English (US) - WaveNet - B - Male',
		'en-US-Wavenet-C'   => 'English (US) - WaveNet - C - Female',
		'en-US-Wavenet-D'   => 'English (US) - WaveNet - D - Male',
		'en-US-Wavenet-E'   => 'English (US) - WaveNet - E - Female',
		'en-US-Wavenet-F'   => 'English (US) - WaveNet - F - Female',
		'es-ES-Wavenet-C'   => 'Spanish (Español) - WaveNet - C - Female',
		'es-ES-Wavenet-D'   => 'Spanish (Español) - WaveNet - D - Female',
		'es-ES-Wavenet-B'   => 'Spanish (Español) - WaveNet - B - Male',
		'fi-FI-Wavenet-A'   => 'Finnish (Suomi) - WaveNet - A - Female',
		'gu-IN-Wavenet-A'   => 'Gujarati (ગુજરાતી) - WaveNet - A - Female',
		'gu-IN-Wavenet-B'   => 'Gujarati (ગુજરાતી) - WaveNet - B - Male',
		'ja-JP-Wavenet-B'   => 'Japanese (日本語) - WaveNet - B - Female',
		'ja-JP-Wavenet-C'   => 'Japanese (日本語) - WaveNet - C - Male',
		'ja-JP-Wavenet-D'   => 'Japanese (日本語) - WaveNet - D - Male',
		'ja-JP-Wavenet-A'   => 'Japanese (日本語) - WaveNet - A - Female',
		'kn-IN-Wavenet-A'   => 'Kannada (ಕನ್ನಡ) - WaveNet - A - Female',
		'kn-IN-Wavenet-B'   => 'Kannada (ಕನ್ನಡ) - WaveNet - B - Male',
		'ml-IN-Wavenet-A'   => 'Malayalam (മലയാളം) - WaveNet - A - Female',
		'ml-IN-Wavenet-B'   => 'Malayalam (മലയാളം) - WaveNet - B - Male',
		'mr-IN-Wavenet-A'   => 'Marathi (India) - WaveNet - A - Female',
		'mr-IN-Wavenet-B'   => 'Marathi (India) - WaveNet - B - Male',
		'mr-IN-Wavenet-C'   => 'Marathi (India) - WaveNet - C - Female',
		'sv-SE-Wavenet-A'   => 'Swedish (Svenska) - WaveNet - A - Female',
		'sv-SE-Wavenet-B'   => 'Swedish (Svenska) - WaveNet - B - Female',
		'sv-SE-Wavenet-C'   => 'Swedish (Svenska) - WaveNet - C - Male',
		'sv-SE-Wavenet-D'   => 'Swedish (Svenska) - WaveNet - D - Female',
		'sv-SE-Wavenet-E'   => 'Swedish (Svenska) - WaveNet - E - Male',
		'ta-IN-Wavenet-A'   => 'Tamil (தமிழ்) - WaveNet - A - Female',
		'ta-IN-Wavenet-B'   => 'Tamil (தமிழ்) - WaveNet - B - Male',
		'ta-IN-Wavenet-C'   => 'Tamil (தமிழ்) - WaveNet - C - Female',
		'ta-IN-Wavenet-D'   => 'Tamil (தமிழ்) - WaveNet - D - Male',
		'tr-TR-Wavenet-B'   => 'Turkish (Türkçe) - WaveNet - B - Male',
		'tr-TR-Wavenet-C'   => 'Turkish (Türkçe) - WaveNet - C - Female',
		'tr-TR-Wavenet-D'   => 'Turkish (Türkçe) - WaveNet - D - Female',
		'tr-TR-Wavenet-E'   => 'Turkish (Türkçe) - WaveNet - E - Male',
		'tr-TR-Wavenet-A'   => 'Turkish (Türkçe) - WaveNet - A - Female',
		'ms-MY-Wavenet-A'   => 'Malay (Malaysia) - WaveNet - A - Female',
		'ms-MY-Wavenet-B'   => 'Malay (Malaysia) - WaveNet - B - Male',
		'ms-MY-Wavenet-C'   => 'Malay (Malaysia) - WaveNet - C - Female',
		'ms-MY-Wavenet-D'   => 'Malay (Malaysia) - WaveNet - D - Male',
		'pa-IN-Wavenet-A'   => 'Punjabi (India) - WaveNet - A - Female',
		'pa-IN-Wavenet-B'   => 'Punjabi (India) - WaveNet - B - Male',
		'pa-IN-Wavenet-C'   => 'Punjabi (India) - WaveNet - C - Female',
		'pa-IN-Wavenet-D'   => 'Punjabi (India) - WaveNet - D - Male',
		'cs-CZ-Wavenet-A'   => 'Czech (Čeština) - WaveNet - A - Female',
		'de-DE-Wavenet-F'   => 'German (Deutsch) - WaveNet - F - Female',
		'de-DE-Wavenet-A'   => 'German (Deutsch) - WaveNet - A - Female',
		'de-DE-Wavenet-B'   => 'German (Deutsch) - WaveNet - B - Male',
		'de-DE-Wavenet-C'   => 'German (Deutsch) - WaveNet - C - Female',
		'de-DE-Wavenet-D'   => 'German (Deutsch) - WaveNet - D - Male',
		'de-DE-Wavenet-E'   => 'German (Deutsch) - WaveNet - E - Male',
		'en-AU-Wavenet-A'   => 'English (Australian) - WaveNet - A - Female',
		'en-AU-Wavenet-B'   => 'English (Australian) - WaveNet - B - Male',
		'en-AU-Wavenet-C'   => 'English (Australian) - WaveNet - C - Female',
		'en-AU-Wavenet-D'   => 'English (Australian) - WaveNet - D - Male',
		'en-IN-Wavenet-D'   => 'Indian English - WaveNet - D - Female',
		'en-IN-Wavenet-A'   => 'Indian English - WaveNet - A - Female',
		'en-IN-Wavenet-B'   => 'Indian English - WaveNet - B - Male',
		'en-IN-Wavenet-C'   => 'Indian English - WaveNet - C - Male',
		'es-US-Wavenet-A'   => 'US Spanish (Hispanoamericano) - WaveNet - A - Female',
		'es-US-Wavenet-B'   => 'US Spanish (Hispanoamericano) - WaveNet - B - Male',
		'es-US-Wavenet-C'   => 'US Spanish (Hispanoamericano) - WaveNet - C - Male',
		'fr-FR-Wavenet-E'   => 'French France (Français) - WaveNet - E - Female',
		'fr-FR-Wavenet-A'   => 'French France (Français) - WaveNet - A - Female',
		'fr-FR-Wavenet-B'   => 'French France (Français) - WaveNet - B - Male',
		'fr-FR-Wavenet-C'   => 'French France (Français) - WaveNet - C - Female',
		'fr-FR-Wavenet-D'   => 'French France (Français) - WaveNet - D - Male',
		'hi-IN-Wavenet-D'   => 'Hindi (हिन्दी) - WaveNet - D - Female',
		'hi-IN-Wavenet-A'   => 'Hindi (हिन्दी) - WaveNet - A - Female',
		'hi-IN-Wavenet-B'   => 'Hindi (हिन्दी) - WaveNet - B - Male',
		'hi-IN-Wavenet-C'   => 'Hindi (हिन्दी) - WaveNet - C - Male',
		'id-ID-Wavenet-D'   => 'Indonesian (Bahasa Indonesia) - WaveNet - D - Female',
		'id-ID-Wavenet-A'   => 'Indonesian (Bahasa Indonesia) - WaveNet - A - Female',
		'id-ID-Wavenet-B'   => 'Indonesian (Bahasa Indonesia) - WaveNet - B - Male',
		'id-ID-Wavenet-C'   => 'Indonesian (Bahasa Indonesia) - WaveNet - C - Male',
		'it-IT-Wavenet-A'   => 'Italian (Italiano) - WaveNet - A - Female',
		'it-IT-Wavenet-B'   => 'Italian (Italiano) - WaveNet - B - Female',
		'it-IT-Wavenet-C'   => 'Italian (Italiano) - WaveNet - C - Male',
		'it-IT-Wavenet-D'   => 'Italian (Italiano) - WaveNet - D - Male',
		'ko-KR-Wavenet-A'   => 'Korean (한국어) - WaveNet - A - Female',
		'ko-KR-Wavenet-B'   => 'Korean (한국어) - WaveNet - B - Female',
		'ko-KR-Wavenet-C'   => 'Korean (한국어) - WaveNet - C - Male',
		'ko-KR-Wavenet-D'   => 'Korean (한국어) - WaveNet - D - Male',
		'ru-RU-Wavenet-E'   => 'Russian (Русский) - WaveNet - E - Female',
		'ru-RU-Wavenet-A'   => 'Russian (Русский) - WaveNet - A - Female',
		'ru-RU-Wavenet-B'   => 'Russian (Русский) - WaveNet - B - Male',
		'ru-RU-Wavenet-C'   => 'Russian (Русский) - WaveNet - C - Female',
		'ru-RU-Wavenet-D'   => 'Russian (Русский) - WaveNet - D - Male',
		'uk-UA-Wavenet-A'   => 'Ukrainian (Українська) - WaveNet - A - Female',
		'cmn-CN-Wavenet-A'  => 'Chinese (官话) - WaveNet - A - Female',
		'cmn-CN-Wavenet-B'  => 'Chinese (官话) - WaveNet - B - Male',
		'cmn-CN-Wavenet-C'  => 'Chinese (官话) - WaveNet - C - Male',
		'cmn-CN-Wavenet-D'  => 'Chinese (官话) - WaveNet - D - Female',
		'cmn-TW-Wavenet-A'  => 'Taiwanese Mandarin (中文(台灣)) - WaveNet - A - Female',
		'cmn-TW-Wavenet-B'  => 'Taiwanese Mandarin (中文(台灣)) - WaveNet - B - Male',
		'cmn-TW-Wavenet-C'  => 'Taiwanese Mandarin (中文(台灣)) - WaveNet - C - Male',
		'da-DK-Wavenet-C'   => 'Danish (Dansk) - WaveNet - C - Male',
		'da-DK-Wavenet-D'   => 'Danish (Dansk) - WaveNet - D - Female',
		'da-DK-Wavenet-E'   => 'Danish (Dansk) - WaveNet - E - Female',
		'da-DK-Wavenet-A'   => 'Danish (Dansk) - WaveNet - A - Female',
		'el-GR-Wavenet-A'   => 'Greek (Ελληνικά) - WaveNet - A - Female',
		'fil-PH-Wavenet-A'  => 'Philippines (Filipino) - WaveNet - A - Female',
		'fil-PH-Wavenet-B'  => 'Philippines (Filipino) - WaveNet - B - Female',
		'fil-PH-Wavenet-C'  => 'Philippines (Filipino) - WaveNet - C - Male',
		'fil-PH-Wavenet-D'  => 'Philippines (Filipino) - WaveNet - D - Male',
		'hu-HU-Wavenet-A'   => 'Hungarian (Magyar) - WaveNet - A - Female',
		'nb-NO-Wavenet-A'   => 'Norwegian (Norsk) - WaveNet - A - Female',
		'nb-NO-Wavenet-B'   => 'Norwegian (Norsk) - WaveNet - B - Male',
		'nb-NO-Wavenet-C'   => 'Norwegian (Norsk) - WaveNet - C - Female',
		'nb-NO-Wavenet-D'   => 'Norwegian (Norsk) - WaveNet - D - Male',
		'nb-NO-Wavenet-E'   => 'Norwegian (Norsk) - WaveNet - E - Female',
		'nl-BE-Wavenet-A'   => 'Dutch (Belgium) - WaveNet - A - Female',
		'nl-BE-Wavenet-B'   => 'Dutch (Belgium) - WaveNet - B - Male',
		'nl-NL-Wavenet-B'   => 'Dutch (Nederlands) - WaveNet - B - Male',
		'nl-NL-Wavenet-C'   => 'Dutch (Nederlands) - WaveNet - C - Male',
		'nl-NL-Wavenet-D'   => 'Dutch (Nederlands) - WaveNet - D - Female',
		'nl-NL-Wavenet-A'   => 'Dutch (Nederlands) - WaveNet - A - Female',
		'nl-NL-Wavenet-E'   => 'Dutch (Nederlands) - WaveNet - E - Female',
		'pt-PT-Wavenet-A'   => 'Portuguese Portugal (Portugal) - WaveNet - A - Female',
		'pt-PT-Wavenet-B'   => 'Portuguese Portugal (Portugal) - WaveNet - B - Male',
		'pt-PT-Wavenet-C'   => 'Portuguese Portugal (Portugal) - WaveNet - C - Male',
		'pt-PT-Wavenet-D'   => 'Portuguese Portugal (Portugal) - WaveNet - D - Female',
		'sk-SK-Wavenet-A'   => 'Slovak (Slovenčina) - WaveNet - A - Female',
		'vi-VN-Wavenet-A'   => 'Vietnamese (Tiếng Việt) - WaveNet - A - Female',
		'vi-VN-Wavenet-B'   => 'Vietnamese (Tiếng Việt) - WaveNet - B - Male',
		'vi-VN-Wavenet-C'   => 'Vietnamese (Tiếng Việt) - WaveNet - C - Female',
		'vi-VN-Wavenet-D'   => 'Vietnamese (Tiếng Việt) - WaveNet - D - Male',
		'pl-PL-Wavenet-A'   => 'Polish (Polski) - WaveNet - A - Female',
		'pl-PL-Wavenet-B'   => 'Polish (Polski) - WaveNet - B - Male',
		'pl-PL-Wavenet-C'   => 'Polish (Polski) - WaveNet - C - Male',
		'pl-PL-Wavenet-E'   => 'Polish (Polski) - WaveNet - E - Female',
		'pl-PL-Wavenet-D'   => 'Polish (Polski) - WaveNet - D - Female',
		'pt-BR-Wavenet-A'   => 'Portuguese Brazil (Português) - WaveNet - A - Female',
		'pt-BR-Wavenet-B'   => 'Portuguese Brazil (Português) - WaveNet - B - Male',
		'pt-BR-Wavenet-C'   => 'Portuguese Brazil (Português) - WaveNet - C - Female',
		'en-AU-Standard-A'  => 'English (Australian) - Standard - A - Female',
		'en-AU-Standard-B'  => 'English (Australian) - Standard - B - Male',
		'en-AU-Standard-C'  => 'English (Australian) - Standard - C - Female',
		'en-AU-Standard-D'  => 'English (Australian) - Standard - D - Male',
		'en-GB-Standard-A'  => 'English (UK) - Standard - A - Female',
		'en-GB-Standard-B'  => 'English (UK) - Standard - B - Male',
		'en-GB-Standard-C'  => 'English (UK) - Standard - C - Female',
		'en-GB-Standard-D'  => 'English (UK) - Standard - D - Male',
		'en-GB-Standard-F'  => 'English (UK) - Standard - F - Female',
		'ca-ES-Standard-A'  => 'Catalan (Català) - Standard - A - Female',
		'es-ES-Standard-C'  => 'Spanish (Español) - Standard - C - Female',
		'es-ES-Standard-D'  => 'Spanish (Español) - Standard - D - Female',
		'es-ES-Standard-B'  => 'Spanish (Español) - Standard - B - Male',
		'en-US-Standard-A'  => 'English (US) - Standard - A - Male',
		'en-US-Standard-B'  => 'English (US) - Standard - B - Male',
		'en-US-Standard-C'  => 'English (US) - Standard - C - Female',
		'en-US-Standard-D'  => 'English (US) - Standard - D - Male',
		'en-US-Standard-E'  => 'English (US) - Standard - E - Female',
		'en-US-Standard-F'  => 'English (US) - Standard - F - Female',
		'en-US-Standard-G'  => 'English (US) - Standard - G - Female',
		'en-US-Standard-H'  => 'English (US) - Standard - H - Female',
		'en-US-Standard-I'  => 'English (US) - Standard - I - Male',
		'en-US-Standard-J'  => 'English (US) - Standard - J - Male',
		'ar-XA-Standard-A'  => 'Arabic (العربية) - Standard - A - Female',
		'ar-XA-Standard-B'  => 'Arabic (العربية) - Standard - B - Male',
		'ar-XA-Standard-C'  => 'Arabic (العربية) - Standard - C - Male',
		'ar-XA-Standard-D'  => 'Arabic (العربية) - Standard - D - Female',
		'ru-RU-Standard-E'  => 'Russian (Русский) - Standard - E - Female',
		'ru-RU-Standard-A'  => 'Russian (Русский) - Standard - A - Female',
		'ru-RU-Standard-B'  => 'Russian (Русский) - Standard - B - Male',
		'ru-RU-Standard-C'  => 'Russian (Русский) - Standard - C - Female',
		'ru-RU-Standard-D'  => 'Russian (Русский) - Standard - D - Male',
		'cmn-CN-Standard-C' => 'Chinese (官话) - Standard - C - Male',
		'cmn-CN-Standard-B' => 'Chinese (官话) - Standard - B - Male',
		'cmn-CN-Standard-A' => 'Chinese (官话) - Standard - A - Female',
		'cmn-CN-Standard-D' => 'Chinese (官话) - Standard - D - Female',
		'ja-JP-Standard-A'  => 'Japanese (日本語) - Standard - A - Female',
		'ja-JP-Standard-B'  => 'Japanese (日本語) - Standard - B - Female',
		'ja-JP-Standard-C'  => 'Japanese (日本語) - Standard - C - Male',
		'ja-JP-Standard-D'  => 'Japanese (日本語) - Standard - D - Male',
		'cmn-TW-Standard-A' => 'Taiwanese Mandarin (中文(台灣)) - Standard - A - Female',
		'cmn-TW-Standard-B' => 'Taiwanese Mandarin (中文(台灣)) - Standard - B - Male',
		'cmn-TW-Standard-C' => 'Taiwanese Mandarin (中文(台灣)) - Standard - C - Male',
		'ko-KR-Standard-B'  => 'Korean (한국어) - Standard - B - Female',
		'ko-KR-Standard-C'  => 'Korean (한국어) - Standard - C - Male',
		'ko-KR-Standard-D'  => 'Korean (한국어) - Standard - D - Male',
		'ko-KR-Standard-A'  => 'Korean (한국어) - Standard - A - Female',
		'vi-VN-Standard-A'  => 'Vietnamese (Tiếng Việt) - Standard - A - Female',
		'vi-VN-Standard-B'  => 'Vietnamese (Tiếng Việt) - Standard - B - Male',
		'vi-VN-Standard-C'  => 'Vietnamese (Tiếng Việt) - Standard - C - Female',
		'vi-VN-Standard-D'  => 'Vietnamese (Tiếng Việt) - Standard - D - Male',
		'ms-MY-Standard-A'  => 'Malay (Malaysia) - Standard - A - Female',
		'ms-MY-Standard-B'  => 'Malay (Malaysia) - Standard - B - Male',
		'ms-MY-Standard-C'  => 'Malay (Malaysia) - Standard - C - Female',
		'ms-MY-Standard-D'  => 'Malay (Malaysia) - Standard - D - Male',
		'id-ID-Standard-A'  => 'Indonesian (Bahasa Indonesia) - Standard - A - Female',
		'id-ID-Standard-B'  => 'Indonesian (Bahasa Indonesia) - Standard - B - Male',
		'id-ID-Standard-C'  => 'Indonesian (Bahasa Indonesia) - Standard - C - Male',
		'id-ID-Standard-D'  => 'Indonesian (Bahasa Indonesia) - Standard - D - Female',
		'nl-BE-Standard-A'  => 'Dutch (Belgium) - Standard - A - Female',
		'nl-BE-Standard-B'  => 'Dutch (Belgium) - Standard - B - Male',
		'nl-NL-Standard-B'  => 'Dutch (Nederlands) - Standard - B - Male',
		'nl-NL-Standard-C'  => 'Dutch (Nederlands) - Standard - C - Male',
		'nl-NL-Standard-D'  => 'Dutch (Nederlands) - Standard - D - Female',
		'nl-NL-Standard-A'  => 'Dutch (Nederlands) - Standard - A - Female',
		'nl-NL-Standard-E'  => 'Dutch (Nederlands) - Standard - E - Female',
		'fil-PH-Standard-A' => 'Philippines (Filipino) - Standard - A - Female',
		'fil-PH-Standard-B' => 'Philippines (Filipino) - Standard - B - Female',
		'fil-PH-Standard-C' => 'Philippines (Filipino) - Standard - C - Male',
		'fil-PH-Standard-D' => 'Philippines (Filipino) - Standard - D - Male',
		'yue-HK-Standard-A' => 'Yue Chinese - Standard - A - Female',
		'yue-HK-Standard-B' => 'Yue Chinese - Standard - B - Male',
		'yue-HK-Standard-C' => 'Yue Chinese - Standard - C - Female',
		'yue-HK-Standard-D' => 'Yue Chinese - Standard - D - Male',
		'cs-CZ-Standard-A'  => 'Czech (Čeština) - Standard - A - Female',
		'el-GR-Standard-A'  => 'Greek (Ελληνικά) - Standard - A - Female',
		'pt-BR-Standard-A'  => 'Portuguese Brazil (Português) - Standard - A - Female',
		'pt-BR-Standard-B'  => 'Portuguese Brazil (Português) - Standard - B - Male',
		'pt-BR-Standard-C'  => 'Portuguese Brazil (Português) - Standard - C - Female',
		'es-US-Standard-A'  => 'US Spanish (Hispanoamericano) - Standard - A - Female',
		'es-US-Standard-B'  => 'US Spanish (Hispanoamericano) - Standard - B - Male',
		'es-US-Standard-C'  => 'US Spanish (Hispanoamericano) - Standard - C - Male',
		'af-ZA-Standard-A'  => 'Afrikaans (South Africa) - Standard - A - Female',
		'bg-BG-Standard-A'  => 'Bulgarian (Български) - Standard - A - Female',
		'hu-HU-Standard-A'  => 'Hungarian (Magyar) - Standard - A - Female',
		'lv-LV-Standard-A'  => 'Latvian (Latvietis) - Standard - A - Male',
		'ro-RO-Standard-A'  => 'Romanian (Română) - Standard - A - Female',
		'sr-rs-Standard-A'  => 'Serbian (Cрпски) - Standard - A - Female',
		'uk-UA-Standard-A'  => 'Ukrainian (Українська) - Standard - A - Female',
		'pl-PL-Standard-A'  => 'Polish (Polski) - Standard - A - Female',
		'pl-PL-Standard-B'  => 'Polish (Polski) - Standard - B - Male',
		'pl-PL-Standard-C'  => 'Polish (Polski) - Standard - C - Male',
		'pl-PL-Standard-E'  => 'Polish (Polski) - Standard - E - Female',
		'pl-PL-Standard-D'  => 'Polish (Polski) - Standard - D - Female',
		'tr-TR-Standard-B'  => 'Turkish (Türkçe) - Standard - B - Male',
		'tr-TR-Standard-C'  => 'Turkish (Türkçe) - Standard - C - Female',
		'tr-TR-Standard-D'  => 'Turkish (Türkçe) - Standard - D - Female',
		'tr-TR-Standard-A'  => 'Turkish (Türkçe) - Standard - A - Female',
		'tr-TR-Standard-E'  => 'Turkish (Türkçe) - Standard - E - Male',
		'en-IN-Standard-D'  => 'Indian English - Standard - D - Female',
		'en-IN-Standard-A'  => 'Indian English - Standard - A - Female',
		'en-IN-Standard-B'  => 'Indian English - Standard - B - Male',
		'en-IN-Standard-C'  => 'Indian English - Standard - C - Male',
		'th-TH-Standard-A'  => 'Thai (ภาษาไทย) - Standard - A - Female',
		'bn-IN-Standard-A'  => 'Bengali (বাংলা) - Standard - A - Female',
		'bn-IN-Standard-B'  => 'Bengali (বাংলা) - Standard - B - Male',
		'gu-IN-Standard-A'  => 'Gujarati (ગુજરાતી) - Standard - A - Female',
		'gu-IN-Standard-B'  => 'Gujarati (ગુજરાતી) - Standard - B - Male',
		'hi-IN-Standard-D'  => 'Hindi (हिन्दी) - Standard - D - Female',
		'hi-IN-Standard-A'  => 'Hindi (हिन्दी) - Standard - A - Female',
		'hi-IN-Standard-B'  => 'Hindi (हिन्दी) - Standard - B - Male',
		'hi-IN-Standard-C'  => 'Hindi (हिन्दी) - Standard - C - Male',
		'kn-IN-Standard-A'  => 'Kannada (ಕನ್ನಡ) - Standard - A - Female',
		'kn-IN-Standard-B'  => 'Kannada (ಕನ್ನಡ) - Standard - B - Male',
		'ml-IN-Standard-A'  => 'Malayalam (മലയാളം) - Standard - A - Female',
		'ml-IN-Standard-B'  => 'Malayalam (മലയാളം) - Standard - B - Male',
		'ta-IN-Standard-C'  => 'Tamil (தமிழ்) - Standard - C - Female',
		'ta-IN-Standard-D'  => 'Tamil (தமிழ்) - Standard - D - Male',
		'ta-IN-Standard-A'  => 'Tamil (தமிழ்) - Standard - A - Female',
		'ta-IN-Standard-B'  => 'Tamil (தமிழ்) - Standard - B - Male',
		'te-IN-Standard-A'  => 'Telugu (తెలుగు) - Standard - A - Female',
		'te-IN-Standard-B'  => 'Telugu (తెలుగు) - Standard - B - Male',
		'mr-IN-Standard-A'  => 'Marathi (India) - Standard - A - Female',
		'mr-IN-Standard-B'  => 'Marathi (India) - Standard - B - Male',
		'mr-IN-Standard-C'  => 'Marathi (India) - Standard - C - Female',
		'pa-IN-Standard-A'  => 'Punjabi (India) - Standard - A - Female',
		'pa-IN-Standard-B'  => 'Punjabi (India) - Standard - B - Male',
		'pa-IN-Standard-C'  => 'Punjabi (India) - Standard - C - Female',
		'pa-IN-Standard-D'  => 'Punjabi (India) - Standard - D - Male',
		'da-DK-Standard-A'  => 'Danish (Dansk) - Standard - A - Female',
		'da-DK-Standard-C'  => 'Danish (Dansk) - Standard - C - Male',
		'da-DK-Standard-D'  => 'Danish (Dansk) - Standard - D - Female',
		'da-DK-Standard-E'  => 'Danish (Dansk) - Standard - E - Female',
		'is-IS-Standard-A'  => 'Icelandic (Íslensk) - Standard - A - Female',
		'nb-NO-Standard-A'  => 'Norwegian (Norsk) - Standard - A - Female',
		'nb-NO-Standard-B'  => 'Norwegian (Norsk) - Standard - B - Male',
		'nb-NO-Standard-C'  => 'Norwegian (Norsk) - Standard - C - Female',
		'nb-NO-Standard-D'  => 'Norwegian (Norsk) - Standard - D - Male',
		'nb-NO-Standard-E'  => 'Norwegian (Norsk) - Standard - E - Female',
		'pt-PT-Standard-A'  => 'Portuguese Portugal (Portugal) - Standard - A - Female',
		'pt-PT-Standard-B'  => 'Portuguese Portugal (Portugal) - Standard - B - Male',
		'pt-PT-Standard-C'  => 'Portuguese Portugal (Portugal) - Standard - C - Male',
		'pt-PT-Standard-D'  => 'Portuguese Portugal (Portugal) - Standard - D - Female',
		'sv-SE-Standard-B'  => 'Swedish (Svenska) - Standard - B - Female',
		'sv-SE-Standard-C'  => 'Swedish (Svenska) - Standard - C - Female',
		'sv-SE-Standard-D'  => 'Swedish (Svenska) - Standard - D - Male',
		'sv-SE-Standard-E'  => 'Swedish (Svenska) - Standard - E - Male',
		'sv-SE-Standard-A'  => 'Swedish (Svenska) - Standard - A - Female',
		'fr-FR-Standard-A'  => 'French France (Français) - Standard - A - Female',
		'fr-FR-Standard-B'  => 'French France (Français) - Standard - B - Male',
		'fr-FR-Standard-C'  => 'French France (Français) - Standard - C - Female',
		'fr-FR-Standard-D'  => 'French France (Français) - Standard - D - Male',
		'de-DE-Standard-A'  => 'German (Deutsch) - Standard - A - Female',
		'de-DE-Standard-B'  => 'German (Deutsch) - Standard - B - Male',
		'de-DE-Standard-C'  => 'German (Deutsch) - Standard - C - Female',
		'de-DE-Standard-D'  => 'German (Deutsch) - Standard - D - Male',
		'de-DE-Standard-E'  => 'German (Deutsch) - Standard - E - Male',
		'de-DE-Standard-F'  => 'German (Deutsch) - Standard - F - Female',
		'fr-CA-Standard-A'  => 'French Canada (Français) - Standard - A - Female',
		'fr-CA-Standard-B'  => 'French Canada (Français) - Standard - B - Male',
		'fr-CA-Standard-C'  => 'French Canada (Français) - Standard - C - Female',
		'fr-CA-Standard-D'  => 'French Canada (Français) - Standard - D - Male',
		'it-IT-Standard-B'  => 'Italian (Italiano) - Standard - B - Female',
		'it-IT-Standard-C'  => 'Italian (Italiano) - Standard - C - Male',
		'it-IT-Standard-D'  => 'Italian (Italiano) - Standard - D - Male',
		'it-IT-Standard-A'  => 'Italian (Italiano) - Standard - A - Female',
		'sk-SK-Standard-A'  => 'Slovak (Slovenčina) - Standard - A - Female',
		'fi-FI-Standard-A'  => 'Finnish (Suomi) - Standard - A - Female',
		'es-ES-Standard-A'  => 'Spanish (Español) - Standard - A - Female',
		'fr-FR-Standard-E'  => 'French France (Français) - Standard - E - Female',
		'de-DE-Neural2-F'   => 'German (Deutsch) - Neural - F - Female',
		'de-DE-Neural2-D'   => 'German (Deutsch) - Neural - D - Male',
		'en-AU-Neural2-A'   => 'English (Australian) - Neural - A - Female',
		'en-AU-Neural2-B'   => 'English (Australian) - Neural - B - Male',
		'en-AU-Neural2-C'   => 'English (Australian) - Neural - C - Female',
		'en-AU-Neural2-D'   => 'English (Australian) - Neural - D - Male',
		'en-GB-Neural2-A'   => 'English (UK) - Neural - A - Female',
		'en-GB-Neural2-B'   => 'English (UK) - Neural - B - Male',
		'en-GB-Neural2-C'   => 'English (UK) - Neural - C - Female',
		'en-GB-Neural2-D'   => 'English (UK) - Neural - D - Male',
		'en-GB-Neural2-F'   => 'English (UK) - Neural - F - Female',
		'en-US-Neural2-A'   => 'English (US) - Neural - A - Male',
		'en-US-Neural2-C'   => 'English (US) - Neural - C - Female',
		'en-US-Neural2-D'   => 'English (US) - Neural - D - Male',
		'en-US-Neural2-E'   => 'English (US) - Neural - E - Female',
		'en-US-Neural2-F'   => 'English (US) - Neural - F - Female',
		'en-US-Neural2-G'   => 'English (US) - Neural - G - Female',
		'en-US-Neural2-H'   => 'English (US) - Neural - H - Female',
		'en-US-Neural2-I'   => 'English (US) - Neural - I - Male',
		'en-US-Neural2-J'   => 'English (US) - Neural - J - Male',
		'es-US-Neural2-A'   => 'US Spanish (Hispanoamericano) - Neural - A - Female',
		'es-US-Neural2-B'   => 'US Spanish (Hispanoamericano) - Neural - B - Male',
		'es-US-Neural2-C'   => 'US Spanish (Hispanoamericano) - Neural - C - Male',
		'fr-CA-Neural2-A'   => 'French Canada (Français) - Neural - A - Female',
		'fr-CA-Neural2-B'   => 'French Canada (Français) - Neural - B - Male',
		'fr-FR-Neural2-A'   => 'French France (Français) - Neural - A - Female',
		'fr-FR-Neural2-B'   => 'French France (Français) - Neural - B - Male',
		'fr-FR-Neural2-C'   => 'French France (Français) - Neural - C - Female',
		'fr-FR-Neural2-D'   => 'French France (Français) - Neural - D - Male',
		'fr-FR-Neural2-E'   => 'French France (Français) - Neural - E - Female',
	]

);

$options[] = array(
	'default'     => 'wearable-class-device',
	'label'       => __( 'Audio Profile', 'soledad' ),
	'description' => __( 'Optimize the synthetic speech for playback on different types of hardware.', 'soledad' ),
	'id'          => 'penci_texttospeech_audio_profile',
	'type'        => 'soledad-fw-select',
	'priority'    => 1,
	'choices'     => array(
		'wearable-class-device'                 => esc_html__( 'Smart watches and other wearables', 'soledad' ),
		'handset-class-device'                  => esc_html__( 'Smartphones', 'soledad' ),
		'headphone-class-device'                => esc_html__( 'Earbuds or headphones', 'soledad' ),
		'small-bluetooth-speaker-class-device'  => esc_html__( 'Small home speakers', 'soledad' ),
		'medium-bluetooth-speaker-class-device' => esc_html__( 'Smart home speakers', 'soledad' ),
		'large-home-entertainment-class-device' => esc_html__( 'Home entertainment systems', 'soledad' ),
		'large-automotive-class-device'         => esc_html__( 'Car speakers', 'soledad' ),
		'telephony-class-application'           => esc_html__( 'Interactive Voice Response', 'soledad' ),
	)
);

$options[] = array(
	'default'     => 'mp3',
	'label'       => __( 'Audio Format', 'soledad' ),
	'description' => __( 'Select the format in which the audio will be sent. All recordings in other formats will become unavailable.', 'soledad' ),
	'id'          => 'penci_texttospeech_audio_format',
	'type'        => 'soledad-fw-select',
	'priority'    => 1,
	'choices'     => array(
		"mp3" => esc_html__( 'MP3', 'soledad' ),
		"wav" => esc_html__( 'WAV', 'soledad' ),
	)
);

$options[] = array(
	'default'  => 1,
	'label'    => __( 'Speaking Rate', 'soledad' ),
	'id'       => 'penci_texttospeech_speaking_rate',
	'type'     => 'soledad-fw-slider',
	'priority' => 1,
	'choices'  => array(
		"min"  => 0.25,
		"max"  => 4.0,
		"step" => 0.1,
	)
);

$options[] = array(
	'default'  => 0,
	'label'    => __( 'Pitch', 'soledad' ),
	'id'       => 'penci_texttospeech_pitch',
	'type'     => 'soledad-fw-slider',
	'priority' => 1,
	'choices'  => array(
		"min"  => - 20,
		"max"  => 20,
		"step" => 0.1,
	)
);

$options[] = array(
	'label'    => __( 'Add Schema Markup on Header', 'soledad' ),
	'id'       => 'penci_texttospeech_schema',
	'type'     => 'soledad-fw-toggle',
	'default'  => false,
	'sanitize' => 'penci_sanitize_checkbox_field'
);

$options[] = array(
	'label'    => __( 'Add Custom Content Before Audio', 'soledad' ),
	'id'       => 'penci_texttospeech_before_audio',
	'type'     => 'soledad-fw-textarea',
	'default'  => '',
	'sanitize' => 'penci_sanitize_choices_field'
);

$options[] = array(
	'label'    => __( 'Add Custom Content After Audio', 'soledad' ),
	'id'       => 'penci_texttospeech_after_audio',
	'type'     => 'soledad-fw-textarea',
	'default'  => '',
	'sanitize' => 'penci_sanitize_choices_field'
);

$options[] = array(
	'label'    => __( 'Read the Post Title & Sub Title', 'soledad' ),
	'id'       => 'penci_texttospeech_read_title',
	'type'     => 'soledad-fw-toggle',
	'default'  => true,
	'sanitize' => 'penci_sanitize_checkbox_field'
);

$options[] = array(
	'label'    => __( 'Read Image Caption', 'soledad' ),
	'id'       => 'penci_texttospeech_read_figcaption',
	'type'     => 'soledad-fw-toggle',
	'default'  => false,
	'sanitize' => 'penci_sanitize_checkbox_field'
);

$options[] = array(
	'label'    => __( 'Show Audio File on RSS Feed', 'soledad' ),
	'id'       => 'penci_texttospeech_podcasts_rss',
	'type'     => 'soledad-fw-toggle',
	'default'  => false,
	'sanitize' => 'penci_sanitize_checkbox_field'
);

$options[] = array(
	'label'       => __( 'Exclude Custom Selectors', 'soledad' ),
	'description' => __( 'Enter the div wrapper of the text area you want to excluded on the audio file. Example: .related-posts, .shorcode-output', 'soledad' ),
	'id'          => 'penci_texttospeech_excluded_html',
	'type'        => 'soledad-fw-textarea',
	'default'     => '',
	'sanitize'    => 'penci_sanitize_choices_field'
);

$options[] = array(
	'label'       => __( 'Ignore Shortcodes', 'soledad' ),
	'description' => __( 'Enter the shortcode you want to ignore on the audio file. Example: shortcode-1, shortcode-2, ...', 'soledad' ),
	'id'          => 'penci_texttospeech_excluded_shortcode',
	'type'        => 'soledad-fw-textarea',
	'default'     => '',
	'sanitize'    => 'penci_sanitize_choices_field'
);

$options[] = array(
	'label'       => __( 'RegEx Peplacements', 'soledad' ),
	'description' => __( 'Enter the regular expression to be replaced and on a new line write the term or SSML tag to be replaced.', 'soledad' ),
	'id'          => 'penci_texttospeech_regex',
	'type'        => 'soledad-fw-textarea',
	'default'     => '',
	'sanitize'    => 'penci_sanitize_choices_field'
);

return $options;