<?php
/*
Plugin Name: Multicote Theme Core
Plugin URL: http://www.anthemes.com
Description: Theme Functionality: Custom Style, Theme core, etc.
Version: 1.1
Author: An-Themes
Author URI: http://themeforest.net/user/An-Themes/portfolio
*/


// ------------------------------------------------ 
// ---- Exit if accessed directly -----------------
// ------------------------------------------------ 
if ( ! defined( 'ABSPATH' ) ) exit; 


// ------------------------------------------------ 
// ---- Display custom color CSS ------------------
// ------------------------------------------------ 
$theme = wp_get_theme(); // gets the current theme
if ( 'Multicote WP' == $theme->name || 'Multicote WP' == $theme->parent_theme ) {
    function multicote_wp_colors_css_wrap() {
        require_once( dirname(__FILE__) . '/css/custom-style.php' );
    ?>
    <style type="text/css"><?php echo multicote_wp_custom_colors_css(); ?></style>
    <?php }
    add_action( 'wp_head', 'multicote_wp_colors_css_wrap' );
}


// ------------------------------------------------
// ---- Add  rel attributes to embedded images ----
// ------------------------------------------------ 
function insert_rel_multicote_wp($content) {
    $pattern = '/<a(.*?)href="(.*?).(bmp|gif|jpeg|jpg|png)"(.*?)>/i';
    $replacement = '<a$1href="$2.$3" class=\'wp-img-bg-off\' rel=\'mygallery\'$4>';
    $content = preg_replace( $pattern, $replacement, $content );
    return $content;
}
add_filter( 'the_content', 'insert_rel_multicote_wp' );


// ------------------------------------------------ 
// --- Pagination class/style for entry articles --
// ------------------------------------------------ 
function custom_nextpage_links_multicote_wp($defaults) {
$args = array(
'before' => '<div class="my-paginated-posts"><p>' . '<span>',
'after' => '</span></p></div>',
);
$r = wp_parse_args($args, $defaults);
return $r;
}
add_filter('wp_link_pages_args','custom_nextpage_links_multicote_wp');


// ------------------------------------------------ 
// ------------ Nr of Topics for Tags -------------
// ------------------------------------------------  
function set_wp_generate_tag_cloud($content, $tags, $args)
{ 
  $count=0;
  $output=preg_replace_callback('(</a\s*>)', 
  function($match) use ($tags, &$count) {
      return "<span class=\"tagcount\"> ".$tags[$count++]->count."</span></a>";  
  }
  , $content);
  
  return $output;
}
add_filter('wp_generate_tag_cloud','set_wp_generate_tag_cloud', 10, 3); 


// ------------------------------------------------ 
// --------------- Posts Time Ago -----------------
// ------------------------------------------------  
function multicote_wp_time_ago( $type = 'post' ) {
    $d = 'comment' == $type ? 'get_comment_time' : 'get_post_time';
    return human_time_diff($d('U'), current_time('timestamp')) . " ";
}


// ------------------------------------------------ 
// ------------ Number of post views --------------
// ------------------------------------------------

// function to display number of posts.
function getPostViews_multicote_wp($postID){
    $count_key = 'post_views_count_multicote_wp';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
        return '0';
    }
    return $count;
}

// function to count views.
function setPostViews_multicote_wp($postID) {
    $count_key = 'post_views_count_multicote_wp';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        $count = 0;
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
    }else{
        $count++;
        update_post_meta($postID, $count_key, $count);
    }
}


// ------------------------------------------------ 
// ------------ Meta Box --------------------------
// ------------------------------------------------
$prefix = 'multicote_wp_';
global $meta_boxes;
$meta_boxes = array();

// 1st meta box
$meta_boxes[] = array(
    'id' => 'standard',
    'title' => esc_html__( 'Article Page Options', 'multicote-wp' ),
    'context' => 'normal',
    'priority' => 'high',
    'autosave' => true,

    // Youtube
    'fields' => array(
        // TEXT
        array(
            // Field name - Will be used as label
            'name'  => esc_html__( 'Video Youtube', 'multicote-wp' ),
            // Field ID, i.e. the meta key
            'id'    => "{$prefix}youtube",
            // Field description (optional)
            'desc'  => esc_html__( 'Add Youtube code ex: HIrMIeN5ttE', 'multicote-wp' ),
            'type'  => 'text',
            // Default value (optional)
            'std'   => esc_html__( '', 'multicote-wp' ),
            // CLONES: Add to make the field cloneable (i.e. have multiple value)
            'clone' => false,
        ),


    // Vimeo
        // TEXT
        array(
            // Field name - Will be used as label
            'name'  => esc_html__( 'Video Vimeo', 'multicote-wp' ),
            // Field ID, i.e. the meta key
            'id'    => "{$prefix}vimeo",
            // Field description (optional)
            'desc'  => esc_html__( 'Add Vimeo code ex: 7449107', 'multicote-wp' ),
            'type'  => 'text',
            // Default value (optional)
            'std'   => esc_html__( '', 'multicote-wp' ),
            // CLONES: Add to make the field cloneable (i.e. have multiple value)
            'clone' => false,
        ),

    // Gallery
        // IMAGE UPLOAD
        array(
            'name' => esc_html__( 'Gallery', 'multicote-wp' ),
            'id'   => "{$prefix}slider",
            // Field description (optional)
            'desc'  => esc_html__( 'Image with any size!', 'multicote-wp' ),            
            'type' => 'image_advanced',
        ),

    // Hide Featured Image
        // CheckBox
        array(
            'name' => esc_html__( 'Featured Image', 'multicote-wp' ),
            'id'   => "{$prefix}hideimg",
            'desc'  => esc_html__( 'Hide Featured Image on single page for this article', 'multicote-wp' ),
            'type' => 'checkbox',
        ),


    ),

);



/**
 * Register meta boxes
 *
 * @return void
 */
function multicote_register_meta_boxes()
{
    // Make sure there's no errors when the plugin is deactivated or during upgrade
    if ( !class_exists( 'RW_Meta_Box' ) )
        return;

    global $meta_boxes;
    foreach ( $meta_boxes as $meta_box )
    {
        new RW_Meta_Box( $meta_box );
    }
}
// Hook to 'admin_init' to make sure the meta box class is loaded before
// (in case using the meta box class in another plugin)
// This is also helpful for some conditionals like checking page template, categories, etc.
add_action( 'admin_init', 'multicote_register_meta_boxes' );


?>