<?php

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

require_once __DIR__ .  DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR . 'Core' . DIRECTORY_SEPARATOR . 'Bootstrap.php';

use Symfony\Component\HttpFoundation\Request;

use PhoxTemplates\Includes\App\Database\Databases;
use WHMCS\View\Menu\Item as MenuItem;

add_hook('ClientAreaPage', 1, function($vars) {

    $classes_list = [
        'BrandSettings',
        'ColorSettings',
        'TypoSettings'
    ];

    foreach ( $classes_list as $class_name ){

        $class = 'PhoxTemplates\Includes\App\Http\Controllers'.'\\' . $class_name ;

        $init = new $class();

        $class_values = call_user_func([$init, 'front_values']);

        $vars [$class_values['var_name']]= $class_values['values'];

    }


    $split_assetPathcss = explode('/css' ,$vars['theme']['assetPath']['css']);
    $split_assetPathRootFolder =explode('templates/' ,$split_assetPathcss[0]);
    $vars['phoxName'] = $split_assetPathRootFolder[1];

    return $vars;
});


// Change Main Menu Home Text To Icon
add_hook('ClientAreaPrimaryNavbar', 1, function (MenuItem $primaryNavbar)
{

    if ( ! is_null($primaryNavbar->getChild('Home') ) ) {
        $primaryNavbar->removeChild('Home');
    }

    if ( ! is_null($primaryNavbar->getChild('Network Status' ) ) ) {
        $primaryNavbar->removeChild('Network Status');
    }

});
