<?php
declare(strict_types = 1);

namespace PhoxTemplates\Includes\App\Database;

class StyleSettings extends AbstractDatabase implements InterfaceDatabase{

    private $default_value = '';

    private const ROW_NAME = 'style-settings';

    public function set_default_value() : void
    {
        //import setting from file json
        $config_value = file_get_contents(__DIR__ . DIRECTORY_SEPARATOR . 'configs'. DIRECTORY_SEPARATOR .self::ROW_NAME.'.json');

        $this->default_value = $config_value;

    }

    public function insert_default_value() : void
    {

        //check if row general setting is set
        if( $this->table()->select('setting_value')->where(self::COLUMN_SETTING_NAME , '=', self::ROW_NAME)->count('*') === 0 ){

            // insert the default data into the table
            $this->table()->insertOrIgnore( [ self::COLUMN_SETTING_NAME => self::ROW_NAME, self::COLUMN_SETTING_VALUE => $this->default_value, self::COLUMN_SETTING_UPDATED_AT => $this->set_updated_at() ]);

        }

    }

    public function fetch_data_json()
    {
        $data_object = $this->table()->select( self::COLUMN_SETTING_VALUE )->where( self::COLUMN_SETTING_NAME, '=', self::ROW_NAME )->first();

        return $data_object->setting_value;
    }

    public function update_values( string $values ): void{

        $this->table()->where([self::COLUMN_SETTING_NAME => self::ROW_NAME])->update( [self::COLUMN_SETTING_VALUE => $values, self::COLUMN_SETTING_UPDATED_AT => $this->set_updated_at() ]);

    }


}