<?php

namespace PhoxTemplates\Includes\App\Http\Controllers;

use PhoxTemplates\Includes\App\Database\StyleSettings;
use PhoxTemplates\Includes\Core\Controllers\AbstractControllers;
use phpDocumentor\Reflection\Types\Mixed_;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use PhoxTemplates\Includes\Core\Service;
/**
 * Dashboard Controller
 * @package PhoxTemplates\Includes\App\Http\Controller
 */
class ColorSettings extends AbstractControllers
{

    public function __construct(){

        parent::__construct();

        $this->db = new StyleSettings();

    }

    /**
     * send all setting from db
     *
     * @return object
     */
    public function view_settings()
    {

        $this->response->setContent($this->get_settings('json'));

        $this->response->setStatusCode(Response::HTTP_OK);

        $this->response->headers->set('Content-Type', 'application/json');

        $this->set_json_type(true);

        return $this->validated_data_before_send($this->response->getContent());

    }

    /**
     * get general setting from db
     *
     * @return mixed
     */
    public function get_settings($type ='json')
    {
        if($type === 'array') return json_decode( $this->db->fetch_data_json(), true );

        return $this->db->fetch_data_json();

    }

    /**
     * Validate data Before Send
     *
     * @param $content
     * @return Response|void
     */
    public function validated_data_before_send($content)
    {
        if( empty( $content ) ) return $this->response->setContent($this->error_message());

        $ref_data = [
            'schema',
            'primaryColor',
            'secondaryColor'
        ];

        $data = $this->get_settings('array');

        $filter_data = array_filter($data, function ($key) use ($ref_data) {
            return in_array($key, $ref_data);
        }, ARRAY_FILTER_USE_KEY);

        if(  count($filter_data) !== count($ref_data)  ) return $this->response->setContent($this->error_message('error on data'));

        return $this->response->setContent($content);

    }

    /**
     * save_settings
     * it will call when saving data to db
     *
     * @return Response
     */
    public function save_settings(){

        $this->response->headers->set('Access-Control-Request-Method', 'POST');

        $method_type = $this->request->server->get('REQUEST_METHOD');

        $content = '';

        $default_options_value = $this->get_settings('array');

        $error_list = [];

        $default_scheme_value = [
            'purple' => [
                'primaryColor' => '#6c63ff',
                'secondaryColor' => '#8f88ff'
            ],
            'green' => [
                'primaryColor' => '#45c36d',
                'secondaryColor' => '#309f53 '
            ],
            'blue' => [
                'primaryColor' => '#283194',
                'secondaryColor' => '#434cae'
            ],
            'orange' => [
                'primaryColor' => '#E87A2D',
                'secondaryColor' => '#D06633'
            ],
            'red' => [
                'primaryColor' => '#D14C4C',
                'secondaryColor' => '#B74444'
            ]

        ];

        if( $method_type === 'POST' ){

            $options = $this->request->request;

            $schema = $options->get('schema');

            $primary_color = $options->get('primaryColor');

            $secondary_color = $options->get('secondaryColor');


            if( $schema === 'custom' ){

                $default_options_value['schema'] = 'custom';

                $color_validation_class = new Service\SafeColor();

                $color_validation_class->sitColor($primary_color);

                $valid_primary_color = $color_validation_class->check();

                $color_validation_class->sitColor($secondary_color);

                $valid_secondary_color = $color_validation_class->check();

                if( ! $valid_primary_color['state']  ){

                    $error_list['messages']['primary_color'] = $valid_primary_color['message'];

                }else {

                    $default_options_value['primaryColor'] = $valid_primary_color['color'];
                }

                if( ! $valid_secondary_color['state']  ){

                    $error_list['messages']['secondaryColor'] = $valid_secondary_color['message'];

                }else {

                    $default_options_value['secondaryColor'] = $valid_secondary_color['color'];
                }


            }else {

                if( in_array($schema,  array_keys($default_scheme_value) ) ){

                  $default_options_value['schema'] = $schema;

                  $default_options_value['primaryColor'] = $default_scheme_value[$schema]['primaryColor'];

                  $default_options_value['secondaryColor'] = $default_scheme_value[$schema]['secondaryColor'];
                }else {

                  $this->response->setStatusCode(Response::HTTP_BAD_REQUEST);

                  $content = $this->error_message('Method Not Allowed',Response::HTTP_BAD_REQUEST);

                  return $this->response->setContent($content);
                }


            }

            //update db
            if ( empty($error_list) ){

                $prepare_data_for_db = json_encode($default_options_value);

                $this->db->update_values($prepare_data_for_db);

                $content = '{"result": "success"}';

            }else{

                $content = $this->error_message( $error_list,Response::HTTP_UNSUPPORTED_MEDIA_TYPE);

            }

        }else{

            $content = $this->error_message('Method Not Allowed',Response::HTTP_METHOD_NOT_ALLOWED);

        }

        return $this->response->setContent($content);

    }
    /**
     * Front values
     * This data will show on frontend
     *
     * @return array
     */
    public function front_values (): array
    {

        $result = [];

        $section_name = 'wdes_phox_color';

        $data = $this->get_settings('array');

        $result ['var_name'] = $section_name;

        $result ['values'] = [
            'primary' => $data['primaryColor'],
            'secondary' => $data['secondaryColor'],

        ];
        return $result;
    }


}