<?php

namespace PhoxTemplates\Includes\App\Http\Controllers;

use PhoxTemplates\Includes\Core\Controllers\AbstractControllers;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\RedirectResponse;
use PhoxTemplates\Includes\Core\Render\Smarty;
use PhoxTemplates\Includes\App\Database\Databases;
use PhoxTemplates\Includes\Core\Service\UploaderHelper;
use \WHMCS\Database\Capsule;
use \WHMCS\Product\Group;
/**
 * Dashboard Controller
 * @package PhoxTemplates\Includes\App\Http\Controller
 */
class Dashboard extends AbstractControllers
{

    /**
     * @var Smarty
     */
    private $smarty ;


    /**
     * @var $error_messages array
     */
    private $error_messages = [];


    final function __construct(){

        $this->smarty = Smarty::instance();

    }

    /**
     * @throws \Exception
     */
    public function homepage()
	{

        return $this->smarty->view( 'dashboard');

	}

    /**
     * Save Template name
     * when you select template it will fire this method
     * that will check on DB if setting record is set on table and then add the template name that have
     * been selected after that it will send json response
     *
     * @throws Exception
     */
	public function save()
    {

        if( $this->request->server->get('REQUEST_METHOD') === 'POST' ){

            if( ! empty( $templ_name = $this->request->request->get('templateName') ) ){

                $db_response = $this->db->insertOrUpdateSelectedTemplate($templ_name);

                if ( $db_response ){

                    $this->json_response(true, 'Template has been installed 🙌');

                }else{

                    $this->json_response(false, 'This Template has been installed before');

                }


            }else{

                $this->json_response(false, 'Template Name is empty');

            }

        }else{

            $redir = new RedirectResponse('addonmodules.php?module=phox_templates');

            $redir->send();
        }

    }

    /**
     * Save brand
     *
     * it will use to save brand page
     *
     * @return void
     */
    public function save_brand() : void{

        $this->saveImages($this->request->files);

        if( isset($this->error_messages['images']) ){

            $img_message = '';

            foreach ( $this->error_messages['images'] as $item_name => $item_message ){

                $img_message .= "{$item_name} : {$item_message}<br/>";

            }

            $this->json_response(false, $img_message);
        }

    }

    protected function saveImages($RequestFile){

        $image = '';

        if(!empty($RequestFile->get('light-logo'))){

            $image = 'light-logo';

        }elseif (!empty($RequestFile->get('dark-logo'))){

            $image = 'dark-logo';

        }

        $uploaderHelper = new UploaderHelper;

        if (!empty($image)){
            /**
             * @var UploadedFile $uploadFile
             */
            $uploadFile =$RequestFile->get($image);
            $hiddenInput = $RequestFile->get($image.'-value');
            if(! is_null($uploadFile)){
                $file = $uploaderHelper->uploadImage($uploadFile, $image);
                if( $file['state'] ){
                    $this->db->updateOption(str_replace('-','', $image), $file['url']);
                }else{
                    $this->error_messages['images'][$image] = $file['message'];
                }

            }else{
                if (! empty ($hiddenInput) ){
                    $this->error_messages['images'][$image] = 'You can not upload files right';
                }else{
                    $this->db->updateOption(str_replace('-','', $image), '');
                }
            }

        }

    }

    /**
     * send response json with message and state
     *
     * @param boolean $state
     * @param string $message
     * @return mixed
     */
    public function json_response( bool $state, string $message ){

        $this->response->setContent(json_encode([
            'state' => $state,
            'message' => $message
        ]));

        $this->response->headers->set('Content-Type', 'application/json');

        $this->response->send();

        exit();
    }

    public function get_logo_images_info(){

        $output = [];

        $images = $this->db->getAllOptions();

        $output['dark-logo']['size'] = get_headers( $images[1]->value, 1 )["Content-Length"];
        $output['dark-logo']['status'] = !empty($images[1]->value);

        $output['light-logo']['size'] = get_headers( $images[0]->value, 1 )["Content-Length"];
        $output['light-logo']['status'] = !empty($images[0]->value);

        return $output;



    }

}