<?php

namespace PhoxTemplates\Includes\Core\Controllers;

use PhoxTemplates\Includes\App\Database\BrandSettings;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

class  AbstractControllers
{
    /**
     * @var BrandSettings
     */
    protected $db;

    /**
     * @var Request
     */
    protected $request;

    /**
     * @var Response
     */
    protected $response;

    /**
     * @var bool
     */
    private $is_json = false;

    public function __construct()
    {

        $this->request = new Request(
            $_GET,
            $_POST,
            [],
            $_COOKIE,
            $_FILES,
            $_SERVER
        );

        $this->db = new BrandSettings();

        $this->response = new Response();


    }

    /**
     * it is run is response type query is json
     *
     * @return void
     */
    public function resolve_json() : void
    {
        $this->response->headers->set('Content-Type', 'application/json');

        $this->response->send();

        exit();

    }

    public function set_json_type($case)
    {
        $this->is_json = $case;
    }

    public function content_json()
    {

        return $this->is_json;

    }

    /**
     * Error Message Handler
     *
     * @param mixed $message
     * @return false|string
     */
    public function error_message($message = 'error message', $state_code = Response::HTTP_OK){

        if( is_array( $message ) ){

            return json_encode(
                array_merge(['code' => $state_code,], $message)
            );

        }

        return json_encode( [
            'code' => $state_code,
            'message' => $message
        ] );



    }

}