<?php
namespace PhoxTemplates\Includes\Core\Demos;

abstract class DemoAbstract{
    /**
     * name
     *
     * @var string
     */
    protected $name = '' ;

    /**
     * title
     *
     * @var string
     */
    protected $title = '' ;

    /**
     *  Image
     *
     * @var array
     */
    protected $image = [] ;


    /**
     *  style external
     *
     * @var array
     */
    protected $style = [] ;

    /**
     *  preview Link
     *
     * @var string
     */
    protected $preview_link = '' ;

    /**
     * Sit Id for template that will use to import template
     *
     * @param string $name
     * @abstract
     *
     * @return string
     */
    abstract protected function sit_name(string $name);

    /**
     * Sit name for template that will use to import template
     *
     * @param string $title
     * @abstract
     *
     * @return string
     */
    abstract protected function sit_title(string $title);

    /**
     * Sit image information for template that will need link and if the link on module or out source link
     *
     * @param string $link
     * @param bool $external
     * @abstract
     *
     * @return array
     */
    abstract protected function sit_img(string $link, bool $external);

    /**
     * Sit style file information for template that will need link and if the link on module or out source link
     *
     * @param string $link
     * @param bool $external
     * @abstract
     *
     * @return array
     */
    abstract protected function sit_style(string $link, bool $external);

    /**
     * Sit preview link for template that will use to import template it must be out source
     *
     * @param string $link
     * @abstract
     *
     * @return string
     */
    abstract protected function sit_preview(string $link);

    /**
     * get all demo info that will use to preview it on dashboard
     *
     * @abstract
     *
     * @return array
     */
    abstract public function get_demo();
}
