<?php

namespace PhoxTemplates\Includes\Core\Service;

use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Validator\Mapping\ClassMetadata;
use Symfony\Component\Validator\Validation;

/**
 * Css Color Checker Service
 * @package PhoxTemplates\Includes\Core\Service
 */
class SafeColor {

    private $color = '';

    /**
     * Sit Color
     *
     * @param $url
     */
    public function sitColor($color)
    {
        $this->color = $color;
    }

    /**
     * Get Color
     *
     * @return array|string
     */
    public function getColor()
    {
        return !empty($this->color) ? $this->color : [ 'state' => false , 'message' => 'There are no color'];
    }

    /**
     * Check Color is valid
     *
     * @return array
     */
    public function check(): array
    {

        /** @var Validation $violations */
        $validator = Validation::createValidator();

        $violations = $validator->validate($this->color, [
            new Assert\CssColor([
                'formats' => Assert\CssColor::HEX_LONG,
                'message' => 'The accent color must be a 6-character hexadecimal color.',
            ])
        ]);

        if (0 !== count($violations)) {

            return [ 'state' => false ,'message' =>$violations[0]->getMessage()];
        }

        return ['state' => true, 'color' => $this->getColor()];

    }

}