<?php

namespace PhoxTemplates\Includes\Core\Service;

use Symfony\Component\Validator\Validation;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Url Checker Service
 * @package PhoxTemplates\Includes\Core\Service
 */

class SafeUrl{

    private $url = '';

    /**
     * Sit Url
     *
     * @param $url
     */
    public function sitUrl($url)
    {
        $this->url = $url;
    }

    /**
     * Get Url
     *
     * @return array|string
     */
    public function getUrl()
    {
        return !empty($this->url) ? $this->url : [ 'state' => false , 'message' => 'There are no url'];
    }

    /**
     * Check Url is valid
     *
     * @return array
     */
    public function check(): array
    {

        /** @var Validation $violations */
        $validator = Validation::createValidator();

        $violations = $validator->validate($this->url, [
            new Assert\Url(['message' => "This is not a valid url",])
        ]);

        if (0 !== count($violations)) {

            return [ 'state' => false ,'message' =>$violations[0]->getMessage()];
        }

        return ['state' => true, 'url' => $this->getUrl()];

    }


}