<?php

namespace PhoxTemplates\Includes\Core\Service;

use Symfony\Component\Validator\Validation;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Symfony\Component\Validator\Constraints as Assert;
/**
 * Upload Service
 * @package PhoxTemplates\Includes\Core\Service
 */

class UploaderHelper{

    /**
     * Upload Image
     *
     * @param UploadedFile $uploadedFile
     * @param string $imagename
     * @return string
     */
    public function uploadImage(UploadedFile $uploadedFile, string $imagename): array{

        /** @var Validation $violations */
        $validator = Validation::createValidator();

        $violations = $validator->validate($uploadedFile, [
            new Assert\Image([
                'maxSize' => '6M',
                'mimeTypes' => ['image/png', 'image/x-icon'],
                'mimeTypesMessage' => 'we only accept png extension'
            ])
        ]);

        if (0 !== count($violations)) {

            return [ 'state' => false ,'message' =>$violations[0]->getMessage()];
        }
        $destination = ROOTDIR . '/templates/phox/img';

        $newFilename = $imagename.'.'.$uploadedFile->guessExtension();

        $uploadedFile->move($destination, $newFilename);

        return ['state' => true, 'url' => $this->getImageUrl($newFilename)];
    }

    /**
     * Get full image url
     * this url will use on client side to show image
     *
     * @param string $filename
     * @return string
     */
    public function getImageUrl(string $filename):string{
        return \App::getSystemUrl().'templates/phox/img/'.$filename;
    }

}