const { src, dest, watch, series } = require("gulp");
const sass = require("gulp-sass")(require("sass"));
const prefix = require("gulp-autoprefixer");
const minify = require("gulp-clean-css");

// Functions

// 01_Css Optimization
function cssOptimize() {
  return src("./assets/css/pages/sass/*.scss")
    .pipe(sass())
    .pipe(prefix("last 2 versions"))
    .pipe(minify())
    .pipe(dest("./assets/css/pages/dist"));
}

// Watch
function watchTask() {
  watch("./assets/css/pages/sass/*.scss", cssOptimize);
}

// Default
exports.default = series(cssOptimize);
