<?php
namespace Phox\import\demo;

/**
 * RTL Demo
 * This is twelfth demo for the theme
 * the primary color #2f55cf
 *
 * @package Phox
 * @author WHMCSdes
 * @link https://whmcsdes.com
 */

class RTL_Demo extends Demo {

    public function config() {

        return [
            'demo_id'                  => 'RTL',
            'demo_num'                 => '14',
            'import_file_name'         => 'RTL Demo',
            'import_file_url'          => 'https://www.whmcsdes.com/ca/dl.php?type=d&id=90',
            'import_widget_file_url'   => 'https://whmcsdes.com/phoxdemo/rtl/rtl_wordpress-widget.wie',
            'preview_url'              => 'https://phox.whmcsdes.com/demos/rtl',
            'import_preview_image_url' => 'https://whmcsdes.com/phoxdemo/rtl/rtl.jpg',
            'update_media_url'         => true,
            'elementor_kit'            => 'rtl-kit',
            'import_notice'            => ! is_rtl() ? esc_html__( 'To install this demo you need to change your site language to one of the Right-To-Left languages', 'phox' ) : ''
        ];

    }

    public function theme_option()
    {
        $theme_options_json = wp_remote_retrieve_body( wp_remote_get( 'https://whmcsdes.com/phoxdemo/rtl/rtl_demo-2022-07-13.json' ) );

        return json_decode( $theme_options_json, true );
    }
}
