<?php
/**
 * Gutenberg Editor CSS
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package     Multihost
 * @author      Multihost
 * @copyright   Copyright (c) 2019, Multihost
 * @link        http://themes-demo.com/multihost/
 * @since       Multihost 1.0
 */

if ( ! class_exists( 'Gutenberg_Editor_CSS' ) ) :
	/**
	 * Admin Helper
	 */
	class Gutenberg_Editor_CSS {

		function __construct() {

			add_action('after_setup_theme', array( $this,  'multihost_after_setup_theme' ) );

			add_action( 'current_screen', array( $this,  'multihost_current_screen_hook' ), 10, 1 );
			add_action( 'enqueue_block_editor_assets', array( $this, 'multihost_backend_editor_styles' ), 10 );
			if ( class_exists( 'Classic_Editor' ) ) {
				add_filter( 'tiny_mce_before_init', array( $this, 'multihost_theme_editor_dynamic_styles' ) );
			}

			add_action( 'wp_enqueue_scripts', array( $this, 'multihost_editor_enqueue_styles'), 110 );

		}

		public function multihost_after_setup_theme() {

			# Gutenberg Compatible
			add_theme_support( 'align-wide' );
			add_theme_support( 'wp-block-styles' );
			add_theme_support( 'editor-styles' );

			# Add support for responsive embedded content.
			add_theme_support( 'responsive-embeds' );

			$skin = dttheme_option('appearance', 'skin');
			$skin = ($skin != '') ? $skin : 'royalblue';

			$colors          = $this->multihost_skins( $skin );
			$primary_color   = $colors['primary-color'];
			$secondary_color = $colors['secondary-color'];
			$tertiary_color  = $colors['tertiary-color'];

			add_theme_support( 'editor-color-palette', array(
				array(
					'name'  => esc_html__( 'Primary Color', 'multihost' ),
					'slug'  => 'primary',
					'color' => $primary_color,
				),
				array(
					'name'  => esc_html__( 'Secondary Color', 'multihost' ),
					'slug'  => 'secondary',
					'color' => $secondary_color,
				),
				array(
					'name'  => esc_html__( 'Tertiary Color', 'multihost' ),
					'slug'  => 'tertiary',
					'color' => $tertiary_color,
				)
			));

		}

		public function multihost_skins( $skin ) {

			$skins['royalblue'] = array ( 'primary-color' => '#3575b9', 'secondary-color' => '#2a323e', 'tertiary-color' => '#e8edf2' );
			$skins['chocolate'] = array( 'primary-color' => '#cd671d', 'secondary-color' => '#121212', 'tertiary-color' => '#e8edf2' );
			$skins['coral'] = array( 'primary-color' => '#fb6e1e', 'secondary-color' => '#121212', 'tertiary-color' => '#e8edf2' );
			$skins['cyan'] = array( 'primary-color' => '#35b5b1', 'secondary-color' => '#121212', 'tertiary-color' => '#e8edf2' );
			$skins['darkblue'] = array( 'primary-color' => '#065c8c', 'secondary-color' => '#121212', 'tertiary-color' => '#e8edf2' );
			$skins['darkmagenta'] = array( 'primary-color' => '#9942a3', 'secondary-color' => '#121212', 'tertiary-color' => '#e8edf2' );
			$skins['duskblue'] = array( 'primary-color' => '#6f95ae', 'secondary-color' => '#121212', 'tertiary-color' => '#e8edf2' );
			$skins['electricblue'] = array( 'primary-color' => '#405069', 'secondary-color' => '#121212', 'tertiary-color' => '#e8edf2' );
			$skins['ferngreen'] = array( 'primary-color' => '#177254', 'secondary-color' => '#121212', 'tertiary-color' => '#e8edf2' );
			$skins['lavender'] = array( 'primary-color' => '#a874ff', 'secondary-color' => '#121212', 'tertiary-color' => '#e8edf2' );
			$skins['lightgreen'] = array( 'primary-color' => '#86af53', 'secondary-color' => '#121212', 'tertiary-color' => '#e8edf2' );
			$skins['limegreen'] = array( 'primary-color' => '#afca47', 'secondary-color' => '#121212', 'tertiary-color' => '#e8edf2' );			
			$skins['ocean'] = array( 'primary-color' => '#22a1c4', 'secondary-color' => '#121212', 'tertiary-color' => '#e8edf2' );
			$skins['orange'] = array( 'primary-color' => '#ff9646', 'secondary-color' => '#121212', 'tertiary-color' => '#e8edf2' );
			$skins['pink'] = array( 'primary-color' => '#f472d0', 'secondary-color' => '#121212', 'tertiary-color' => '#e8edf2' );
			$skins['purple'] = array( 'primary-color' => '#9b59b6', 'secondary-color' => '#121212', 'tertiary-color' => '#e8edf2' );
			$skins['red'] = array( 'primary-color' => '#cc4744', 'secondary-color' => '#121212', 'tertiary-color' => '#e8edf2' );
			$skins['salmon'] = array( 'primary-color' => '#ea6153', 'secondary-color' => '#121212', 'tertiary-color' => '#e8edf2' );
			$skins['violet'] = array( 'primary-color' => '#665a98', 'secondary-color' => '#121212', 'tertiary-color' => '#e8edf2' );
			$skins['yellow'] = array( 'primary-color' => '#f1c40f', 'secondary-color' => '#121212', 'tertiary-color' => '#e8edf2' );

			return $skins[ $skin ];

		}

		public function multihost_current_screen_hook( $current_screen ) {

			if ( 'post' == $current_screen->base ) {

				$font = $subset = '';

				$custom_fonts = array ();

				#Body Section
				$disable_boddy_settings = dttheme_option('appearance', 'disable-boddy-settings');

				if (empty($disable_boddy_settings)) :
					$font = dttheme_option('appearance', 'body-font');
					$font = str_replace(' ', '+', $font);
					if (!empty($font)) :
						array_push($custom_fonts, $font);
					endif;
				endif;

				#Typography Section
				$disable_typo = dttheme_option('appearance', 'disable-typography-settings');
				if (empty($disable_typo)) :
					for ($i = 1; $i <= 6; $i++) :
						$font = dttheme_option('appearance', 'H'.$i.'-font');
						if (!empty($font)) :
							$font = str_replace(' ', '+', $font);
							array_push($custom_fonts, $font);
						endif;
					endfor;
				endif;

				if (!empty($custom_fonts)) :
					$custom_fonts = array_unique($custom_fonts);
					$font = implode(':100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic|', $custom_fonts);
					$font .= ':100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic|';
				endif;

				$font .= 'Ubuntu:300,400,500,700';

				$protocol = is_ssl() ? 'https' : 'http';
				$query_args = array('family' => $font, 'subset' => $subset);
				$fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );

				add_editor_style( $fonts_url );

				add_editor_style( 'css/editor-style.css' );

			}

		}

		public function multihost_generate_editor_styles( $editor_type = 'block' ) {

			if($editor_type == 'tinymce') {
				$wrapper_class = 'body#tinymce.wp-editor.content';
			} else {
				$wrapper_class = '.editor-styles-wrapper';
			}

			$styles = '';

			$styles .= $wrapper_class.' pre { font-family:monospace; }';

			// Body Typography
			$disable_boddy_settings = dttheme_option('appearance', 'disable-boddy-settings');
			if (empty($disable_boddy_settings)) {

				$font_type = dttheme_option('appearance', 'body-font-type');
				$style = dttheme_option('appearance','body-standard-font-style');

				if( !empty($font_type) ) {
					$body_font = dttheme_option('appearance','body-standard-font');
				} else {
					$body_font = dttheme_option('appearance', 'body-font');
				}

				$body_font_size = dttheme_option('appearance', 'body-font-size');
				$body_font_color = dttheme_option('appearance', 'body-font-color');

				$body_primary_color = dttheme_option('appearance', 'body-primary-color');
				$body_secondary_color = dttheme_option('appearance', 'body-secondary-color');

				if (!empty($body_font) || (!empty($body_font_color) and $body_font_color != '#') || !empty($body_font_size)) {

					$styles .= $wrapper_class.' > * {';

						if (!empty($body_font)) {
							$styles .= 'font-family:'.$body_font.';';
						}

						if (!empty($body_font_color) && ($body_font_color != '#')) {
							$styles .= 'color:'.$body_font_color.';';
						}

						if (!empty($body_font_size)) {
							$styles .= 'font-size:'.$body_font_size.'px;';
						}

						if (!empty($style)) {
							if ($style == 'Bold Italic') {
								$styles .= 'font-weight:bold; font-style:italic;';
							} elseif ($style == 'Bold') {
								$styles .= 'font-weight:bold;';
							} elseif ($style == 'Italic') {
								$styles .= 'font-style:italic;';
							} elseif ($style == 'Normal') {
								$styles .= 'font-weight:normal; font-style:normal;';
							}
						}

					$styles .= '}';

				}

				if (!empty($body_font_color) and $body_font_color != '#') {

					$styles .= $wrapper_class.' pre, .wp-block-pullquote {';
						$styles .= 'color:'.$body_font_color.';';
					$styles .= '}';

				}

				if (!empty($body_primary_color) && ($body_primary_color != '#')) {
					$styles .= $wrapper_class.' a { color:'.$body_primary_color.'; }';
				}

				if (!empty($body_secondary_color) && ($body_secondary_color != '#')) {
					$styles .= $wrapper_class.' a:focus, '.$wrapper_class.' a:hover { color:'.$body_secondary_color.'; }';
				}

			}
			// Body Typography End

			// Heading Typography
			$disable_typo = dttheme_option('appearance', 'disable-typography-settings');
			if (empty($disable_typo)) {

				for ($i = 1; $i <= 6; $i++) {

					$font_type = dttheme_option('appearance', 'H'.$i.'-font-type');
					$style = dttheme_option('appearance','H'.$i.'-standard-font-style');

					if( !empty($font_type) ){
						$font = dttheme_option('appearance','H'.$i.'-standard-font');
					} else {
						$font = dttheme_option('appearance', 'H'.$i.'-font');
					}

					$color = dttheme_option('appearance', 'H'.$i.'-font-color');
					$size = dttheme_option('appearance', 'H'.$i.'-size');

					if (!empty($font) || (!empty($color) and $color != '#') || !empty($size)) {

						if($editor_type == 'tinymce') {
							$styles .= $wrapper_class.' h'.$i.' {';
						} else {
							if($i == 1) {
								$styles .= '.editor-post-title__block .editor-post-title__input, '.$wrapper_class.' h1.wp-block {';
							} else{
								$styles .= $wrapper_class.' h'.$i.'.wp-block {';
							}
						}

							if (!empty($font)) {
								$styles .= 'font-family:'.$font.'; ';
							}

							if( !empty($font_type) ) {
								if (!empty($style)) {
									if ($style == 'Bold Italic') {
										$styles .= 'font-weight:bold; font-style:italic;';
									} elseif ($style == 'Bold') {
										$styles .= 'font-weight:bold;';
									} elseif ($style == 'Italic') {
										$styles .= 'font-style:italic;';
									} elseif ($style == 'Normal') {
										$styles .= 'font-weight:normal; font-style:normal;';
									}
								}
							}

							if (!empty($color) && ($color != '#')) {
								$styles .= 'color:'.$color.'; ';
							}

							if (!empty($size)) {
								$styles .= 'font-size:'.$size.'px; ';
							}

						$styles .= '}';

					}

				}

			}
			// Heading Typography End

			return $styles;

		}

		public function multihost_backend_editor_styles() {

			wp_enqueue_style( 'multihost-gutenberg', get_theme_file_uri('/css/admin-gutenberg.css'), false, IAMD_THEME_VERSION, 'all' );

			$styles = $this->multihost_generate_editor_styles('block');

			wp_add_inline_style( 'multihost-gutenberg', $styles );

		}

		public function multihost_theme_editor_dynamic_styles( $mceInit ) {

			$styles = $this->multihost_generate_editor_styles('tinymce');

			if ( isset( $mceInit['content_style'] ) ) {
				$mceInit['content_style'] .= ' ' . $styles . ' ';
			} else {
				$mceInit['content_style'] = $styles . ' ';
			}

			return $mceInit;
		}

		public function multihost_editor_enqueue_styles( ) {

			$styles = '';

			$primary_color = $secondary_color = $tertiary_color = '';

			$skin = dttheme_option('appearance', 'skin');
			$skin = ($skin != '') ? $skin : 'royalblue';

			$colors          = $this->multihost_skins( $skin );
			$primary_color   = $colors['primary-color'];
			$secondary_color = $colors['secondary-color'];
			$tertiary_color  = $colors['tertiary-color'];

			# Primary Color
			$styles .= '.has-primary-background-color { background-color:'.$primary_color.'; }';
			$styles .= '.has-primary-color { color:'.$primary_color.'; }';

			# Secondary Color
			$styles .= '.has-secondary-background-color { background-color:'.$secondary_color.'; }';
			$styles .= '.has-secondary-color { color:'.$secondary_color.'; }';

			# Tertiary Color
			$styles .= '.has-tertiary-background-color { background-color:'.$tertiary_color.'; }';
			$styles .= '.has-tertiary-color { color:'.$tertiary_color.'; }';

			wp_add_inline_style('multihost-gutenberg', $styles );

		}

	}

	new Gutenberg_Editor_CSS();

endif;