<?php
add_action('admin_init', 'dttheme_admin_options_init', 1);
add_action('admin_enqueue_scripts', 'dttheme_admin_panel_scripts');

##Admin panel media uploader hooks( to alter the media uploder used to upload logo , favicon ... )
if (isset($_GET['mytheme_upload_button']) || isset($_POST['mytheme_upload_button']) && (isset($_GET['page']) && $_GET['page'] == 'parent')) :
	add_action('admin_init', 'dttheme_image_upload_option');
endif;
## End hook

if( !function_exists('dttheme_admin_panel_scripts') ) {
	function dttheme_admin_panel_scripts() {
		global $wp_version;

		wp_enqueue_style('thickbox');

		wp_enqueue_style('dttheme-adminpanel', IAMD_FW_URL.'theme_options/style.css');	

		wp_enqueue_script('media-upload');
		wp_enqueue_script('thickbox');
		wp_enqueue_script('jquery-ui-tabs');
		wp_enqueue_script('jquery-ui-sortable');
		wp_enqueue_script('jquery-ui-slider');
		
		if (version_compare($wp_version, '3.5', '>=')) :
			wp_enqueue_script('wp-color-picker'); #New Color Picker
			wp_enqueue_style('wp-color-picker'); #New Color Picker
		else :
			wp_enqueue_script('farbtastic'); #Color picker
			wp_enqueue_style('farbtastic'); #Color Picker
		endif;

		wp_enqueue_script('dttheme-browser', IAMD_FW_URL.'js/admin/jquery.browser.min.js');
		wp_enqueue_script('dttheme-tooltip', IAMD_FW_URL.'js/admin/jquery.tools.min.js');
		wp_enqueue_script('dttheme', IAMD_FW_URL.'js/admin/mytheme.admin.js', array( 'wp-blocks' ));
		
		wp_localize_script('dttheme', 'objectL10n', array(
			'saveall' => esc_html__('Save All','multihost'),
			'saving' => esc_html__('Saving ...','multihost'),
			'resetConfirm' => esc_html__('This will restore all of your options to default. Are you sure?', 'multihost'),
			'importConfirm' => esc_html__('You are going to import the dummy data provided with the theme, kindly confirm?', 'multihost'),
			'disableImportMsg' => esc_html__('Importing is disabled.. :), Please set Disable Import to NO in Buddha Panel General Settings', 'multihost'),
			'backupMsg' => esc_html__('Click OK to backup your current saved options.', 'multihost'),
			'backupSuccess' => esc_html__('Your options are backuped successfully', 'multihost'),
			'backupFailure' => esc_html__('Backup Process not working', 'multihost'),
			'restoreMsg' => esc_html__('Warning: All of your current options will be replaced with the data from your last backup! Proceed?', 'multihost'),
			'restoreSuccess' => esc_html__('Your options are restored from previous backup successfully', 'multihost'),
			'restoreFailure' => esc_html__('Restore Process not working', 'multihost'),
			'importMsg' => esc_html__('Click ok import options from the above textarea', 'multihost'),
			'importSuccess' => esc_html__('Your options are imported successfully', 'multihost'),
			'pageBuilderUpdate' => esc_html__('You page and post contents are updated successfully for page builder latest version!', 'multihost'),
			'pageBuilderUpdateAlready' => esc_html__('Page builder updates are implemented already to your page and post contents!', 'multihost'),
			'importFailure' => esc_html__('Import Process not working', 'multihost'),
			'mysiteWpVersion' => $wp_version));
	}
}

if( !function_exists('dttheme_admin_options_init') ) {
	function dttheme_admin_options_init() {
		register_setting(IAMD_THEME_SETTINGS, IAMD_THEME_SETTINGS);
		add_option(IAMD_THEME_SETTINGS, dttheme_default_option());
		if (isset($_POST['mytheme-option-save'])) :
			dttheme_ajax_option_save();
		endif;
	
		if (isset($_POST['mytheme']['reset'])) :
			delete_option(IAMD_THEME_SETTINGS);
			update_option(IAMD_THEME_SETTINGS, dttheme_default_option()); # To set Default options
			wp_redirect(admin_url('admin.php?page=parent&reset=true'));
			exit;
		endif;
	}
}

if( !function_exists('dttheme_ajax_option_save') ) {
	function dttheme_ajax_option_save() {
		$ajax_ref_check = check_ajax_referer(IAMD_THEME_SETTINGS.'_wpnonce', 'mytheme_admin_wpnonce');

		if( $ajax_ref_check === false ) {
			return false;
		} else {

			$data = $_POST;
			unset($data['_wp_http_referer'], $data['_wpnonce'], $data['action']);
			unset($data['mytheme_admin_wpnonce'], $data['mytheme-option-save'], $data['option_page']);

			$msg = array('success' => false, 'message' => esc_html__('Error: Options not saved, please try again.', 'multihost'));

			$data = array_filter($data[IAMD_THEME_SETTINGS]);

			$final = array();
			foreach( $data as $k => $v ):
				switch ( $k ):
					case 'social':
						$final['social'] = $data['social'];
						break;
					case 'seo':
						$final['seo'] = $data['seo'];
						break;

					default:
						$inner = array();
						foreach( $v as $kk => $vv ){
							
							if( !empty( $vv ) ) {
								$inner[$kk] =  $vv;
							}
						}
						$final[$k] =  $inner;				
					break;
				endswitch;
			endforeach;

			// final array...
			$data = $final;

			if (get_option(IAMD_THEME_SETTINGS) != $data) {
				if (update_option(IAMD_THEME_SETTINGS, $data))
					$msg = array('success' => 'options_saved', 'message' => esc_html__('Options Saved.', 'multihost'));
			} else {
				$msg = array('success' => true, 'message' => esc_html__('Options Saved.', 'multihost'));
			}

			$echo = json_encode($msg);
			header('Content-Type: application/json; charset='.get_option('blog_charset'));
			echo !empty( $echo ) ? $echo : '';
			exit;
		}
	}
}

######### SAMPLE FONT PREVIEW ##########
add_action('wp_ajax_dttheme_font_url', 'dttheme_font_url');
if( !function_exists('dttheme_font_url') ) {
	function dttheme_font_url() {
		$recieve_font  = sanitize_text_field($_POST['font']);
		$font_url = array('url' => 'http'.dt_ssl().'://fonts.googleapis.com/css?family='.str_replace(' ', '+', $recieve_font));
		die(json_encode($font_url));
	}
}

#### BACKUP OPTION #####
add_action('wp_ajax_dttheme_backup_and_restore_action', 'dttheme_backup_and_restore_action');
if( !function_exists('dttheme_backup_and_restore_action') ) {
	function dttheme_backup_and_restore_action() {

		$save_type = $_REQUEST['type'];
		
		if ($save_type == 'backup_options') :
			$data = array('general' => dttheme_option('general'),
				'appearance' => dttheme_option('appearance'),
				'integration' => dttheme_option('integration'),
				'seo' => dttheme_option('seo'),
				'specialty' => dttheme_option('specialty'),
				'widgetarea' => dttheme_option("widgetarea"),
				'mobile' => dttheme_option('mobile'),
				'advance' => dttheme_option('advance'),
				
				'backup' => date('r'));
			update_option("mytheme_backup", $data);
			die('1');
		elseif ($save_type == 'restore_options') :
			$data = get_option("mytheme_backup");
			update_option(IAMD_THEME_SETTINGS, $data);
			die('1');
		elseif ($save_type == "import_options") :
			$data = $_REQUEST['data'];
			$data = stripslashes( $data );
			$data =  json_decode( $data , true );
			update_option(IAMD_THEME_SETTINGS, $data);
			die('1');
		elseif( $save_type == "reset_options") :
			delete_option(IAMD_THEME_SETTINGS);
			update_option(IAMD_THEME_SETTINGS, dttheme_default_option()); # To set Default options
			die('1');
		endif;
	}
}?>