<?php
	#Standard Sidebar
	register_sidebar(array(
		'name' 			=>	esc_html__('Standard Sidebar','multihost'),
		'id'			=>	'standard-sidebar',
		'description'	=>	esc_html__("Common sidebar that appears once enabled.",'multihost'),
		'before_widget' => 	'<aside id="%1$s" class="widget %2$s">',
		'after_widget' 	=> 	'</aside>',
		'before_title' 	=> 	'<h3 class="widgettitle">',
		'after_title' 	=> 	'<span></span></h3>'
	) );

	#Custom Sidebars
	$widgets = dttheme_option('widgetarea','custom');
	$widgets = is_array($widgets) ? array_unique($widgets) : array();
    $widgets = array_filter($widgets);
    foreach ($widgets as $key => $value) {
    	$id = mb_convert_case($value, MB_CASE_LOWER, "UTF-8");
    	$id = str_replace(" ", "-", $id);

    	register_sidebar(array(
		'name' 			=>	$value,
		'id'			=>	$id,
		'description'   =>  esc_html__("A unique sidebar that is created in Admin panel",'multihost'),
		'before_widget' => 	'<aside id="%1$s" class="widget %2$s">',
		'after_widget' 	=> 	'</aside>',
		'before_title' 	=> 	'<h3 class="widgettitle">',
		'after_title' 	=> 	'<span></span></h3>'));
    }

    #Post's Author Archive Sidebar 
    	$author_archive_layout = dttheme_option('specialty','author-archives-layout');
    	$author_archive_layout = !empty($author_archive_layout) ? $author_archive_layout : "content-full-width";
    	switch ($author_archive_layout ) {
    		case 'with-left-sidebar':
    		case 'with-right-sidebar':
				register_sidebar(array(
					'name' 			=>	esc_html__("Author's Archive Sidebar",'multihost'),
					'id'			=>	'author-archive-sidebar',
					'description'   =>  esc_html__("Author's Archive sidebar",'multihost'),
					'before_widget' => 	'<aside id="%1$s" class="widget %2$s">',
					'after_widget' 	=> 	'</aside>',
					'before_title' 	=> 	'<h3 class="widgettitle">',
					'after_title' 	=> 	'<span></span></h3>'));
    		break;
   		}

    #Post's Category Archive Sidebar 
    	$cat_archive_layout = dttheme_option('specialty','category-archives-layout');
    	$cat_archive_layout = !empty($cat_archive_layout) ? $cat_archive_layout : "content-full-width";
    	switch ($cat_archive_layout ) {
    		case 'with-left-sidebar':
    		case 'with-right-sidebar':
				register_sidebar(array(
					'name' 			=>	esc_html__("Post's Category Archive Sidebar",'multihost'),
					'id'			=>	'category-archives-sidebar',
					'description'   =>  esc_html__("Post's Category sidebar.",'multihost'),
					'before_widget' => 	'<aside id="%1$s" class="widget %2$s">',
					'after_widget' 	=> 	'</aside>',
					'before_title' 	=> 	'<h3 class="widgettitle">',
					'after_title' 	=> 	'<span></span></h3>'));
    		break;
   		}

    #Post's Tag Archive Sidebar
    	$tag_archive_layout = dttheme_option('specialty','tag-archives-layout');
    	$tag_archive_layout = !empty($tag_archive_layout) ? $tag_archive_layout : "content-full-width";
    	switch ($tag_archive_layout ) {
    		case 'with-left-sidebar':
    		case 'with-right-sidebar':
				register_sidebar(array(
					'name' 			=>	esc_html__("Post's Tag Archive Sidebar",'multihost'),
					'id'			=>	'tag-archives-sidebar',
					'description'   =>  esc_html__("Post's Tag sidebar.",'multihost'),
					'before_widget' => 	'<aside id="%1$s" class="widget %2$s">',
					'after_widget' 	=> 	'</aside>',
					'before_title' 	=> 	'<h3 class="widgettitle">',
					'after_title' 	=> 	'<span></span></h3>'));
    		break;
   		}

    #Search Page Layout
    	$search_layout = dttheme_option('specialty','search-layout');
    	$search_layout = !empty($search_layout) ? $search_layout : "content-full-width";
    	switch ($search_layout ) {
    		case 'with-left-sidebar':
    		case 'with-right-sidebar':
				register_sidebar(array(
					'name' 			=>	esc_html__('Search Sidebar','multihost'),
					'id'			=>	'search-sidebar',
					'description'   =>  esc_html__("Search page sidebar.",'multihost'),
					'before_widget' => 	'<aside id="%1$s" class="widget %2$s">',
					'after_widget' 	=> 	'</aside>',
					'before_title' 	=> 	'<h3 class="widgettitle">',
					'after_title' 	=> 	'<span></span></h3>'));
    		break;
      	}

    #404 Page Layout
    	$layout_404 = dttheme_option('specialty','404-layout');
    	$layout_404 = !empty($layout_404) ? $layout_404 : "content-full-width";
    	switch ($layout_404 ) {
    		case 'with-left-sidebar':
    		case 'with-right-sidebar':
				register_sidebar(array(
					'name' 			=>	esc_html__('Not Found ( 404 ) Sidebar','multihost'),
					'id'			=>	'not-found-404-sidebar',
					'description'   =>  esc_html__("404 page sidebar.",'multihost'),
					'before_widget' => 	'<aside id="%1$s" class="widget %2$s">',
					'after_widget' 	=> 	'</aside>',
					'before_title' 	=> 	'<h3 class="widgettitle">',
					'after_title' 	=> 	'<span></span></h3>'));
    		break;
    	}

	if( class_exists( 'DTCorePlugin' ) ):

		$layout = dttheme_option('specialty','gallery-archives-layout');
	    $layout = !empty($layout) ? $layout : "content-full-width";

	    switch ($layout ) {
	    	case 'with-left-sidebar':
	    	case 'with-right-sidebar':
	    		register_sidebar(array(
	    			'name' 			=>	esc_html__("Portfolio's Terms Sidebar",'multihost'),
					'id'			=>	'custom-post-gallery-archives',
					'description'   =>  esc_html__("Portfolio's term sidebar that appears on the left side.",'multihost'),
					'before_widget' => 	'<aside id="%1$s" class="widget %2$s">',
					'after_widget' 	=> 	'</aside>',
					'before_title' 	=> 	'<h3 class="widgettitle">',
					'after_title' 	=> 	'<span></span></h3>'));
	    	break;
	   	}
	endif;

	#Footer Columnns		
	$footer_columns =  dttheme_option('general','footer-columns');
	if( function_exists('dttheme_footer_widgetarea') ) {
		dttheme_footer_widgetarea($footer_columns);		
	}

	#Custom Mega Menu Sidebars
	$widgets = dttheme_option('widgetarea','megamenu');
	$widgets = is_array($widgets) ? array_unique($widgets) : array();
    $widgets = array_filter($widgets);
    foreach ($widgets as $key => $value) {
    	$id = mb_convert_case($value, MB_CASE_LOWER, "UTF-8");
    	$id = str_replace(" ", "-", $id);

    	register_sidebar(array(
			'name' 			=>	$value,
			'id'			=>	$id,
			'description'   =>  esc_html__("A unique mega menu sidebar that is created in Admin panel",'multihost'),
			'before_widget' => 	'<li id="%1$s" class="widget %2$s">',
			'after_widget' 	=> 	'</li>',
			'before_title' 	=> 	'<h3 class="widgettitle">',
			'after_title' 	=> 	'<span></span></h3>'
		) );
    }?>