<!-- pagebuilder -->
<div id="pagebuilder" class="bpanel-content">

    <!-- .bpanel-main-content -->
    <div class="bpanel-main-content">
        <ul class="sub-panel"> 
            <li><a href="#my-pagebuilder"><?php esc_html_e("Page Builder",'multihost'); ?></a></li>
        </ul>        

        <!-- my-pagebuilder-->
        <div id="my-pagebuilder" class="tab-content">
            <!-- .bpanel-box -->
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('Page Builder','multihost'); ?></h3>
                </div><?php
				$dt_pb_status = class_exists( 'DTCorePlugin' );
				if($dt_pb_status) { ?>
                <div class="box-content">                
                    <div class="bpanel-option-set">

                        <h6><?php esc_html_e('Choose any of these post types to activate page builder','multihost'); ?></h6><?php
                        $post_types = array( 'post' => 'Post', 'page' => 'Page', 'dt_portfolios' => 'Portfolios');

                        $selected_post_types = dttheme_option('pagebuilder', 'post-types');
                        $selected_post_type_keys = (is_array($selected_post_types) && !empty($selected_post_types)) ? array_keys($selected_post_types) : array ();
						
                        foreach ( $post_types as $post_type_key => $post_type_name ) {

							$switchclass = in_array($post_type_key, $selected_post_type_keys) ? 'checkbox-switch-on' :'checkbox-switch-off';
                            $post_type_object = get_post_type_object( $post_type_key );

                            ?>
                            <div class="column one-third">
                                <label><?php echo esc_attr($post_type_object->labels->singular_name); ?></label>
                            </div>
                            <div class="column two-third last">
                                 <div data-for="mytheme-<?php echo esc_attr( $post_type_key ); ?>" class="checkbox-switch <?php echo esc_attr( $switchclass ); ?>"></div>
                                 <input class="hidden" id="mytheme-<?php echo esc_attr( $post_type_key ); ?>" type="checkbox" value="<?php echo esc_attr( $post_type_key ); ?>"
                                    name="mytheme[pagebuilder][post-types][<?php echo esc_attr( $post_type_key ); ?>]" <?php echo in_array($post_type_key, $selected_post_type_keys) ? 'checked' :'';?> />
                            </div><?php							
                        }?>
                        <div class="hr"></div>
                    </div><!-- .bpanel-option-set -->
 
                    <div class="bpanel-option-set"><?php
						$pb_switchclass = ( "true" ==  dttheme_option('pagebuilder', 'enable-pagebuilder') ) ? 'checkbox-switch-on' :'checkbox-switch-off';?>
                        <h6><?php esc_html_e('Keep page builder active in above selected post types','multihost'); ?></h6>
                        <div data-for="mytheme-enable-pagebuilder" class="checkbox-switch <?php echo esc_attr( $pb_switchclass ); ?>"></div>
                        <input class="hidden" id="mytheme-enable-pagebuilder" <?php $checked; ?> name="mytheme[pagebuilder][enable-pagebuilder]" type="checkbox" value="true" <?php if( "true" == dttheme_option('pagebuilder','enable-pagebuilder') ):?> checked="checked" <?php endif;?> />
                        <div class="hr"></div>
                    </div><!-- .bpanel-option-set --> 

                    <div class="bpanel-option-set"><?php
                        if(dttheme_option('pagebuilder_update') == 'done') { 
                            $disable_cls = 'disabled';
                        } else {
                            $disable_cls = '';
                        }?>
                        <h6><?php esc_html_e('Update page contents for latest page builder', 'multihost'); ?></h6>
                        <input type="hidden" name="mytheme_update_wpnonce" value="<?php echo wp_create_nonce('mytheme_update_wpnonce'); ?>" />
                        <input type="button" value="<?php esc_attr_e('Update Content','multihost'); ?>" class="dt_update_pagebuilder_contents <?php echo esc_attr( $disable_cls ); ?>" />
                        <p class="note"><?php esc_html_e('Latest page builder update needs your content to be updated. Please click the above button to update it. It may take while please be patient.','multihost'); ?></p>
                        <div class="hr"></div>
                    </div><!-- .bpanel-option-set -->                   
                </div> <!-- .box-content -->
                
                <?php } else { ?>            	
                	<div class="bpanel-box">
                    	 <div class="bpanel-option-set">
                            <p class="note"><?php esc_html_e('Please activate "DesignThemes Core Features Plugin" to get the Page Builder options.','multihost'); ?></p>
                        </div>
                    </div>                    
                <?php } ?>                
            </div><!-- .bpanel-box end -->
        </div><!--my-footer end-->        
    </div><!-- .bpanel-main-content end-->
</div><!-- general end-->