(function ($) {
    "use strict";

    var $body = $('body');

    var ajax_url = uxper_admin_vars.ajax_url;

    $('body').on('click', '.open-popup', function(event) {
        event.preventDefault();
        var id = $(this).attr('href');
        $(id).addClass('active');
        $( '.site-header' ).addClass( 'show-popup' );
    });

    $('body').on('click', '.btn-close,.bg-overlay', function() {
        $(this).parents('.uxper-popup').removeClass('active');
        $( '.site-header' ).removeClass( 'show-popup' );
        return false;
    });

    $('body').on('click', '.admin-tab-control a', function(e){
        e.preventDefault();
        $('.admin-tab-control a').removeClass('active');
        $(this).addClass('active');
        var id = $(this).attr('href');
        $('.admin-tab-content .inner-content').removeClass('active');
        $(id).addClass('active');
    });

    $('body').on('click', 'td .select-all', function(e) {
        e.preventDefault();
        $(this).closest('td').find(':checkbox').each(function() {
            this.checked = true;                        
        });
    });

    $('body').on('click', 'td .unselect-all', function(e) {
        e.preventDefault();
        $(this).closest('td').find(':checkbox').each(function() {
            this.checked = false;                        
        });
    });

    $('.click-to-copy').on('click', function(){
        $(this).select();
        document.execCommand("copy");
        $(this).closest('.uxper-shortcode').addClass('active');
        setTimeout(function() {
            $('.uxper-shortcode').removeClass('active');
        }, 1000);
    });

    function init_calendar() {
        var $calendars = $('.admin-datepick-calendar');
			
        if ( $calendars.length ) {
            $calendars.each(function(){
                var $calendar = $(this),
                    isRangeSlider = $calendar.hasClass('calendar--range-on');
                
                $calendar.datepick({
                    dateFormat: 'dd M yyyy',
                    minDate: new Date(),
                    changeMonth: false,
                    useMouseWheel: false,
                    showAnim: 'fadeIn',
                    rangeSelect: isRangeSlider,
                    monthsToShow: 1,
                    useMouseWheel: ! isRangeSlider,
                    prevText: '<i class="fal fa-arrow-left"></i>',
                    nextText: '<i class="fal fa-arrow-right"></i>',
                    renderer: {
                        picker: '<div class="datepick">{months}{popup:start}{popup:end}<div class="datepick-clear-fix"></div></div>',
                        monthRow: '<div class="datepick-month-row">{link:prev}{months}{link:next}</div>',
                    },
                });
            });
        }
    }

    function purchase_form() {
        $('.hidden-code input').prop('disabled', true);

        $('body').on('click', '.purchase-form.verified .purchase-icon', function() {
            if( !$(this).closest('.purchase-form').hasClass('hidden-code') ) {
                $(this).closest('.purchase-form').removeClass('hidden-code');
                $('.purchase-form input').prop('disabled', false);
            }else{
                $(this).closest('.purchase-form').addClass('hidden-code');
                $('.purchase-form input').prop('disabled', true);
            }
        });
    }

    function toggle() {
        const CURRENT_SECTION = 'uxper_theme_options_current_section';
        var _current_tab = $('#_current_tab').val(),
            currentSection = localStorage.getItem(CURRENT_SECTION + '_' + _current_tab);
        if (currentSection === null) {
            var sectionActive = $('.uxper-tab li:first').data('id');
            currentSection = sectionActive;
            if (typeof (sectionActive) != 'undefined') {
                localStorage.setItem(CURRENT_SECTION + '_' + _current_tab, sectionActive);
            }
            else {
                /**
                 * Off reset section if not exist section
                 */
                $('.uxper-theme-options-reset-section').remove();
            }
        }
        $('.uxper-tab li').removeClass('active');
        $('.uxper-fields-wrapper > .uxper-section-container').hide();
        $('.uxper-tab li[data-id="' + currentSection + '"]').addClass('active');
        $('.uxper-fields-wrapper > .uxper-section-container[id="' + currentSection + '"]').show();

        /**
         * Store currentSection when section clicked
         */
        $('.uxper-tab li').on('click', function () {
            localStorage.setItem(CURRENT_SECTION + '_' + _current_tab, $(this).data('id'));
        });
    }

    function toggle_admin_tab() {
        const CURRENT_TAB = 'uxper_admin_current_section';
        var _current_page = $('#_current_page').val(),
            currentSection = localStorage.getItem(CURRENT_TAB + '_' + _current_page);
        if (currentSection === null) {
            var sectionActive = $('.admin-tab-control li:first').data('id');
            currentSection = sectionActive;
            if (typeof (sectionActive) != 'undefined') {
                localStorage.setItem(CURRENT_TAB + '_' + _current_page, sectionActive);
            }
            else {
                /**
                 * Off reset section if not exist section
                 */
                $('.uxper-theme-options-reset-section').remove();
            }
        }
        $('.admin-tab-control a').removeClass('active');
        $('.admin-tab-control li').removeClass('active');
        $('.admin-tab-content .inner-content').removeClass('active');
        $('.admin-tab-control li[data-id="' + currentSection + '"] a').addClass('active');
        $('.admin-tab-control li[data-id="' + currentSection + '"]').addClass('active');
        $('.admin-tab-content .inner-content[id="' + currentSection + '"]').addClass('active');

        /**
         * Store currentSection when section clicked
         */
        $('.admin-tab-control li').on('click', function () {
            localStorage.setItem(CURRENT_TAB + '_' + _current_page, $(this).data('id'));
        });
    }

    function save_options() {
        $('.uxper-theme-options-save-options').on('click', function() {
            window.onbeforeunload = null;
        });
    }

    function changeWidthContent() {
        var $tab = $('.area-theme-options .uxper-tab');
        if ($tab.length > 0) {
            var $wrap = $('.area-theme-options .uxper-meta-box-wrap'),
                $fields = $('.area-theme-options .uxper-fields'),
                tabWidth = $tab.outerWidth(),
                wrapWidth = $wrap.width();
            $fields.css({
                'float': 'left',
                'width': (wrapWidth - tabWidth) + 'px',
                'overflow': 'visible'
            });
        }
    }

    function plugin_action() {
        $( '.uxper-crypto-action' ).on( 'click', function(e) {
            e.preventDefault();

            var $el = $( e.currentTarget ),
                $pluginsTable = $( '.uxper-box--plugins table' ),
                $pluginRow = $el.closest( '.uxper-crypto--required' ),
                pluginAction = $el.attr( 'data-plugin-action' ),
                $icon = $pluginRow.find( 'i, .svg-inline--fa' ),
                ajaxData = {
                    'action': 'process_plugin_actions',
                    'slug': $el.attr( 'data-slug' ),
                    'source': $el.attr( 'data-source' ),
                    'plugin_action': $el.attr( 'data-plugin-action' ),
                    '_wpnonce': $el.attr( 'data-nonce' )
                };

            if ( 'deactivate-plugin' === pluginAction ) {
                $el.html( '<i class="las la-circle-notch la-spin"></i>Deactivating' );
            }

            if ( 'activate-plugin' === pluginAction ) {
                $el.html( '<i class="las la-circle-notch la-spin"></i>Activating' );
            }

            $.ajax({
                type: 'POST',
                url: ajax_url,
                data: ajaxData,
                timeout: 20000
            }).done( ( response ) => {
                if ( response.success ) {
                    if ( 'deactivate-plugin' === pluginAction ) {
                        $pluginRow.removeClass( 'uxper-crypto--activated' ).addClass( 'uxper-crypto--deactivated' );
                        $el.text( 'Activate' )
                            .attr( 'data-plugin-action', 'activate-plugin' )
                            .attr( 'data-nonce', response.data )
                            .removeClass( 'plugin-deactivate' )
                            .addClass( 'plugin-activate' );
                        $icon.addClass( 'fa-times' ).removeClass( 'fa-check' );
                    }

                    if ( 'activate-plugin' === pluginAction ) {
                        $pluginRow.removeClass( 'uxper-crypto--deactivated' ).addClass( 'uxper-crypto--activated' );
                        $el.text( 'Deactivate' )
                            .attr( 'data-plugin-action', 'deactivate-plugin' )
                            .attr( 'data-nonce', response.data )
                            .removeClass( 'plugin-activate' )
                            .addClass( 'plugin-deactivate' );
                        $icon.addClass( 'fa-check' ).removeClass( 'fa-times' );
                    }

                    var requiredPluginCount = $pluginsTable.find( '.uxper-crypto--required.uxper-crypto--deactivated' ).length,
                        $pluginCount = $( '.uxper-box--plugins .uxper-box__footer span' );

                    if ( requiredPluginCount ) {
                        $pluginCount.css( 'color', '#dc433f' ).text( 'Please install and activate all required plugins (' + requiredPluginCount + ')' );
                    } else {
                        $pluginCount.css( 'color', '#6fbcae' ).text( 'All required plugins are activated. Now you can import the demo data.' );
                    }
                } else {
                    $el.text( 'Error' );
                }
            });
        });
    }

    function additionalFieldProcess() {
        var $wrapAdditionalField = $('#additional_fields');
        additionalFieldReadOnly();
        additionalFieldEventProcess($wrapAdditionalField);
        $wrapAdditionalField.on('uxper_add_clone_field', function (event) {
            var $target = $(event.target);
            additionalFieldEventProcess($target);

            $target.find('.uxper-field-panel-content,.uxper-clone-field-panel-inner')
                .find('input').removeAttr('readonly');

            $target.find('.uxper-field-panel-content,.uxper-clone-field-panel-inner')
                .find('#additional_fields_label input,#additional_fields_id input,#additional_fields_select_choices textarea')
                .val('');

            $target.find('.uxper-field-panel-content,.uxper-clone-field-panel-inner')
                .find('#additional_fields_field_type select').val('text');
        });

        $(document).on('uxper_save_option_success', function () {
            additionalFieldReadOnly();
        });
    }

    function additionalFieldReadOnly() {
        $('.uxper-field-panel-content,.uxper-clone-field-panel-inner').each(function () {
            var $label = $(this).find('#additional_fields_label input'),
                $id = $label.closest('.uxper-field-panel-content,.uxper-clone-field-panel-inner').find('#additional_fields_id input');
            if ($id.val() !== '') {
                $id.attr('readonly', 'readonly');
            }
        });

    }

    function additionalFieldEventProcess($wrap) {
        $wrap.find('.uxper-field-panel-content,.uxper-clone-field-panel-inner').find('#additional_fields_label input').on('change', function () {
            var $label = $(this),
                $id = $label.closest('.uxper-field-panel-content,.uxper-clone-field-panel-inner').find('#additional_fields_id input');
            if ($id.attr('readonly') !== 'readonly') {
                $id.val(toSlug($label.val()));
            }
        });
    }

    function toSlug(str) {
        str = String(str).toString();
        str = str.replace(/^\s+|\s+$/g, "");
        str = str.toLowerCase();

        var swaps = {
            '0': ['°', '₀', '۰', '０'],
            '1': ['¹', '₁', '۱', '１'],
            '2': ['²', '₂', '۲', '２'],
            '3': ['³', '₃', '۳', '３'],
            '4': ['⁴', '₄', '۴', '٤', '４'],
            '5': ['⁵', '₅', '۵', '٥', '５'],
            '6': ['⁶', '₆', '۶', '٦', '６'],
            '7': ['⁷', '₇', '۷', '７'],
            '8': ['⁸', '₈', '۸', '８'],
            '9': ['⁹', '₉', '۹', '９'],
            'a': ['à', 'á', 'ả', 'ã', 'ạ', 'ă', 'ắ', 'ằ', 'ẳ', 'ẵ', 'ặ', 'â', 'ấ', 'ầ', 'ẩ', 'ẫ', 'ậ', 'ā', 'ą', 'å', 'α', 'ά', 'ἀ', 'ἁ', 'ἂ', 'ἃ', 'ἄ', 'ἅ', 'ἆ', 'ἇ', 'ᾀ', 'ᾁ', 'ᾂ', 'ᾃ', 'ᾄ', 'ᾅ', 'ᾆ', 'ᾇ', 'ὰ', 'ά', 'ᾰ', 'ᾱ', 'ᾲ', 'ᾳ', 'ᾴ', 'ᾶ', 'ᾷ', 'а', 'أ', 'အ', 'ာ', 'ါ', 'ǻ', 'ǎ', 'ª', 'ა', 'अ', 'ا', 'ａ', 'ä'],
            'b': ['б', 'β', 'ب', 'ဗ', 'ბ', 'ｂ'],
            'c': ['ç', 'ć', 'č', 'ĉ', 'ċ', 'ｃ'],
            'd': ['ď', 'ð', 'đ', 'ƌ', 'ȡ', 'ɖ', 'ɗ', 'ᵭ', 'ᶁ', 'ᶑ', 'д', 'δ', 'د', 'ض', 'ဍ', 'ဒ', 'დ', 'ｄ'],
            'e': ['é', 'è', 'ẻ', 'ẽ', 'ẹ', 'ê', 'ế', 'ề', 'ể', 'ễ', 'ệ', 'ë', 'ē', 'ę', 'ě', 'ĕ', 'ė', 'ε', 'έ', 'ἐ', 'ἑ', 'ἒ', 'ἓ', 'ἔ', 'ἕ', 'ὲ', 'έ', 'е', 'ё', 'э', 'є', 'ə', 'ဧ', 'ေ', 'ဲ', 'ე', 'ए', 'إ', 'ئ', 'ｅ'],
            'f': ['ф', 'φ', 'ف', 'ƒ', 'ფ', 'ｆ'],
            'g': ['ĝ', 'ğ', 'ġ', 'ģ', 'г', 'ґ', 'γ', 'ဂ', 'გ', 'گ', 'ｇ'],
            'h': ['ĥ', 'ħ', 'η', 'ή', 'ح', 'ه', 'ဟ', 'ှ', 'ჰ', 'ｈ'],
            'i': ['í', 'ì', 'ỉ', 'ĩ', 'ị', 'î', 'ï', 'ī', 'ĭ', 'į', 'ı', 'ι', 'ί', 'ϊ', 'ΐ', 'ἰ', 'ἱ', 'ἲ', 'ἳ', 'ἴ', 'ἵ', 'ἶ', 'ἷ', 'ὶ', 'ί', 'ῐ', 'ῑ', 'ῒ', 'ΐ', 'ῖ', 'ῗ', 'і', 'ї', 'и', 'ဣ', 'ိ', 'ီ', 'ည်', 'ǐ', 'ი', 'इ', 'ی', 'ｉ'],
            'j': ['ĵ', 'ј', 'Ј', 'ჯ', 'ج', 'ｊ'],
            'k': ['ķ', 'ĸ', 'к', 'κ', 'Ķ', 'ق', 'ك', 'က', 'კ', 'ქ', 'ک', 'ｋ'],
            'l': ['ł', 'ľ', 'ĺ', 'ļ', 'ŀ', 'л', 'λ', 'ل', 'လ', 'ლ', 'ｌ'],
            'm': ['м', 'μ', 'م', 'မ', 'მ', 'ｍ'],
            'n': ['ñ', 'ń', 'ň', 'ņ', 'ŉ', 'ŋ', 'ν', 'н', 'ن', 'န', 'ნ', 'ｎ'],
            'o': ['ó', 'ò', 'ỏ', 'õ', 'ọ', 'ô', 'ố', 'ồ', 'ổ', 'ỗ', 'ộ', 'ơ', 'ớ', 'ờ', 'ở', 'ỡ', 'ợ', 'ø', 'ō', 'ő', 'ŏ', 'ο', 'ὀ', 'ὁ', 'ὂ', 'ὃ', 'ὄ', 'ὅ', 'ὸ', 'ό', 'о', 'و', 'θ', 'ို', 'ǒ', 'ǿ', 'º', 'ო', 'ओ', 'ｏ', 'ö'],
            'p': ['п', 'π', 'ပ', 'პ', 'پ', 'ｐ'],
            'q': ['ყ', 'ｑ'],
            'r': ['ŕ', 'ř', 'ŗ', 'р', 'ρ', 'ر', 'რ', 'ｒ'],
            's': ['ś', 'š', 'ş', 'с', 'σ', 'ș', 'ς', 'س', 'ص', 'စ', 'ſ', 'ს', 'ｓ'],
            't': ['ť', 'ţ', 'т', 'τ', 'ț', 'ت', 'ط', 'ဋ', 'တ', 'ŧ', 'თ', 'ტ', 'ｔ'],
            'u': ['ú', 'ù', 'ủ', 'ũ', 'ụ', 'ư', 'ứ', 'ừ', 'ử', 'ữ', 'ự', 'û', 'ū', 'ů', 'ű', 'ŭ', 'ų', 'µ', 'у', 'ဉ', 'ု', 'ူ', 'ǔ', 'ǖ', 'ǘ', 'ǚ', 'ǜ', 'უ', 'उ', 'ｕ', 'ў', 'ü'],
            'v': ['в', 'ვ', 'ϐ', 'ｖ'],
            'w': ['ŵ', 'ω', 'ώ', 'ဝ', 'ွ', 'ｗ'],
            'x': ['χ', 'ξ', 'ｘ'],
            'y': ['ý', 'ỳ', 'ỷ', 'ỹ', 'ỵ', 'ÿ', 'ŷ', 'й', 'ы', 'υ', 'ϋ', 'ύ', 'ΰ', 'ي', 'ယ', 'ｙ'],
            'z': ['ź', 'ž', 'ż', 'з', 'ζ', 'ز', 'ဇ', 'ზ', 'ｚ'],
            'aa': ['ع', 'आ', 'آ'],
            'ae': ['æ', 'ǽ'],
            'ai': ['ऐ'],
            'ch': ['ч', 'ჩ', 'ჭ', 'چ'],
            'dj': ['ђ', 'đ'],
            'dz': ['џ', 'ძ'],
            'ei': ['ऍ'],
            'gh': ['غ', 'ღ'],
            'ii': ['ई'],
            'ij': ['ĳ'],
            'kh': ['х', 'خ', 'ხ'],
            'lj': ['љ'],
            'nj': ['њ'],
            'oe': ['ö', 'œ', 'ؤ'],
            'oi': ['ऑ'],
            'oii': ['ऒ'],
            'ps': ['ψ'],
            'sh': ['ш', 'შ', 'ش'],
            'shch': ['щ'],
            'ss': ['ß'],
            'sx': ['ŝ'],
            'th': ['þ', 'ϑ', 'ث', 'ذ', 'ظ'],
            'ts': ['ц', 'ც', 'წ'],
            'ue': ['ü'],
            'uu': ['ऊ'],
            'ya': ['я'],
            'yu': ['ю'],
            'zh': ['ж', 'ჟ', 'ژ'],
            '(c)': ['©'],
            'A': ['Á', 'À', 'Ả', 'Ã', 'Ạ', 'Ă', 'Ắ', 'Ằ', 'Ẳ', 'Ẵ', 'Ặ', 'Â', 'Ấ', 'Ầ', 'Ẩ', 'Ẫ', 'Ậ', 'Å', 'Ā', 'Ą', 'Α', 'Ά', 'Ἀ', 'Ἁ', 'Ἂ', 'Ἃ', 'Ἄ', 'Ἅ', 'Ἆ', 'Ἇ', 'ᾈ', 'ᾉ', 'ᾊ', 'ᾋ', 'ᾌ', 'ᾍ', 'ᾎ', 'ᾏ', 'Ᾰ', 'Ᾱ', 'Ὰ', 'Ά', 'ᾼ', 'А', 'Ǻ', 'Ǎ', 'Ａ', 'Ä'],
            'B': ['Б', 'Β', 'ब', 'Ｂ'],
            'C': ['Ç', 'Ć', 'Č', 'Ĉ', 'Ċ', 'Ｃ'],
            'D': ['Ď', 'Ð', 'Đ', 'Ɖ', 'Ɗ', 'Ƌ', 'ᴅ', 'ᴆ', 'Д', 'Δ', 'Ｄ'],
            'E': ['É', 'È', 'Ẻ', 'Ẽ', 'Ẹ', 'Ê', 'Ế', 'Ề', 'Ể', 'Ễ', 'Ệ', 'Ë', 'Ē', 'Ę', 'Ě', 'Ĕ', 'Ė', 'Ε', 'Έ', 'Ἐ', 'Ἑ', 'Ἒ', 'Ἓ', 'Ἔ', 'Ἕ', 'Έ', 'Ὲ', 'Е', 'Ё', 'Э', 'Є', 'Ə', 'Ｅ'],
            'F': ['Ф', 'Φ', 'Ｆ'],
            'G': ['Ğ', 'Ġ', 'Ģ', 'Г', 'Ґ', 'Γ', 'Ｇ'],
            'H': ['Η', 'Ή', 'Ħ', 'Ｈ'],
            'I': ['Í', 'Ì', 'Ỉ', 'Ĩ', 'Ị', 'Î', 'Ï', 'Ī', 'Ĭ', 'Į', 'İ', 'Ι', 'Ί', 'Ϊ', 'Ἰ', 'Ἱ', 'Ἳ', 'Ἴ', 'Ἵ', 'Ἶ', 'Ἷ', 'Ῐ', 'Ῑ', 'Ὶ', 'Ί', 'И', 'І', 'Ї', 'Ǐ', 'ϒ', 'Ｉ'],
            'J': ['Ｊ'],
            'K': ['К', 'Κ', 'Ｋ'],
            'L': ['Ĺ', 'Ł', 'Л', 'Λ', 'Ļ', 'Ľ', 'Ŀ', 'ल', 'Ｌ'],
            'M': ['М', 'Μ', 'Ｍ'],
            'N': ['Ń', 'Ñ', 'Ň', 'Ņ', 'Ŋ', 'Н', 'Ν', 'Ｎ'],
            'O': ['Ó', 'Ò', 'Ỏ', 'Õ', 'Ọ', 'Ô', 'Ố', 'Ồ', 'Ổ', 'Ỗ', 'Ộ', 'Ơ', 'Ớ', 'Ờ', 'Ở', 'Ỡ', 'Ợ', 'Ø', 'Ō', 'Ő', 'Ŏ', 'Ο', 'Ό', 'Ὀ', 'Ὁ', 'Ὂ', 'Ὃ', 'Ὄ', 'Ὅ', 'Ὸ', 'Ό', 'О', 'Θ', 'Ө', 'Ǒ', 'Ǿ', 'Ｏ', 'Ö'],
            'P': ['П', 'Π', 'Ｐ'],
            'Q': ['Ｑ'],
            'R': ['Ř', 'Ŕ', 'Р', 'Ρ', 'Ŗ', 'Ｒ'],
            'S': ['Ş', 'Ŝ', 'Ș', 'Š', 'Ś', 'С', 'Σ', 'Ｓ'],
            'T': ['Ť', 'Ţ', 'Ŧ', 'Ț', 'Т', 'Τ', 'Ｔ'],
            'U': ['Ú', 'Ù', 'Ủ', 'Ũ', 'Ụ', 'Ư', 'Ứ', 'Ừ', 'Ử', 'Ữ', 'Ự', 'Û', 'Ū', 'Ů', 'Ű', 'Ŭ', 'Ų', 'У', 'Ǔ', 'Ǖ', 'Ǘ', 'Ǚ', 'Ǜ', 'Ｕ', 'Ў', 'Ü'],
            'V': ['В', 'Ｖ'],
            'W': ['Ω', 'Ώ', 'Ŵ', 'Ｗ'],
            'X': ['Χ', 'Ξ', 'Ｘ'],
            'Y': ['Ý', 'Ỳ', 'Ỷ', 'Ỹ', 'Ỵ', 'Ÿ', 'Ῠ', 'Ῡ', 'Ὺ', 'Ύ', 'Ы', 'Й', 'Υ', 'Ϋ', 'Ŷ', 'Ｙ'],
            'Z': ['Ź', 'Ž', 'Ż', 'З', 'Ζ', 'Ｚ'],
            'AE': ['Æ', 'Ǽ'],
            'Ch': ['Ч'],
            'Dj': ['Ђ'],
            'Dz': ['Џ'],
            'Gx': ['Ĝ'],
            'Hx': ['Ĥ'],
            'Ij': ['Ĳ'],
            'Jx': ['Ĵ'],
            'Kh': ['Х'],
            'Lj': ['Љ'],
            'Nj': ['Њ'],
            'Oe': ['Œ'],
            'Ps': ['Ψ'],
            'Sh': ['Ш'],
            'Shch': ['Щ'],
            'Ss': ['ẞ'],
            'Th': ['Þ'],
            'Ts': ['Ц'],
            'Ya': ['Я'],
            'Yu': ['Ю'],
            'Zh': ['Ж']
        };
        Object.keys(swaps).forEach(function (swap) {
            swaps[swap].forEach(function (s) {
                str = str.replace(new RegExp(s, "g"), swap);
            });
        });
        return str.replace(/[^a-z0-9 -]/g, "").replace(/\s+/g, "-").replace(/-+/g, "-").replace(/^-+/, "").replace(/-+$/, "");
    }

    $(document).on('ready', function() {

        additionalFieldProcess();

        init_calendar();

        purchase_form();

        toggle();

        toggle_admin_tab();

        save_options();

        plugin_action();

        setTimeout(function() {
            changeWidthContent();
        }, 100);

    });

})(jQuery);