<?php 
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( !class_exists('Uxper_Base') ) {
	
    /**
     * Class Uxper_Base
     */
    class Uxper_Base {
    	/**
		 * Constructor SP_Loader
		 * *******************************************************
		 */
		public function __construct()
		{	
			$this->create_roles();
			$this->define_constants();
			$this->includes();

			/*
			 * Register auto loader for fields type
			 */
			spl_autoload_register(array($this, 'fields_autoload'));
			add_action('init', array($this, 'theme_init'));
		}

		public function theme_init()
		{
			if (!defined('UXPER_OPTIONS_FONT_USING')) {
				define('UXPER_OPTIONS_FONT_USING', 'uxper_font_using');
			}
		}

		/**
		 * Define constant using in BASE
		 * *******************************************************
		 */
		private function define_constants()
		{
			$base_url = UXPER_CRYPTO_PLUGIN_URL . 'base/';
			$base_url = apply_filters('uxper_base_url', $base_url);
			/**
			 * Define plugin URL
			 */
			if (!defined('UXPER_BASE_URL')) {
				define('UXPER_BASE_URL', $base_url);
			}

			if (!defined('UXPER_BASE_DIR')) {
				define('UXPER_BASE_DIR', plugin_dir_path(__FILE__));
			}

			if (!defined('UXPER_BASE_RESOURCE_PREFIX')) {
				define('UXPER_BASE_RESOURCE_PREFIX', 'uxper_');
			}
		}

    	/**
		 * Includes library for plugin
		 * *******************************************************
		 */
		private function includes() 
		{
			/*
			 * Function
			 */
			require_once UXPER_BASE_DIR . 'inc/functions.php';

			/*
			 * Define post type
			 */
			require_once UXPER_BASE_DIR . 'controls/post-type.php';

			/*
			 * Define taxonomy for post type
			 */
			require_once UXPER_BASE_DIR . 'controls/taxonomy.php';

			/*
			 * Meta box for post type Attribute
			 */
			require_once UXPER_BASE_DIR . 'controls/meta-box.php';

			/*
			 * Define term meta custom config
			 */
			require_once UXPER_BASE_DIR . 'controls/term-meta.php';

			/*
			 * Define theme options
			 */
			require_once UXPER_BASE_DIR . 'controls/theme-options.php';

			/*
			 * Required Field abstract class
			 */
			require_once UXPER_BASE_DIR . 'fields/field.php';
		}

		public function create_roles() {
		    global $wp_roles;

			if ( ! class_exists( 'WP_Roles' ) ) {
				return;
			}

			if ( ! isset( $wp_roles ) ) {
				$wp_roles = new WP_Roles();
			}

		    $capabilities = $this->get_capabilities();

		    foreach ( $capabilities as $cap_group ) {
		        foreach ( $cap_group as $cap ) {
		            $wp_roles->add_cap( 'administrator', $cap );
		        }
		    }
		}

		public function get_capabilities() {
		    $capabilities = array();

		    $capability_types = array( 'room', 'booking' );

		    foreach ( $capability_types as $capability_type ) {

		        $capabilities[ $capability_type ] = array(
		            // Post type
		            "edit_{$capability_type}",
		            "read_{$capability_type}",
		            "delete_{$capability_type}",
		            "edit_{$capability_type}s",
		            "edit_others_{$capability_type}s",
		            "publish_{$capability_type}s",
		            "read_private_{$capability_type}s",
		            "delete_{$capability_type}s",
		            "delete_private_{$capability_type}s",
		            "delete_published_{$capability_type}s",
		            "delete_others_{$capability_type}s",
		            "edit_private_{$capability_type}s",
		            "edit_published_{$capability_type}s",

		            // Terms
		            "manage_{$capability_type}_terms",
		            "edit_{$capability_type}_terms",
		            "delete_{$capability_type}_terms",
		            "assign_{$capability_type}_terms"
		        );
		    }

		    return $capabilities;
		}

		/**
		 * Auto load fields
		 * *******************************************************
		 */
		public function fields_autoload($class_name)
		{
			$class = preg_replace('/^Uxper_Field_/', '', $class_name);
			if ( $class != $class_name ) {
				$class = strtolower($class);
				include_once( UXPER_BASE_DIR . "fields/{$class}/{$class}.class.php" );
			}
		}
    }
    
    new Uxper_Base();
}