<?php
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}
if (!class_exists('Uxper_Field_Group')) {
	class Uxper_Field_Group extends Uxper_Field
	{
		function html_start()
		{
			$field_id = $this->get_id();
			$this->params['clone'] = false;
			$isToggle = isset($this->params['toggle']) ? $this->params['toggle'] : true;
			?>
			<div <?php echo (!empty($field_id) ? 'id="' . esc_attr($field_id) . '"' : ''); ?> class="uxper-group uxper-field" <?php $this->the_required(); ?>>
				<h4>
					<?php echo esc_html($this->params['title']); ?>
					<?php if ($isToggle): ?>
						<?php if ($isToggle && !(isset($this->params['toggle_default']) ? $this->params['toggle_default'] : true)): ?>
                            <span class="uxper-group-toggle dashicons dashicons-arrow-up"></span>
						<?php else: ?>
                            <span class="uxper-group-toggle dashicons dashicons-arrow-down"></span>
						<?php endif;?>
					<?php endif;?>
				</h4>
				<div class="uxper-group-inner"
                <?php if ($isToggle && !(isset($this->params['toggle_default']) ? $this->params['toggle_default'] : true)): ?>
                 style="display: none"
                <?php endif; ?>
                >
			<?php
		}
		function html_end() {
			?>
				</div><!-- /.uxper-group-inner -->
			</div><!-- /.uxper-group -->
			<?php
		}
		function render_content($content_args = '')
		{
			if (!isset($this->params['fields']) || !is_array($this->params['fields'])) {
				return;
			}
			$col = isset($this->params['col']) ? $this->params['col'] : 12;
			foreach ($this->params['fields'] as $field) {
				if (!isset($field['type'])) {
					continue;
				}
				if (!empty($this->panel_id) && ($field['type'] === 'panel')) {
					continue;
				}
				$field_cls = uxper_get_field_class_name($field['type']);
				$meta = new $field_cls($field, 'group', $col, $this->panel_id, $this->panel_index);
				$meta->panel_default = $this->panel_default;
				$meta->render();
			}
		}
	}
}