/**
 * radio field script
 *
 */

var Uxper_RadioClass = function($container) {
	this.$container = $container;
};

(function($) {
	"use strict";

	/**
	 * Define class field prototype
	 */
	Uxper_RadioClass.prototype = {
		init: function() {
			this.$container.find('input.uxper-radio').on('change', function() {
				var $field = $(this).closest('.uxper-field'),
					value = UxperFieldsConfig.fields.getValue($field);
				UxperFieldsConfig.required.checkRequired($field, value);
			});
		}
	};

	/**
	 * Define object field
	 */
	var Uxper_RadioObject = {
		init: function() {
			/**
			 * Init Fields after make clone template
			 */
			var $configWrapper = $('.uxper-meta-config-wrapper');
			$configWrapper = $configWrapper.length ? $configWrapper : $('body');

			$configWrapper.on('uxper_make_template_done', function() {
				$('.uxper-field-radio-inner').each(function () {
					var field = new Uxper_RadioClass($(this));
					field.init();
				});
			});

			/**
			 * Init Clone Field after field cloned
			 */
			$('.uxper-field.uxper-field-radio').on('uxper_add_clone_field', function(event){
				var $items = $(event.target).find('.uxper-field-radio-inner');
				if ($items.length) {
					var field = new Uxper_RadioClass($items);
					field.init();
				}
			});
		}
	};

	/**
	 * Init Field when document ready
	 */
	$(document).ready(function() {
		Uxper_RadioObject.init();
		UxperFieldsConfig.fieldInstance.push(Uxper_RadioObject);
	});
})(jQuery);