<?php
if ( !defined('ABSPATH') ) {
    exit; // Exit if accessed directly
}

if ( !class_exists('Uxper_Post_Type') ) {

    /**
     * Class Uxper_Post_Type
     */
    class Uxper_Post_Type 
    {
        
        protected static $instance = null;

		static function instance() 
        {
			if ( null === self::$instance ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function initialize() 
        {
            add_filter('uxper_register_post_type', array( $this, 'register_post_type' ) );
            add_filter('manage_ux_crypto_posts_columns', array($this, 'posts_columns'));
            add_action('manage_ux_crypto_posts_custom_column', array($this, 'posts_columns_content'), 10, 2);
            add_filter('uxper_meta_box_config', array( $this, 'register_meta_box' ) );
            add_action('add_meta_boxes', array($this, 'meta_boxes'));
		}

        public function posts_columns($columns) {
            $ncolumns = array();
            foreach( $columns as $key => $title ) {
                if ( $key == 'date' ) {
                    $ncolumns['shortcode'] = __('Shortcode', 'uxper-crypto');
                    $ncolumns['type'] = __('Widget Type', 'uxper-crypto');
                }
                $ncolumns[$key] = $title;
            }
            return $ncolumns;
        }

        public function posts_columns_content($column, $post_id) {
            switch ($column) {
                case 'type':
                    $widget_type = get_post_meta( $post_id, UXPER_CRYPTO_METABOX_PREFIX . 'widget_type', true);
                    _e(ucfirst($widget_type), 'uxper-crypto');
                    break;
                case 'shortcode':
                    echo '[uxper_crypto id="' . $post_id . '"]';
                    break;
            }
        }

        public function meta_boxes() {
            add_meta_box('crypto_widget_shortcode', __('Shortcode', 'uxper-crypto'), array($this, 'meta_shortcode'), 'ux_crypto', 'side', 'high');
        }

        public function meta_shortcode($post) {
            echo '<div class="uxper-shortcode"><p><span class="shortcode-hint">Copied!</span>Paste this shortcode anywhere like page, post or widgets</p>';
            echo '<input type="text" class="click-to-copy" readonly="readonly" value="' . esc_attr('[uxper_crypto id="' . $post->ID . '"]') . '" /></div>';
        }

        /**
         * Register post_type
         * @param $post_types
         * @return mixed
         */
        public function register_post_type($post_types)
        {
            $post_types['ux_crypto'] = array(
                'label'           => esc_html__('Uxper Crypto', 'uxper-crypto'),
                'singular_name'   => esc_html__('Uxper Crypto', 'uxper-crypto'),
                'supports'        => array('title'),
                'menu_icon'       => 'dashicons-money-alt',
                'can_export'      => true,
                'show_in_rest'    => false,
                'capability_type' => 'post',
                'map_meta_cap'    => true,
                'menu_position'   => 4,
                'rewrite'         => array(
                    'slug' => apply_filters('uxper_crypto_slug', 'ux_crypto'),
                ),
            );
            
            return $post_types;
        }

        /**
         * Register meta boxes
         * @param $configs
         * @return mixed
         */
        public function register_meta_box($configs)
        {
            $meta_prefix   = UXPER_CRYPTO_METABOX_PREFIX;
            $dec_point     = Uxper_Helper::setting('decimal_separator', '.');
            $currency_sign = Uxper_Helper::setting('currency_sign', '$');
            $format_number = '^[0-9]+([' . $dec_point . '][0-9]+)?$';

            $select_list = Uxper_Coin::select_list();
            
            $configs['ux_crypto_meta_boxes'] = apply_filters('uxper_register_meta_boxes_ux_crypto', array(
                'name'      => esc_html__('Widget Settings', 'uxper-crypto'),
                'post_type' => array('ux_crypto'),
                'fields' => array(
                    array(
                        'id'      => "{$meta_prefix}widget_type",
                        'title'   => esc_html__('Widget Type', 'uxper-crypto'),
                        'type'    => 'radio',
                        'default' => 'ticker',
                        'options' => array( 
                            'ticker'    => esc_html__('Ticker', 'uxper-crypto'),
                            'table'     => esc_html__('Table', 'uxper-crypto'),
                            'converter' => esc_html__('Converter', 'uxper-crypto'),
                        ),
                    ),
                    array(
                        'id'       => "{$meta_prefix}widget_coin",
                        'title'    => esc_html__('Coin(s)', 'uxper-crypto'),
                        'type'     => 'selectize',
                        'multiple' => true,
                        'drag'     => true,
                        'options'  => $select_list,
                        'default'  => '',
                    ),
                    array(
                        'type'        => 'row',
                        'col'         => '12',
                        'fields'      => array(
                            array(
                                'id'      => "{$meta_prefix}widget_real_time",
                                'title'   => esc_html__('Real Time', 'uxper-crypto'),
                                'type'    => 'button_set',
                                'col'     => '6',
                                'options' => array(
                                    'off' => esc_html__('No', 'uxper-crypto'),
                                    'on'  => esc_html__('Yes', 'uxper-crypto'),
                                ),
                                'default'  => 'on',
                                'required' => array(
                                    "{$meta_prefix}widget_type", '!=', 'converter',
                                ),
                            ),
                            array(
                                'id'      => "{$meta_prefix}widget_display_logo",
                                'title'   => esc_html__('Display Logo', 'uxper-crypto'),
                                'type'    => 'button_set',
                                'col'     => '6',
                                'options' => array(
                                    '0' => esc_html__('No', 'uxper-crypto'),
                                    '1' => esc_html__('Yes', 'uxper-crypto'),
                                ),
                                'default' => '1',
                                'required' => array(
                                    "{$meta_prefix}widget_type", '!=', 'converter',
                                ),
                            ),
                            array(
                                'id'      => "{$meta_prefix}widget_display_24h_change",
                                'title'   => esc_html__('24h Change', 'uxper-crypto'),
                                'type'    => 'button_set',
                                'col'     => '6',
                                'options' => array(
                                    '0' => esc_html__('No', 'uxper-crypto'),
                                    '1' => esc_html__('Yes', 'uxper-crypto'),
                                ), 
                                'default'  => '0',
                                'required' => array(
                                    "{$meta_prefix}widget_type", '=', 'ticker',
                                ),
                            ),
                            array(
                                'id'      => "{$meta_prefix}widget_display_chart",
                                'title'   => esc_html__('Chart', 'uxper-crypto'),
                                'type'    => 'button_set',
                                'col'     => '6',
                                'options' => array(
                                    '0' => esc_html__('No', 'uxper-crypto'),
                                    '1' => esc_html__('Yes', 'uxper-crypto'),
                                ), 
                                'default'  => '0',
                                'required' => array(
                                    "{$meta_prefix}widget_type", '=', 'ticker',
                                ),
                            ),
                        )
                    ),
                    array(
                        'id'      => "{$meta_prefix}widget_ticker_position",
                        'title'   => esc_html__('Ticker Position', 'uxper-crypto'),
                        'type'    => 'radio',
                        'options' => array(
                            'top'       => esc_html__('Top', 'uxper-crypto'),
                            'bottom'    => esc_html__('Bottom', 'uxper-crypto'),
                            'shortcode' => esc_html__('Shortcode', 'uxper-crypto'),
                        ), 
                        'default'  => 'top',
                        'required' => array(
                            "{$meta_prefix}widget_type", '=', 'ticker',
                        ),
                    ),
                    array(
                        'id'      => "{$meta_prefix}widget_ticker_speed",
                        'title'   => esc_html__('Speed (%)', 'uxper-crypto'),
                        'type'    => 'slider',
                        'default' => '100',
                        'js_options' => array(
                            'step' => 1,
                            'min'  => 0,
                            'max'  => 200
                        ),
                        'required' => array(
                            "{$meta_prefix}widget_type", '=', 'ticker',
                        ),
                    ),
                    array(
                        'id'      => "{$meta_prefix}widget_table_column",
                        'title'   => esc_html__('Display Column', 'uxper-crypto'),
                        'type'    => 'sortable',
                        'options' => array(
                            'rank'               => esc_html__('#', 'uxper-crypto'),
                            'name'               => esc_html__('Name', 'uxper-crypto'),
                            'price_usd'          => esc_html__('Price', 'uxper-crypto'),
                            'percent_change_24h' => esc_html__('24h %', 'uxper-crypto'),
                            'percent_change_7d'  => esc_html__('7d %', 'uxper-crypto'),
                            'volume_usd_24h'     => esc_html__('24H %', 'uxper-crypto'),
                            'market_cap_usd'     => esc_html__('Marketcap', 'uxper-crypto'),
                            'chart'              => esc_html__('Chart', 'uxper-crypto'),
                            'available_supply'   => esc_html__('Supply', 'uxper-crypto'),
                            'total_supply'       => esc_html__('Max Supply', 'uxper-crypto'),
                        ),
                        'default'  => array(
                            'rank', 'name', 'price_usd', 'percent_change_24h', 'percent_change_7d', 'volume_usd_24h', 'market_cap_usd', 'available_supply', 'total_supply'
                        ),
                        'required' => array(
                            "{$meta_prefix}widget_type", '=', 'table',
                        ),
                    ),
                    array(
                        'id'       => "{$meta_prefix}widget_background_color",
                        'title'    => esc_html__('Background Color', 'uxper-crypto'),
                        'type'     => 'color',
                        'default'  => '#ffffff',
                        'required' => array(
                            "{$meta_prefix}widget_type", '!=', 'converter',
                        ),
                    ),
                    array(
                        'id'       => "{$meta_prefix}widget_color",
                        'title'    => esc_html__('Text Color', 'uxper-crypto'),
                        'type'     => 'color',
                        'default'  => '#333333',
                        'required' => array(
                            "{$meta_prefix}widget_type", '!=', 'converter',
                        ),
                    ),
                )
            ));

            return apply_filters('uxper_register_meta_boxes', $configs);
        }
    }

    Uxper_Post_Type::instance()->initialize();
}