<?php

// Exit if accessed directly
if ( ! defined('ABSPATH') ) {
    exit;
}

// Uxper Crypto Table
if ( ! class_exists('Uxper_Crypto_Table') ) {

    /**
     *  Class Uxper_Crypto_Table
     */
    class Uxper_Crypto_Table
    {
        protected static $instance = null;

        public static function instance() {
            if (null === self::$instance) {
                self::$instance = new self();
            }

            return self::$instance;
        }

        public function initialize() {
            if( ! $this->is_table_exists() ) {
                $this->active();
            }
            $this->check_table();

            register_activation_hook( UXPER_CRYPTO_PLUGIN_FILE, array( $this, 'active') );
            register_deactivation_hook( UXPER_CRYPTO_PLUGIN_FILE, array( $this, 'deactivate') );
        }

        public static function is_table_exists() {
            global $wpdb;
            $table_name = $wpdb->base_prefix . 'ux_crypto';

            $table = $wpdb->prepare("SHOW TABLES LIKE %s", $table_name);

            if ( $wpdb->get_var($table) == $table_name) {
                return true;
            } else {
                return false;
            }
        }

        public static function check_table() {
            global $wpdb;
            $table_name = $wpdb->base_prefix . 'ux_crypto';

            $result = $wpdb->get_results( 
                "SELECT *
                FROM $table_name LIMIT 1"
            );
            
            return ( count($result) > 0 ) ? true : false;
        }

        public function active() {
            global $wpdb;
            $table_name = $wpdb->base_prefix . 'ux_crypto';
            $charset_collate = $wpdb->get_charset_collate();

            $sql = "CREATE TABLE IF NOT EXISTS $table_name (
                id mediumint(9) NOT NULL AUTO_INCREMENT,
                name varchar(100) NOT NULL,
                symbol varchar(10) NOT NULL,
                slug varchar(100) NOT NULL,
                img varchar(200) NOT NULL,
                rank int(5) NOT NULL,
                price_usd decimal(20,10) NOT NULL,
                price_btc decimal(10,8) NOT NULL,
                volume_usd_24h decimal(22,2) NOT NULL,
                market_cap_usd decimal(22,2) NOT NULL,
                chart varchar(200) NOT NULL,
                high_24h decimal(20,10) NOT NULL,
                low_24h decimal(20,10) NOT NULL,
                available_supply decimal(22,2) NOT NULL,
                total_supply decimal(22,2) NOT NULL,
                ath decimal(20,10) NOT NULL,
                ath_date int(11) UNSIGNED NOT NULL,
                price_change_24h decimal(20,10) NOT NULL,
                percent_change_1h decimal(7,2) NOT NULL,
                percent_change_24h decimal(7,2) NOT NULL,
                percent_change_7d decimal(7,2) NOT NULL,
                percent_change_30d decimal(7,2) NOT NULL,
                weekly longtext NOT NULL,
                weekly_expire TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
                keywords varchar(255) NOT NULL,
                custom text NULL,
                UNIQUE KEY id (id),
                UNIQUE (slug)
            ) $charset_collate;";
    
            // we do not execute sql directly
            // we are calling dbDelta which cant migrate database
            require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
            dbDelta($sql);
        }

        public function deactivate() {
            delete_transient('uxper-coin-request');
            delete_transient('uxper-currencies');
        }
    }

    Uxper_Crypto_Table::instance()->initialize();
}