<?php

// Exit if accessed directly
if ( ! defined('ABSPATH') ) {
    exit;
}

// Uxper Coin
if ( ! class_exists('Uxper_Coin') ) {

    /**
     *  Class Uxper_Coin
     */
    class Uxper_Coin
    {
        protected static $instance = null;

        public static function instance() {
            if (null === self::$instance) {
                self::$instance = new self();
            }

            return self:: $instance;
        }

        public function initialize() {
            $this->data_request();
        }

        public static function api_request($url, $parameters, $headers) {
            if( empty($url) ) return;

            if( empty($headers) ) {
                $headers = [
                    'Accepts: application/json',
                ];
            }

            $request = $url; 
            if( !empty($parameters) ) {
                $qs      = http_build_query($parameters);  // query string encode the parameters
                $request = "{$url}?{$qs}";                 // create the request URL
            }

            $curl = curl_init($request); // Get cURL resource

            curl_setopt($curl, CURLOPT_POST, false);
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($curl, CURLOPT_HEADER, false);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

            $response = curl_exec($curl); // Send the request, save the response

            if ( empty($response) ) {
                $notice = curl_error($curl);
                curl_close($curl);
            } else {
                $info = curl_getinfo($curl);
                curl_close($curl);
                if ( $info['http_code'] != 200 && $info['http_code'] != 201 ) {
                    $notice = "Received error: " . $info['http_code'] . "\n";
                    $notice .= "Raw response:" . $response . "\n";
                }
            }

            $jsonResponse = json_decode($response, true);

            return $jsonResponse;
        }

        public static function data_request() {
            $data  = get_transient('uxper-coin-request');
            $cache = get_transient('uxper-crypto-datatime');
            $api   = 'coincap';
            $api_interval = 900;
            $jsonResponse = '';

            if ( $cache !== false && $cache > (time() - $api_interval) && Uxper_Crypto_Table::check_table() ) return;
            delete_transient('uxper-crypto-datatime');

            switch ($api) {
                case 'coincap':

                    $jsonResponse = self::data_coin_cap();

                    break;

                case 'coinmarketcap':

                    $jsonResponse = self::data_coinmarketcap();

                    break;
            }

            return $jsonResponse;
        }

        public static function data_coin_cap() {

            $parameters = [
                'limit' => '2000',
            ];

            $url = 'https://api.coincap.io/v2/assets';
            $jsonResponse = self::api_request($url, $parameters, false);

            $result = apply_filters('uxper_coin_data', $jsonResponse);

            if ( !empty($result) ) {

                global $wpdb;
                $table_name = $wpdb->base_prefix . 'ux_crypto';

                if( !Uxper_Crypto_Table::is_table_exists() ) return;
            
                $wpdb->query("TRUNCATE $table_name");

                if( !empty($result['data']) ) {

                    $data = $result['data'];

                    $sql_rows = [];

                    $btc_price = 1;
                    if( !empty($data[0]['priceUsd']) ) {
                        $btc_price = $data[0]['priceUsd'];
                    }

                    foreach ($data as $coin) {
                        $priceUSD = $priceBTC = '';
                        if( !empty($coin['priceUsd']) ) {
                            $priceBTC = $coin['priceUsd'] / $btc_price;
                        }
                        if( !empty($coin['symbol']) ) {
                                  $symbol  = strtolower($coin['symbol']);
                            $coin['image'] = 'https://assets.coincap.io/assets/icons/' . $symbol . '@2x.png';
                        }

                        $name               = !empty($coin['name']) ? $coin['name'] : '';
                        $symbol             = !empty($coin['symbol']) ? $coin['symbol'] : '';
                        $slug               = !empty($coin['id']) ? $coin['id'] : '';
                        $image              = !empty($coin['image']) ? $coin['image'] : '';
                        $rank               = !empty($coin['rank']) ? $coin['rank'] : '';
                        $priceUSD           = !empty($coin['priceUsd']) ? floatval($coin['priceUsd']) : '';
                        $volume_24h         = !empty($coin['volumeUsd24Hr']) ? floatval($coin['volumeUsd24Hr']) : '';
                        $market_cap         = !empty($coin['marketCapUsd']) ? floatval($coin['marketCapUsd']) : '';
                        $chart              = !empty($coin['chart']) ? $coin['chart'] : '';
                        $supply             = !empty($coin['supply']) ? floatval($coin['supply']) : '';
                        $total_supply       = !empty($coin['maxSupply']) ? floatval($coin['maxSupply']) : '';
                        $percent_change_1h  = !empty($coin['percent_change_1h']) ? floatval($coin['percent_change_1h']) : '';
                        $percent_change_24h = !empty($coin['changePercent24Hr']) ? floatval($coin['changePercent24Hr']) : '';
                        $percent_change_7d  = !empty($coin['percent_change_7d']) ? floatval($coin['percent_change_7d']) : '';
                        
                        if( !empty($coin['symbol']) ) {
                            $symbol = strtolower($coin['symbol']);
                            $image = 'https://assets.coincap.io/assets/icons/' . $symbol . '@2x.png';
                        }

                        if( !empty($coin['symbol']) ) {
                            $chart = 'https://images.cryptocompare.com/sparkchart/' . strtoupper($coin['symbol']) . '/USD/latest.png';
                        }
                        
                        $sql_rows[] = array(
                            $name, 
                            $symbol, 
                            $slug,
                            $image,
                            $chart,
                            $rank, 
                            floatval($priceUSD),
                            floatval($priceBTC), 
                            $volume_24h,
                            $market_cap,  
                            0.00, 
                            0.00, 
                            $supply, 
                            $total_supply, 
                            0.00, 
                            strtotime('now'), 
                            0.00, 
                            $percent_change_1h, 
                            $percent_change_24h, 
                            $percent_change_7d, 
                            null, 
                            gmdate("Y-m-d H:i:s")
                        );
                    }

                    $sql_rows = array_chunk($sql_rows, 100, true);

                    foreach ($sql_rows as $row) {
                        $placeholder = "(%s, %s, %s, %s, %s, %d, %f, %f, %f, %f, %f, %f, %f, %f, %f, %d, %f, %f, %f, %f, %f, %s)";
                        $query = "INSERT IGNORE INTO `{$table_name}` (`name`, `symbol`, `slug`, `img`, `chart`, `rank`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `high_24h`, `low_24h`, `available_supply`, `total_supply`, `ath`, `ath_date`, `price_change_24h`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `percent_change_30d`, `weekly_expire`) VALUES ";
                        $query .= implode(", ", array_fill(0, count($row), $placeholder));
                        $wpdb->query( $wpdb->prepare( $query, call_user_func_array('array_merge', $row) ) );
                    }

                    set_transient('uxper-crypto-datatime', time());
                }
            }

            return $jsonResponse;
        }

        public static function data_coinmarketcap() {
            $parameters = [
                'start' => '1',
                'limit' => '5000',
                'convert' => 'USD'
            ];

            $headers = [
                'Accepts: application/json',
                'X-CMC_PRO_API_KEY: 7f4c10fd-e8f1-4814-b346-ca1b8932e8f7'
            ];

            $url = 'https://pro-api.coinmarketcap.com/v1/cryptocurrency/listings/latest';

            $jsonResponse = self::api_request($url, $parameters, $headers);

            $result = apply_filters('uxper_coin_data', $jsonResponse);

            if ( !empty($result) ) {

                global $wpdb;
                $table_name = $wpdb->base_prefix . 'ux_crypto';
            
                $wpdb->query("TRUNCATE $table_name");

                if( !empty($result['data']) ) {

                    $data = $result['data'];

                    $sql_rows = [];

                    $btc_price = 1;
                    if( !empty($data[0]['quote']['USD']['price']) ) {
                        $btc_price = $data[0]['quote']['USD']['price'];
                    }

                    foreach ($data as $coin) {
                        $priceUSD     = $priceBTC = '';
                        $name         = !empty($coin['name']) ? $coin['name'] : '';
                        $symbol       = !empty($coin['symbol']) ? strtoupper($coin['symbol']) : '';
                        $slug         = !empty($coin['slug']) ? $coin['slug'] : '';
                        $image        = !empty($coin['image']) ? $coin['image'] : '';
                        $cmc_rank     = !empty($coin['cmc_rank']) ? $coin['cmc_rank'] : '';
                        $supply       = !empty($coin['circulating_supply']) ? floatval($coin['circulating_supply']) : '';
                        $total_supply = !empty($coin['total_supply']) ? floatval($coin['total_supply']) : '';
                        $chart        = !empty($coin['chart']) ? $coin['chart'] : '';

                        if( !empty($coin['quote']['USD']) ) {
                            $quoteUSD = $coin['quote']['USD'];
                            if( !empty($quoteUSD['price']) ) {
                                $priceUSD = $quoteUSD['price'];
                                if( $btc_price !== 0 ) {
                                    $priceBTC = $priceUSD / $btc_price;
                                }
                            }

                            $volume_24h         = !empty($quoteUSD['volume_24h']) ? floatval($quoteUSD['volume_24h']) : '';
                            $market_cap         = !empty($quoteUSD['market_cap']) ? floatval($quoteUSD['market_cap']) : '';
                            $percent_change_1h  = !empty($quoteUSD['percent_change_1h']) ? floatval($quoteUSD['percent_change_1h']) : '';
                            $percent_change_24h = !empty($quoteUSD['percent_change_24h']) ? floatval($quoteUSD['percent_change_24h']) : '';
                            $percent_change_7d  = !empty($quoteUSD['percent_change_7d']) ? floatval($quoteUSD['percent_change_7d']) : '';
                        }
                        
                        if( !empty($coin['id']) ) {
                            $image = 'https://s2.coinmarketcap.com/static/img/coins/64x64/' . $coin['id'] . '.png';
                        }

                        if( !empty($coin['symbol']) ) {
                            $chart = 'https://images.cryptocompare.com/sparkchart/' . strtoupper($coin['symbol']) . '/USD/latest.png';
                        }
                        
                        $sql_rows[] = array(
                            $name, 
                            $symbol, 
                            $slug,
                            $image,
                            $chart,
                            $cmc_rank, 
                            floatval($priceUSD), 
                            floatval($priceBTC), 
                            $volume_24h,
                            $market_cap, 
                            0.00, 
                            0.00, 
                            $supply, 
                            $total_supply, 
                            0.00, 
                            strtotime('now'), 
                            0.00, 
                            $percent_change_1h, 
                            $percent_change_24h, 
                            $percent_change_7d, 
                            null, 
                            gmdate("Y-m-d H:i:s")
                        );
                    }

                    $sql_rows = array_chunk($sql_rows, 100, true);

                    foreach ($sql_rows as $row) {
                        $placeholder = "(%s, %s, %s, %s, %s, %d, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %d, %f, %f, %f, %f, %f, %s)";
                        $query = "INSERT IGNORE INTO `{$table_name}` (`name`, `symbol`, `slug`, `img`, `chart`, `rank`, `price_usd`, `price_btc`, `volume_usd_24h`, `market_cap_usd`, `high_24h`, `low_24h`, `available_supply`, `total_supply`, `ath`, `ath_date`, `price_change_24h`, `percent_change_1h`, `percent_change_24h`, `percent_change_7d`, `percent_change_30d`, `weekly_expire`) VALUES ";
                        $query .= implode(", ", array_fill(0, count($row), $placeholder));
                        $wpdb->query( $wpdb->prepare( $query, call_user_func_array('array_merge', $row) ) );
                    }

                    set_transient('uxper-crypto-datatime', time());
                }
            }

            return $jsonResponse;
        }

        public static function select_list() {
            global $wpdb;
			$table_name = $wpdb->base_prefix . 'ux_crypto';
            $data = $wpdb->get_results("SELECT `name`, `symbol`, `slug` FROM `{$table_name}` ORDER BY `rank` ASC");

            $result = array();

            if( !empty($data) ) {
                foreach( $data as $coin ) {
                    $result[$coin->slug] = $coin->name;
                }
            }
            
            return $result;
        }

        public static function select_currencies() {
            $currencies = get_transient('uxper-currencies');

            if ( $currencies === false ) {
                $url = 'https://api.coincap.io/v2/rates';
                $jsonResponse = self::api_request($url, false, false);

                if( !empty($jsonResponse) ) {
                    set_transient('uxper-currencies', $jsonResponse, DAY_IN_SECONDS);
                }
            }

            if( empty($currencies) ) return;

            ob_start();
            ?>
                <select name="select_currency" class="uxper-crypto-select2">
                    <?php foreach( $currencies['data'] as $currency ) { ?>
                        <option value="<?php echo esc_attr($currency['rateUsd']); ?>" <?php if( $currency['symbol'] == 'USD' ) : echo ' selected';endif; ?>>
                            <?php echo esc_attr($currency['symbol']); ?>
                            <?php 
                            if( !empty($currency['currencySymbol']) ) {
                                echo esc_attr('(' . $currency["currencySymbol"] . ')'); 
                            }
                            ?>
                        </option>
                    <?php } ?>
                </select>
            <?php
            return ob_get_clean();
        }
    }

    Uxper_Coin::instance()->initialize();
}