<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
   exit;
}

/**
 * Helper functions
 */
if ( ! class_exists( 'Uxper_Helper' ) )
{

	class Uxper_Helper
	{
		/**
		 * The constructor.
		 */
		function __construct() {
			add_action( 'delete_attachment', array( $this, 'delete_resized_images' ) );
		}

		/**
		 * Get Option
		 */
	    public static function setting($key, $default = '')
		{
			$option = '';
			$option = get_theme_mod($key);
			return ( !empty($option) ) ? $option : $default;
		}

		/**
		 * Get Option
		 */
	    public static function get_option($key, $default = '')
		{
			$option = get_option(UXPER_CRYPTO_OPTIONS_NAME);
			return (isset($option[$key])) ? $option[$key] : $default;
		}

		/**
		 * Get Setting
		 */
	    public static function theme_setting($key, $default = '')
	    {
	    	$option = '';
			if( class_exists( 'Kirki' ) ) {
				$option = Nuss_Kirki::get_option( 'theme', $key );
			}
			
	        return ( !empty($option) ) ? $option : $default;
	    }

	    /**
		 * Clean Variable
		 */
	    public static function clean( $var ) {
	        if ( is_array( $var ) ) {
	            return array_map( 'uxper_clean', $var );
	        } else {
	            return is_scalar( $var ) ? sanitize_text_field( $var ) : $var;
	        }
	    }

		 /**
         * Get template path
         */
        public static function template_path()
        {
            return apply_filters('uxper_template_path', 'uxper-crypto/');
        }

		/**
		 * Get page id
		 */
		public static function get_page_id($page)
		{
			$page_id = self::get_option('uxper_' . $page . '_page_id');
			if ( $page_id ) {
				return absint( function_exists('pll_get_post') ? pll_get_post($page_id) : $page_id );
			} else {
				return 0;
			}
		}

		/**
		 * Get permalink
		 */
		public static function get_permalink($page)
		{
			if ( $page_id = self::get_page_id($page ) ) {
				return get_permalink($page_id);
			} else {
				return false;
			}
		}

		/**
		 * Get Template
		 */
		public static function get_template($slug, $args = array()) {
			if ( $args && is_array($args) ) {
				extract($args);
			}
			$located = locate_template(array("templates/{$slug}.php"));

			if ( !file_exists($located) ) {
				_doing_it_wrong(__FUNCTION__, sprintf('<code>%s</code> does not exist.', $slug), '1.0');
				return;
			}
			include($located);
		}

		public static function get_template_part($slug, $name = '')
		{
			$template = '';
			if ($name) {
				$template = locate_template(array("{$slug}-{$name}.php", self::template_path() . "{$slug}-{$name}.php"));
			}

			// Get default slug-name.php
			if ( !$template && $name && file_exists( UXPER_CRYPTO_PLUGIN_DIR . "templates/{$slug}-{$name}.php") ) {
				$template = UXPER_CRYPTO_PLUGIN_DIR . "templates/{$slug}-{$name}.php";
			}

			if (!$template) {
				$template = locate_template(array("{$slug}.php", self::template_path() . "{$slug}.php"));
			}

			// Allow 3rd party plugins to filter template file from their plugin.
			$template = apply_filters('get_template_part', $template, $slug, $name);

			if ($template) {
				load_template($template, false);
			}
		}

		public static function get_format_money($money, $price_unit = '', $decimals = 0, $small_sign = false, $symbol = '', $position  = 'before') {
			$formatted_price = $money;
			$money           = doubleval($money);
			if ( isset($money) ) {
				$dec_point      = self::setting('decimal_separator', '.');
				$thousands_sep  = self::setting('thousand_separator', ',');
				$price_decimals = self::setting('price_decimals', '0');

				if( $decimals ) {
					$price_decimals = $decimals;
				}

				if( ! $price_decimals ) {
					$price_decimals = 0;
				}

				$price_unit      = intval($price_unit);
				$formatted_price = number_format($money, $price_decimals, $dec_point, $thousands_sep);

				$currency = self::setting('currency_sign', esc_html__('$', 'uxper-crypto'));

				if( $symbol ) {
					$currency = $symbol;
				}

				if( $symbol == 'none' ) {
					$currency = '';
				}

				if( $small_sign == true && !empty($currency) ) {
					$currency = '<sup>' . $currency. '</sup>';
				}

				$currency_sign_position = self::setting('currency_sign_position', 'before');
				if( $position ) {
					$currency_sign_position = $position;
				}

				if ( $currency_sign_position == 'before' ) {
					return $currency . $formatted_price;
				} else {
					return $formatted_price . $currency;
				}
			} else {
				$currency = 0;
			}
			return $currency;
		}

		public static function send_email( $name, $email, $email_type, $args = array() ) {
			global $wpdb;
			$table_name = $wpdb->base_prefix . 'ux_email_templates';
			$email_template = $wpdb->get_results("SELECT * FROM $table_name WHERE slug = '{$email_type}'");
			if( empty($email_template) ) return;
			$message = $email_template[0]->message;
			$subject = $email_template[0]->subject;

			if ( function_exists('icl_translate') ) {
				$message = icl_translate('uxper-crypto', 'uxper_crypto_email_' . $message, $message);
				$subject = icl_translate('uxper-crypto', 'uxper_crypto_email_subject_' . $subject, $subject);
			}
			$args['website_url']  = get_option('siteurl');
			$args['website_name'] = get_option('blogname');
			$args['user_email']   = $email;
			$args['username']     = $name;

			foreach ($args as $key => $val) {
				$subject = str_replace('%' . $key, $val, $subject);
				$message = str_replace('%' . $key, $val, $message);
			}
			$headers = apply_filters( 'uxper_crypto_contact_mail_header', array('Content-Type: text/html; charset=UTF-8'));

			@wp_mail(
				$email,
				$subject,
				$message,
				$headers
			);
		}

		/**
		 * Get other templates (e.g. product attributes) passing attributes and including the file.
		 */
		public static function uxper_get_template($template_name, $args = array(), $template_path = '', $default_path = '')
		{
			if (!empty($args) && is_array($args)) {
				extract($args);
			}

			$located = self::uxper_locate_template($template_name, $template_path, $default_path);

			if (!file_exists($located)) {
				_doing_it_wrong(__FUNCTION__, sprintf('<code>%s</code> does not exist.', $located), '2.1');
				return;
			}

			// Allow 3rd party plugin filter template file from their plugin.
			$located = apply_filters('uxper_get_template', $located, $template_name, $args, $template_path, $default_path);

			do_action('uxper_before_template_part', $template_name, $template_path, $located, $args);

			include($located);

			do_action('uxper_after_template_part', $template_name, $template_path, $located, $args);
		}

		public static function uxper_locate_template($template_name, $template_path = '', $default_path = '')
		{
			if (!$template_path) {
				$template_path = self::template_path();
			}

			if (!$default_path) {
				$default_path = UXPER_CRYPTO_PLUGIN_DIR . 'templates/';
			}

			// Look within passed path within the theme - this is priority.
			$template = locate_template(
				array(
					trailingslashit($template_path) . $template_name,
					$template_name
				)
			);

			// Get default template/
			if (!$template) {
				$template = $default_path . $template_name;
			}

			// Return what we found.
			return apply_filters('uxper_locate_template', $template, $template_name, $template_path);
		}

		public static function get_post_meta( $name, $default = false ) {
			global $uxper_page_options;

			if ( $uxper_page_options != false && isset( $uxper_page_options[ $name ] ) ) {
				return $uxper_page_options[ $name ];
			}

			return $default;
		}


		public static function uxper_render_additional_fields() {
			$meta_prefix = UXPER_CRYPTO_METABOX_PREFIX;
			$form_fields = self::get_option('room_additional_fields');
			$configs     = array();
			if ($form_fields && is_array($form_fields)) {
				foreach ($form_fields as $key => $field) {
					if(!empty($field['label']))
					{
						$type = $field['field_type'];
						$config = array(
							'title' => $field['label'],
							'id'    => $meta_prefix . sanitize_title($field['label']),
							'type'  => $type,
						);
						$first_opt = '';
						switch ($type) {
							case 'checkbox_list':
							case 'select':
							case 'radio':
								$options     = array();
								$options_arr = isset($field['select_choices']) ? $field['select_choices'] : '';
								$options_arr = str_replace("\r\n", "\n", $options_arr);
								$options_arr = str_replace("\r", "\n", $options_arr);
								$options_arr = explode("\n", $options_arr);
								$first_opt   = !empty($options_arr) ? $options_arr[0] : '';
								foreach ($options_arr as $opt_value) {
									$options[$opt_value] = $opt_value;
								}
	
								$config['options'] = $options;
								break;
						}
						if (in_array($type, array('select', 'radio'))) {
							$config['default'] = $first_opt;
						}
	
						$configs[] = $config;
					}
				}
			}
			return $configs;
		}

		public static function get_the_post_meta( $options, $name, $default = false ) {
			if ( $options != false && isset( $options[ $name ] ) ) {
				return $options[ $name ];
			}

			return $default;
		}

	    /**
		 * Allowed_html
		 */
	    public static function kses_allowed_html() {
	    	$allowed_tags = array(
				'a' => array(
					'id'    => array(),
					'class' => array(),
					'href'  => array(),
					'rel'   => array(),
					'title' => array(),
				),
				'abbr' => array(
					'title' => array(),
				),
				'b' => array(),
				'blockquote' => array(
					'cite'  => array(),
				),
				'cite' => array(
					'title' => array(),
				),
				'code' => array(),
				'del' => array(
					'datetime' => array(),
					'title' => array(),
				),
				'dd' => array(),
				'div' => array(
					'class' => array(),
					'title' => array(),
					'style' => array(),
				),
				'dl' => array(),
				'dt' => array(),
				'em' => array(),
				'h1' => array(),
				'h2' => array(),
				'h3' => array(),
				'h4' => array(),
				'h5' => array(),
				'h6' => array(),
				'i' => array(
					'class' => array(),
				),
				'img' => array(
					'alt'    => array(),
					'class'  => array(),
					'height' => array(),
					'src'    => array(),
					'width'  => array(),
				),
				'li' => array(
					'class' => array(),
				),
				'ol' => array(
					'class' => array(),
				),
				'p' => array(
					'class' => array(),
				),
				'q' => array(
					'cite' => array(),
					'title' => array(),
				),
				'span' => array(
					'class' => array(),
					'title' => array(),
					'style' => array(),
				),
				'strike' => array(),
				'strong' => array(),
				'ul' => array(
					'class' => array(),
				),
			);

			return $allowed_tags;
		}

		/**
		 * Image size
		 */
		public static function image_resize( $data, $image_size ) {
	        if( preg_match( '/\d+x\d+/', $image_size) ){
	            $image_sizes = explode( 'x', $image_size );
	            $image_src  = self::image_resize_id($data, $image_sizes[0], $image_sizes[1], true);
	        }else{
	            if(!in_array( $image_size, array('full','thumbnail'))){
	                $image_size = 'full';
	            }
	            $image_src = wp_get_attachment_image_src($data, $image_size);
	            if ( $image_src && ! empty( $image_src[0] ) ) {
	                $image_src = $image_src[0];
	            }
	        }
	        return $image_src;
	    }

		/**
		 * Image resize by url
		 */
	    public static function image_resize_url( $url, $width = NULL, $height = NULL, $crop = true, $retina = false ) {

	        global $wpdb;

	        if (empty($url))
	            return new WP_Error('no_image_url', esc_html__('No image URL has been entered.', 'uxper-crypto'), $url);

	        if (class_exists('Jetpack') && method_exists('Jetpack', 'get_active_modules') && in_array('photon', Jetpack::get_active_modules())) {
	            $args_crop = array(
	                'resize' => $width . ',' . $height,
	                'crop' => '0,0,' . $width . 'px,' . $height . 'px'
	            );
	            $url = jetpack_photon_url($url, $args_crop);
	        }

	        // Get default size from database
	        $width = ($width) ? $width : self::get_option('thumbnail_size_w');
	        $height = ($height) ? $height : self::get_option('thumbnail_size_h');

	        // Allow for different retina sizes
	        $retina = $retina ? ($retina === true ? 2 : $retina) : 1;

	        // Get the image file path
			$file_path = parse_url($url);
			$file_path = $_SERVER['DOCUMENT_ROOT'] . $file_path['path'];

			// Check for Multisite
			if ( is_multisite() ) { 
				global $blog_id; 
				$blog_details = get_blog_details( $blog_id );
				$file_path = str_replace( $blog_details->path, '/', $file_path );
			}

	        // Destination width and height variables
	        $dest_width = $width * $retina;
	        $dest_height = $height * $retina;

	        // File name suffix (appended to original file name)
	        $suffix = "{$dest_width}x{$dest_height}";

	        // Some additional info about the image
	        $info = pathinfo($file_path);
	        $dir = $info['dirname'];
	        $ext = $info['extension'];
	        $name = wp_basename($file_path, ".$ext");

	        if ('bmp' == $ext) {
	            return new WP_Error('bmp_mime_type', esc_html__('Image is BMP. Please use either JPG or PNG.', 'uxper-crypto'), $url);
	        }

	        // Suffix applied to filename
	        $suffix = "{$dest_width}x{$dest_height}";

	        // Get the destination file name
	        $dest_file_name = "{$dir}/{$name}-{$suffix}.{$ext}";

	        if (!file_exists($dest_file_name)) {

	            /*
	             *  Bail if this image isn't in the Media Library.
	             *  We only want to resize Media Library images, so we can be sure they get deleted correctly when appropriate.
	             */
	            $query = $wpdb->prepare("SELECT * FROM $wpdb->posts WHERE guid='%s'", $url);
	            $get_attachment = $wpdb->get_results($query);
	            // if (!$get_attachment)
	            //     return array('url' => $url, 'width' => $width, 'height' => $height);

	            // Load Wordpress Image Editor
	            $editor = wp_get_image_editor($file_path);
	            if (is_wp_error($editor))
	                return array('url' => $url, 'width' => $width, 'height' => $height);

	            // Get the original image size
	            $size = $editor->get_size();
	            $orig_width = $size['width'];
	            $orig_height = $size['height'];

	            $src_x = $src_y = 0;
	            $src_w = $orig_width;
	            $src_h = $orig_height;

	            if ($crop) {

	                $cmp_x = $orig_width / $dest_width;
	                $cmp_y = $orig_height / $dest_height;

	                // Calculate x or y coordinate, and width or height of source
	                if ($cmp_x > $cmp_y) {
	                    $src_w = round($orig_width / $cmp_x * $cmp_y);
	                    $src_x = round(($orig_width - ($orig_width / $cmp_x * $cmp_y)) / 2);
	                } else if ($cmp_y > $cmp_x) {
	                    $src_h = round($orig_height / $cmp_y * $cmp_x);
	                    $src_y = round(($orig_height - ($orig_height / $cmp_y * $cmp_x)) / 2);
	                }

	            }

	            // Time to crop the image!
	            $editor->crop($src_x, $src_y, $src_w, $src_h, $dest_width, $dest_height);

	            // Now let's save the image
	            $saved = $editor->save($dest_file_name);

	            // Get resized image information
	            $resized_url = str_replace(wp_basename($url), wp_basename($saved['path']), $url);
	            $resized_width = $saved['width'];
	            $resized_height = $saved['height'];
	            $resized_type = $saved['mime-type'];

	            // Add the resized dimensions to original image metadata (so we can delete our resized images when the original image is delete from the Media Library)
	            if( $get_attachment ) {
	            	$metadata = wp_get_attachment_metadata($get_attachment[0]->ID);
		            if (isset($metadata['image_meta'])) {
		                $metadata['image_meta']['resized_images'][] = $resized_width . 'x' . $resized_height;
		                wp_update_attachment_metadata($get_attachment[0]->ID, $metadata);
		            }
	            }

	            // Create the image array
	            $image_array = array(
	                'url' => $resized_url,
	                'width' => $resized_width,
	                'height' => $resized_height,
	                'type' => $resized_type
	            );

	        } else {
	            $image_array = array(
	                'url' => str_replace(wp_basename($url), wp_basename($dest_file_name), $url),
	                'width' => $dest_width,
	                'height' => $dest_height,
	                'type' => $ext
	            );
	        }

	        // Return image array
	        return $image_array;
	    }

		/**
		 * Image resize by id
		 */
	    public static function image_resize_id( $images_id, $width = NULL, $height = NULL, $crop = true, $retina = false ) {
	        $output = '';
	        $image_src = wp_get_attachment_image_src($images_id, 'full');
	        if ($image_src) {
	            $resize = self::image_resize_url($image_src[0], $width, $height, $crop, $retina);
	            if ($resize != null && is_array($resize)) {
	                $output = $resize['url'];
	            }
	        }
	        return $output;
	    }

	    /**
		 * Delete resized images
		 */
		public static function delete_resized_images($post_id) {
	        // Get attachment image metadata
	        $metadata = wp_get_attachment_metadata($post_id);
	        if (!$metadata)
	            return;

	        // Do some bailing if we cannot continue
	        if (!isset($metadata['file']) || !isset($metadata['image_meta']['resized_images']))
	            return;
	        $pathinfo = pathinfo($metadata['file']);
	        $resized_images = $metadata['image_meta']['resized_images'];

	        // Get Wordpress uploads directory (and bail if it doesn't exist)
	        $wp_upload_dir = wp_upload_dir();
	        $upload_dir = $wp_upload_dir['basedir'];
	        if (!is_dir($upload_dir))
	            return;

	        // Delete the resized images
	        foreach ($resized_images as $dims) {

	            // Get the resized images filename
	            $file = $upload_dir . '/' . $pathinfo['dirname'] . '/' . $pathinfo['filename'] . '-' . $dims . '.' . $pathinfo['extension'];
				
	            // Delete the resized image
	            @unlink($file);
	        }
	    }

	}

	new Uxper_Helper();
}

