<?php
if ( !defined('ABSPATH') ) {
    exit; // Exit if accessed directly
}

if ( !class_exists('Uxper_Shortcode') ) {

    /**
     * Class Uxper_Shortcode
     */
    class Uxper_Shortcode 
    {
        
        protected static $instance = null;

		static function instance() 
        {
			if ( null === self::$instance ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function initialize() 
        {
            add_shortcode('uxper_crypto', array( $this, 'shortcode'));
            add_action('wp_footer', array($this, 'show_ticker'));
		}

        public function show_ticker() {
            $posts = get_posts( array(
                'post_type'      => 'ux_crypto',
                'posts_per_page' => 1,
                'meta_query'     => array(
                    'relation' => 'AND',
                    array(
                        'key'   => UXPER_CRYPTO_METABOX_PREFIX . 'widget_type',
                        'value' => 'ticker'
                    ), 
                    array(
                        'key'     => UXPER_CRYPTO_METABOX_PREFIX . 'widget_ticker_position',
                        'value'   => array('top', 'bottom'),
                        'compare' => 'IN'
                    )
                )
            ));
            
            if ( sizeof($posts) > 0 ) {
                echo apply_filters('uxper_show_ticker', do_shortcode('[uxper_crypto id="' . $posts[0]->ID . '"]'));
            }
        }

        public function shortcode($atts) {

            $widget_type = get_post_meta( $atts['id'], UXPER_CRYPTO_METABOX_PREFIX . 'widget_type', true);

            $post = get_post($atts['id']);
            if( $post->post_status != 'publish' && !is_admin() ) {
                return;
            }

            ob_start();

            switch ($widget_type) {
                case 'ticker':

                    self::render_ticker($atts['id']);
                    
                    break;
                
                case 'table':

                    self::render_table($atts['id']);

                case 'converter':

                    self::render_converter($atts['id']);
                    
                    break;
            }

			return ob_get_clean();
        }

        public function render_ticker($id) {

            if( empty($id) ) return;

            $widget_type               = get_post_meta( $id, UXPER_CRYPTO_METABOX_PREFIX . 'widget_type', true);
            $widget_coin               = get_post_meta( $id, UXPER_CRYPTO_METABOX_PREFIX . 'widget_coin', true);
            $widget_real_time          = get_post_meta( $id, UXPER_CRYPTO_METABOX_PREFIX . 'widget_real_time', true);
            $widget_display_logo       = get_post_meta( $id, UXPER_CRYPTO_METABOX_PREFIX . 'widget_display_logo', true);
            $widget_display_24h_change = get_post_meta( $id, UXPER_CRYPTO_METABOX_PREFIX . 'widget_display_24h_change', true);
            $widget_display_chart      = get_post_meta( $id, UXPER_CRYPTO_METABOX_PREFIX . 'widget_display_chart', true);
            $widget_ticker_position    = get_post_meta( $id, UXPER_CRYPTO_METABOX_PREFIX . 'widget_ticker_position', true);
            $widget_ticker_speed       = get_post_meta( $id, UXPER_CRYPTO_METABOX_PREFIX . 'widget_ticker_speed', true);
            $widget_background_color   = get_post_meta( $id, UXPER_CRYPTO_METABOX_PREFIX . 'widget_background_color', true);
            $widget_color              = get_post_meta( $id, UXPER_CRYPTO_METABOX_PREFIX . 'widget_color', true);

            $currency_sign = Uxper_Helper::setting('currency_sign', '$');

            $classes = array();
            $classes[] = $widget_ticker_position;

            if( $widget_display_chart == '1' ) {
                $classes[] = 'has-chart';
            }

            if( empty($widget_coin) ) return;

            global $wpdb;
            $table_name = $wpdb->base_prefix . 'ux_crypto';

            $wquery = "WHERE `slug` IN ('" . implode("', '", $widget_coin) . "') ORDER BY FIELD (`slug`, '" . implode("', '", $widget_coin) . "')";
            $data = $wpdb->get_results("SELECT `name`, `symbol`, `slug`, `img`, `chart`, `price_usd`, `percent_change_24h` FROM `{$table_name}` " . $wquery);
            $data = (array) $data;

            $api_notice = apply_filters('uxper_api_notice', '');

            $css = 'style=';
            $css .= 'background-color:' . $widget_background_color . ';';
            $css .= 'color:' . $widget_color. ';';
            ?>

            <?php if( !empty($data) ) { ?>
                <div class="uxper-widget-crypto uxper-ticker <?php echo join(' ', $classes); ?>" data-liveprice="<?php echo esc_attr($widget_real_time); ?>">
                    <div class="uxper-widget-wrap" <?php echo esc_attr($css); ?>>
                        <div class="inner-wrap">
                            <div class="infinite-ticker" data-speed="<?php echo esc_attr($widget_ticker_speed); ?>">
                                <?php foreach( $data as $coin ) { ?>
                                <div class="item">
                                    <div class="item-detail">
                                        <div class="entry-detail">
                                            <?php if( $widget_display_logo == '1' && !empty($coin->img) ) : ?>
                                            <div class="entry-image">
                                                <img src="<?php echo esc_url($coin->img); ?>" alt="<?php echo esc_attr($coin->name); ?>">
                                            </div>
                                            <?php endif; ?>

                                            <?php if( !empty($coin->name) ) : ?>
                                            <div class="name">
                                                <?php echo esc_html($coin->name); ?>
                                            </div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="extra-detail">
                                            <?php if( !empty($coin->price_usd) ) : ?>
                                            <div class="coin-price" data-live-price="<?php echo esc_attr($coin->slug); ?>" data-price="<?php echo Uxper_Helper::get_format_money($coin->price_usd, '', 2, false, 'none', false); ?>">
                                                <?php if( !empty($currency_sign) ) : ?>
                                                    <span><?php echo esc_html($currency_sign); ?></span>
                                                <?php endif; ?>
                                                <div class="price">
                                                    <?php echo Uxper_Helper::get_format_money($coin->price_usd, '', 2, false, 'none', false); ?>
                                                </div>
                                            </div>
                                            <?php endif; ?>

                                            <?php
                                            if( $widget_display_24h_change == '1' && !empty($coin->percent_change_24h) ) :
                                                $class_percent = '';
                                                if( floatval($coin->percent_change_24h) >= 0 ) {
                                                    $class_percent = 'change-up';
                                                }else{
                                                    $class_percent = 'change-down';
                                                }
                                            ?>
                                            <div class="coin-24h-change <?php echo esc_attr($class_percent); ?>">
                                                <?php echo Uxper_Helper::get_format_money($coin->percent_change_24h, '', 2, false, '%', 'after'); ?>
                                            </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    
                                    <?php if( !empty($coin->chart) && $widget_display_chart == '1' ) { ?>
                                    <div class="chart">
                                        <img src="<?php echo esc_url($coin->chart); ?>" alt="<?php echo esc_attr(strtoupper($coin->symbol)); ?>">
                                    </div>
                                    <?php } ?>
                                </div>
                            <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php }elseif( !empty($api_notice) ){ ?>
                <div class="uxper-notice">
                    <?php echo esc_html($api_notice); ?>
                </div>
            <?php } ?>

            <?php
        }

        public function render_table($id) {

            if( empty($id) ) return;

            $widget_coin               = get_post_meta( $id, UXPER_CRYPTO_METABOX_PREFIX . 'widget_coin', true);
            $widget_real_time          = get_post_meta( $id, UXPER_CRYPTO_METABOX_PREFIX . 'widget_real_time', true);
            $widget_display_logo       = get_post_meta( $id, UXPER_CRYPTO_METABOX_PREFIX . 'widget_display_logo', true);
            $widget_display_24h_change = get_post_meta( $id, UXPER_CRYPTO_METABOX_PREFIX . 'widget_display_24h_change', true);
            $widget_table_column       = get_post_meta( $id, UXPER_CRYPTO_METABOX_PREFIX . 'widget_table_column', true);
            $widget_background_color   = get_post_meta( $id, UXPER_CRYPTO_METABOX_PREFIX . 'widget_background_color', true);
            $widget_color              = get_post_meta( $id, UXPER_CRYPTO_METABOX_PREFIX . 'widget_color', true);
            
            unset($widget_table_column['sort_order']);
            $widget_table_column = array_keys($widget_table_column);
            

            $currency_sign = Uxper_Helper::setting('currency_sign', '$');

            if( empty($widget_coin) ) return;

            global $wpdb;
            $table_name = $wpdb->base_prefix . 'ux_crypto';

            $wquery = "WHERE `slug` IN ('" . implode("', '", $widget_coin) . "') ORDER BY FIELD (`slug`, '" . implode("', '", $widget_coin) . "')";
            $data = $wpdb->get_results("SELECT * FROM `{$table_name}` " . $wquery);
            $data = (array) $data;

            $api_notice = apply_filters('uxper_api_notice', '');

            $css = 'style=';
            $css .= 'background-color:' . $widget_background_color . ';';
            $css .= 'color:' . $widget_color. ';';

            ?>

            <?php if( !empty($data) ) { ?>
                <div class="uxper-widget-crypto uxper-crypto-table uxper-table" data-liveprice="<?php echo esc_attr($widget_real_time); ?>">
                    <div class="uxper-widget-wrap" <?php echo esc_attr($css); ?>>
                        <div class="inner-wrap">
                            <table>
                                <thead>
                                    <tr>
                                        <?php foreach( $widget_table_column as $column ) { ?>
                                        <th class="<?php echo esc_attr($column); ?>">
                                            <?php
                                            switch ($column) {
                                                case 'rank':
                                                    esc_html_e('#', 'uxper-crypto');
                                                    break;
                                                case 'name':
                                                    esc_html_e('Name', 'uxper-crypto');
                                                    break;
                                                case 'price_usd':
                                                    esc_html_e('Price', 'uxper-crypto');
                                                    break;
                                                case 'percent_change_24h':
                                                    esc_html_e('24h %', 'uxper-crypto');
                                                    break;
                                                case 'percent_change_7d':
                                                    esc_html_e('7d %', 'uxper-crypto');
                                                    break;
                                                case 'volume_usd_24h':
                                                    esc_html_e('Volume(24h)', 'uxper-crypto');
                                                    break;
                                                case 'market_cap_usd':
                                                    esc_html_e('Market Cap', 'uxper-crypto');
                                                    break;
                                                case 'available_supply':
                                                    esc_html_e('Supply', 'uxper-crypto');
                                                    break;
                                                case 'total_supply':
                                                    esc_html_e('Max Supply', 'uxper-crypto');
                                                    break;
                                                case 'chart':
                                                    esc_html_e('Last 7 Days', 'uxper-crypto');
                                                    break;
                                            }
                                            ?>
                                        </th>
                                        <?php } ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach( $data as $coin ) { ?>
                                    <tr class="live-change">
                                        <?php foreach( $widget_table_column as $column ) { ?>
                                        <td class="<?php echo esc_attr($column); ?>">
                                            <?php
                                            switch ($column) {
                                                case 'rank':
                                                    echo esc_html($coin->rank);
                                                    break;
                                                case 'name':
                                                    ?>
                                                        <div class="coin-name">
                                                            <?php if( $widget_display_logo == '1' && !empty($coin->img) ) : ?>
                                                                <img src="<?php echo esc_url($coin->img); ?>" alt="<?php echo esc_attr($coin->name); ?>">
                                                            <?php endif; ?>
                                                            <?php if( !empty($coin->name) ) : ?>
                                                                <div class="title">
                                                                    <?php echo esc_html($coin->name); ?>
                                                                </div>
                                                            <?php endif; ?>
                                                            <?php if( !empty($coin->symbol) ) : ?>
                                                                <div class="symbol">
                                                                    <?php echo strtoupper($coin->symbol); ?>
                                                                </div>
                                                            <?php endif; ?>
                                                        </div>
                                                    <?php

                                                    break;
                                                case 'price_usd':

                                                    if( !empty($coin->price_usd) ) : 
                                                    ?>
                                                        <div class="coin-price" data-live-price="<?php echo esc_attr($coin->slug); ?>" data-price="<?php echo Uxper_Helper::get_format_money($coin->price_usd, '', 2, false, 'none', false); ?>">
                                                            <?php if( !empty($currency_sign) ) : ?>
                                                                <span><?php echo esc_html($currency_sign); ?></span>
                                                            <?php endif; ?>
                                                            <div class="price">
                                                                <?php echo Uxper_Helper::get_format_money($coin->price_usd, '', 2, false, 'none', false); ?>
                                                            </div>
                                                        </div>
                                                    <?php 
                                                    endif;

                                                    break;
                                                case 'percent_change_24h':

                                                    if( !empty($coin->percent_change_24h) ) :
                                                        $class_percent = '';
                                                        if( floatval($coin->percent_change_24h) >= 0 ) {
                                                            $class_percent = 'change-up';
                                                        }else{
                                                            $class_percent = 'change-down';
                                                        }
                                                    ?>
                                                        <div class="coin-24h-change <?php echo esc_attr($class_percent); ?>">
                                                            <?php echo Uxper_Helper::get_format_money($coin->percent_change_24h, '', 2, false, '%', 'after'); ?>
                                                        </div>
                                                    <?php 
                                                    endif;

                                                    break;
                                                case 'percent_change_7d':

                                                    if( !empty($coin->percent_change_7d) ) :
                                                        $class_percent = '';
                                                        if( floatval($coin->percent_change_7d) >= 0 ) {
                                                            $class_percent = 'change-up';
                                                        }else{
                                                            $class_percent = 'change-down';
                                                        }
                                                    ?>
                                                        <div class="coin-7d-change <?php echo esc_attr($class_percent); ?>">
                                                            <?php echo Uxper_Helper::get_format_money($coin->percent_change_7d, '', 2, false, '%', 'after'); ?>
                                                        </div>
                                                    <?php 
                                                    endif;

                                                    break;
                                                case 'volume_usd_24h':
                                                    echo Uxper_Helper::get_format_money($coin->volume_usd_24h, '', 0, false, 'none', false);
                                                    break;
                                                case 'market_cap_usd':
                                                    if( !empty($coin->market_cap_usd) && $coin->market_cap_usd != 0 ) {
                                                        echo Uxper_Helper::get_format_money($coin->market_cap_usd, '', 0, false, '', false);
                                                    }
                                                    break;
                                                case 'available_supply':
                                                    if( !empty($coin->available_supply) && $coin->available_supply != 0 && !empty($coin->symbol) ) {
                                                        echo Uxper_Helper::get_format_money($coin->available_supply, '', 0, false, 'none', false) . strtoupper($coin->symbol);
                                                    }
                                                    break;
                                                case 'total_supply':
                                                    if( !empty($coin->total_supply) && $coin->total_supply != 0 && !empty($coin->symbol) ) {
                                                        echo Uxper_Helper::get_format_money($coin->total_supply, '', 0, false, 'none', false) . strtoupper($coin->symbol);
                                                    }else{
                                                        echo '--';
                                                    }
                                                    break;
                                                case 'chart':
                                                    if( !empty($coin->chart) ) {
                                                    ?>
                                                        <img src="<?php echo esc_url($coin->chart); ?>" alt="<?php echo esc_attr(strtoupper($coin->symbol)); ?>">
                                                    <?php
                                                    }

                                                    break;
                                            }
                                            ?>
                                        </td>
                                        <?php } ?>
                                    </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            <?php }elseif( !empty($api_notice) ){ ?>
                <div class="uxper-notice">
                    <?php echo esc_html($api_notice); ?>
                </div>
            <?php } ?>

            <?php
        }

        public function render_converter($id) {

            if( empty($id) ) return;

            $widget_type             = get_post_meta( $id, UXPER_CRYPTO_METABOX_PREFIX . 'widget_type', true);
            $widget_coin             = get_post_meta( $id, UXPER_CRYPTO_METABOX_PREFIX . 'widget_coin', true);
            $widget_background_color = get_post_meta( $id, UXPER_CRYPTO_METABOX_PREFIX . 'widget_background_color', true);
            $widget_color            = get_post_meta( $id, UXPER_CRYPTO_METABOX_PREFIX . 'widget_color', true);

            $currency_sign = Uxper_Helper::setting('currency_sign', '$');

            $classes = array();

            if( empty($widget_coin) ) return;

            global $wpdb;
            $table_name = $wpdb->base_prefix . 'ux_crypto';

            $wquery = "WHERE `slug` IN ('" . implode("', '", $widget_coin) . "') ORDER BY FIELD (`slug`, '" . implode("', '", $widget_coin) . "')";
            $data = $wpdb->get_results("SELECT `name`, `symbol`, `slug`, `img`, `chart`, `price_usd`, `percent_change_24h` FROM `{$table_name}` " . $wquery);
            $data = (array) $data;

            $api_notice = apply_filters('uxper_api_notice', '');

            $css = 'style=';
            $css .= 'background-color:' . $widget_background_color . ';';
            $css .= 'color:' . $widget_color. ';';
            ?>

            <?php if( !empty($data) ) { ?>
                <div class="uxper-widget-crypto uxper-converter <?php echo join(' ', $classes); ?>">
                    <div class="uxper-widget-wrap" <?php echo esc_attr($css); ?>>
                        <div class="inner-wrap">
                            <div class="entry-select from">
                                <select name="coin_from" class="uxper-crypto-select2">
                                    <?php foreach( $data as $coin ) { ?>
                                        <option value="<?php echo esc_attr($coin->price_usd); ?>">
                                            <?php echo esc_html($coin->name . '(' . strtoupper($coin->symbol) . ')'); ?>
                                        </option>
                                    <?php } ?>
                                </select>
                                <input type="text" name="ip_coin_from" value="1">
                            </div>
                            <div class="entry-select to">
                                <?php echo Uxper_Coin::select_currencies(); ?>
                                <input type="text" name="ip_coin_to">
                            </div>
                        </div>
                    </div>
                </div>
            <?php }elseif( !empty($api_notice) ){ ?>
                <div class="uxper-notice">
                    <?php echo esc_html($api_notice); ?>
                </div>
            <?php } ?>

            <?php
        }
    }

    Uxper_Shortcode::instance()->initialize();
}