<?php
// ------------------------------------------------------
// ------ Categories in 2 columns  ----------------------
// ------ by AnThemes.net -------------------------------
//        http://themeforest.net/user/An-Themes/portfolio
//        http://themeforest.net/user/An-Themes/follow 
// ------------------------------------------------------

class multicote_wp_categories extends WP_Widget {
     function __construct() {
	    $widget_ops = array('description' => esc_html__('Display Categories in 2 columns.', 'multicote-wp'));
        parent::__construct(false, $name = ''. esc_html__('Custom: Categories', 'multicote-wp') .'',$widget_ops); 
    }

   function widget($args, $instance) {  
		extract( $args );
		$title = $instance['title'];
?>		
 
<?php echo wp_kses_post($before_widget); ?>
<?php if ( $title ) echo wp_kses_post($before_title) . esc_attr($title) . wp_kses_post($after_title); ?>

  <ul>
  <?php wp_list_categories('orderby=name&show_count=1&hierarchical=0&title_li='); ?> 
  </ul>

<?php echo wp_kses_post($after_widget); ?> 
  
<?php
    }

     function update($new_instance, $old_instance) {				
			$instance = $old_instance;
			$instance['title'] = strip_tags($new_instance['title']);
     return $instance;
    }

 	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance );
?>


        <p>
          <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e( 'Title:', 'multicote-wp' ); ?></label> 
          <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php if( isset($instance['title']) ) echo esc_attr($instance['title']); ?>" />
        </p>
      

<?php  } }

// register widget
function multicote_wp_categories_init_widget () {
    return register_widget('multicote_wp_categories');
  }
add_action ('widgets_init', 'multicote_wp_categories_init_widget');
?>