<?php
// ------------------------------------------------------
// ------ Subscribe widget  -----------------------------
// ------ Feedburner subscribe --------------------------
// ------ by AnThemes.net -------------------------------
//        http://themeforest.net/user/An-Themes/portfolio
//        http://themeforest.net/user/An-Themes/follow 
// ------------------------------------------------------

class multicote_wp_subscribe extends WP_Widget {
     function __construct() {
      $widget_ops = array('description' => esc_html__('Feedburner subscribe widget.', 'multicote-wp'));
        parent::__construct(false, $name = ''. esc_html__('Custom: Feedburner Subscribe', 'multicote-wp') .'',$widget_ops); 
    }

   function widget($args, $instance) {  
		extract( $args );
    $title = $instance['title'];
    $feedid = $instance['feedid'];
    $text = $instance['text'];
?>		
 
<?php echo wp_kses_post($before_widget); ?>
<?php if ( $title ) echo wp_kses_post($before_title) . esc_attr($title) . wp_kses_post($after_title); ?>
    
    <div class="feed-info"><?php echo stripslashes_deep($text); ?></div>

    <form action="//feedburner.google.com/fb/a/mailverify" method="get" target="popupwindow" onsubmit="window.open('<?php echo esc_attr($feedid); ?>', 'popupwindow', 'scrollbars=yes,width=600,height=560');return true" class="newsletter-form">
      <input name="email" class="newsletter" placeholder="<?php esc_html_e('Enter your e-mail address', 'multicote-wp'); ?>" type="text">
      <input type="hidden" value="<?php echo esc_attr($feedid); ?>" name="uri"/>
      <input class="newsletter-btn" value="<?php esc_html_e('Subscribe', 'multicote-wp'); ?>" type="submit">
    </form>


  <?php echo wp_kses_post($after_widget); ?>
  
<?php
    }

     function update($new_instance, $old_instance) {				
			$instance = $old_instance;
      $instance['title'] = strip_tags($new_instance['title']);
			$instance['feedid'] = strip_tags($new_instance['feedid']);
      $instance['text'] = stripslashes($new_instance['text']);
     return $instance;
    }

 	function form( $instance ) {

  // Set up some default widget settings
  $defaults = array(
    'title' => 'Feedburner',
    'text' => stripslashes('We cover the top <strong>social media</strong> news, you\'ll get Freebies and <strong>Freelance</strong> Jobs.
<i class="far fa-hand-point-down"></i>'),
  );

  $instance = wp_parse_args( (array) $instance, $defaults ); ?>

        <p>
          <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e( 'Widget Title:', 'multicote-wp' ); ?></label> 
          <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php if( isset($instance['title']) ) echo esc_attr($instance['title']); ?>" />
        </p>

        <p>
          <label for="<?php echo esc_attr($this->get_field_id('feedid')); ?>"><?php esc_html_e( 'Feedburner ID:', 'multicote-wp' ); ?></label> 
          <input class="widefat" id="<?php echo esc_attr($this->get_field_id('feedid')); ?>" name="<?php echo esc_attr($this->get_field_name('feedid')); ?>" type="text" value="<?php if( isset($instance['feedid']) ) echo esc_attr($instance['feedid']); ?>" />
        </p>

        <p>
          <label for="<?php echo esc_attr($this->get_field_id('text')); ?>"><?php esc_html_e( 'Description:', 'multicote-wp' ); ?></label>      
          <textarea style="height:100px;" class="widefat" id="<?php echo esc_attr($this->get_field_id('text')); ?>" name="<?php echo esc_attr($this->get_field_name('text')); ?>" ><?php if( isset($instance['text']) ) echo stripslashes($instance['text']); ?></textarea>
        </p> 

<?php  } }

// register widget
function multicote_wp_subscribe_init_widget () {
    return register_widget('multicote_wp_subscribe');
  }
add_action ('widgets_init', 'multicote_wp_subscribe_init_widget');
?>