<?php

if ( !defined('ABSPATH') ) {
	exit; // Exit if accessed directly
}

if ( !class_exists('Uxper_Field_Map') ) {
	class Uxper_Field_Map extends Uxper_Field
	{
		public function enqueue()
		{
		    $api_key = Uxper_Helper::setting('googlemap_api_key', 'AIzaSyBvPDNG6pePr9iFpeRKaOlaZF_l0oT3lWk');
			$google_map_url = apply_filters('uxper_google_map_api_url', 'https://maps.googleapis.com/maps/api/js?key=' . $api_key);

			wp_enqueue_script('google-map', esc_url_raw($google_map_url), array(), '', true);
			wp_enqueue_script(UXPER_BASE_RESOURCE_PREFIX . 'map', UXPER_BASE_URL . 'fields/map/assets/map.js', array(), UXPER_CRYPTO_PLUGIN_VER, true);
			wp_enqueue_script(UXPER_BASE_RESOURCE_PREFIX . 'mapbox', UXPER_BASE_URL . 'assets/libs/mapbox/mapbox-gl.js', array(), UXPER_CRYPTO_PLUGIN_VER, true);
			wp_enqueue_script(UXPER_BASE_RESOURCE_PREFIX . 'leaflet', UXPER_BASE_URL . 'assets/libs/leaflet/leaflet.js', array(), UXPER_CRYPTO_PLUGIN_VER, true);
			wp_enqueue_script(UXPER_BASE_RESOURCE_PREFIX . 'leaflet-src', UXPER_BASE_URL . 'assets/libs/leaflet/leaflet-src.js', array(), UXPER_CRYPTO_PLUGIN_VER, true);
			wp_enqueue_style(UXPER_BASE_RESOURCE_PREFIX . 'map', UXPER_BASE_URL . 'fields/map/assets/map.css', array(), UXPER_CRYPTO_PLUGIN_VER);
			wp_enqueue_style(UXPER_BASE_RESOURCE_PREFIX . 'mapbox', UXPER_BASE_URL . 'assets/libs/mapbox/mapbox-gl.css', array(), UXPER_CRYPTO_PLUGIN_VER);
			wp_enqueue_style(UXPER_BASE_RESOURCE_PREFIX . 'leaflet', UXPER_BASE_URL . 'assets/libs/leaflet/leaflet.css', array(), UXPER_CRYPTO_PLUGIN_VER);
		}

		function field_map() {
			return 'location,address';
		}

		function render_content($content_args = '')
		{
		    $map_type = Uxper_Helper::setting('map_type', 'google_map');
		    $mapbox_style = Uxper_Helper::setting('mapbox_style', 'streets-v11');
		    $openstreetmap_style = Uxper_Helper::setting('openstreetmap_style', 'streets-v11');
		    $map_zoom_level = Uxper_Helper::setting('map_zoom_level', '12');
		    $mapbox_api_key = Uxper_Helper::setting('mapbox_api_key', 'pk.eyJ1Ijoic2F5aTc3NDciLCJhIjoiY2tpcXRmYW1tMWpjMjJzbGllbThieTFlaCJ9.eDj6zNLBZpG-veFqXiyVPw');
		    $openstreetmap_api_key = Uxper_Helper::setting('openstreetmap_api_key', 'pk.eyJ1Ijoic2F5aTc3NDciLCJhIjoiY2tpcXRmYW1tMWpjMjJzbGllbThieTFlaCJ9.eDj6zNLBZpG-veFqXiyVPw');
			$field_value = $this->get_value();
			if (!is_array($field_value)) {
				$field_value = array();
			}
			$value_default = array(
				'location' => isset($this->params['default']) ? $this->params['default'] : '-74.5, 40',
				'address'  => ''
			);
			$field_value = wp_parse_args($field_value, $value_default);
			$js_options = isset($this->params['js_options']) ? $this->params['js_options'] : array();
			if (isset($js_options['styles'])) {
				$js_options['styles'] = json_decode($js_options['styles']);
			}
			$placeholder = isset($this->params['placeholder']) ? $this->params['placeholder'] : esc_html__('Enter an address...','uxper-crypto');
		    ?>
			<div class="uxper-field-map-inner">
				<input data-field-control="" type="hidden" class="uxper-map-location-field" name="<?php echo esc_attr($this->get_name()) ?>[location]" value="<?php echo esc_attr($field_value['location']); ?>"/>
				<?php if (!isset($this->params['show_address']) || $this->params['show_address']): ?>
					<div class="uxper-map-address">
						<div class="uxper-map-address-text">
							<input data-field-control="" type="text" placeholder="<?php echo esc_attr($placeholder); ?>" name="<?php echo esc_attr($this->get_name()) ?>[address]" value="<?php echo esc_attr($field_value['address']); ?>"/>
						</div>
						<button type="button" class="button"><?php echo esc_html__('Find Address','uxper-crypto'); ?></button>
						<div class="uxper-map-suggest"></div>
					</div>
				<?php endif;?>
				<?php if( $map_type == 'google_map' ){  ?>
				    <div class="uxper-map-canvas uxper-map-type" data-maptype="<?php echo $map_type; ?>" data-options="<?php echo esc_attr(wp_json_encode($js_options)); ?>" data-zoom="<?php echo $map_zoom_level; ?>" style="height: 300px; width: 100%"></div>
				<?php } else if( $map_type == 'openstreetmap' ){  ?>
				    <div class="uxper-openstreetmap-canvas uxper-map-type" data-maptype="<?php echo $map_type; ?>" data-zoom="<?php echo $map_zoom_level; ?>" data-style="<?php echo $openstreetmap_style; ?>" data-api="<?php echo $openstreetmap_api_key; ?>" data-options="<?php echo esc_attr(wp_json_encode($js_options)); ?>" style="height: 300px; width: 100%"></div>
				<?php } else { ?>
				    <div class="uxper-mapbox-canvas uxper-map-type" data-maptype="<?php echo $map_type; ?>" data-zoom="<?php echo $map_zoom_level; ?>" data-style="<?php echo $mapbox_style; ?>" data-api="<?php echo $mapbox_api_key; ?>" data-options="<?php echo esc_attr(wp_json_encode($js_options)); ?>" style="height: 300px; width: 100%"></div>
				<?php } ?>
				
			</div>
			<?php
		}

		/**
		 * Get default value
		 *
		 * @return array
		 */
		function get_default() {
			$default = array(
				'location' => isset($this->params['default']) ? $this->params['default'] : '-74.5, 40',
				'address'  => ''
			);

			$field_default = isset($this->params['default']) ? $this->params['default'] : array();
			$default = wp_parse_args($field_default, $default);

			return $this->is_clone() ? array($default) : $default;
		}
	}
}