<?php
if ( !defined('ABSPATH') ) {
    exit;
}

if ( !class_exists('Uxper_Admin_Pages') ) {

    /**
     * Class Uxper_Admin_Pages
     */
    class Uxper_Admin_Pages
    {

        protected static $instance = null;

		static function instance() 
        {
			if ( null === self::$instance ) {
				self::$instance = new self();
			}

			return self:: $instance;
		}

		public function initialize() 
        {
            // action admin_menu
            add_action('admin_menu', array( $this, 'admin_menu') );
		}

        /**
         * admin_menu
         */
        public function admin_menu()
        {
            add_menu_page(
                esc_html__('Uxper Crypto', 'uxper-crypto' ),
                esc_html__('Uxper Crypto', 'uxper-crypto'),
                'manage_options',
                'uxper_crypto',
                array($this, 'menu_page_uxper_crypto'),
                'dashicons-money-alt',
                99
            );
        }

        public function menu_page_uxper_crypto()
        {
            echo '<h1 class="wp-heading-inline">' . esc_html__( 'Uxper Crypto', 'uxper-crypto' ) . '</h1>';
            ?>
                <div class="admin-tab-content">
                    <?php
                    $endpoint = '/v1/cryptocurrency/listings/latest';
                    $parameters = [
                        'start' => '1',
                        'limit' => '50',
                        'convert' => 'USD'
                    ];
                    $get_listing_lastest = Uxper_CMC::cmc_request($endpoint, $parameters);
                    $listing_lastest = $get_listing_lastest['data'];
                    ?>
                    <table data-liveprice="on">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Price</th>
                                <th>24h %</th>
                                <th>7d %</th>
                                <th>Market Cap</th>
                                <th>Volume(24h)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            foreach( $listing_lastest as $data ) { 
                                $quote = $data['quote']['USD'];
                            ?>
                            <tr>
                                <td><?php echo esc_html($data['id']); ?></td>
                                <td><?php echo esc_html($data['name']); ?></td>
                                <td data-live-price="<?php echo esc_attr($data['slug']); ?>" data-price="<?php echo Uxper_Helper::get_format_money($quote['price'], '', 2, false); ?>"><?php echo Uxper_Helper::get_format_money($quote['price'], '', 2, false); ?></td>
                                <td><?php echo Uxper_Helper::get_format_money($quote['percent_change_24h'], '', 2, false, '%', 'after'); ?></td>
                                <td><?php echo Uxper_Helper::get_format_money($quote['percent_change_7d'], '', 2, false, '%', 'after'); ?></td>
                                <td><?php echo Uxper_Helper::get_format_money($quote['market_cap'], '', 0, false); ?></td>
                                <td><?php echo Uxper_Helper::get_format_money($quote['volume_24h'], '', '', false); ?></td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            <?php
        }
        
    }

    Uxper_Admin_Pages::instance()->initialize();
}