<?php get_header(); // add header  ?>
<?php
    $multicote_wp_home_select = get_theme_mod('multicote_wp_home_select');
    if (empty($multicote_wp_home_select)) { $multicote_wp_home_select = 'Small Thumbnails'; } 

    $multicote_wp_home_pag_select = get_theme_mod('multicote_wp_home_pag_select');
    if (empty($multicote_wp_home_pag_select)) { $multicote_wp_home_pag_select = 'Infinite Scroll'; }
?>
<!-- Begin Wrap Content -->
<div class="wrap-fullwidth">
 
    <!-- Begin Main Home Content -->
    <div id="infinite-articles" class="home-content js-masonry">

        <?php if (is_category()) { ?> 
            <div class="archive-header"><h3><?php esc_html_e( 'All posts in:', 'multicote-wp' ); ?> <strong><?php single_cat_title(''); ?></strong></h3><?php echo category_description(); ?></div>
        <?php } elseif (is_tag()) { ?>
            <div class="archive-header"><h3><?php esc_html_e( 'All posts tagged in:', 'multicote-wp' ); ?> <strong><?php single_tag_title(''); ?></strong></h3><?php echo tag_description(); ?></div>
        <?php } elseif (is_search()) { ?>
            <div class="archive-header"><h3><?php printf( esc_html__( 'Search Results for: %s', 'multicote-wp' ), '<strong>' . get_search_query() . '</strong>' ); ?></h3></div>
        <?php } elseif (is_author()) { ?>
            <?php if(get_the_author_meta('description') ): ?>
            <div class="archive-header"><h3><?php esc_html_e( 'All posts by:', 'multicote-wp' ); ?> <strong><?php the_author(); ?></strong></h3></div>
            <div class="author-meta">
                <div class="entry">
                    <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>" class="author-nrposts"><?php echo number_format_i18n( get_the_author_posts() ); ?></a>
                    <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php echo get_avatar( get_the_author_meta( 'user_email' ), 100 ); ?></a>
                    <div class="author-info">
                        <strong><?php the_author_posts_link(); ?></strong> &rsaquo; <a class="author-link" href="<?php the_author_meta('url'); ?>" target="_blank"><?php the_author_meta('url'); ?></a><br />
                        <p><?php the_author_meta('description'); ?></p>
                    </div><!-- end .autor-info -->
                </div><!-- end .entry -->
                <div class="clear"></div>
            </div><!-- end .author-meta -->
            <?php else: ?>
                <div class="archive-header"><h3><?php esc_html_e( 'All posts by:', 'multicote-wp' ); ?> <strong><?php the_author(); ?></strong></h3></div>
            <?php endif; ?>
        <?php } ?> 

 
        <?php if (have_posts()) : while (have_posts()) : the_post(); ?>

<?php if ($multicote_wp_home_select == 'Small Thumbnails') { ?>   
     
        <article>
            <div <?php post_class('blog-ex2') ?> id="post-<?php the_ID(); ?>">

            <div class="ex2-content">

                <?php if ( has_post_thumbnail()) { ?>
                    <div class="article-category"><i></i> <?php $multicote_wp_category = get_the_category(); if ($multicote_wp_category) 
                            { echo '<a href="' . get_category_link( $multicote_wp_category[0]->term_id ) . '" class="tiptipBlog" title="' . sprintf( esc_html__( "View all posts in %s", "multicote-wp" ), $multicote_wp_category[0]->name ) . '" ' . '>' . $multicote_wp_category[0]->name.'</a> ';}  ?>
                    </div><!-- end .article-category -->
                    <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('multicote-wp-thumbnail-blog-small', array('title' => "", 'class' => 'thumbnail_image')); ?></a>
                <?php } // end post_thumbnail ?> 

            
                    <div class="an-home-title" <?php if ( has_post_thumbnail()) { } else {?> style="width: auto;" <?php } ?>>
                        <h2 class="article-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                <?php if(function_exists('taqyeem_get_score')) { ?>
                                    <?php
                                        $post_ft_type = get_post_meta($post->ID, 'post_ft_type', true);
                                        $post_review_score = get_review_score($post->ID);
                                        if(!empty($post_review_score))
                                        {
                                    ?>
                                    <div class="review_score">
                                        <?php taqyeem_get_score(); ?>
                                    </div>
                                <?php }} // Review Points ?>                        


                        <span><?php esc_html_e('Written by', 'multicote-wp'); ?> <?php the_author_posts_link(); ?></span> <i class="fas fa-check-circle"></i>
                        <p><?php echo multicote_wp_excerpt(strip_tags(strip_shortcodes(get_the_excerpt())), 150); ?></p>
                        <div class="an-read-more"><a href="<?php the_permalink(); ?>"><?php esc_html_e('Continue reading', 'multicote-wp'); ?></a></div>
                        <div class="clear"></div>
                    </div> <div class="clear"></div>

                    <div class="home-meta">
                        <div class="an-display-time"><i class="far fa-clock"></i> <?php if ( function_exists( 'multicote_wp_time_ago' ) ) { echo multicote_wp_time_ago(); esc_html_e('ago', 'multicote-wp'); } else { the_time('M j, Y'); } ?></div>
                        <?php if (function_exists('getPostViews_multicote_wp')) { ?>
                            <div class="an-display-view"><i class="icofont icofont-fire-burn"></i> <?php echo getPostViews_multicote_wp(get_the_ID()); ?></div>      
                        <?php } ?>
                        <div class="an-display-comm"><i class="fas fa-comments"></i> <?php comments_popup_link('0 ' . esc_html__('Comments', 'multicote-wp') . '', '1 ' . esc_html__('Comment', 'multicote-wp') . '', '% ' . esc_html__('Comments', 'multicote-wp') . ''); ?></div>       
                        <div class="home-data">
                            <?php if (function_exists('thumbs_rating_getlink')) { echo thumbs_rating_getlink(); } ?>
                        </div><!-- end .home-data -->                        
                        <div class="clear"></div> 
                    </div><!-- Meta ( time and comments ) -->
                </div><!-- end .ex2-content -->

            </div><!-- Blog .blog-ex2 --> 
        </article><!-- end article -->

<?php } else { ?>

        <article>
            <div <?php post_class('blog-ex1') ?> id="post-<?php the_ID(); ?>">

                <?php if ( has_post_thumbnail()) { ?>
                <div class="img-container">
                    <div class="article-category"><i></i> <?php $multicote_wp_category = get_the_category(); if ($multicote_wp_category) 
                            { echo '<a href="' . get_category_link( $multicote_wp_category[0]->term_id ) . '" class="tiptipBlog" title="' . sprintf( esc_html__( "View all posts in %s", "multicote-wp" ), $multicote_wp_category[0]->name ) . '" ' . '>' . $multicote_wp_category[0]->name.'</a> ';}  ?>
                    </div><!-- end .article-category -->

                    <ul class="meta-icons-home">
                        <?php if (is_sticky()) { ?><li class="sticky-lm"><i class="far fa-lightbulb"></i><span class="tooltiptext"><?php esc_html_e( 'Sticky post!', 'multicote-wp' ); ?></span></li><?php } ?>
                        <?php if (get_comments_number() > 1) { ?><li class="trending-lm"><i class="fas fa-bolt"></i><span class="tooltiptext"><?php esc_html_e( 'Trending post!', 'multicote-wp' ); ?></span></li><?php } ?>
                    </ul><div class="clear"></div>                    
                    <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('multicote-wp-thumbnail-blog-big', array('title' => "", 'class' => 'thumbnail_image')); ?></a>

                    <?php if ( function_exists( 'rwmb_meta' ) ) {  
                        // If Meta Box plugin is activate  
                        $multicote_wp_youtubecode = rwmb_meta('multicote_wp_youtube', true );
                        $multicote_wp_vimeocode = rwmb_meta('multicote_wp_vimeo', true );                
                        if(!empty($multicote_wp_youtubecode) || !empty($multicote_wp_vimeocode)) { ?>                    
                            <div class="playicon"></div>
                        <?php } ?>
                    <?php } ?>
                </div><!-- end .img-container -->
                <?php } // end post_thumbnail ?> 

                <div class="ex1-content">
                    <div class="an-home-title">
                        <h2 class="article-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                <?php if(function_exists('taqyeem_get_score')) { ?>
                                    <?php
                                        $post_ft_type = get_post_meta($post->ID, 'post_ft_type', true);
                                        $post_review_score = get_review_score($post->ID);
                                        if(!empty($post_review_score))
                                        {
                                    ?>
                                    <div class="review_score">
                                        <?php taqyeem_get_score(); ?>
                                    </div>
                                <?php }} // Review Points ?>                        


                        <span><?php esc_html_e('Written by', 'multicote-wp'); ?> <?php the_author_posts_link(); ?></span> <i class="fas fa-check-circle"></i>
                    </div>

                    <div class="home-data">
                        <?php if (function_exists('thumbs_rating_getlink')) { echo thumbs_rating_getlink(); } ?>
                    </div><!-- end .home-data -->
                    <div class="clear"></div>
                    <p><?php echo multicote_wp_excerpt(strip_tags(strip_shortcodes(get_the_excerpt())), 200); ?></p>


                    <div class="home-meta">
                        <div class="an-display-time"><i class="far fa-clock"></i> <?php if ( function_exists( 'multicote_wp_time_ago' ) ) { echo multicote_wp_time_ago(); esc_html_e('ago', 'multicote-wp'); } else { the_time('M j, Y'); } ?></div>
                        <?php if (function_exists('getPostViews_multicote_wp')) { ?>
                            <div class="an-display-view"><i class="icofont icofont-fire-burn"></i> <?php echo getPostViews_multicote_wp(get_the_ID()); ?></div>      
                        <?php } ?>   
                        <div class="an-display-comm"><i class="fas fa-comments"></i> <?php comments_popup_link('0 ' . esc_html__('Comments', 'multicote-wp') . '', '1 ' . esc_html__('Comment', 'multicote-wp') . '', '% ' . esc_html__('Comments', 'multicote-wp') . ''); ?></div> 
                        <div class="an-read-more"><a href="<?php the_permalink(); ?>"><?php esc_html_e('Continue reading', 'multicote-wp'); ?></a></div><div class="clear"></div> 
                    </div><!-- Meta ( time and comments ) & read more link -->
                </div><!-- end .ex1-content -->

            </div><!-- Blog .blog-ex1 --> 
        </article><!-- end article -->

<?php } ?>

        <div class="clear"></div>
        <?php endwhile; ?>


        <!-- Pagination -->
        <div class="clear"></div>
        <?php if(function_exists('wp_pagenavi')) { ?>
            <?php wp_pagenavi(); ?>
        <?php } else { ?>
            <div class="defaultpag">
                <div class="sright"><?php next_posts_link('' . esc_html__('Older Entries', 'multicote-wp') . ' &rsaquo;'); ?></div>
                <div class="sleft"><?php previous_posts_link('&lsaquo; ' . esc_html__('Newer Entries', 'multicote-wp') . ''); ?></div>
            </div>
        <?php } ?>
        <!-- pagination -->
 

        <?php else : ?> 
            <div class="archive-header">
            <?php esc_html_e('Error 404 - Not Found.', 'multicote-wp'); ?><br />
            <?php esc_html_e('Sorry, but you are looking for something that isn\'t here.', 'multicote-wp'); ?>
            </div>
        <?php endif; ?>  

    </div><!-- end .home-content -->


    <!-- Begin Sidebar 2 (left middle) -->
    <?php get_template_part('sidebar2'); ?>
    <!-- end #sidebar 2 (left) --> 


    <!-- Begin Sidebar 1 (default right) -->
    <?php get_sidebar(); // add sidebar ?>
    <!-- end #sidebar 1 (default right) --> 

        
<div class="clear"></div>
</div><!-- end .wrap-fullwidth -->

<?php get_footer(); // add footer  ?>