<?php 
/* 
Template Name: Template - Home Masonry Style
*/ 
?>
<?php get_header(); // add header  ?>
<?php
    // Nr. of featured posts
    $multicote_wp_featured_posts = get_theme_mod('multicote_wp_featured_posts');
    if (empty($multicote_wp_featured_posts)) { $multicote_wp_featured_posts = '8'; }
?>

<!-- Begin Wrap Content -->
<div class="wrap-fullwidth">

      <!-- Begin Featured articles on slide -->
      <div class="featured-articles">

        <div class="featured-title">
            <h3><?php esc_html_e('Featured Articles', 'multicote-wp'); ?></h3>
            <div class="slide-nav">
              <span id="slider-prev"></span>
              <span id="slider-next"></span>
            </div><!-- end .slide-nav -->          
        </div><!-- end .featured-title -->  
        
        <ul class="featured-articles-slider">
          <?php $multicote_wp_featured_articles = new WP_Query( array( 'post_type' => 'post', 'tag' => 'featured', 'posts_per_page' => esc_attr($multicote_wp_featured_posts) ) );  ?> 
          <?php while ($multicote_wp_featured_articles->have_posts()) : $multicote_wp_featured_articles->the_post(); ?> 

            <li <?php post_class('post-slide') ?>>
                <?php if ( has_post_thumbnail()) { ?>
                    <div class="article-category"><i></i> <?php $multicote_wp_category = get_the_category(); if ($multicote_wp_category) 
                        { echo '<a href="' . get_category_link( $multicote_wp_category[0]->term_id ) . '" class="tiptipBlog" title="' . sprintf( esc_html__( "View all posts in %s", "multicote-wp" ), $multicote_wp_category[0]->name ) . '" ' . '>' . $multicote_wp_category[0]->name.'</a> ';}  ?>
                    </div><!-- end .article-category -->
                    <?php the_post_thumbnail('multicote-wp-thumbnail-blog-featured', array('title' => "")); ?>
                <?php } // Post Thumbnail ?>

                <div class="title-box">
                    <span><?php the_author_posts_link(); ?></span>
                    <?php if(function_exists('taqyeem_get_score')) { ?> <?php taqyeem_get_score(); ?> <?php } ?>                    
                    <div class="clear"></div>
                    <h2><a href="<?php the_permalink(); ?>"><?php if ( strlen(get_the_title()) > 60 ) { echo mb_substr(get_the_title(), 0, 56)." ..."; } else { the_title(''); } ?></a></h2>
                </div>

            </li><!-- end .post-slide --> 
          <?php endwhile; 
          /* Restore original Post Data */
          wp_reset_postdata(); ?>
        </ul><!-- end .featured-articles-slider --> 
      
        <div class="clear"></div>             
      </div><!-- end .featured-articles -->


    <?php if ( has_nav_menu( 'multicote-wp-tertiary-menu' ) ) { // Check if there's a menu assigned to the 'Categories Carousel Navigation' location. ?>
        <div class="sub-header">
            <div class="categories-title">
                <strong><?php esc_html_e( 'Popular Categories', 'multicote-wp' ); ?></strong>           
            </div><!-- end .categories-title -->
            <div class="categories-section">
                        <nav class="jquerycssmenu">
                            <?php wp_nav_menu( array( 'container' => false, 'items_wrap' => '<ul class="carousel-categories">%3$s</ul>', 'theme_location' =>   'multicote-wp-tertiary-menu' ) ); ?>
                        </nav>
            </div><!-- end .categories-section -->
        </div><!-- end .sub-header -->
    <?php } // End check for menu. ?> 


    <!-- Begin Main Home Content -->
    <div class="wrap-content">
        <ul id="infinite-articles" class="masonry_list js-masonry">

        <?php
            if ( get_query_var('paged') )  {  $paged = get_query_var('paged'); } elseif ( get_query_var('page') ) { $paged = get_query_var('page'); } else { $paged = 1;  }
            // The Query
            query_posts( array( 'post_type' => 'post', 'paged' => $paged ) );
            if (have_posts()) : while (have_posts()) : the_post();
        ?>

            <li <?php post_class('ex34') ?> id="post-<?php the_ID(); ?>">

                  <?php if ( has_post_thumbnail()) { ?>
                    <div class="article-category"><i></i> <?php $multicote_wp_category = get_the_category(); if ($multicote_wp_category) 
                            { echo '<a href="' . get_category_link( $multicote_wp_category[0]->term_id ) . '" class="tiptipBlog" title="' . sprintf( esc_html__( "View all posts in %s", "multicote-wp" ), $multicote_wp_category[0]->name ) . '" ' . '>' . $multicote_wp_category[0]->name.'</a> ';}  ?>
                    </div><!-- end .article-category --> 
                    <a href="<?php the_permalink(); ?>"> <?php echo the_post_thumbnail('multicote-wp-thumbnail-blog-masonry'); ?> </a> 
                <?php } else { ?> 
                    <a href="<?php the_permalink(); ?>"><img src="<?php echo get_template_directory_uri(); ?>/images/no-img-2.png" alt="article image" /></a> 
                    <div class="article-category"><i></i> <?php $multicote_wp_category = get_the_category(); if ($multicote_wp_category) 
                            { echo '<a href="' . get_category_link( $multicote_wp_category[0]->term_id ) . '" class="tiptipBlog" title="' . sprintf( esc_html__( "View all posts in %s", "multicote-wp" ), $multicote_wp_category[0]->name ) . '" ' . '>' . $multicote_wp_category[0]->name.'</a> ';}  ?>
                    </div><!-- end .article-category -->                 
                <?php } // Post Thumbnail ?>  <div class="clear"></div>  

                  <div class="an-widget-title">
                    <h2 class="article-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                      <?php if(function_exists('taqyeem_get_score')) { ?>
                        <?php taqyeem_get_score(); ?>
                      <?php } ?>                    
                    <span><?php esc_html_e('Written by', 'multicote-wp'); ?> <?php the_author_posts_link(); ?></span> <i class="fas fa-check-circle"></i>
                  </div> 

                  <p><?php echo multicote_wp_excerpt(strip_tags(strip_shortcodes(get_the_excerpt())), 100); ?></p>

            </li>
        <?php endwhile; ?>
        </ul>  

        <!-- Pagination -->
        <div class="clear"></div>
        <?php if(function_exists('wp_pagenavi')) { ?>
            <?php wp_pagenavi(); ?>
        <?php } else { ?>
            <div class="defaultpag">
                <div class="sright"><?php next_posts_link('' . esc_html__('Older Entries', 'multicote-wp') . ' &rsaquo;'); ?></div>
                <div class="sleft"><?php previous_posts_link('&lsaquo; ' . esc_html__('Newer Entries', 'multicote-wp') . ''); ?></div>
            </div>
        <?php } ?>
        <!-- pagination -->
        <?php endif; ?>  


    </div><!-- end .home-content -->



    <!-- Begin Sidebar 1 (default right) -->
    <?php get_sidebar(); // add sidebar ?>
    <!-- end #sidebar 1 (default right) --> 

        
<div class="clear"></div>
</div><!-- end .wrap-fullwidth -->

<?php get_footer(); // add footer  ?>