<?php if ( post_password_required() ) : ?>
		<p class="nopassword"><?php
			_e( 'This post is password protected. Enter the password to view any comments.','multihost'); ?></p><?php
		return;
	endif;?>

	<h2 class="dt-sc-title"><?php
		$no_comments = esc_html__('No','multihost').' <i class="fa fa-comment"></i> '.esc_html__('Comments','multihost');
		$one_comment = '1 <i class="fa fa-comment"></i> '.esc_html__('Comment','multihost');
		$n_comments = '% <i class="fa fa-comment"></i> '.esc_html__('Comments','multihost');
		 comments_number( $no_comments , $one_comment , $n_comments ); ?> 
	</h2>

	<?php if ( have_comments() ) :?>

		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // Are there comments to navigate through? ?>
                    <div class="navigation">
                        <div class="nav-previous"><?php previous_comments_link( esc_html__( 'Older Comments','multihost'  ) ); ?></div>
                        <div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments','multihost') ); ?></div>
                    </div> <!-- .navigation -->
        <?php endif; // check for comment navigation ?>

        <ul class="commentlist">
     		<?php wp_list_comments( array( 'callback' => 'dttheme_custom_comments' ) ); ?>
        </ul>

	<?php else:
			if ( ! comments_open() ) :?>
				<p class="nocomments"><?php esc_html_e( 'Comments are closed.','multihost'); ?></p>
	<?php 	endif;
		  endif;?>

	<?php
	$fields =  array(
		"author" => "<div class='column dt-sc-one-half first'><input id='author' name='author' type='text' placeholder='".esc_attr__("Your Name","multihost")."' required /></div>",
		"email"  => "<div class='column dt-sc-one-half'><input id='email' name='email' type='text' placeholder='".esc_attr__("Your Email","multihost")."' required /></div>",
	);

	$comment = "<div class='dt-sc-clear'></div><div class='dt-sc-one-column'><textarea id='comment' name='comment' cols='5' rows='3' placeholder='".esc_attr__("Your Comment","multihost")."' ></textarea></div>";
	
	$privacy_cmdfrm = dttheme_option('privacy','enable-commentfrm-msg');
	if( isset( $privacy_cmdfrm ) ) {
	
		$content = do_shortcode( dttheme_option('privacy', 'commentfrm-msg') );
	
		$fields['comment-form-dt-privatepolicy'] = '<p class="comment-form-dt-privatepolicy">
			<input id="comment-form-dt-privatepolicy" name="comment-form-dt-privatepolicy" type="checkbox" value="yes">
			<label for="comment-form-dt-privatepolicy">'.$content.'</label> </p>';
	}
	
	$comments_args = array(
		'title_reply' 			=> 	esc_html__( 'Leave a Reply','multihost' ),
		'fields'				=> 	$fields,
		'comment_field'			=> 	$comment,
		'comment_notes_before'	=>	'',
		'comment_notes_after'	=>	'',
		'label_submit'			=>	esc_html__('Comment','multihost'));
	comment_form($comments_args);