<?php
if( !function_exists('dttheme_blog_title') ) {
	function dttheme_blog_title() {
		$the_content = preg_replace("~(?:\[/?)[^/\]]+/?\]~s", '', get_option('blogname'));
		return $the_content;
	}
}

add_filter('widget_text', 'do_shortcode');

#FILTER TO MODIFY THE DEFAULT CATEGORY WIDGET
add_filter('wp_list_categories', 'my_wp_list_categories');
if( !function_exists('my_wp_list_categories') ) {
	function my_wp_list_categories($output) {
		if (strpos($output, "</span>") <= 0) {
			$output = str_replace('</a> (', ' <span>(', $output);
			$output = str_replace(')', ')</span></a> ', $output);
		}
		return $output;
	}
}

add_filter('get_archives_link', 'my_wp_list_archive');
if( !function_exists('my_wp_list_archive') ) {
	function my_wp_list_archive($output) {
		$output = str_replace('</a>&nbsp;(', '<span> ', $output);
		$output = str_replace(')', '</span></a> ', $output);
		return $output;
	}
}

/** dttheme_default_navigation()
 * Objective:
 *		To setup default navigation  when no menu is selected
 **/
if( !function_exists('dttheme_default_navigation') ) {
	function dttheme_default_navigation() {
		echo '<ul class="menu">';
		$args = array('depth' => 1, 'title_li' => '', 'echo' => 0, 'post_type' => 'page', 'post_status' => 'publish');
		$pages = wp_list_pages($args);
		echo !empty( $pages ) ? $pages : '';
		echo '</ul>';
	}
}
### --- ****  dttheme_default_navigation() *** --- ###

add_action('wp_enqueue_scripts', 'plugin_head_styles_scripts');
if( !function_exists('plugin_head_styles_scripts') ) {
	function plugin_head_styles_scripts() {

		#Theme urls for Style Picker
		global $dt_google_fonts;
		$loadingbar = ( dttheme_option("general","loading-bar") ) ? "disable" : "enable";
		$scroll = dttheme_option('general', 'disable-custom-scroll') ? "disable" : "enable";
		$stickynav = ( dttheme_option("general","enable-sticky-nav") ) ? "enable" : "disable";
		$mobilestickynav = ( dttheme_option("general","enable-mobile-sticky-nav") ) ? "enable" : "disable";
		$isResponsive = dttheme_option ( "mobile", "is-theme-responsive" ) ? "enable" : "disable";
		$linkedin = ( dttheme_option("integration","page-linkedin") || dttheme_option("integration","post-linkedin") ) ? "enable" : "disable";
		
		#Theme urls for Style Picker End
		wp_enqueue_script('modernizr', IAMD_FW_URL.'js/public/modernizr.min.js', array('jquery'));

		wp_enqueue_script( 'html5shiv', IAMD_FW_URL . '/js/public/html5shiv.min.js', array(), false, true );
		wp_script_add_data( 'html5shiv', 'conditional', 'lt IE 9' );
		
		wp_enqueue_script('pace', IAMD_FW_URL.'js/public/pace.min.js',array(),false,true);

		wp_enqueue_script('jquery-isotope', IAMD_FW_URL.'js/public/jquery.isotope.min.js',array(),false,true);

		wp_enqueue_script('jquery-fitvids', IAMD_FW_URL.'js/public/jquery.fitvids.js',array(),false,true);

		wp_enqueue_script('jquery-easing', IAMD_FW_URL.'js/public/easing.js',array(),false,true);
		wp_enqueue_script('jquery-ui-top', IAMD_FW_URL.'js/public/jquery.ui.totop.min.js',array(),false,true);
		wp_enqueue_script('jquery-bxslider', IAMD_FW_URL.'js/public/jquery.bxslider.js',array(),false,true);

		wp_enqueue_script('jquery-prettyphoto', IAMD_FW_URL.'js/public/jquery.prettyPhoto.js',array(),false,true);
		
		wp_enqueue_script('jquery-isotope', IAMD_FW_URL.'js/public/jquery.isotope.min.js',array(),false,true);

		$cookiebar = dttheme_option('privacy', 'enable-cookie-msgbar');
		if( isset($cookiebar) ) {
			wp_enqueue_script('jq-cookie-js', IAMD_FW_URL.'js/public/cookieconsent.js', array(), false, true);
		}

		wp_enqueue_script('jq-popup-js', IAMD_FW_URL.'js/public/magnific/jquery.magnific-popup.min.js', array(), false, true);

		if( is_page_template('tpl-onepage.php') ) {
			wp_enqueue_script('onepage', IAMD_FW_URL.'js/public/jquery.nav.min.js',array(),false,true);
		}
		
		if( dttheme_option("general","enable-sticky-nav") || dttheme_option("general","enable-mobile-sticky-nav") ):
			wp_enqueue_script('jquery-sticky', IAMD_FW_URL.'js/public/jquery.sticky.js',array(),false,true);
		endif;

		wp_enqueue_script('jquery-nicescroll', IAMD_FW_URL.'js/public/jquery.nicescroll.min.js',array(),false,true);

		wp_enqueue_script('retina', IAMD_FW_URL.'js/public/retina.js',array(),false,true);
		
		#Theme Picker 		
		if( dttheme_option("general","disable-picker") === NULL  && !is_user_logged_in() ):
			wp_enqueue_script('theme-cookies', IAMD_FW_URL.'js/public/jquery.cookie.js',array(),false,true);
			wp_enqueue_script('theme-picker', IAMD_FW_URL.'js/public/picker.js',array(),false,true);
		endif;

		wp_enqueue_script('jquery-caroufredsel', IAMD_FW_URL.'js/public/jquery.carouFredSel-6.2.1-packed.js',array(),false,true);
		
		wp_enqueue_script('custom', IAMD_FW_URL.'js/public/custom.js',array(),false,true);

		wp_localize_script('jquery', 'mytheme_urls', array(
			'theme_base_url' => esc_js(IAMD_BASE_URL),
			'framework_base_url' => esc_js(IAMD_FW_URL),
			'ajaxurl' => esc_url( admin_url('admin-ajax.php') ),
			'url' => esc_url( get_site_url() ),
			'scroll' => $scroll,
			'stickynav' => $stickynav,
			'mobilestickynav' => $mobilestickynav,
			'is_admin' => current_user_can('level_10'),
			'skin' => dttheme_option('appearance','skin'),
			'layout' => dttheme_option('appearance','layout'),
			'isResponsive' => $isResponsive,
			'layout_pattern' => dttheme_option('appearance','boxed-layout-pattern'),
			'loadingbar' => $loadingbar,
			'linkedin' => esc_js($linkedin)
		));
	}
}

add_action('wp_head', 'dttheme_appearance_load_fonts', 7);
/** dttheme_appearance_load_fonts()
 * Objective:
 *		To load google fonts based on appearance settings in admin panel.
 **/
if( !function_exists('dttheme_appearance_load_fonts') ) {
	function dttheme_appearance_load_fonts() {

		if( ! isset( $_COOKIE['dtPrivacyGoogleWebfontsDisabled'] ) ):
				
			$custom_fonts = array();
			$output = $font = "";

			$subset = dttheme_option('general', 'google-font-subset');
			if ($subset) {
				$subset = strtolower(str_replace(' ', '', $subset));
			}

			#Menu Section
			$disable_menu = dttheme_option("appearance", "disable-menu-settings");
			if (empty($disable_menu)) :
				$font = dttheme_option("appearance", "menu-font");
				if (!empty($font)) :
					$font = str_replace(" ", "+", $font);
					array_push($custom_fonts, $font);
				endif;
			endif; #Menu Secion End

			#Body Section
			$disable_boddy_settings = dttheme_option("appearance", "disable-boddy-settings");

			if (empty($disable_boddy_settings)) :
				$font = dttheme_option("appearance", "body-font");
				$font = str_replace(" ", "+", $font);
				if (!empty($font)) :
					array_push($custom_fonts, $font);
				endif;
			endif;

			#Footer Section
			$disable_footer = dttheme_option("appearance", "disable-footer-settings");
			if (empty($disable_footer)) :
				$footer_title_font = dttheme_option("appearance", "footer-title-font");
				$footer_title_font = !empty($footer_title_font) ? str_replace(" ", "+", $footer_title_font) : NULL;
				if (!empty($footer_title_font)) :
					array_push($custom_fonts, $footer_title_font);
				endif;

				$footer_content_font = dttheme_option("appearance", "footer-content-font");
				$footer_content_font = !empty($footer_content_font) ? str_replace(" ", "+", $footer_content_font) : NULL;
				if (!empty($footer_content_font)) :
					array_push($custom_fonts, $footer_content_font);
				endif;

			endif; #Footer Section End

			#Typography Section
			$disable_typo = dttheme_option("appearance", "disable-typography-settings");
			if (empty($disable_typo)) :
				for ($i = 1; $i <= 6; $i++) :
					$font = dttheme_option("appearance", "H{$i}-font");
					if (!empty($font)) :
						$font = str_replace(" ", "+", $font);
						array_push($custom_fonts, $font);
					endif;
				endfor;
			endif; #Typography Section End

			#404 Section
			$disable_404_settings = dttheme_option("specialty", "disable-404-font-settings");
			if (empty($disable_404_settings)) :
				$font = dttheme_option("specialty", "message-font");
				if (!empty($font)) :
					$font = str_replace(" ", "+", $font);
					array_push($custom_fonts, $font);
				endif;
			endif;


			if (!empty($custom_fonts)) :
				$custom_fonts = array_unique($custom_fonts);
				$font = implode(":300,400,400italic,700%7C", $custom_fonts);
				$font .= ":300,400,400italic,700%7C";
			endif;

			$font .= "Ubuntu:300,400,500,700";
			$protocol = is_ssl() ? 'https' : 'http';
			$query_args = array('family' => $font, 'subset' => $subset);
			wp_enqueue_style('mytheme-google-fonts', add_query_arg($query_args, "$protocol://fonts.googleapis.com/css" ), array(), null);

		endif;
		
	}
}
### --- ****  dttheme_appearance_load_fonts() *** --- ###

add_action('wp_enqueue_scripts', 'dttheme_appearance_css', 91);
/** dttheme_appearance_css()
 * Objective:
 *		To generate in-line style based on appearance settings in admin panel.
 **/
if( !function_exists('dttheme_appearance_css') ) {
	function dttheme_appearance_css() {
		
		$output = NULL;
		
		#Layout Section
		if(dttheme_option("appearance","layout") == "boxed"):
			if(dttheme_option("appearance","bg-type") == "bg-patterns"):
				$pattern = dttheme_option("appearance","boxed-layout-pattern");
				$pattern_repeat = dttheme_option("appearance","boxed-layout-pattern-repeat");
				$pattern_opacity = dttheme_option("appearance","boxed-layout-pattern-opacity");
				$disable_color = dttheme_option("appearance","disable-boxed-layout-pattern-color");
				$pattern_color =  dttheme_option("appearance","boxed-layout-pattern-color");
				$output .= "body { ";
					if(!empty($pattern))
						$output .= "background-image:url('".IAMD_FW_URL."theme_options/images/patterns/{$pattern}');"; 
							
					$output .= "background-repeat:$pattern_repeat;";
					if(empty($disable_color)){
						if(!empty($pattern_opacity)){
							$color = hex2rgb($pattern_color);
							$output .= "background-color:rgba($color[0],$color[1],$color[2],$pattern_opacity); ";
						}else{
							$output .= "background-color:$pattern_color;";
						}
					}
				$output .= "}\r\t";
			
			elseif(dttheme_option("appearance","bg-type") == "bg-custom"):
				$bg = dttheme_option("appearance","boxed-layout-bg");
				$bg_repeat = dttheme_option("appearance","boxed-layout-bg-repeat");
				$bg_opacity = dttheme_option("appearance","boxed-layout-bg-opacity");
				$bg_color =  dttheme_option("appearance","boxed-layout-bg-color");
				$disable_color = dttheme_option("appearance","disable-boxed-layout-bg-color");
				$bg_position =  dttheme_option("appearance","boxed-layout-bg-position");
				$output .= "body { ";
				if(!empty($bg)) {
					$output .= "background-image:url($bg);";
					$output .= "background-repeat:$bg_repeat;";
					$output .= "background-position:$bg_position;";
				}
				
				if(empty($disable_color)){
					if(!empty($bg_opacity)){	
						$color = hex2rgb($bg_color);
						$output .= "background-color:rgba($color[0],$color[1],$color[2],$bg_opacity);";
					}else{
						$output .= "background-color:$bg_color;";
					}
				}
				$output .= "}\r\t";
			endif;
		endif;
		#Layout Section
		
		#Top Bar Color
		$diaable_topbar = dttheme_option("appearance", 'disable-top-bar-colors');
		
		if( empty($diaable_topbar) ) {

			#Top Bar BG Color
			$topbar_bg_color = dttheme_option("appearance", "topbar-bg-color");
			if( !empty($topbar_bg_color) and $topbar_bg_color != "#"  ):
				$output .= "\r\t #header-top { background-color:{$topbar_bg_color} } \r\t";
			endif;

			#Top Bar Text Color
			$topbar_text_color = dttheme_option("appearance", "topbar-text-color");
			if( !empty($topbar_text_color) and $topbar_text_color != "#"  ):
				$output .= "\r\t #header-top ul li { color:{$topbar_text_color} } \r\t";
				$output .= "\r\t #header-top ul li { border-color:{$topbar_text_color} } \r\t";
			endif;

			#Top Bar Primary Color
			$topbar_primary_color = dttheme_option("appearance", "topbar-primary-color");
			if( !empty($topbar_primary_color) and $topbar_primary_color != "#"  ):
				$output .= "\r\t #header-top, #header-top p, #header-top span, #header-top p.contact span, #header-top a { color:{$topbar_primary_color} } \r\t";
			endif;

			#Top Bar Secondary Color
			$topbar_secondary_color = dttheme_option("appearance", "topbar-secondary-color");
			if( !empty($topbar_secondary_color) and $topbar_secondary_color != "#"  ):
				$output .= "\r\t #header-top a:hover { color:{$topbar_secondary_color} } \r\t";
			endif;

			#Top Bar Border Color
			$topbar_border_color = dttheme_option("appearance", "topbar-border-color");
			if( !empty($topbar_border_color) and $topbar_border_color != "#"  ):
				$output .= "\r\t #header-top { border-color:{$topbar_border_color} } \r\t";
			endif;
		}#Top Bar Color
		
		#Headar Color
		$disable_header = dttheme_option("appearance", 'disable-header-settings');
		if( empty($disable_header) ){
			#Header BG Color
			$header_bg_color = dttheme_option("appearance", "header-bg-color");
			if( !empty($header_bg_color) and $header_bg_color != "#"  ):
				$output .= "\r\t #header, .main-menu-wrapper { background-color:{$header_bg_color} } \r\t";
			endif;
		}#Header Color End

		#Menu Section
		$disable_menu = dttheme_option("appearance", "disable-menu-settings");
		if (empty($disable_menu)) :
			$font_type = dttheme_option("appearance", "menu-font-type");
			$style = dttheme_option("appearance","menu-standard-font-style");
			
			if( !empty($font_type) ){
			#Menu Font: Standard
				$font = dttheme_option("appearance","menu-standard-font");
			} else {
			#Menu Font: Google
				$font = dttheme_option("appearance", "menu-font");
			}

			$size = dttheme_option("appearance", "menu-font-size");
			$primary_color = dttheme_option("appearance", "menu-primary-color");
			$secondary_color = dttheme_option("appearance", "menu-secondary-color");
			
			if (!empty($font) || (!empty($primary_color) and $primary_color != "#") || !empty($size)) :
			
				$output .= "  #main-menu ul.menu > li > a, #main-menu ul li.menu-item-simple-parent ul li a, .megamenu-child-container ul.sub-menu > li > ul li a, .megamenu-child-container > ul.sub-menu > li > a, .megamenu-child-container > ul.sub-menu > li > .nolink-menu { ";
					if (!empty($font)) { $output .= "font-family:{$font},sans-serif; ";	}
					
					if (!empty($primary_color) && ($primary_color != '#')) { $output .= "color:{$primary_color}; "; }
					
					if (!empty($size) and ($size > 0)) { $output .= "font-size:{$size}px; "; }

					if (!empty($style) && !empty($font_type)) { 
						if ($style == 'Bold Italic') {
							$output .= "font-weight:bold; font-style:italic;";
						} elseif ($style == 'Bold') {
							$output .= "font-weight:bold;";
						} elseif ($style == 'Italic') {
							$output .= "font-style:italic;";
						} elseif ($style == 'Normal') {
							$output .= "font-weight:normal; font-style:normal;";
						}				
					}

				$output .= "}\r\t";

				if (!empty($size) and ($size > 0)) {  $size = $size-2 ;$output .= " #main-menu ul.sub-menu li a, #main-menu ul li.menu-item-simple-parent ul li a { font-size:{$size}px; }\r\t"; }

			endif;

			if (!empty($secondary_color) and $secondary_color != "#") :
			  $output .= "#main-menu ul li a:hover, #main-menu ul > li.current_page_item > a, #main-menu ul > li.current_page_ancestor > a, #main-menu ul > li.current-menu-item > a, #main-menu ul > li.current-menu-ancestor > a, #main-menu ul li.menu-item-simple-parent ul > li.current_page_item > a, #main-menu ul li.menu-item-simple-parent ul > li.current_page_ancestor > a, #main-menu ul li.menu-item-simple-parent ul > li.current-menu-item > a, #main-menu ul li.menu-item-simple-parent ul > li.current-menu-ancestor > a, #main-menu ul li.menu-item-simple-parent ul li a:hover, #main-menu ul li.menu-item-megamenu-parent:hover > a { ";
		  	  $output .= "color:{$secondary_color} !important; ";
			  $output .= "}\r\t";
			endif;
			
			$menu_bg_color = dttheme_option("appearance", "menu-bg-color");
			if( !empty($menu_bg_color) and $menu_bg_color != "#"  ):
				$output .= "\r\t #main-menu { background-color:{$menu_bg_color} } \r\t";
			endif;

			$smenu_bg_color = dttheme_option("appearance", "smenu-bg-color");
			if( !empty($smenu_bg_color) and $smenu_bg_color != "#"  ):
				$output .= "\r\t #main-menu ul li.menu-item-simple-parent ul, .megamenu-child-container  { background-color:{$smenu_bg_color} } \r\t";
			endif;

			#Menu BG
			$menu_bg = dttheme_option("appearance","menu-bg");
			if( !empty($menu_bg) ):
				$repeat = dttheme_option("appearance","menu-bg-repeat");
				$position = dttheme_option("appearance","menu-bg-position");
				$output .= "\r\t #main-menu, #main-menu ul li.menu-item-simple-parent ul, .megamenu-child-container { background-image:url({$menu_bg}); background-repeat:{$repeat}; background-position:{$position} } \r\t";
			endif;
		endif; #Menu Section End

		#Body Section
		$disable_boddy_settings = dttheme_option("appearance", "disable-boddy-settings");
		if (empty($disable_boddy_settings)) :
			$font_type = dttheme_option("appearance", "body-font-type");
			$style = dttheme_option("appearance","body-standard-font-style");

			if( !empty($font_type) ){
			#Body Font: Standard
				$body_font = dttheme_option("appearance","body-standard-font");
				
			} else {
			#Body Font: Google
				$body_font = dttheme_option("appearance", "body-font");
			}

			$body_font_size = dttheme_option("appearance", "body-font-size");
			$body_font_color = dttheme_option("appearance", "body-font-color");

			$body_primary_color = dttheme_option("appearance", "body-primary-color");
			$body_secondary_color = dttheme_option("appearance", "body-secondary-color");


			if (!empty($body_font) || (!empty($body_font_color) and $body_font_color != "#") || !empty($body_font_size)) :
				$output .= "body {";
				if (!empty($body_font)) {	$output .= "font-family:{$body_font} , sans-serif; ";  }

				if (!empty($body_font_color) && ($body_font_color != '#')) { $output .= "color:{$body_font_color}; "; }

				if (!empty($body_font_size)) {	$output .= "font-size:{$body_font_size}px; "; }
				
				if (!empty($style) && !empty($font_type)) { 
					if ($style == 'Bold Italic') {
						$output .= "font-weight:bold; font-style:italic;";
					} elseif ($style == 'Bold') {
						$output .= "font-weight:bold;";
					} elseif ($style == 'Italic') {
						$output .= "font-style:italic;";
					} elseif ($style == 'Normal') {
						$output .= "font-weight:normal; font-style:normal;";
					}				
				}

				$output .= "}\r\t";
			endif;

			if (!empty($body_font_color) and $body_font_color != "#") :
				$output .= ".wp-block-pullquote {";
					$output .= "color:{$body_font_color}; ";
				$output .= "}\r\t";
			endif;

			if ((!empty($body_primary_color) and $body_primary_color != "#") || (!empty($body_secondary_color) and $body_secondary_color != "#")) :
				if (!empty($body_primary_color) && ($body_primary_color != '#')) { 	$output .= "a { color:{$body_primary_color}; }"; }

				if (!empty($body_secondary_color) && ($body_secondary_color != '#')) {	$output .= "a:hover { color:{$body_secondary_color}; }";	}
			endif;
		endif; #Body Section End

		#Footer Section
		$disable_footer = dttheme_option("appearance", "disable-footer-settings");
		if (empty($disable_footer)) :

			#Footer Title
			$font_type = dttheme_option("appearance", "footer-title-font-type");
			$style = dttheme_option("appearance","footer-title-standard-font-style");
			
			if( !empty($font_type) ){
				#Footer Title Font : Standard Font
				$footer_title_font = dttheme_option("appearance","footer-title-standard-font");
			} else {
				#Footer Title Font : Google Font	
				$footer_title_font = dttheme_option("appearance", "footer-title-font");		
			}
			
			$footer_title_font_color = dttheme_option("appearance", "footer-title-font-color");
			$footer_title_font_size = dttheme_option("appearance", "footer-font-size");
			$footer_primary_color = dttheme_option("appearance", "footer-primary-color");
			$footer_secondary_color = dttheme_option("appearance", "footer-secondary-color");
			$footer_bg_color = dttheme_option("appearance", "footer-bg-color");
			$copyright_bg_color = dttheme_option("appearance", "copyright-bg-color");

			if (!empty($footer_title_font) || (!empty($footer_title_font_color) and $footer_title_font_color != "#") || !empty($footer_title_font_size)) :
				$output .= "#footer h1, #footer h2, #footer h3, #footer h4, #footer h5, #footer h6, #footer h1 a, #footer h2 a, #footer h3 a, #footer h4 a, #footer h5 a, #footer h6 a, #footer .widget h3.widgettitle, #footer .widget h3.widgettitle a {";
				if (!empty($footer_title_font)) {	$output .= "font-family:{$footer_title_font}; ";	}

				if (!empty($footer_title_font_color) && ($footer_title_font_color != '#')) {	$output .= "color:{$footer_title_font_color}; ";	}

				if (!empty($footer_title_font_size)) {	$output .= "font-size:{$footer_title_font_size}px; ";	}
				
				if (!empty($style) && !empty($font_type)) { 
					if ($style == 'Bold Italic') {
						$output .= "font-weight:bold; font-style:italic;";
					} elseif ($style == 'Bold') {
						$output .= "font-weight:bold;";
					} elseif ($style == 'Italic') {
						$output .= "font-style:italic;";
					} elseif ($style == 'Normal') {
						$output .= "font-weight:normal; font-style:normal;";
					}				
				}

				$output .= "}\r\t";
			endif;

			if ((!empty($footer_primary_color) and $footer_primary_color != "#") || (!empty($footer_secondary_color) and $footer_secondary_color != "#")) :
				if (!empty($footer_primary_color) && ($footer_primary_color != '#')) {
					$output .= "#footer .footer-widgets-wrapper ul li a, #footer .footer-widgets-wrapper .widget_categories ul li a, #footer .footer-widgets-wrapper .widget.widget_recent_entries .entry-metadata .tags a, #footer .footer-widgets-wrapper .categories a, .copyright a, #footer .widget ul li:before, #footer .entry-details .entry-metadata p a span { color:{$footer_primary_color} !important;; }";
				}

				if (!empty($footer_secondary_color) && ($footer_secondary_color != '#')) {
					$output .= "#footer .footer-widgets-wrapper h1 a:hover, #footer .footer-widgets-wrapper h2 a:hover, #footer .footer-widgets-wrapper h3 a:hover, #footer .footer-widgets-wrapper h4 a:hover, #footer .footer-widgets-wrapper h5 a:hover, #footer .footer-widgets-wrapper h6 a:hover, #footer .footer-widgets-wrapper ul li a:hover, #footer .footer-widgets-wrapper .widget.widget_recent_entries .entry-metadata .tags a:hover, #footer .footer-widgets-wrapper .categories a:hover, #footer .copyright a:hover, #footer .widget ul li:hover:before, #footer .entry-details .entry-metadata p a:hover span { color:{$footer_secondary_color} !important; }";
				}
			endif;
			
			#Footer Content
			$font_type = dttheme_option("appearance","footer-content-font-type");
			$style = dttheme_option("appearance","footer-content-standard-font-style");
			if( !empty($font_type) ){
				#Footer Content Font : Standard Font
				$footer_content_font = dttheme_option("appearance","footer-content-standard-font");
			} else {
				#Footer Content Font : Google Font	
				$footer_content_font = dttheme_option("appearance", "footer-content-font");		
			}
			
			$footer_content_font_color = dttheme_option("appearance", "footer-content-font-color");
			$footer_content_font_size = dttheme_option("appearance", "footer-content-font-size");
			
			if (!empty($footer_content_font) || (!empty($footer_content_font_color) and $footer_content_font_color != "#") || !empty($footer_content_font_size)) :
				$output .= "#footer, #footer .footer-widgets-wrapper .widget.widget_recent_entries .entry-metadata .author, #footer .footer-widgets-wrapper .widget.widget_recent_entries .entry-meta .date, #footer .footer-widgets-wrapper label, #footer .footer-widgets-wrapper .widget ul li, #footer .footer-widgets-wrapper .widget ul li:hover, .copyright, #footer .footer-widgets-wrapper .widget.widget_recent_entries .entry-metadata .tags, #footer .footer-widgets-wrapper .categories, #footer .footer-widgets-wrapper .widget.widget_rss .rss-date, #footer .footer-widgets-wrapper .widget.widget_rss cite, #footer .widget #wp-calendar caption {";
				
				if (!empty($footer_content_font)) {	$output .= "font-family:{$footer_content_font} !important; ";	}

				if (!empty($footer_content_font_color) && ($footer_content_font_color != '#')) {	$output .= "color:{$footer_content_font_color} !important; ";	}

				if (!empty($footer_content_font_size)) {	$output .= "font-size:{$footer_content_font_size}px !important; ";	}
				
				if (!empty($style) && !empty($font_type)) { 
					if ($style == 'Bold Italic') {
						$output .= "font-weight:bold; font-style:italic;";
					} elseif ($style == 'Bold') {
						$output .= "font-weight:bold;";
					} elseif ($style == 'Italic') {
						$output .= "font-style:italic;";
					} elseif ($style == 'Normal') {
						$output .= "font-weight:normal; font-style:normal;";
					}				
				}

				$output .= "}\r\t";

				if (!empty($footer_content_font_size)) {
					$output .= "#footer .widget_categories ul li a, #footer .widget.widget_archive ul li a { font-size:{$footer_content_font_size}px !important; } \r\t";
				}
			endif;
			
			if (!empty($footer_bg_color) and $footer_bg_color != "#") {		$output .= "#footer .footer-widgets-wrapper { background-color: $footer_bg_color !important; }";	}

			if (!empty($copyright_bg_color) and $copyright_bg_color != "#") {	$output .= "#footer .copyright { background-color: $copyright_bg_color !important; }"; }
		endif; #Footer Section End */

		#Typography Settings
		$disable_typo = dttheme_option("appearance", "disable-typography-settings");
		if (empty($disable_typo)) :
			for ($i = 1; $i <= 6; $i++) :
				$font_type = dttheme_option("appearance", "H{$i}-font-type");
				$style = dttheme_option("appearance","H{$i}-standard-font-style");
				
				if( !empty($font_type) ){
				#Menu Font: Standard
					$font = dttheme_option("appearance","H{$i}-standard-font");
				} else {
				#Menu Font: Google
					$font = dttheme_option("appearance", "H{$i}-font");
				}
				
				$color = dttheme_option("appearance", "H{$i}-font-color");
				$size = dttheme_option("appearance", "H{$i}-size");

				if (!empty($font) || (!empty($color) and $color != "#") || !empty($size)) :
					$output .= "H$i {";
					if (!empty($font)) {	$output .= "font-family:{$font}; ";	}

					if (!empty($color) && ($color != '#')) {	$output .= "color:{$color}; ";	}
					
					if (!empty($size)) { $output .= "font-size:{$size}px; "; }

					if (!empty($style) && !empty($font_type)) { 
						if ($style == 'Bold Italic') {
							$output .= "font-weight:bold; font-style:italic;";
						} elseif ($style == 'Bold') {
							$output .= "font-weight:bold;";
						} elseif ($style == 'Italic') {
							$output .= "font-style:italic;";
						} elseif ($style == 'Normal') {
							$output .= "font-weight:normal; font-style:normal;";
						}				
					}

					$output .= "}\r\t";
				endif;
			endfor;
		endif; #Typography Settings end 

		#404 Settings
		$disable_404_settings = dttheme_option("specialty", "disable-404-font-settings");
		if (empty($disable_404_settings)) :
			$font = dttheme_option("specialty", "message-font");
			$color = dttheme_option("specialty", "message-font-color");
			$size = dttheme_option("specialty", "message-font-size");

			if (!empty($font) || (!empty($color) and $color != "#") || !empty($size)) :
				$output .= "div.error-info { ";
				if (!empty($font)) {
					$output .= "font-family:{$font}; ";
				}

				if (!empty($color) && ($color != '#')) {
					$output .= "color:{$color}; ";
				}

				if (!empty($size)) {
					$output .= "font-size:{$size}px; ";
				}
				$output .= "}\r\t";

				$output .= "div.error-info h1, div.error-info h2, div.error-info h3,div.error-info h4,div.error-info h5,div.error-info h6 { ";
				if (!empty($font)) {
					$output .= "font-family:{$font}; ";
				}

				if (!empty($color) && ($color != '#')) {
					$output .= "color:{$color}; ";
				}
				$output .= "}\r\t";

			endif;
		endif; #404 Settings end 

		#custom CSS
		if (dttheme_option('integration', 'enable-custom-css')) :
			$css = dttheme_option('integration', 'custom-css');
			$output .= wp_specialchars_decode(stripcslashes($css));
		endif; #custom CSS eND

		if (!empty($output)) :
			wp_add_inline_style( 'multihost-gutenberg', $output );
		endif;
	}
}

if( !function_exists('dttheme_slider_section') ) {
	function dttheme_slider_section($post_id) {
		$tpl_default_settings = get_post_meta($post_id, '_tpl_default_settings', TRUE);
		$tpl_default_settings = is_array($tpl_default_settings) ? $tpl_default_settings : array();

		if (array_key_exists('show_slider', $tpl_default_settings) && array_key_exists('slider_type', $tpl_default_settings)) :

			echo '<!-- **Slider Section** -->';
			echo '<div id="slider">';

			echo '	<div id="slider-container">';
			if ($tpl_default_settings['slider_type'] === "layerslider") :

				$id = isset( $tpl_default_settings['layerslider_id'])? $tpl_default_settings['layerslider_id'] : "";
				echo !empty( $id ) ?  do_shortcode("[layerslider id='{$id}']") : '';
				
			elseif ($tpl_default_settings['slider_type'] === "revolutionslider") :

				$id = isset($tpl_default_settings['revolutionslider_id']) ? $tpl_default_settings['revolutionslider_id'] : "";
				echo !empty( $id ) ?  do_shortcode("[rev_slider $id]") : '';
				
			elseif( $tpl_default_settings['slider_type'] === "imageonly" ):
				
				$img = isset($tpl_default_settings['slider-image']) ? "<div class='slider-image-only'><img src='".esc_url( $tpl_default_settings['slider-image'] )."' alt=''/></div>" : "";
				echo !empty( $img ) ? $img : '';
			endif;
			echo '</div>';
			echo '</div>';
			echo '<!-- **Slider Section Ends ** -->';
		endif;
	}
}

if( !function_exists('dttheme_subtitle_section') ) {
	function dttheme_subtitle_section($id=0, $type = '', $settings = array() ){
		
		if( $id > 0 ){

			$title = get_the_title($id);

			if( $type === "post" )
				$settings = '_dt_post_settings';
			elseif( $type === "page" )
				$settings = '_tpl_default_settings';
			elseif( $type === "dt_galleries" )
				$settings = '_gallery_settings';

			$settings = get_post_meta( $id, $settings, TRUE );
			$settings = is_array($settings) ? $settings : array();

			$darkbg = array_key_exists('dark-bg', $settings) ? "light-bg" : "";	

			$disable_breadcrumb = array_key_exists('disable-breadcrumb', $settings ) ? false : true;
			$class = array_key_exists('disable-breadcrumb', $settings ) ? "align-center" : "";

			$style = "";
			if( array_key_exists('sub-title-bg', $settings)  ) {
				$bg = $settings['sub-title-bg'];
				$position = array_key_exists('sub-title-bg-position', $settings) ? $settings['sub-title-bg-position'] :'center center';
				$repeat = array_key_exists('sub-title-bg-repeat', $settings) ? $settings['sub-title-bg-repeat'] :'repeat';
				$style  = "background-image:url($bg);";
				$style .= "background-repeat: $repeat;";
				$style .= "background-position:$position;";
				$style = "style='{$style}'";
			}
		}

		if ( !array_key_exists('show_slider', $settings) ) :
			echo '<!-- breadcrumb-section starts -->';
			echo "<div class='breadcrumb-section {$class} {$darkbg}' {$style}>";
			echo '	<div class="container">';
			echo "		<h1>{$title}</h1>";
						if( $disable_breadcrumb )
							new dttheme_breadcrumb;
			echo '	</div>';
			echo '</div><!-- breadcrumb-section ends -->';
		endif;	
	}
}

if( !function_exists('dttheme_custom_subtitle_section') ) {
	function dttheme_custom_subtitle_section( $title ) {

		echo '<!-- breadcrumb-section starts -->';
		echo '<div class="breadcrumb-section">';
		echo '	<div class="container">';

					if ( is_front_page() && is_home() ) {
		echo "			<h1>".get_bloginfo('description')."</h1>";
					} elseif( is_post_type_archive('tribe_events') || is_tax('tribe_events_cat') || in_array('events-single', get_body_class()) || in_array('events-list', get_body_class()) || in_array('tribe-filter-live', get_body_class()) || in_array('tribe-events-week', get_body_class()) || in_array('tribe-events-day', get_body_class()) || in_array('tribe-events-map', get_body_class()) || in_array('tribe-events-photo', get_body_class()) || in_array('tribe-events-venue', get_body_class()) ) {
		echo 			get_events_title();
						new dttheme_events_breadcrumb;					
					} else {					
		echo "			<h1>{$title}</h1>";
						new dttheme_breadcrumb;
					}
		echo '	</div>';
		echo '</div><!-- breadcrumb-section ends -->';
	}
}

if( !function_exists('dttheme_bpress_subtitle') ) {
	function dttheme_bpress_subtitle(){
		global $bp;
		
		if ( !empty( $bp->displayed_user->fullname ) ) { // looking at a user or self
			$title =  bp_current_component() === "profile" ? esc_html__("Profile","multihost") : esc_html__("Member","multihost");
			$subtitle = strip_tags( $bp->displayed_user->userdata->display_name );
			$icon = "fa-user";
			$class = "dark-bg dt-bp-member-page";
			dttheme_custom_subtitle_section($title,$subtitle,$icon,$class);

		}elseif( bp_is_members_component() ) {
			dttheme_subtitle_section( $bp->pages->members->id , 'page' );
		}elseif( bp_is_activity_component() ){
			dttheme_subtitle_section( $bp->pages->activity->id , 'page' );
		}elseif( bp_current_component() === "groups" ) {
			dttheme_subtitle_section( $bp->pages->groups->id , 'page' );
		}elseif( bp_current_component() === "register" ) {
			dttheme_subtitle_section( $bp->pages->register->id , 'page' );
		}elseif( bp_current_component() === "activate" ) {
			dttheme_subtitle_section( $bp->pages->activate->id , 'page' );
		}else{
			bp_current_component();
		}	
	}
}

/** dttheme_excerpt()
 * Objective:
 *		To produce the excerpt for the posts.
 **/
if( !function_exists('dttheme_excerpt') ) {
	function dttheme_excerpt($limit = NULL) {

		$limit = !empty($limit) ? $limit : 10;
		
		$excerpt = explode(' ', get_the_excerpt(), $limit);
		$excerpt = array_filter($excerpt);
		
		if (!empty($excerpt)) {
			if (count($excerpt) >= $limit) {
				array_pop($excerpt);
				$excerpt = implode(" ", $excerpt).'...';
			} else {
				$excerpt = implode(" ", $excerpt);
			}
			$excerpt = preg_replace('`\[[^\]]*\]`', '', $excerpt);
			return "<p>{$excerpt}</p>";
		}
	}
}
### --- ****  dttheme_excerpt() *** --- ###

/** dttheme_custom_comments()
 * Objective:
 *		To customize the post/page comments view.
 **/
if( !function_exists('dttheme_custom_comments') ) {
	function dttheme_custom_comments($comment, $args, $depth) {
		$GLOBALS['comment'] = $comment;
		switch ($comment->comment_type ) :
		case 'pingback':
		case 'trackback':
			echo '<li class="post pingback">';
			echo "<p>";
			_e('Pingback:', 'multihost');
			comment_author_link();
			edit_comment_link(esc_html__('Edit', 'multihost'), ' ', '');
			echo "</p>";
			break;

		default:
		case '':
			echo "<li ";
			comment_class();
			echo ' id="li-comment-';
			comment_ID();
			echo '">';
			echo '<div class="comment-container" id="comment-';
			comment_ID();
			echo '">';


			echo '<div class="comment-author">';
			echo get_avatar($comment, 70);
			echo '</div>';

			echo '<div class="comment-details">';

			echo '	<div class="comment-meta">';
			echo '		<h3 class="author-name">'; 
			echo 			comment_reply_link(array_merge($args, array('reply_text' => ucfirst(get_comment_author_link()) , 'depth' => $depth, 'max_depth' => $args['max_depth'])));
			echo '		</h3>';
			echo 		'<span class="commentmetadata">'.get_comment_date('d M Y').'</span>';
			echo 		comment_reply_link(array_merge($args, array('reply_text' => esc_html__('Reply', 'multihost'), 'depth' => $depth, 'max_depth' => $args['max_depth'])));
			echo '	</div>';

					comment_text();

					if ($comment->comment_approved == '0') :
						_e('Your comment is awaiting moderation.', 'multihost');
					endif;

					edit_comment_link(esc_html__('Edit', 'multihost'));						

			echo '</div>';
			echo '</div><!-- .comment-ID -->';
			break;
		endswitch;
	}
}
### --- ****  dttheme_custom_comments() *** --- ###

#BREADCRUMB
if( !class_exists('dttheme_breadcrumb') ) {
	class dttheme_breadcrumb {
		var $options;

		function __construct(){
			
			$delimiter =  'fa '.dttheme_option('general', 'breadcrumb-delimiter');
			$this->options = array( 'before' => "<span class='${delimiter}' > ",'after' => ' </span>');
			$markup = $this->options['before'].$this->options['after'];
			
			global $post;
			
			echo '<div class="breadcrumb">				
						<a href="'.esc_url( home_url('/') ).'">'.esc_html__('Home','multihost').'</a>';
					
				if( !is_front_page() && !is_home()) {
					echo !empty( $markup ) ? $markup : '';
				}
				
				$output = $this->simple_breadcrumb_case($post);

			if ( is_page() || is_single() ) {
				echo '<span class="current">';
						the_title();
				echo "</span>";
				
			}elseif( $output !== NULL ){
				echo '<span class="current">'.esc_html($output)."</span>";
			}else {
				$title =  (get_option( 'page_for_posts' ) > 0) ? get_the_title( get_option( 'page_for_posts' ))  :NULL;
				echo !empty( $markup ) ? $markup : '';
				echo '<span class="current">'.esc_html( $title )."</span>";
			}
			echo "</div><!-- ** breadcrumb - End -->";
		}
		
		function simple_breadcrumb_case($der_post){
			$markup = $this->options['before'].$this->options['after'];
			if (is_page()){
				 if($der_post->post_parent) {
					 $my_query = get_post($der_post->post_parent);			 
					 $this->simple_breadcrumb_case($my_query);
					 $link = '<a href="'.get_permalink($my_query->ID).'">';
					 $link .= ''. get_the_title($my_query->ID) . '</a>'. $markup;
					 echo !empty( $link ) ? $link : '';
				 }
			return;	 	
			} 

			if(is_single()){
				$category = get_the_category();
				if (is_attachment()){
					$my_query = get_post($der_post->post_parent);			 
					$category = get_the_category($my_query->ID);
					if( isset($category[0])) {
						$ID = $category[0]->cat_ID;
						echo is_wp_error( $cat_parents = get_category_parents($ID, TRUE, $markup, FALSE) ) ? '' : $cat_parents;					
						previous_post_link("%link $markup");
					}
				}else{
					$postType = get_post_type();

					if($postType == 'post')	{
						$ID = $category[0]->cat_ID;
						echo get_category_parents($ID, TRUE,$markup, FALSE );
						
					} else if($postType == 'dt_portfolios') {
						global $post;
						$terms = get_the_term_list( $post->ID, 'dt_portfolio_entries', '', '$$$', '' );
						$terms =  array_filter(explode('$$$',$terms));
						
						echo !empty( $terms ) ? $terms[0].$markup : ''; 
						
					} else if($postType == 'product') {
						global $post;
						$terms = get_the_term_list( $post->ID, 'product_cat', '', '$$$', '' );
						$terms =  array_filter(explode('$$$',$terms));
						
						echo !empty( $terms ) ? $terms[0].$markup : '';					
					}
				}
			return;
			}

			if(is_tax()){
				  $term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );
				  return esc_html__("Archive for Term: ",'multihost').$term->name;
			}

			if(is_category()){
				$category = get_the_category(); 
				$i = $category[0]->cat_ID;
				$parent = $category[0]-> category_parent;
				if($parent > 0 && $category[0]->cat_name == single_cat_title("", false)){
					echo get_category_parents($parent, TRUE, $markup, FALSE);
				}
			return esc_html__("Archive for Category: ",'multihost').single_cat_title('',FALSE);
			}

			if(is_author()){
				$curauth = get_user_by('slug',get_query_var('author_name')) ;
				return esc_html__("Archive for Author: ",'multihost').$curauth->nickname;
			}

			if(is_tag()){ return esc_html__("Archive for Tag: ",'multihost').single_tag_title('',FALSE); }

			if(is_404()){ return esc_html__("LOST",'multihost'); }

			if(is_search()){ return esc_html__("Search",'multihost'); }	

			if(is_year()){ return get_the_time('Y'); }

			if(is_month()){
				$k_year = get_the_time('Y');
				echo "<a href='".get_year_link($k_year)."'>".$k_year."</a>".$markup;
				return get_the_time('F'); 
			}

			if(is_day() || is_time()){ 
				$k_year = get_the_time('Y');
				$k_month = get_the_time('m');
				$k_month_display = get_the_time('F');
				echo "<a href='".get_year_link($k_year)."'>".$k_year."</a>".$markup;
				echo "<a href='".get_month_link($k_year, $k_month)."'>".$k_month_display."</a>".$markup;
			return get_the_time('jS (l)'); 
			}
			
			if(is_post_type_archive('product')){
				return esc_html__('Products','multihost');
			}
		}
	}
}
#END OF BREADCRUMB
####################################

if( !class_exists('dttheme_events_breadcrumb') ) {
	class dttheme_events_breadcrumb {

		function __construct() {
			global $post, $wp_query;

			$delimiter =  'fa '.dttheme_option('general', 'breadcrumb-delimiter');
			$this->options = array( 'before' => "<span class='${delimiter}' > ",'after' => ' </span>');
			$markup = $this->options['before'].$this->options['after'];

			echo '<div class="breadcrumb">
					<a href="'.esc_url( home_url('/') ).'">'.esc_html__('Home', 'multihost').'</a>';
					
			echo !empty( $markup ) ? $markup : '';
			echo '<a href="'.tribe_get_events_link().'">'.esc_html__('Events', 'multihost').'</a>';

			if( tribe_is_month() && !is_tax() ) {
				
				echo !empty( $markup ) ? $markup : '';
				echo '<span class="current">'.esc_html__('Events This Month', 'multihost').'</span>';
				
			} elseif( class_exists('TribeEventsPro') && tribe_is_week() ) {
				
				echo !empty( $markup ) ? $markup : '';
				echo '<span class="current">'.esc_html__('Events This Week', 'multihost').'</span>';
				
			} elseif( class_exists('TribeEventsPro') && tribe_is_day() ) {
				
				echo !empty( $markup ) ? $markup : '';
				echo '<span class="current">'.esc_html__('Events Today', 'multihost').'</span>';
				
			} elseif( class_exists('TribeEventsPro') && tribe_is_map() ) {
				
				echo !empty( $markup ) ? $markup : '';			
				echo '<span class="current">'.esc_html__('Upcoming Events', 'multihost').'</span>';
		
			} elseif( class_exists('TribeEventsPro') && tribe_is_photo() ) {
				
				echo !empty( $markup ) ? $markup : '';
				echo '<span class="current">'.esc_html__('Upcoming Events', 'multihost').'</span>';
		
			} elseif( tribe_is_list_view() ) {
				
				echo !empty( $markup ) ? $markup : '';
				echo '<span class="current">'.esc_html__('Upcoming Events', 'multihost').'</span>';
				
			} elseif (is_single()) {
				
				echo !empty( $markup ) ? $markup : '';
				
				$post_title = $wp_query->post->post_title;
				echo '<span class="current">'.$post_title.'</span>';
						
			} elseif( tribe_is_month() && is_tax() ) { 
			
				$term_slug = $wp_query->query_vars['tribe_events_cat'];
				$term = get_term_by('slug', $term_slug, 'tribe_events_cat');
				$name = $term->name;
			
				echo !empty( $markup ) ? $markup : '';
				echo '<span class="current">'.$name.'</span>';
		
			} elseif( is_tag() ) { 

				echo !empty( $markup ) ? $markup : '';
				echo '<span class="current">'.single_tag_title('',FALSE).'</span>';
				
			}
			echo "</div><!-- ** breadcrumb - End -->";			
		}
	}
}
#END OF EVENTS BREADCRUMB
####################################

#Event Titles
if( !function_exists('get_events_title') ) {
	function get_events_title() {
		global $wp_query;
		$title = '';
		$date_format = apply_filters( 'tribe_events_pro_page_title_date_format', 'l, F jS Y' );

		if( tribe_is_month() && !is_tax() ) {
			$title = sprintf( esc_html__( 'Events for %s', 'multihost' ), date_i18n( 'F Y', strtotime( tribe_get_month_view_date() ) ) );

		} elseif( class_exists('TribeEventsPro') && tribe_is_week() ) {
			$title = sprintf( esc_html__('Events for week of %s', 'multihost'), date_i18n( $date_format, strtotime( tribe_get_first_week_day($wp_query->get('start_date') ) ) ) );

		} elseif( class_exists('TribeEventsPro') && tribe_is_day() ) {
			$title = esc_html__( 'Events for', 'multihost' ) . ' ' . date_i18n( $date_format, strtotime( $wp_query->get('start_date') ) );

		} elseif( class_exists('TribeEventsPro') && (tribe_is_map() || tribe_is_photo()) ) {

			if( tribe_is_past() ) {
				$title = esc_html__( 'Past Events', 'multihost' );
			} else {
				$title = esc_html__( 'Upcoming Events', 'multihost' );
			}

		} elseif( tribe_is_list_view() ) {
			$title = esc_html__('Upcoming Events', 'multihost');
				
		} elseif (is_single()) {
			$title = $wp_query->post->post_title;

		} elseif( tribe_is_month() && is_tax() ) { 
			$term_slug = $wp_query->query_vars['tribe_events_cat'];
			$term = get_term_by('slug', $term_slug, 'tribe_events_cat');
			$name = $term->name;
			$title = $name;

		} elseif( is_tag() ) { 
			$name = esc_html__('Tag Archives','multihost');;
			$title = $name;
		}
		echo '<h1>'.$title.'</h1>';
	}
}

#MyTheme Color Picker
if( !function_exists('dttheme_color_picker') ) {
	function dttheme_color_picker(){

		$patterns_url = IAMD_FW_URL."theme_options/images/pattern/";
		$skins_url = IAMD_BASE_URL."images/style-picker/";
		
		$patterns = "";
		$patterns_array =  dttheme_listImage( get_template_directory()."/images/style-picker/patterns/");
		
		foreach($patterns_array as $k => $v){
			$img = 	IAMD_BASE_URL."images/style-picker/patterns/".$k;
			$patterns .= '<li>';
			$patterns .= "<a data-image='{$k}' href='#'>";
			$patterns .= "<img src='$img' alt='$v' title='$v' width='20' height='20' />";
			$patterns .= '</a>';
			$patterns .= '</li>'; 
		}
		
		$colors = "";
		$skins = getFolders(get_template_directory()."/skins");
		if( $skins ) {
			foreach( $skins as $skin ):
				$img = 	$skins_url.$skin.".jpg";
				$colors .= '<li>';
				$colors .= '<a id="'.$skin.'" href="#">';
				$colors .= '<img src="'.$img.'" alt="color-'.$skin.'" title="'.$skin.'"/>';
				$colors .= '</a>';
				$colors .= '</li>';
			endforeach;
		}
		
		echo '<!-- **DesignThemes Style Picker Wrapper** -->';
		echo '<div class="dt-style-picker-wrapper">';
		echo '	<a href="#" class="style-picker-ico"> <img class="rotating" src="'.IAMD_BASE_URL.'images/style-picker/picker-icon.png"/> </a>';
		echo '	<div id="dt-style-picker">';
		echo '   	<h2>'.esc_html__('Select Your Style','multihost').'</h2>';
		
		echo '       <h3>'.esc_html__('Choose your layout','multihost').'</h3>';
		echo '		<ul class="layout-picker">';
		echo '       	<li> <a id="fullwidth" href="#" class="selected"> <img src="'.IAMD_BASE_URL.'images/style-picker/fullwidth.jpg"/> </a> </li>';
		echo '       	<li> <a id="boxed" href="#"> <img src="'.IAMD_BASE_URL.'images/style-picker/boxed.jpg"/> </a> </li>';
		echo '		</ul>';
		echo '		<div class="dt-hr"> </div>';
		echo '		<div id="pattern-holder" style="display:none;">';
		echo'			<h3>'.esc_html__('Patterns for Boxed Layout','multihost').'</h3>';
		echo '			<ul class="pattern-picker">' . $patterns .'</ul>';
		echo '			<div class="dt-hr"> </div>';
		echo '		</div>';
		
		echo '		<h3>'.esc_html__('Color scheme','multihost').'</h3>';
		echo '		<ul class="color-picker">' . $colors .'</ul>';		
		
		echo '	</div>';
		echo '</div><!-- **DesignThemes Style Picker Wrapper - End** -->';	
	}
}

if( !function_exists('dt_wp_kses') ) {
	function dt_wp_kses( $arg ){
		
		$dt_allowed_html_tags = array(
			'a'          => array('class' => array(), 'href' => array(), 'title' => array(), 'target' => array()),
			'abbr'       => array('title' => array()),
			'address'    => array(),
			'area'       => array('shape' => array(), 'coords' => array(), 'href' => array(), 'alt' => array()),
			'article'    => array(),
			'aside'      => array(),
			'audio'      => array('autoplay' => array(), 'controls' => array(), 'loop' => array(), 'muted' => array(), 'preload' => array(), 'src' => array()),
			'b'          => array(),
			'base'       => array('href' => array(), 'target' => array()),
			'bdi'        => array(),
			'bdo'        => array('dir' => array()), 
			'blockquote' => array('cite' => array()), 
			'br'         => array(),
			'button'     => array('autofocus' => array(), 'disabled' => array(), 'form' => array(), 'formaction' => array(), 'formenctype' => array(), 'formmethod' => array(), 'formnovalidate' => array(), 'formtarget' => array(), 'name' => array(), 'type' => array(), 'value' => array()),
			'canvas'     => array('height' => array(), 'width' => array()),
			'caption'    => array('align' => array()),
			'cite'       => array(),
			'code'       => array(),
			'col'        => array(),
			'colgroup'   => array(),
			'datalist'   => array('id' => array()),
			'dd'         => array(),
			'del'        => array('cite' => array(), 'datetime' => array()),
			'details'    => array('open' => array()),
			'dfn'        => array(),
			'dialog'     => array('open' => array()),
			'div'        => array('class' => array(), 'id' => array(), 'align' => array()),
			'dl'         => array(),
			'dt'         => array(),
			'em'         => array(),
			'embed'      => array('height' => array(), 'src' => array(), 'type' => array(), 'width' => array()),
			'fieldset'   => array('disabled' => array(), 'form' => array(), 'name' => array()),
			'figcaption' => array(),
			'figure'     => array(),
			'form'       => array('accept' => array(), 'accept-charset' => array(), 'action' => array(), 'autocomplete' => array(), 'enctype' => array(), 'method' => array(), 'name' => array(), 'novalidate' => array(), 'target' => array(), 'id' => array(), 'class' => array()),
			'h1'         => array('class' => array()), 'h2' => array('class' => array()), 'h3' => array('class' => array()), 'h4' => array('class' => array()), 'h5' => array('class' => array()), 'h6' => array('class' => array()),
			'hr'         => array(), 
			'i'          => array('class' => array()), 
			'iframe'     => array('name' => array(), 'seamless' => array(), 'src' => array(), 'srcdoc' => array(), 'width' => array()),
			'img'        => array('alt' => array(), 'crossorigin' => array(), 'height' => array(), 'ismap' => array(), 'src' => array(), 'usemap' => array(), 'width' => array()),
			'input'      => array('align' => array(), 'alt' => array(), 'autocomplete' => array(), 'autofocus' => array(), 'checked' => array(), 'disabled' => array(), 'form' => array(), 'formaction' => array(), 'formenctype' => array(), 'formmethod' => array(), 'formnovalidate' => array(), 'formtarget' => array(), 'height' => array(), 'list' => array(), 'max' => array(), 'maxlength' => array(), 'min' => array(), 'multiple' => array(), 'name' => array(), 'pattern' => array(), 'placeholder' => array(), 'readonly' => array(), 'required' => array(), 'size' => array(), 'src' => array(), 'step' => array(), 'type' => array(), 'value' => array(), 'width' => array(), 'id' => array(), 'class' => array()),
			'ins'        => array('cite' => array(), 'datetime' => array()),
			'label'      => array('for' => array(), 'form' => array()),
			'legend'     => array('align' => array()), 
			'li'         => array('type' => array(), 'value' => array(), 'class' => array()),
			'link'       => array('crossorigin' => array(), 'href' => array(), 'hreflang' => array(), 'media' => array(), 'rel' => array(), 'sizes' => array(), 'type' => array()),
			'main'       => array(), 
			'map'        => array('name' => array()), 
			'mark'       => array(), 
			'menu'       => array('label' => array(), 'type' => array()),
			'menuitem'   => array('checked' => array(), 'command' => array(), 'default' => array(), 'disabled' => array(), 'icon' => array(), 'label' => array(), 'radiogroup' => array(), 'type' => array()),
			'meta'       => array('charset' => array(), 'content' => array(), 'http-equiv' => array(), 'name' => array()),
			'object'     => array('form' => array(), 'height' => array(), 'name' => array(), 'type' => array(), 'usemap' => array(), 'width' => array()),
			'ol'         => array('class' => array(), 'reversed' => array(), 'start' => array(), 'type' => array()),
			'p'          => array('class' => array()), 
			'q'          => array('cite' => array()), 
			'section'    => array(), 
			'select'     => array('autofocus' => array(), 'disabled' => array(), 'form' => array(), 'multiple' => array(), 'name' => array(), 'required' => array(), 'size' => array()),
			'small'      => array(), 
			'source'     => array('media' => array(), 'src' => array(), 'type' => array()),
			'span'       => array('class' => array()), 
			'strong'     => array(),
			'style'      => array('media' => array(), 'scoped' => array(), 'type' => array()),
			'sub'        => array(),
			'sup'        => array(),
			'table'      => array('sortable' => array()), 
			'tbody'      => array(), 
			'td'         => array('colspan' => array(), 'headers' => array()),
			'textarea'   => array('autofocus' => array(), 'cols' => array(), 'disabled' => array(), 'form' => array(), 'maxlength' => array(), 'name' => array(), 'placeholder' => array(), 'readonly' => array(), 'required' => array(), 'rows' => array(), 'wrap' => array()),
			'tfoot'      => array(),
			'th'         => array('abbr' => array(), 'colspan' => array(), 'headers' => array(), 'rowspan' => array(), 'scope' => array(), 'sorted' => array()),
			'thead'      => array(), 
			'time'       => array('datetime' => array()), 
			'title'      => array(), 
			'tr'         => array(), 
			'track'      => array('default' => array(), 'kind' => array(), 'label' => array(), 'src' => array(), 'srclang' => array()), 
			'u'          => array(), 
			'ul'         => array('class' => array()), 
			'var'        => array(), 
			'video'      => array('autoplay' => array(), 'controls' => array(), 'height' => array(), 'loop' => array(), 'muted' => array(), 'muted' => array(), 'poster' => array(), 'preload' => array(), 'src' => array(), 'width' => array()), 
			'wbr'        => array(), 
		);

		$data = wp_kses( $arg  , $dt_allowed_html_tags );
		return $data;
	}
}

/* ---------------------------------------------------------------------------
 * Getting privacy button action selection box
 * --------------------------------------------------------------------------- */
if ( ! function_exists( 'multihost_privacy_btnaction_selection' ) ) {
	function multihost_privacy_btnaction_selection($name = '', $selected = "") {
		$actions = array( '' => esc_html__('Dismiss the notification', 'multihost'), 'link' => esc_html__('Link to another page', 'multihost'), 'info_modal' => esc_html__('Open info modal on privacy and cookies', 'multihost') );
	
		$name = ! empty ( $name ) ? "name='mytheme[privacy-bar][{$name}][action]'" : '';
		$out = "<select class='button-select' {$name}>"; // name attribute will be added to this by jQuery menuAdd()
		foreach ( $actions as $key => $value ) :
			$s = selected ( $key, $selected, false );
			$v = $value;
			$out .= "<option value='{$key}' {$s} >{$v}</option>";
		endforeach;
		$out .= "</select>";
	
		return $out;
	}
}?>