<!-- general -->
<div id="general" class="bpanel-content">

    <!-- .bpanel-main-content -->
    <div class="bpanel-main-content">
        <ul class="sub-panel"> 
            <li><a href="#my-general"><?php esc_html_e("General",'multihost'); ?></a></li>
            <li><a href="#my-sociable"><?php esc_html_e("Sociable",'multihost'); ?></a></li>
            <li><a href="#my-bars"><?php esc_html_e('Bars','multihost'); ?></a></li>
        </ul>
        
        <!-- my-general-->
        <div id="my-general" class="tab-content">
            <!-- .bpanel-box -->
            <div class="bpanel-box">
                    <!-- Logo -->
                    <div class="box-title"><h3><?php esc_html_e('Logo','multihost'); ?></h3></div>
                    <div class="box-content">
                    
                    
                    	<div class="column three-fifth">
                            <div class="bpanel-option-set">
                                <?php $logo = array(
                                        'id'=>		'logo',
                                        'options'=>		array(
                                                            'true'	=> esc_html__('Custom Image Logo','multihost'),
                                                             ''=> 	esc_html__('Display Site Title','multihost').' <small><a href="'.esc_url('options-general.php').'">('.esc_html__('click here to edit site title','multihost').')</a></small>'
                                                            )
                                        );
										
										$i = 0;										
										foreach( $logo['options'] as $key => $option ):
											$checked = ( $key ==  dttheme_option('general',$logo['id']) ) ? ' checked="checked"' : '';
											echo '<label><input type="radio" name="mytheme[general]['.esc_attr($logo['id']).']" value="'.esc_attr($key).'" '.$checked.'/>'.$option.'</label>';
											if($i == 0):
												echo '<div class="clear"></div>';
											endif;
											$i++;
										endforeach;?>
                          </div><!-- .bpanel-option-set end-->
                      
                        </div>
                        
                        <div class="column two-fifth last">
                            <p class="note"><?php esc_html_e('You can choose whether you wish to display a custom logo or your site title.','multihost'); ?></p>
                        </div>  
                        
                        <div class="hr"> </div>

                        <h6><?php esc_html_e('Logo','multihost'); ?></h6>  
                        <div class="image-preview-container">
                            <input id="mytheme-logo" name="mytheme[general][logo-url]" type="text" class="uploadfield" readonly="readonly"
                                    value="<?php echo  dttheme_option('general','logo-url'); ?>" />
                            <input type="button" value="<?php esc_attr_e('Upload','multihost'); ?>" class="upload_image_button show_preview" />
                            <input type="button" value="<?php esc_attr_e('Remove','multihost'); ?>" class="upload_image_reset" />
                            <?php dttheme_adminpanel_image_preview(dttheme_option('general','logo-url'),false,'logo.png'); ?>
                        </div>
                        
                        <p class="note"> <?php esc_html_e('Upload a logo for your theme, or specify the image address of your online logo.','multihost'); ?> </p>

                        <div class="hr"></div>
                        <div class="clear"></div>
                        <h6><?php esc_html_e('Retina Logo','multihost'); ?></h6>
                        <div class="image-preview-container">
                          <input id="mytheme-retina-logo" type="text" name="mytheme[general][retina-logo-url]" class="uploadfield" readonly="readonly" 
                            value="<?php echo dttheme_option('general','retina-logo-url'); ?>"/>
                          <input type="button" value="<?php esc_attr_e('Upload','multihost'); ?>" class="upload_image_button show_preview" />
                          <input type="button" value="<?php esc_attr_e('Remove','multihost'); ?>" class="upload_image_reset" />
                          <?php dttheme_adminpanel_image_preview(dttheme_option('general','retina-logo-url'),false,'logo@2x.png'); ?>
                        </div>

                        <p class="note"><?php esc_html_e('Upload a retina logo for your theme, or specify the image address of your online logo.','multihost'); ?></p>
                        <div class="clear"></div>

                        <div class="one-half-content">
                        	<h6><?php esc_html_e('Width','multihost'); ?></h6>
                            <input type="text" class="medium" name="mytheme[general][retina-logo-width]" value="<?php echo dttheme_option('general','retina-logo-width'); ?>" />
							<?php esc_html_e('px','multihost'); ?>
                        </div>    

                        <div class="one-half-content last">
                        	<h6><?php esc_html_e('Height','multihost'); ?></h6>
                            <input type="text" class="medium" name="mytheme[general][retina-logo-height]" value="<?php echo dttheme_option('general','retina-logo-height'); ?>"/>
                            <?php esc_html_e('px','multihost'); ?>
                        </div>    
                        <p class="note"><?php esc_html_e('If retina logo is uploaded, enter the standard logo width and height in above respective boxes.','multihost'); ?></p>
                        <div class="clear"></div>
                    </div> <!-- Logo End -->

                    <!-- Favicon -->
                    <div class="box-title"><h3><?php esc_html_e('Favicon','multihost'); ?></h3></div>
                    <div class="box-content">
                    	<h6> <?php esc_html_e('Enable Favicon','multihost'); ?> </h6> 
                        
                        <div class="column one-fifth">
                        <?php $switchclass = ( "true" ==  dttheme_option('general','enable-favicon') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                            <div data-for="enable-favicon" class="checkbox-switch <?php echo esc_attr( $switchclass ); ?>"></div>
                            <input class="hidden" id="enable-favicon" name="mytheme[general][enable-favicon]" type="checkbox" value="true"
                            	<?php if( "true" == dttheme_option('general','enable-favicon') ):?> checked="checked"<?php endif;?> />
                        </div>
                        <div class="column four-fifth last"></div>

                        <div class="hr"></div>
                        <div class="clear"></div>
                        <h6><?php esc_html_e('Custom Favicon','multihost'); ?></h6>
                          <div class="image-preview-container">
                            <input id="mytheme-favicon" name="mytheme[general][favicon-url]" type="text" class="uploadfield" 
                                value="<?php echo  dttheme_option('general','favicon-url'); ?>" />
                            <input type="button" value="<?php esc_attr_e('Upload','multihost'); ?>" class="upload_image_button" />
                            <input type="button" value="<?php esc_attr_e('Remove','multihost'); ?>" class="upload_image_reset" />
                            <?php dttheme_adminpanel_image_preview(dttheme_option('general','favicon-url'),false,'favicon.png'); ?>
                          </div>
                          <p class="note"> <?php esc_html_e('Upload a favicon for your theme, or specify the oneline URL for favicon','multihost'); ?>  </p>

                        <div class="hr"></div>
                        <div class="clear"></div>
                        <h6><?php esc_html_e('Apple iPhone Icon','multihost'); ?></h6>
                        <div class="image-preview-container">
                          <input id="mytheme-apple-icon" name="mytheme[general][apple-favicon]" type="text" class="uploadfield"
                            value="<?php echo dttheme_option('general','apple-favicon'); ?>"/>
                            <input type="button" value="<?php esc_attr_e('Upload','multihost'); ?>" class="upload_image_button" />
                            <input type="button" value="<?php esc_attr_e('Remove','multihost'); ?>" class="upload_image_reset" />
                            <?php dttheme_adminpanel_image_preview(dttheme_option('general','apple-favicon'),false,'apple-touch-icon.png'); ?>
                        </div>
                        <p class="note"> <?php esc_html_e('Upload your custom iPhone icon (57px by 57px), or specify the oneline URL for favicon','multihost'); ?>  </p>

                        <div class="hr"></div>
                        <div class="clear"></div>
                        <h6><?php esc_html_e('Apple iPhone Retina Icon','multihost'); ?></h6>
                        <div class="image-preview-container">
                          <input id="mytheme-apple-icon" name="mytheme[general][apple-retina-favicon]" type="text" class="uploadfield"
                            value="<?php echo dttheme_option('general','apple-retina-favicon'); ?>"/>
                            <input type="button" value="<?php esc_attr_e('Upload','multihost'); ?>" class="upload_image_button" />
                            <input type="button" value="<?php esc_attr_e('Remove','multihost'); ?>" class="upload_image_reset" />
                            <?php dttheme_adminpanel_image_preview(dttheme_option('general','apple-retina-favicon'),false,'apple-touch-icon-114x114.png'); ?>
                        </div>
                        <p class="note"><?php esc_html_e('Upload your custom iPhone retina icon (114px by 114px), or specify the oneline URL for favicon','multihost'); ?></p>

                        <div class="hr"></div>
                        <div class="clear"></div>
                        <h6><?php esc_html_e('Apple iPad Icon','multihost'); ?></h6>
                        <div class="image-preview-container">
                          <input id="mytheme-apple-icon" name="mytheme[general][apple-ipad-favicon]" type="text" class="uploadfield"
                            value="<?php echo dttheme_option('general','apple-ipad-favicon'); ?>"/>
                            <input type="button" value="<?php esc_attr_e('Upload','multihost'); ?>" class="upload_image_button" />
                            <input type="button" value="<?php esc_attr_e('Remove','multihost'); ?>" class="upload_image_reset" />
                            <?php dttheme_adminpanel_image_preview(dttheme_option('general','apple-ipad-favicon'),false,'apple-touch-icon-72x72.png'); ?>
                        </div>
                        <p class="note"> <?php esc_html_e('Upload your custom iPad icon (72px by 72px), or specify the oneline URL for favicon','multihost'); ?>  </p>

                        <div class="hr"></div>
                        <div class="clear"></div>
                        <h6><?php esc_html_e('Apple iPad Retina Icon','multihost'); ?></h6>
                        <div class="image-preview-container">
                          <input id="mytheme-apple-icon" name="mytheme[general][apple-ipad-retina-favicon]" type="text" class="uploadfield"
                            value="<?php echo dttheme_option('general','apple-ipad-retina-favicon'); ?>"/>
                            <input type="button" value="<?php esc_attr_e('Upload','multihost'); ?>" class="upload_image_button" />
                            <input type="button" value="<?php esc_attr_e('Remove','multihost'); ?>" class="upload_image_reset" />
                            <?php dttheme_adminpanel_image_preview(dttheme_option('general','apple-ipad-retina-favicon'),false,'apple-touch-icon-114x114.png'); ?>
                        </div>
                        <p class="note"><?php esc_html_e('Upload your custom iPad retina icon (144px by 144px), or specify the oneline URL for favicon','multihost'); ?></p>
                    </div> <!-- Favicon End -->

                    <!-- Others -->
                    <div class="box-title"><h3><?php esc_html_e('Others', 'multihost'); ?></h3></div>
                    <div class="box-content">
                    
                      <h6><?php esc_html_e('Page loader','multihost'); ?></h6>
                      <div class="column one-fifth">
                      	<?php $checked = ( "true" ==  dttheme_option('general','loading-bar') ) ? ' checked="checked"' : ''; ?>
                        <?php $switchclass = ( "true" ==  dttheme_option('general','loading-bar') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                        <div data-for="mytheme-page-loader" class="checkbox-switch <?php echo esc_attr( $switchclass ); ?>"></div>
                        <input class="hidden" id="mytheme-page-loader" name="mytheme[general][loading-bar]" type="checkbox" value="true"
                        	<?php if( "true" == dttheme_option('general','loading-bar') ):?> checked="checked"<?php endif;?>/>                      
                      </div>
                      <div class="column four-fifth last">
                      	<p class="note"><?php esc_html_e('YES! to disable page loader.','multihost'); ?> </p>
                      </div>                      
                      <div class="clear"></div>
                      <div class="hr"></div>
                      
                    
                      <h6> <?php esc_html_e('Enable Sticky Navigation','multihost'); ?></h6>
                        <div class="column one-fifth">
                            <?php $checked = ( "true" ==  dttheme_option('general','enable-sticky-nav') ) ? ' checked="checked"' : ''; ?>
                            <?php $switchclass = ( "true" ==  dttheme_option('general','enable-sticky-nav') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                            <div data-for="mytheme-enable-sticky-nav" class="checkbox-switch <?php echo esc_attr( $switchclass ); ?>"></div>
                                <input class="hidden" id="mytheme-enable-sticky-nav" name="mytheme[general][enable-sticky-nav]" type="checkbox" value="true"
                                	<?php if( "true" == dttheme_option('general','enable-sticky-nav') ):?> checked="checked"<?php endif;?>/>
                        </div>
                        <div class="column four-fifth last">
                            <p class="note"><?php esc_html_e('YES! to enable sticky navigation.','multihost'); ?> </p>
                        </div>
                        
                        <div class="clear"> </div>
                        <div class="hr"></div>


                      <h6> <?php esc_html_e('Enable Sticky Navigation For Mobile','multihost'); ?></h6>
                        <div class="column one-fifth">
                            <?php $switchclass = ( "true" ==  dttheme_option('general','enable-mobile-sticky-nav') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                            <div data-for="mytheme-enable-mobile-sticky-nav" class="checkbox-switch <?php echo esc_attr($switchclass); ?>"></div>
                                <input class="hidden" id="mytheme-enable-mobile-sticky-nav" name="mytheme[general][enable-mobile-sticky-nav]" type="checkbox" value="true"
                                	<?php if( "true" == dttheme_option('general','enable-mobile-sticky-nav') ):?> checked="checked"<?php endif;?>/>
                        </div>
                        
                        <div class="column four-fifth last">
                            <p class="note"><?php esc_html_e('YES! to enable sticky navigation in mobile.','multihost'); ?> </p>
                        </div>
                        
                        <div class="clear"> </div>
                        <div class="hr"></div>

                        <h6> <?php esc_html_e('Globally Disable Comments on Pages','multihost'); ?> </h6>
                        <div class="column one-fifth">
                            <?php $switchclass = ( "true" ==  dttheme_option('general','disable-page-comment') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                            <div data-for="mytheme-global-page-comment" class="checkbox-switch <?php echo esc_attr( $switchclass ); ?>"></div>
                            <input class="hidden" id="mytheme-global-page-comment" name="mytheme[general][disable-page-comment]" type="checkbox" value="true"
                            	<?php if( "true" == dttheme_option('general','disable-page-comment') ):?> checked="checked"<?php endif;?>/>
                        </div>
                        <div class="column four-fifth last">
                      	 <p class="note no-margin"><?php 
							esc_html_e('YES! to disable comments on all the pages. This will globally override your "Allow comments" option under your page "Discussion" settings. ','multihost'); ?> </p>
                        </div>
                      <div class="hr"></div>
                      
                        <h6><?php esc_html_e('Globally Disable Comments on Posts','multihost'); ?></h6>
                        <div class="column one-fifth">
                            <?php $switchclass = ( "true" ==  dttheme_option('general','global-post-comment') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                            <div data-for="mytheme-global-post-comment" class="checkbox-switch <?php echo esc_attr( $switchclass ); ?>"></div>
                            <input class="hidden" id="mytheme-global-post-comment" name="mytheme[general][global-post-comment]" type="checkbox" value="true"
                            	<?php if( "true" == dttheme_option('general','global-post-comment') ):?> checked="checked"<?php endif;?> />
                        </div>
                        <div class="column four-fifth last">
                            <p class="note no-margin"><?php esc_html_e('YES! to disable comments on all the posts. This will globally override your "Allow comments" option under your post "Discussion" settings. ','multihost'); ?> </p>
                        </div>
                        <div class="hr"></div>

                      <!-- Breadcrumb -->
                      <h6><?php esc_html_e('Breadcrumb Delimiter','multihost'); ?></h6>
                      <select id="mytheme-breadcrumb-delimiter" name="mytheme[general][breadcrumb-delimiter]"><?php 
                        $breadcrumb_icons = array('fa-angle-double-right','fa-sort','fa-caret-square-o-left', 'fa-caret-square-o-right', 'fa-angle-right','fa-caret-right','fa-double-angle-right','fa-arrow-right','fa-chevron-right',
                            'fa-hand-right','fa-plus','fa-remove', 'fa-exchange');
                            foreach($breadcrumb_icons as $breadcrumb_icon):
                                $s = selected(dttheme_option('general','breadcrumb-delimiter'),$breadcrumb_icon,false);
                                echo "<option ".$s.'>'.$breadcrumb_icon."</option>";
                            endforeach;?></select>
                            <p class="note"><?php esc_html_e('This is the symbol that will appear in between your breadcrumbs','multihost'); ?></p>
                      <div class="hr"></div>
                      <!-- Breadcrumb -->
                      
                        <!-- Browser Scroll -->
                        <h6><?php esc_html_e('Disable browser custom scroll','multihost'); ?></h6>
                        <div class="column one-fifth">
                            <?php $switchclass = ( "on" ==  dttheme_option('general','disable-custom-scroll') ) ? 'checkbox-switch-on' :'checkbox-switch-off';?>
                            <div data-for="mytheme-browesr-scroll-disable" class="checkbox-switch <?php echo esc_attr( $switchclass ); ?>"></div>
                            <input class="hidden" id="mytheme-browesr-scroll-disable" name="mytheme[general][disable-custom-scroll]" type="checkbox"<?php checked(dttheme_option('general','disable-custom-scroll'),'on'); ?>/>
                        </div>

                        <div class="column four-fifth last">
                            <p class="note"><?php esc_html_e('Check if you do not want disable the browser custom scrollbar :)','multihost'); ?> </p>
                        </div>
                        <div class="hr"></div>
                        <!-- Browser Scroll -->

                        <!-- Picker -->
                        <h6><?php esc_html_e('Disable Style Picker','multihost'); ?></h6>
                        <div class="column one-fifth">
                            <?php $switchclass = ( "on" ==  dttheme_option('general','disable-picker') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                            <div data-for="mytheme-global-disable-picker" class="checkbox-switch <?php echo esc_attr( $switchclass ); ?>"></div>
                            <input class="hidden" id="mytheme-global-disable-picker" name="mytheme[general][disable-picker]" type="checkbox" <?php checked(dttheme_option('general','disable-picker'),'on'); ?>/>
                        </div>
                        <div class="column four-fifth last">
                            <p class="note"><?php esc_html_e('YES! to hide the front end style picker','multihost'); ?> </p>
                        </div>
                        <div class="hr"></div>
                        <!-- Picker End -->

                        <h6><?php esc_html_e('Disable import dummy content','multihost'); ?></h6>
                        <div class="column one-fifth">
                            <?php $switchclass = ( "on" ==  dttheme_option('general','disable-import') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                            <div data-for="mytheme-global-import-disable" class="checkbox-switch <?php echo esc_attr( $switchclass ); ?>"></div>
                                <input class="hidden" id="mytheme-global-import-disable" name="mytheme[general][disable-import]" type="checkbox"  <?php checked(dttheme_option('general','disable-import'),'on'); ?>/>
                        </div>
                        <div class="column four-fifth last">
                            <p class="note"><?php esc_html_e('YES! to hide Import Dummy Data button from the Adminpanel','multihost'); ?> </p>
                        </div>
                        <div class="hr"></div>

                        <h6><?php esc_html_e('Google Font Subset','multihost'); ?></h6>
                        <div class="column one-half">
                            <input id="mytheme-google-font-subset" name="mytheme[general][google-font-subset]" type="text" value="<?php echo dttheme_option('general','google-font-subset'); ?>"/>
                        </div>
                        <div class="column one-half last">
                            <p class="note no-margin"><?php esc_html_e('Specify which subsets should be downloaded. Multiple subsets should be separated with coma','multihost'); ?></p>
                        </div>

                        <div class="clear"> </div>
                        <div class="hr-invisible-small"> </div>
                        <p class="note"><?php esc_html_e('Some of the fonts in the Google Font Directory supports multiple scripts (like Latin and Cyrillic for example). In order to specify which subsets should be downloaded the subset parameter should be appended to the URL. For a complete list of available fonts and font subsets please see','multihost'); 
							echo " <a href='http://www.google.com/webfonts'>Google Web Fonts</a>";?> </p>
                        <div class="hr"></div>
                        <div class="clear"> </div>

                        <h6><?php esc_html_e('Mailchimp API KEY','multihost'); ?></h6>
                        <div class="column one-half">
                            <input id="mytheme-mailchimp-key" name="mytheme[general][mailchimp-key]" type="text" value="<?php echo dttheme_option('general','mailchimp-key'); ?>" />
                        </div>
                        <div class="column one-half last">
                            <p class="note no-margin"><?php esc_html_e('Paste your mailchimp api key that will be used by the mailchimp widget.','multihost'); ?></p>
                        </div>
                        <div class="hr"></div>

                      <h6><?php esc_html_e('Google Map API KEY', 'lms');?></h6>
                      <div class="column one-half">
                      	<input name="mytheme[general][googlemap-api-key]" type="text" value="<?php echo dttheme_option('general','googlemap-api-key'); ?>" />
                      </div>
                      
                      <div class="column one-half last">
                      	<p class="note no-margin"><?php esc_html_e('Paste your google map api key here.', 'lms'); ?></p>
                      </div>
                      <div class="hr"></div>
                      <div class="clear"> </div>

                        <h6><?php esc_html_e('Twitter API Settings', 'multihost'); ?></h6>

                        <h6><?php esc_html_e('Consumer Key','multihost'); ?></h6>
                        <div class="column one-half">
                            <input name="mytheme[general][bottombar-twitter-key]" type="text" value="<?php echo dttheme_option('general','bottombar-twitter-key'); ?>"/>
                        </div>
                        <div class="column one-half last">
                            <p class="note no-margin"><?php esc_html_e('Specify Twitter consumer key','multihost'); ?></p>
                        </div>

                        <h6><?php esc_html_e('Consumer Secret','multihost'); ?></h6>
                        <div class="column one-half">
                            <input name="mytheme[general][bottombar-twitter-secret]" type="text" value="<?php echo dttheme_option('general','bottombar-twitter-secret'); ?>"/>
                        </div>
                        <div class="column one-half last">
                            <p class="note no-margin"><?php esc_html_e('Specify Twitter consumer secret','multihost'); ?></p>
                        </div>

                        <h6><?php esc_html_e('Access Token','multihost'); ?></h6>
                        <div class="column one-half">
                            <input name="mytheme[general][bottombar-twitter-token]" type="text" value="<?php echo dttheme_option('general','bottombar-twitter-token'); ?>"/>
                        </div>
                        <div class="column one-half last">
                            <p class="note no-margin"><?php esc_html_e('Specify Twitter access token','multihost'); ?></p>
                        </div>
                        <h6><?php esc_html_e('Access Secret','multihost'); ?></h6>
                        <div class="column one-half">
                            <input name="mytheme[general][bottombar-twitter-token-secret]" type="text" value="<?php echo dttheme_option('general','bottombar-twitter-token-secret'); ?>"/>
                        </div>
                        <div class="column one-half last">
                            <p class="note no-margin"><?php esc_html_e('Specify Twitter access secret','multihost'); ?></p>
                        </div>
                    </div>                                            
            </div><!-- .bpanel-box end-->
        </div><!--my-general end-->

        <!-- my-sociable-->
        <div id="my-sociable" class="tab-content">
            <!-- .bpanel-box -->
            <div class="bpanel-box">
            
                <div class="box-title">
                	<h3><?php esc_html_e('Sociable','multihost'); ?></h3>
                </div><!-- .box-title -->

                <div class="box-content">
                    <div class="bpanel-option-set">
                         <h6><?php esc_html_e('Show Sociable','multihost'); ?></h6>
                         
                         <div class="column one-fifth">
							 <?php $switchclass = ( "on" ==  dttheme_option('general','show-sociables') ) ? 'checkbox-switch-on' :'checkbox-switch-off'; ?>
                             <div data-for="mytheme-show-sociables" class="checkbox-switch <?php echo esc_attr( $switchclass ); ?>"></div>
                             <input class="hidden" id="mytheme-show-sociables" name="mytheme[general][show-sociables]" type="checkbox" 
                             <?php checked(dttheme_option('general','show-sociables'),'on'); ?>/>
                         </div>
                         
                         <input type="button" value="<?php esc_attr_e('Add New Sociable','multihost'); ?>" class="black mytheme_add_item" />
                         
                         <div class="column four-fifth last">
                             <p class="note"> <?php esc_html_e('Manage Social Network icons list to display','multihost'); ?> </p>
                         </div>
                         
                         <div class="hr_invisible"></div>
                    </div>
                    
                    <div class="bpanel-option-set">
                        <ul class="menu-to-edit"><?php
                            $socials = dttheme_option('social');
                            if(is_array($socials)) :
                                $keys = array_keys($socials);
                                $i = 0;

                                foreach ( $socials as $s ):?>
                                    <li id="<?php echo esc_html( $keys[$i] ); ?>">
                                        <div class="item-bar">
                                            <span class="item-title"><?php $n = $s['icon']; $n = substr($n, 3); $n = ucwords($n); echo esc_html( $n ); ?></span>
                                            <span class="item-control"><a class="item-edit"><?php esc_html_e('Edit','multihost'); ?></a></span>
                                        </div>

                                        <div class="item-content" style="display: none;">
                                            <span><label><?php esc_html_e('Sociable Icon','multihost'); ?></label>
                                            <?php dttheme_sociables_selection( $keys[$i],$s['icon'] ); ?></span>

                                            <span><label><?php esc_html_e('Sociable Link','multihost'); ?></label>
                                                <input type="text" class="social-link" name="mytheme[social][<?php echo esc_attr( $keys[$i] ); ?>][link]" 
                                                	value="<?php echo esc_attr( $s['link'] ); ?>"/>
                                            </span>

                                            <div class="remove-cancel-links">
                                                <span class="remove-item"><?php esc_html_e('Remove','multihost'); ?></span>
                                                <span class="meta-sep"> | </span>
                                                <span class="cancel-item"><?php esc_html_e('Cancel','multihost'); ?></span>
                                            </div>
                                        </div>
                                    </li><?php
                                    $i++;
                                endforeach;
                            endif;?></ul>
                        
                        <ul class="sample-to-edit" style="display:none;">
                        	<!-- Social Item -->
                            <li>
                            	<!-- .item-bar -->
                            	<div class="item-bar">
                                	<span class="item-title"><?php esc_html_e('Sociable','multihost'); ?></span>
                                    <span class="item-control"><a class="item-edit"><?php esc_html_e('Edit','multihost'); ?></a></span>
                                </div><!-- .item-bar -->
                                <!-- .item-content -->
                                <div class="item-content">                                
                                	<span><label><?php esc_html_e('Sociable Icon','multihost'); ?></label><?php dttheme_sociables_selection(); ?></span>
                                    <span><label><?php esc_html_e('Sociable Link','multihost'); ?></label><input type="text" class="social-link" /></span>
                                    <div class="remove-cancel-links">
                                        <span class="remove-item"><?php esc_html_e('Remove','multihost'); ?></span>
                                        <span class="meta-sep"> | </span>
                                        <span class="cancel-item"><?php esc_html_e('Cancel','multihost'); ?></span>
                                    </div>
                                </div><!-- .item-content end -->
                            </li><!-- Social Item End-->
                        </ul>
                        
                    </div>
                </div> <!-- .box-content -->    
                
                
            </div><!-- .bpanel-box end -->
        </div><!--my-sociable end-->

        <!-- my-bars-->
        <div id="my-bars" class="tab-content">

            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('Top Bar', 'multihost'); ?></h3>
                </div>
                <div class="box-content">

                    <h6><?php esc_html_e('Phone Number Text','multihost'); ?></h6>
                    <div class="column one-half">
                        <input name="mytheme[general][topbar-phoneno-text]" type="text" value="<?php echo dttheme_option('general','topbar-phoneno-text'); ?>"/>
                    </div>
                    <div class="column one-half last">
                        <p class="note no-margin"><?php esc_html_e('Specify label for phone number which is shown at top of header','multihost'); ?></p>
                    </div>

                    <div class="clear"></div>

                    <h6><?php esc_html_e('Phone Number','multihost'); ?></h6>
                    <div class="column one-half">
                        <input name="mytheme[general][topbar-phoneno]" type="text" value="<?php echo dttheme_option('general','topbar-phoneno'); ?>"/>
                    </div>
                    <div class="column one-half last">
                        <p class="note no-margin"><?php esc_html_e('Specify phone number which is shown at top of header','multihost'); ?></p>
                    </div>

                    <div class="hr"></div>
                    <div class="clear"></div>

                    <h6><?php esc_html_e('Email id Text','multihost'); ?></h6>
                    <div class="column one-half">
                        <input name="mytheme[general][topbar-emailid-text]" type="text" value="<?php echo dttheme_option('general','topbar-emailid-text'); ?>"/>
                    </div>

                    <div class="column one-half last">
                        <p class="note no-margin"><?php esc_html_e('Specify label for email which is shown at top of header','multihost'); ?></p>
                    </div>

                    <h6><?php esc_html_e('Email id','multihost'); ?></h6>
                    <div class="column one-half">
                        <input name="mytheme[general][topbar-emailid]" type="text" value="<?php echo dttheme_option('general','topbar-emailid'); ?>"/>
                    </div>

                    <div class="column one-half last">
                        <p class="note no-margin"><?php esc_html_e('Specify email which is shown at top of header','multihost'); ?></p>
                    </div>
                </div>
            </div>

            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e('Bottom Bar', 'multihost'); ?></h3>
                </div>
                <div class="box-content">

                    <h6><?php esc_html_e('Default Bottom bar module','multihost'); ?></h6>
                    <div class="column one-half">
                        <select vlass="mytheme-select" name="mytheme[general][default-bottombar-module]"><?php
                            $selected = dttheme_option('general','default-bottombar-module');
                            $modules = array("none" => esc_html__('None','multihost') , "twitter" => esc_html__('Twitter Module','multihost') , 'text'=>esc_html__('Simple Text Module','multihost'));
                            foreach ($modules as $key => $value) {
                                 $rs = selected ( $key, $selected, false );
                                  echo "<option value='".esc_attr($key)."' ".$rs.">".esc_html($value)."</option>";
                            }?>    
                        </select>
                    </div>
                    <div class="column one-half last">
                        <p class="note no-margin"><?php esc_html_e('How many tweets want to show?','multihost'); ?></p>
                    </div>

                    <div class="hr"></div>
                    <div class="clear"></div>

                    <h6><?php esc_html_e('Twitter User name ','multihost'); ?></h6>
                    <div class="column one-half">
                        <input name="mytheme[general][bottombar-twitter]" type="text" value="<?php echo dttheme_option('general','bottombar-twitter'); ?>"/>
                    </div>
                    <div class="column one-half last">
                        <p class="note no-margin"><?php esc_html_e('Specify Twitter username from which you want to show the tweets at the top bar of your footer section','multihost'); ?></p>
                    </div>

                    <h6><?php esc_html_e('Tweets Count ','multihost'); ?></h6>
                    <div class="column one-half">
                        <select vlass="mytheme-select" name="mytheme[general][bottombar-tweets]"><?php
                            $selected = dttheme_option('general','bottombar-tweets');
                            for( $i = 1; $i<=10; $i++ ):
                                $rs = selected ( $i, $selected, false );
                                echo "<option value='".esc_attr($i)."' ".$rs.">".esc_html($i)."</option>";
                            endfor;?>    
                        </select>
                    </div>
                    <div class="column one-half last">
                        <p class="note no-margin"><?php esc_html_e('How many tweets want to show?','multihost'); ?></p>
                    </div>

                    <div class="hr"></div>
                    <div class="clear"></div>

                    <h6><?php esc_html_e('Bottom Bar Text','multihost'); ?></h6>
                    <textarea id="mytheme-bottombar-text" name="mytheme[general][bottombar-text]"
                            rows="" cols=""><?php echo htmlspecialchars (stripslashes(dttheme_option('general','bottombar-text'))); ?></textarea>
                    <p class="note"> <?php esc_html_e('You can paste any text in this box. This will be automatically shown at the top bar of your footer section.','multihost'); ?> </p>
                </div>
            </div>
        </div><!-- my-bars-->
   </div><!-- .bpanel-main-content end-->
</div><!-- general end -->