<!-- integration -->
<div id="integration" class="bpanel-content">
	<!-- .bpanel-main-content -->
    <div class="bpanel-main-content">
        <ul class="sub-panel">   
            <li><a href="#integration-general"><?php esc_html_e("General",'multihost'); ?></a></li>
            <li><a href="#integration-post"><?php esc_html_e("Post",'multihost'); ?></a></li>
            <li><a href="#integration-page"><?php esc_html_e("Page",'multihost'); ?></a></li>
            <li><a href="#integration-portfolio"><?php esc_html_e("Portfolio",'multihost'); ?></a></li>
        </ul>
	    
        <!-- integration-general-->    
        <div id="integration-general">
        	<?php $integration_general = array( 
					array(
						"title"=>		esc_html__('Add Code Inside the head tag','multihost'),
						"tooltip"=>		esc_html__('Any code you place here will appear in the head section of every page of your site. This code wrapped between scripts tags.','multihost'),
						"textarea"=>	"header-code",
						"checkbox"=>	"enable-header-code",
						"label"=>		esc_html__('Enable Header Code','multihost')
					),
					array(
						"title"=>		esc_html__('Add Code above closing body tag;','multihost'),
						"tooltip"=>		esc_html__('You can paste your Google Analytics or other website tracking codes in this box. This code wrapped between scripts tags.','multihost'), 
						"textarea"=>	"body-code",
						"checkbox"=>	"enable-body-code",
						"label"=>		esc_html__('Enable Body Code','multihost')
					),
					array(
						"title"=> 	    esc_html__('Custom CSS','multihost'),
						"tooltip"=>		esc_html__('Paste your custom CSS code here.','multihost'), 
						"textarea"=>	"custom-css",
						"checkbox"=>	"enable-custom-css",
						"label"=>		esc_html__('Enable Custom CSS','multihost')
						
                    ),
                    array(
                        "title"=>       esc_html__('Tracking Code','multihost'),
                        "tooltip"=>     esc_html__('"Enter your Google tracking id (UA-XXXXX-X) here. If you want to offer your visitors the option to stop being tracked you can place the shortcode [dt_sc_privacy_google_tracking] somewhere on your site.','multihost'),
                        "textarea"=>    "tracking-code",
                        "checkbox"=>    "enable-tracking-code",
                        "label"=>       esc_html__('Enable Tracking Code','multihost')
                        
                    )
			);
			
			foreach($integration_general as $i_general): ?>
                <!-- .bpanel-box-->
                <div class="bpanel-box">
                	<div class="box-title"><h3><?php echo esc_html( $i_general['title'] ); ?></h3></div>
                    <!-- .box-content -->
                	<div class="box-content">
                    	 <h6><?php echo esc_html( $i_general['label'] ); ?></h6>
                         <div class="column one-fifth">
							 <?php $switchclass = (dttheme_option('integration',$i_general['checkbox'])<>'') ? 'checkbox-switch-on' :'checkbox-switch-off';?>
                             <div data-for="<?php echo esc_attr( $i_general['checkbox'] ); ?>" class="checkbox-switch <?php echo esc_attr( $switchclass ); ?>"></div>
                             <input id="<?php echo esc_attr( $i_general['checkbox'] ); ?>" class="hidden" type="checkbox" 
                             	name="mytheme[integration][<?php echo esc_attr( $i_general['checkbox'] ); ?>]" 
                                value="<?php echo esc_attr( $i_general['checkbox'] ); ?>" <?php checked($i_general['checkbox'],dttheme_option('integration',$i_general['checkbox'])); ?> />                         </div>

                        <div class="column four-fifth last">
                            <p class="note no-margin"><?php echo esc_html( $i_general['tooltip'] ); ?></p>
                        </div>  
                             
                         <div class="clear"></div>
	                     <div class="hr_invisible"></div>
                         <div class="hr_invisible"></div>
                         <textarea id="mytheme[integration][<?php echo esc_attr( $i_general['textarea'] ); ?>]" 
                         	name="mytheme[integration][<?php echo esc_attr( $i_general['textarea'] ); ?>]"><?php echo stripslashes(dttheme_option('integration',$i_general['textarea'])); ?></textarea>
                    </div><!-- .box-content end-->

                </div><!-- .bpanel-box end-->
	  <?php endforeach;?>
        </div><!-- integration-general end-->

        <!-- integration-post-->
        <div id="integration-post">
        <?php $integration_post = array(
					array(
						"title"=>		esc_html__('Add code to the top of your posts','multihost'),
						"tooltip"=>		esc_html__('Place any codes to show on top of all single post. This is useful if you are looking to integrate things such as social bookmarking links, AD etc.,.','multihost'),
						"textarea"=>	"single-post-top-code", 
						"checkbox"=>	"enable-single-post-top-code",
						"label"=>		esc_html__('Enable single post top code','multihost')
					),
					array(
						"title"=>		esc_html__('Add code to the bottom of your posts, before the comments','multihost'),
						"tooltip"=>		esc_html__('Place any codes to show on bottom of all single post. This is useful if you are looking to integrate things such as social bookmarking links, AD etc.,.','multihost'),
						"textarea"=>	"single-post-bottom-code",
						"checkbox"=>	"enable-single-post-bottom-code",
						"label"=>		esc_html__('Enable single post bottom code','multihost')
					));
				foreach($integration_post as $i_post): ?>
                	<!-- .bpanel-box-->
                    <div class="bpanel-box">
                    	<div class="box-title"><h3><?php echo esc_html( $i_post['title'] ); ?></h3></div>
                        
                        <!-- .box-content -->
                        <div class="box-content">
                        	<h6><?php echo esc_html( $i_post['label'] ); ?></h6>
                            <div class="column one-fifth">
	                   	    	<?php $switchclass = (dttheme_option('integration',$i_post['checkbox'])<>'') ? 'checkbox-switch-on' :'checkbox-switch-off';?>
								<div data-for="<?php echo esc_attr( $i_post['checkbox'] ); ?>" class="checkbox-switch <?php echo esc_attr( $switchclass ); ?>"></div>
        	                    <input id="<?php echo esc_attr( $i_post['checkbox'] ); ?>" class="hidden" type="checkbox" 
                                	name="mytheme[integration][<?php echo esc_attr( $i_post['checkbox'] ); ?>]"
                                    value="<?php echo esc_attr( $i_post['checkbox'] ); ?>" <?php checked($i_post['checkbox'],dttheme_option('integration',$i_post['checkbox'])); ?>/>
                             </div>

                            <div class="column four-fifth last">
                                <p class="note no-margin"><?php echo esc_html( $i_post['tooltip'] ); ?></p>
                            </div>  
                            
                            <div class="clear"></div>
                            <div class="hr_invisible"></div>
                            <div class="hr_invisible"></div>
                    	<textarea id="mytheme[integration][<?php echo esc_attr( $i_post['textarea'] ); ?>]"  name="mytheme[integration][<?php echo esc_attr( $i_post['textarea'] ); ?>]"><?php echo stripslashes(dttheme_option('integration',$i_post['textarea'])); ?></textarea>
                    	</div><!-- .box-content end-->
                </div><!-- .bpanel-box end-->
        <?php	endforeach;?>        

            <!-- Socialshare Module -->
            <!-- .bpanel-box-->
            <div class="bpanel-box">
            
                <div class="box-title">
                    <h3><?php esc_html_e("Social Shares",'multihost'); ?></h3>
                </div>
                
                <div class="box-content">
                 <p class="note no-margin"><?php esc_html_e("Manage social share options and its layout to show in the blog post.",'multihost'); ?></p>
                 
                 <div class="hr_invisible"> </div>
                 
                <?php global $dttheme_social_bookmarks;
                    $count = 1;
                    foreach($dttheme_social_bookmarks as $social_bookmark):
                        $last = ($count%2 == 0)?"last":'';?>
                        <div class="one-half-content <?php echo "{$last}";?>">
                        <div class="bpanel-option-set">                        
                         <label><?php echo esc_html( $social_bookmark["label"] ); ?></label>
                            <?php $switchclass = (dttheme_option('integration',"post-".$social_bookmark['id'])<>'') ? 'checkbox-switch-on' :'checkbox-switch-off';?>
                            <div data-for="<?php echo "post-".$social_bookmark['id'];?>" class="checkbox-switch <?php echo esc_attr( $switchclass ); ?>"></div>
                            
                            <input id="post-<?php echo esc_attr( $social_bookmark['id'] ); ?>" type="checkbox" name="mytheme[integration][<?php echo "post-".$social_bookmark['id'];?>]" 
                            value="<?php echo esc_attr( $social_bookmark['id'] ); ?>" <?php checked($social_bookmark['id'],dttheme_option('integration',"post-".$social_bookmark['id'])); ?>
                            class="hidden"/>
                            <div class="hr_invisible"></div>
                            <?php if(array_key_exists("username",$social_bookmark)):?>
                                <div class="clear"></div>
                                <?php esc_html_e("Username",'multihost'); ?>
                                <div class="clear"></div>
                                <input type="text" class="medium" name="mytheme[integration][<?php echo "post-".$social_bookmark['id']."-username";?>]"
                                     value="<?php echo dttheme_option('integration',"post-".$social_bookmark['id']."-username"); ?>" />
                                <br/><br/>
                            <?php endif;?>
                            
                            
                            <?php if( array_key_exists("options",$social_bookmark)):?>
                                <div class="clear"></div>
                                <?php esc_html_e("Layout",'multihost'); ?>
                                <select name="mytheme[integration][<?php echo "post-".$social_bookmark['id']."-layout";?>]">
                                <?php 	foreach($social_bookmark['options'] as $key => $value):?>
                                			<option value="<?php echo esc_attr( $key ); ?>"
												<?php echo ( selected($key,dttheme_option('integration',"post-".$social_bookmark['id']."-layout"),false) ); ?>>
												<?php echo esc_attr( $value ); ?></option>
                                <?php	endforeach;?>
                                </select>                                
                            <?php endif;?>
    
                            <?php if(array_key_exists("color-scheme",$social_bookmark)): ?>
                                <div class="hr_invisible"></div><br/>
                                <?php esc_html_e("Color Scheme",'multihost'); ?>
                                <select name="mytheme[integration][<?php echo "post-".$social_bookmark['id']."-color-scheme";?>]">
                                    <?php foreach($social_bookmark['color-scheme'] as $options):?>
                                            <option value="<?php echo esc_attr( $options ); ?>" 
												<?php echo (selected($options,dttheme_option('integration',"post-".$social_bookmark['id']."-color-scheme"),false)); ?>>
												<?php echo esc_attr( $options ); ?></option>
                                    <?php endforeach;?>
                                </select>
                            <?php endif;?>
    
                            <?php if(array_key_exists('lang',$social_bookmark)):?>
                                <div class="hr_invisible"></div><br/>
                                <?php esc_html_e("Language",'multihost'); ?>
                                    <select name="mytheme[integration][<?php echo "post-".$social_bookmark['id']."-lang";?>]">
                                    <?php foreach($social_bookmark['lang'] as $key => $value):?>
                                        <option value="<?php echo esc_attr( $key ); ?>"
                                        <?php echo ( selected($key,dttheme_option('integration',"post-".$social_bookmark['id']."-lang"),false) ); ?>>
											<?php echo esc_attr( $value ); ?></option>
                                    <?php endforeach;?>
                                    </select>
                            <?php endif;?>
    
                            <?php if(array_key_exists("text",$social_bookmark)):?>
                                <div class="clear"></div>
                                <?php esc_html_e("Default Text",'multihost'); ?>
                                <div class="clear"></div>
                                <input type="text" class="medium" name="mytheme[integration][<?php echo "post-".$social_bookmark['id']."-text";?>]"
                                     value="<?php echo dttheme_option('integration',"post-".$social_bookmark['id']."-text"); ?>" />
                                <br/><br/>
                            <?php endif;?>
                            <div class="hr"></div>
                         </div><!-- bpanel-option-set-->
                    </div><!-- .one-half-content-->
                  <?php $count++;
                      endforeach;?>
                </div><!--.box-content end-->
            </div><!-- .bpanel-box end -->    
            <!-- Socialshare Module -->
            
            <!-- Social Bookmark module -->
            <!-- .bpanel-box-->
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e("Social Bookmark",'multihost'); ?></h3>
                </div>
                <div class="box-content">
	                <p class="note no-margin"><?php esc_html_e("Manage social media bookmark options and its layout to show in the blog post",'multihost'); ?></p>
                	<?php global $dttheme_social_bookmarks;
					  $count = 1;
						foreach($dttheme_social_bookmarks as $social_bookmark):
                            $last = ($count%2 == 0)?"last":'';?>
                        <div class="one-half-content <?php echo "{$last}";?>">
                            <div class="bpanel-option-set">
                             <label><?php echo esc_html( $social_bookmark["label"] ); ?></label>
                                <?php $switchclass = (dttheme_option('integration',"sb-post-".$social_bookmark['id'])<>'') ? 'checkbox-switch-on' :'checkbox-switch-off';?>
                                <div data-for="<?php echo "sb-post-".$social_bookmark['id'];?>" class="checkbox-switch <?php echo esc_attr( $switchclass ); ?>"></div>
                                <input id="<?php echo "sb-post-".$social_bookmark['id'];?>" type="checkbox" 
                                	name="mytheme[integration][<?php echo "sb-post-".$social_bookmark['id'];?>]" value="<?php echo esc_attr( $social_bookmark['id'] ); ?>" 
									<?php checked($social_bookmark['id'],dttheme_option('integration',"sb-post-".$social_bookmark['id'])); ?>
                                class="hidden"/>
                            </div>
                        </div>
                <?php  $count++;
						 endforeach;?>  
                </div>
            </div><!-- Social Bookmark module end-->            
        
        </div><!-- integration-post end-->

        <div id="integration-page">
        	<?php $integration_page = array( 
					array(
						"title"=>		esc_html__('Add code to the top of your pages','multihost'),
						"tooltip"=>		esc_html__('Place any codes to show on top of all single page. This is useful if you are looking to integrate things such as social bookmarking links, AD etc.,.','multihost'),
						"textarea"=>	"single-page-top-code",
						"checkbox"=>	"enable-single-page-top-code",
						"label"=>		esc_html__('Enable single page top code','multihost')
					),
					array(
						"title"=>		esc_html__('Add code to the bottom of your pages, before the comments','multihost'),
						"tooltip"=>		esc_html__('Place any codes to show on bottom of all single page. This is useful if you are looking to integrate things such as social bookmarking links, AD etc.,.','multihost'),
						"textarea"=>	"single-page-bottom-code",
						"checkbox"=>	"enable-single-page-bottom-code",
						"label"=>		esc_html__('Enable single page bottom code','multihost')
					)
				);
			foreach($integration_page as $i_page): ?>
                <!-- .bpanel-box-->
                <div class="bpanel-box">
                	<div class="box-title"><h3><?php echo esc_html( $i_page['title'] ); ?></h3></div>
                    
                    <!-- .box-content -->
                	<div class="box-content">
                    	<h6><?php echo esc_html( $i_page['label'] ); ?></h6>
                        <div class="column one-fifth">
                   	    <?php $switchclass = (dttheme_option('integration',$i_page['checkbox'])<>'') ? 'checkbox-switch-on' :'checkbox-switch-off';?>
						<div data-for="<?php echo esc_attr( $i_page['checkbox'] ); ?>" class="checkbox-switch <?php echo esc_attr( $switchclass ); ?>"></div>
                        	<input id="<?php echo esc_attr( $i_page['checkbox'] ); ?>" class="hidden" type="checkbox" 
                            	name="mytheme[integration][<?php echo esc_attr( $i_page['checkbox'] ); ?>]" 
                                value="<?php echo esc_attr( $i_page['checkbox'] ); ?>" <?php checked($i_page['checkbox'],dttheme_option('integration',$i_page['checkbox'])); ?>/>
                        </div>
                        
                        <div class="column four-fifth last"><p class="note no-margin"><?php echo esc_html( $i_page['tooltip'] ); ?></p></div>  
                        
	                    <div class="clear"></div>
                        <div class="hr_invisible"></div>
                        <div class="hr_invisible"></div>
                    	<textarea id="mytheme[integration][<?php echo esc_attr($i_page['textarea']); ?>]" 
                        name="mytheme[integration][<?php echo esc_attr($i_page['textarea']); ?>]"><?php echo stripslashes(dttheme_option('integration',$i_page['textarea'])); ?></textarea>
                    </div><!-- .box-content end-->
                </div><!-- .bpanel-box end-->
	  <?php endforeach;?>
      
            <!-- Socialshare Module -->
            <!-- .bpanel-box-->
            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php esc_html_e("Social Shares",'multihost'); ?></h3>
                </div>
                
                <div class="box-content">
                
                 <p class="note no-margin"><?php esc_html_e("Manage social share options and its layout to show in the page.",'multihost'); ?></p>
                 
                 <div class="hr_invisible"> </div>
                 
                <?php global $dttheme_social_bookmarks;
                    $count = 1;
                    foreach($dttheme_social_bookmarks as $social_bookmark):
                        $last = ($count%2 == 0)?"last":'';?>
                        <div class="one-half-content <?php echo "{$last}";?>">
                        <div class="bpanel-option-set">                        
                         <label><?php echo esc_html( $social_bookmark["label"] ); ?></label>
                            <?php $switchclass = (dttheme_option('integration',"page-".$social_bookmark['id'])<>'') ? 'checkbox-switch-on' :'checkbox-switch-off';?>
                            <div data-for="<?php echo "page-".$social_bookmark['id'];?>" class="checkbox-switch <?php echo esc_attr( $switchclass ); ?>"></div>
                            
                            <input id="page-<?php echo esc_attr( $social_bookmark['id'] ); ?>" type="checkbox" name="mytheme[integration][<?php echo "page-".$social_bookmark['id'];?>]" 
                            value="<?php echo esc_attr( $social_bookmark['id'] ); ?>" <?php checked($social_bookmark['id'],dttheme_option('integration',"page-".$social_bookmark['id'])); ?>
                            class="hidden"/>
                            <div class="hr_invisible"></div>
                            <?php if(array_key_exists("username",$social_bookmark)):?>
                                <div class="clear"></div>
                                <?php esc_html_e("Username",'multihost'); ?>
                                <div class="clear"></div>
                                <input type="text" class="medium" name="mytheme[integration][<?php echo "page-".$social_bookmark['id']."-username";?>]"
                                     value="<?php echo dttheme_option('integration',"page-".$social_bookmark['id']."-username"); ?>" />
                                <br/><br/>
                            <?php endif;?>
                            
                            
                            <?php if( array_key_exists("options",$social_bookmark)):?>
                                <div class="clear"></div>
                                <?php esc_html_e("Layout",'multihost'); ?>
                                <select name="mytheme[integration][<?php echo "page-".$social_bookmark['id']."-layout";?>]">
                                <?php 	foreach($social_bookmark['options'] as $key => $value):?>
                                            <option value="<?php echo esc_attr( $key ); ?>" 
												<?php echo ( selected($key,dttheme_option('integration',"page-".$social_bookmark['id']."-layout"),false) ); ?>>
													<?php echo esc_attr( $value ); ?></option>
                                <?php	endforeach;?>
                                </select>                                
                            <?php endif;?>
    
                            <?php if(array_key_exists("color-scheme",$social_bookmark)): ?>
                                <div class="hr_invisible"></div><br/>
                                <?php esc_html_e("Color Scheme",'multihost'); ?>
                                <select name="mytheme[integration][<?php echo "page-".$social_bookmark['id']."-color-scheme";?>]">
                                    <?php foreach($social_bookmark['color-scheme'] as $options):?>
                                            <option value="<?php echo esc_attr( $options ); ?>" 
												<?php echo (selected($options,dttheme_option('integration',"page-".$social_bookmark['id']."-color-scheme"),false)); ?>>
													<?php echo esc_attr( $options ); ?></option>
                                    <?php endforeach;?>
                                </select>
                            <?php endif;?>
    
                            <?php if(array_key_exists('lang',$social_bookmark)):?>
                                <div class="hr_invisible"></div><br/>
                                <?php esc_html_e("Language",'multihost'); ?>
                                    <select name="mytheme[integration][<?php echo "page-".$social_bookmark['id']."-lang";?>]">
                                    <?php foreach($social_bookmark['lang'] as $key => $value):?>
                                        <option value="<?php echo esc_attr( $key ); ?>"
                                        	<?php echo ( selected($key,dttheme_option('integration',"page-".$social_bookmark['id']."-lang"),false) ); ?>>
												<?php echo esc_attr( $value ); ?></option>
                                    <?php endforeach;?>
                                    </select>
                            <?php endif;?>
    
                            <?php if(array_key_exists("text",$social_bookmark)):?>
                                <div class="clear"></div>
                                <?php esc_html_e("Default Text",'multihost'); ?>
                                <div class="clear"></div>
                                <input type="text" class="medium" name="mytheme[integration][<?php echo "page-".$social_bookmark['id']."-text";?>]"
                                     value="<?php echo dttheme_option('integration',"page-".$social_bookmark['id']."-text"); ?>" />
                                <br/><br/>
                            <?php endif;?>
                            <div class="hr"></div>
                         </div><!-- bpanel-option-set-->
                    </div><!-- .one-half-content-->
                  <?php $count++;
                      endforeach;?>
                </div><!--.box-content end-->
            </div><!-- .bpanel-box end -->    
            <!-- Socialshare Module -->
    
            <!-- Social Bookmark module -->
            <!-- .bpanel-box-->
            <div class="bpanel-box">
               <div class="box-title"><h3><?php esc_html_e("Social Bookmark",'multihost'); ?></h3></div>
               <div class="box-content">
               	<p class="note no-margin"><?php esc_html_e("Manage social media bookmark options and its layout to show in the page.",'multihost'); ?></p>
               <?php global $dttheme_social_bookmarks;
                      $count = 1;
                      foreach($dttheme_social_bookmarks as $social_bookmark):
                        $last = ($count%2 == 0)?"last":'';    ?>
                        <div class="one-half-content <?php echo "{$last}";?>">
                            <div class="bpanel-option-set">
                                <label><?php echo esc_html( $social_bookmark["label"] ); ?></label>
                                <?php $switchclass = (dttheme_option('integration',"sb-page-".$social_bookmark['id'])<>'') ? 'checkbox-switch-on' :'checkbox-switch-off';?>
                                 <div data-for="sb-page-<?php echo esc_attr( $social_bookmark['id'] ); ?>" class="checkbox-switch <?php echo esc_attr( $switchclass ); ?>"></div>
                                 <input id="sb-page-<?php echo esc_attr( $social_bookmark['id'] ); ?>" type="checkbox" value="<?php echo esc_attr( $social_bookmark['id'] ); ?>" 
                                    name="mytheme[integration][sb-page-<?php echo esc_attr( $social_bookmark['id'] ); ?>]" 
                                    <?php checked($social_bookmark['id'],dttheme_option('integration',"sb-page-".$social_bookmark['id'])); ?>
                                    class="hidden"/>
                                </div>
                            </div>
                    <?php  $count++;
                             endforeach;?>  
                </div>
            </div><!-- Social Bookmark module end-->
        </div><!-- integration-page end-->
        
        
        <div id="integration-portfolio">
            <!-- Social Bookmark module -->
            <!-- .bpanel-box-->
            <div class="bpanel-box">
               <div class="box-title">
                   <h3><?php esc_html_e("Social Bookmark",'multihost'); ?></h3>
               </div>
               <div class="box-content">
               <p class="note no-margin"><?php esc_html_e("Manage social media bookmark options and its layout to show in the portfolio.",'multihost'); ?></p>
               <?php global $dttheme_social_bookmarks;
                      $count = 1;
                      foreach($dttheme_social_bookmarks as $social_bookmark):
                        $last = ($count%2 == 0)?"last":'';?>
                        <div class="one-half-content <?php echo "{$last}";?>">
                            <div class="bpanel-option-set">
                                <label><?php echo esc_html( $social_bookmark["label"] ); ?></label>
                                <?php $switchclass = (dttheme_option('integration',"sb-portfolio-".$social_bookmark['id'])<>'') ? 'checkbox-switch-on' :'checkbox-switch-off';?>
                                 <div data-for="sb-portfolio-<?php echo esc_attr( $social_bookmark['id'] ); ?>" class="checkbox-switch <?php echo esc_attr( $switchclass ); ?>"></div>
                                 <input id="sb-portfolio-<?php echo esc_attr( $social_bookmark['id'] ); ?>" type="checkbox"  value="<?php echo esc_attr( $social_bookmark['id'] ); ?>" 
                                    name="mytheme[integration][sb-portfolio-<?php echo esc_attr($social_bookmark['id']); ?>]" 
                                    <?php checked($social_bookmark['id'],dttheme_option('integration',"sb-portfolio-".$social_bookmark['id'])); ?>
                                    class="hidden"/>
                                </div>
                            </div>
                    <?php  $count++;
                             endforeach;?>  
                </div>
            </div><!-- Social Bookmark module end-->
        </div>
        
   </div><!-- .bpanel-main-content end-->
</div><!-- integration end-->