<!-- specialty-pages -->
<div id="specialty-pages" class="bpanel-content">
    <!-- .bpanel-main-content -->
    <div class="bpanel-main-content">
        <ul class="sub-panel"><?php
            $sub_menus = array(
                array("title"=>esc_html__("Global",'multihost'), "link"=>"#global"),
                array("title"=>esc_html__("Author",'multihost'), "link"=>"#author-archives"),
                array("title"=>esc_html__("Category",'multihost'), "link"=>"#category-archives"),
                array("title"=>esc_html__("Tag",'multihost'), "link"=>"#tag-archives"),
                array("title"=>esc_html__("Portfolio",'multihost'), "link"=>"#gallery-archives"),
                array("title"=>esc_html__("Search",'multihost'), "link"=>"#search"),
                array("title"=>esc_html__("404",'multihost'), "link"=>"#404"));

                foreach($sub_menus as $menu): ?>
                    <li><a href="<?php echo esc_attr( $menu['link'] ); ?>"><?php echo esc_html( $menu['title'] ); ?></a></li><?php
                endforeach?>
        </ul>

        <div id="global" class="tab-content">

            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php echo esc_html__('Page Layout','multihost'); ?></h3>
                </div>
                <div class="box-content">
                    <h6><?php esc_html_e('Force to Enable Global Page Layout','multihost'); ?></h6>
                    <?php dttheme_switch("",'specialty','force-enable-global-page-layout'); ?>

                    <div class="clear"> </div>
                    <div class="hr"> </div>
                    <p class="note"><?php esc_html_e("You can choose between a left, right or no sidebar layout globally for all pages.",'multihost'); ?></p>
                    <div class="bpanel-post-layout bpanel-option-set">
                        <ul class="bpanel-layout-set"><?php
                            $layout = array( 'content-full-width'=>'without-sidebar',
                                'with-left-sidebar'=>'left-sidebar',
                                'with-right-sidebar'=>'right-sidebar'
                            );
                            foreach($layout as $key => $value):
                                $class = ( $key ==  dttheme_option('specialty',"global-page-layout")) ? " class='selected' " : "";
                                echo "<li><a href='#' rel='{$key}' {$class}><img src='".IAMD_FW_URL."theme_options/images/columns/{$value}.png' /></a></li>";
                            endforeach;?>
                        </ul>
                        <input id="mytheme[specialty][global-page-layout]" name="mytheme[specialty][global-page-layout]" type="hidden"
                            value="<?php echo dttheme_option('specialty','global-page-layout'); ?>"/>
                    </div>                    
                </div>
            </div>

            <div class="bpanel-box">
                <div class="box-title">
                    <h3><?php echo esc_html__('Post Layout','multihost'); ?></h3>
                </div>
                <div class="box-content">
                    <h6><?php esc_html_e('Force to Enable Global Post Layout','multihost'); ?></h6>
                    <?php dttheme_switch("",'specialty','force-enable-global-post-layout'); ?>

                    <div class="clear"> </div>
                    <div class="hr"> </div>
                    <p class="note"><?php esc_html_e("You can choose between a left, right or no sidebar layout globally for all posts.",'multihost'); ?></p>
                    <div class="bpanel-post-layout bpanel-option-set">
                        <ul class="bpanel-layout-set"><?php
                            $layout = array( 'content-full-width'=>'without-sidebar',
                                'with-left-sidebar'=>'left-sidebar',
                                'with-right-sidebar'=>'right-sidebar'
                            );
                            foreach($layout as $key => $value):
                                $class = ( $key ==  dttheme_option('specialty',"global-post-layout")) ? " class='selected' " : "";
                                echo "<li><a href='#' rel='{$key}' {$class}><img src='".IAMD_FW_URL."theme_options/images/columns/{$value}.png' /></a></li>";
                            endforeach;?>
                        </ul>
                        <input id="mytheme[specialty][global-post-layout]" name="mytheme[specialty][global-post-layout]" type="hidden"
                            value="<?php echo dttheme_option('specialty','global-post-layout'); ?>"/>
                    </div>                
                </div>
            </div>
        </div><?php
        $posts_layout_array =   array(
            'one-column'=> esc_html__("Single post per row.",'multihost'),
            'one-half-column'=> esc_html__("Two posts per row.",'multihost'),
            'one-third-column' => esc_html__("Three posts per row",'multihost'),
            'post-thumb' => esc_html__("Thumb view of posts",'multihost')
        );

        $tabs = array(

                array(  "id"=>"author-archives", 
                        "layout-title"=>esc_html__("Post's Author Archive Page Layout",'multihost'),
                        "layout-tooltip"=>esc_html__("You can choose between a left, right, both or no sidebar layout for the Author Archive page.",'multihost'),
                        "post-layout-title" => esc_html__("Posts Layout",'multihost'),
                        "post-layout-tooltip"=>esc_html__("Your author archive results will use the layout you select below.",'multihost'),                                
                        "post-layouts" => $posts_layout_array
                 ),

	 			array(	"id"=>"category-archives", 
						"layout-title"=>esc_html__("Post's Category Archive Page Layout",'multihost'),
						"layout-tooltip"=>esc_html__("You can choose between a left, right, both or no sidebar layout for the Category Archive page.",'multihost'),
						"post-layout-title" => esc_html__("Posts Layout",'multihost'),
						"post-layout-tooltip"=>esc_html__("Your category archive results will use the layout you select below.",'multihost'),								
                        "post-layouts" => $posts_layout_array
				 ),

                array(  "id"=>"tag-archives", 
                        "layout-title"=>esc_html__("Post's Tag Archive Page Layout",'multihost'),
                        "layout-tooltip"=>esc_html__("You can choose between a left, right, both or no sidebar layout for the Tag Archive page.",'multihost'),
                        "post-layout-title" => esc_html__("Posts Layout",'multihost'),
                        "post-layout-tooltip"=>esc_html__("Your tag archive results will use the layout you select below.",'multihost'),
                        "post-layouts" => $posts_layout_array                                
                 ),

                array(  "id"=>"gallery-archives", 
                        "layout-title"=>esc_html__("Portfolio Custom Post's Category Archive Page Layout",'multihost'),
                        "layout-tooltip"=>esc_html__("You can choose between a left, right, both or no sidebar layout for the Portfolio custom post's category Archive page.",'multihost'),
                        "post-layout-title" => esc_html__("Posts Layout",'multihost'),
                        "post-layout-tooltip"=>esc_html__("Your category archive results will use the layout you select below.",'multihost'),                                
                        "post-layouts" => array(
                            'one-third-column'=>esc_html__("Three portfolio items per row.",'multihost'),                                   
                            'one-fourth-column' => esc_html__("Three portfolio items per row.",'multihost'))
                ),

				array(  "id"=>"search",
						"layout-title"=>esc_html__("Search Layout",'multihost'),
						"layout-tooltip"=>esc_html__("You can choose between a left, right or no sidebar layout for your Search page.",'multihost'),
						"post-layout-title" => esc_html__("Posts Layout",'multihost'),
						"post-layout-tooltip"=>esc_html__("Your Search results will use the layout you select below.",'multihost'),
                        "post-layouts" => $posts_layout_array
				),

				array(  "id"=>"404",
						"layout-title"=>esc_html__("404 Layout",'multihost'),
						"layout-tooltip"=>esc_html__("You can choose between a left, right or no sidebar layout for your 404 page.",'multihost'),
						
						"bg-title"=>esc_html__("404 Background",'multihost'),
						"bg-label"=>esc_html__("404 background image",'multihost'),
						"bg-tooltip"=>esc_html__('Upload an image for the theme\'s 404 page background','multihost'),

						"content-title" => esc_html__("404 Message",'multihost'),
						"content-tooltip"=>esc_html__("You can give custom 404 page message",'multihost')
				)); ?>
        <?php foreach($tabs as $tab): 
				$id =  $tab['id'];?>
        	<div id="<?php echo esc_attr( $id ); ?>" class="tab-content">
            	 <div class="bpanel-box">
                 
                 	<!-- Section 1 -->	
                    <div class="box-title"><h3><?php echo esc_html( $tab['layout-title'] ); ?></h3></div>
                    <div class="box-content">
                    	<p class="note"> <?php echo esc_html($tab['layout-tooltip']); ?></p>

                    	<div class="bpanel-option-set">
                        	<ul id="<?php echo 'dt-'.$id;?>" class="bpanel-post-layout bpanel-layout-set">
                           	<?php $layout = array(	'content-full-width'=>'without-sidebar', 'with-left-sidebar'=>'left-sidebar', 'with-right-sidebar'=>'right-sidebar');
							foreach($layout as $key => $value):
								$class = ( $key ==  dttheme_option('specialty',"{$id}-layout")) ? " class='selected' " : "";
								echo "<li><a href='#' rel='{$key}' {$class}><img src='".IAMD_FW_URL."theme_options/images/columns/{$value}.png' /></a></li>";
							endforeach; ?>
                            </ul>
                            <input id="mytheme[specialty][<?php echo esc_attr($id); ?>-layout]" name="mytheme[specialty][<?php echo esc_attr($id); ?>-layout]" type="hidden"  
                            	value="<?php echo dttheme_option('specialty',"{$id}-layout"); ?>"/>
                        </div><?php 
                            $sb_layout = dttheme_option('specialty',"{$id}-layout");
                            $sidebar = '';
                            if($sb_layout == 'content-full-width') {
                                $sidebar = 'display:none;'; 
                            }?>
                        <div id="bpanel-widget-area-options" class="dt-<?php esc_attr($id); ?>" style=" <?php echo esc_attr($sidebar); ?>">
                            
                            <div id="left-sidebar-container" class="bpanel-page-left-sidebar" style=" <?php echo esc_attr($sidebar); ?>">
                                <!-- 2. Every Where Sidebar Left Start -->
                                <div id="page-commom-sidebar" class="bpanel-sidebar-section custom-box">
                                    <h6><?php esc_html_e('Disable Standard Sidebar','multihost'); ?></label></h6>
                                    <?php dttheme_switch("",'specialty','disable-standard-sidebar-for-'.$id); ?>
                                </div><!-- Every Where Sidebar Left End-->
                            </div>
                        </div>
                    </div><!-- Section 1 End -->

                    <?php if( $id != "404" ): ?>
                    <!-- Post Layout Section -->
	                <div class="box-title"><h3><?php echo esc_html( $tab['post-layout-title'] ); ?></h3></div>
                    <div class="box-content">
                    	<p class="note"><?php echo esc_html( $tab['post-layout-tooltip'] ); ?></p>
                    	<div class="bpanel-option-set">
                        	<ul class="bpanel-post-layout bpanel-layout-set">
                            <?php $posts_layout = $tab['post-layouts'];
									$v = dttheme_option('specialty',"{$id}-post-layout");
									$v = !empty($v) ? $v : "one-column";
								  foreach($posts_layout as $key => $value):
									$class = ( $key ==  $v ) ? " class='selected' " :"";								  
									echo "<li><a href='#' rel='{$key}' {$class} title='{$value}'><img src='".IAMD_FW_URL."theme_options/images/columns/{$key}.png' /></a></li>";
                           		 endforeach;?>
                    		</ul>
                            <input id="mytheme[specialty][<?php echo esc_attr($id); ?>-post-layout]" name="mytheme[specialty][<?php echo esc_attr($id); ?>-post-layout]" type="hidden"  
                            	value="<?php echo dttheme_option('specialty',"{$id}-post-layout"); ?>"/>
                        </div>
                    </div>
                    <!-- Post Layout Section End-->
                    <?php endif; ?>                   

                   
                    <!-- 404 Content -->
                    <?php if($id == "404"): ?>
                        <div class="box-title"><h3><?php echo esc_html( $tab['content-title'] ); ?></h3></div>
                        <div class="box-content">
                        	<p class="note"><?php echo esc_html($tab['content-tooltip']); ?></p>
                            
                            
                            <div class="bpanel-option-set">
                                <h6><?php esc_html_e('404 Custom Message','multihost'); ?></h6>
                                <textarea id="mytheme-404-text" name="mytheme[specialty][404-message]" rows="" 
                                	cols=""><?php echo stripslashes(dttheme_option('specialty','404-message')); ?></textarea>
                            </div>
                            <div class="hr"></div>
                            
                            <h6><?php esc_html_e("Disable Font Settings",'multihost'); ?></h6>
                            <div class="column one-fifth bpanel-option-set">
                            	<?php dttheme_switch("",'specialty','disable-404-font-settings'); ?>
                            </div>
                            <div class="column four-fifth last"><p class="note"><?php esc_html_e('Enable / Disable 404 Font settings','multihost'); ?></p></div>
                            <div class="hr"></div>
                        
                        	<!-- Font Section -->                        	
                            <div class="column one-column">
                                <div class="bpanel-option-set">
                                    <?php dttheme_admin_fonts(esc_html__('Message Font','multihost'),'mytheme[specialty][message-font]',dttheme_option('specialty','message-font')); ?>
                                </div>
                            </div>
                            <!-- Font Section -->
                            <div class="hr_invisible"> </div>
                            <!-- Font Color Section -->
                            <div class="column one-half">
        	                    <?php $label = 		esc_html__("Message Font Color",'multihost');
									  $name  =		"mytheme[specialty][message-font-color]";	
									  $value =  	 (dttheme_option('specialty','message-font-color')!= NULL) ? dttheme_option('specialty','message-font-color') : "#";
									  $tooltip = 	esc_html__("Pick a custom color for 404 message font color of the theme e.g. #a314a3",'multihost'); ?>
									  <h6> <?php echo esc_html( $label ); ?> </h6>
                                  <?php dttheme_admin_color_picker("",$name,$value,''); ?>
                            
                            </div><!-- Font Color Section -->
                            <div class="column one-half last">
								<?php dttheme_admin_jqueryuislider(esc_html__('Message Font Size','multihost'),"mytheme[specialty][message-font-size]",
    	                        dttheme_option('specialty',"message-font-size")); ?>
                            </div>
                            
                        </div>
                    <?php endif;?>
                    <!-- 404 Content End-->

                 </div><!-- .bpanel-box end -->
            </div><!-- .tab-content end -->
        <?php endforeach;?>
    </div>
</div><!-- specialty-pages end-->