<?php

$group = 'Addtional Options';
vc_map( array(
	'base'          => 'penci_media_carousel',
	'icon'          => get_template_directory_uri() . '/images/vc-icon.png',
	'category'      => penci_get_theme_name( 'Soledad' ),
	'html_template' => get_template_directory() . '/inc/js_composer/shortcodes/media_carousel/frontend.php',
	'weight'        => 700,
	'as_parent'     => array( 'except' => 'penci_media_carousel' ),
	'name'          => penci_get_theme_name( 'Penci' ) . ' ' . esc_html__( 'Advanced Carousel', 'soledad' ),
	'description'   => __( 'Media Advanced Block', 'soledad' ),
	'controls'      => 'full',
	'params'        => array(
		array(
			'type'             => 'penci_only_number',
			'heading'          => esc_html__( 'Gap', 'penci-framework' ),
			'param_name'       => 'slides_item_gap',
			'class'            => '',
			'value'            => 10,
			'min'              => 1,
			'max'              => 100,
			'step'             => 1,
			'edit_field_class' => 'vc_col-sm-3',
		),
		array(
			'type'             => 'penci_only_number',
			'heading'          => esc_html__( 'Items display on Desktop', 'penci-framework' ),
			'param_name'       => 'limit_desk',
			'class'            => '',
			'value'            => 3,
			'min'              => 1,
			'max'              => 25,
			'step'             => 1,
			'edit_field_class' => 'vc_col-sm-3',
		),
		array(
			'type'             => 'penci_only_number',
			'heading'          => esc_html__( 'Items display on Tablet', 'penci-framework' ),
			'param_name'       => 'limit_tab',
			'class'            => '',
			'value'            => 2,
			'min'              => 1,
			'max'              => 25,
			'step'             => 1,
			'edit_field_class' => 'vc_col-sm-3',
		),
		array(
			'type'             => 'penci_only_number',
			'heading'          => esc_html__( 'Items display on Mobile', 'penci-framework' ),
			'param_name'       => 'limit_mobile',
			'class'            => '',
			'value'            => 1,
			'min'              => 1,
			'max'              => 25,
			'step'             => 1,
			'edit_field_class' => 'vc_col-sm-3',
		),
		// Slider
		array(
			'type'       => 'penci_switch',
			'heading'    => esc_html__( 'Autoplay', 'soledad' ),
			'param_name' => 'autoplay',
			'value'      => array( esc_html__( 'Yes', 'soledad' ) => 'yes' ),
			'std'        => 'no',
			'group'      => $group,
		),
		array(
			'type'       => 'penci_switch',
			'heading'    => esc_html__( 'Slider Loop', 'soledad' ),
			'param_name' => 'loop',
			'value'      => array( esc_html__( 'Yes', 'soledad' ) => 'yes' ),
			'std'        => 'no',
			'group'      => $group,
		),
		array(
			'type'       => 'textfield',
			'param_name' => 'auto_time',
			'heading'    => esc_html__( 'Slider Auto Time (at x seconds)', 'soledad' ),
			'value'      => 4000,
			'group'      => $group,
		),
		array(
			'type'       => 'textfield',
			'param_name' => 'speed',
			'heading'    => esc_html__( 'Slider Speed (at x seconds)', 'soledad' ),
			'value'      => 800,
			'group'      => $group,
		),
		array(
			'type'       => 'penci_switch',
			'heading'    => esc_html__( 'Show next/prev buttons', 'soledad' ),
			'param_name' => 'shownav',
			'value'      => array( esc_html__( 'Yes', 'soledad' ) => 'yes' ),
			'std'        => 'no',
			'group'      => $group,
		),
		array(
			'type'       => 'penci_switch',
			'heading'    => esc_html__( 'Show dots navigation', 'soledad' ),
			'param_name' => 'showdots',
			'value'      => 'no',
			'group'      => $group,
		)
	),
	'js_view'       => 'VcColumnView'
) );
