<?php
$group_color = 'Typo & Color';
vc_map( array(
	'base'          => 'penci_product',
	'icon'          => get_template_directory_uri() . '/images/vc-icon.png',
	'category'      => penci_get_theme_name( 'Soledad' ),
	'html_template' => get_template_directory() . '/inc/js_composer/shortcodes/product/frontend.php',
	'weight'        => 700,
	'name'          => penci_get_theme_name( 'Penci' ) . ' ' . esc_html__( 'Product', 'soledad' ),
	'description'   => __( 'Show the latest product', 'soledad' ),
	'controls'      => 'full',
	'params'        => array_merge( array(
		array(
			'type'             => 'dropdown',
			'heading'          => __( 'Date Source', 'soledad' ),
			'value'            => array(
				esc_html__( 'All Products', 'soledad' )            => 'product',
				esc_html__( 'Featured Products', 'soledad' )       => 'featured',
				esc_html__( 'Sale Products', 'soledad' )           => 'sale',
				esc_html__( 'Products with NEW label', 'soledad' ) => 'new',
				esc_html__( 'Bestsellers', 'soledad' )             => 'bestselling',
				esc_html__( 'List of IDs', 'soledad' )             => 'ids',
				esc_html__( 'Top Rated Products', 'soledad' )      => 'top_rated_products',
			),
			'std'              => 'product',
			'param_name'       => 'post_type',
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			'type'             => 'autocomplete',
			'heading'          => __( 'Included Only', 'soledad' ),
			'value'            => '',
			'param_name'       => 'include',
			'edit_field_class' => 'vc_col-sm-6',
			'hint'             => esc_html__( 'Add products by title.', 'soledad' ),
			'settings'         => array(
				'multiple' => true,
				'sortable' => true,
				'groups'   => true
			),
		),
		array(
			'type'             => 'autocomplete',
			'heading'          => __( 'Excluded', 'soledad' ),
			'value'            => '',
			'param_name'       => 'exclude',
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			'type'             => 'autocomplete',
			'heading'          => __( 'Categories OR Tags', 'soledad' ),
			'value'            => '',
			'param_name'       => 'taxonomies',
			'edit_field_class' => 'vc_col-sm-6',
			'settings'         => array(
				'multiple'       => true,
				// is multiple values allowed? default false
				// 'sortable' => true, // is values are sortable? default false
				'min_length'     => 1,
				// min length to start search -> default 2
				// 'no_hide' => true, // In UI after select doesn't hide an select list, default false
				'groups'         => true,
				// In UI show results grouped by groups, default false
				'unique_values'  => true,
				// In UI show results except selected. NB! You should manually check values in backend, default false
				'display_inline' => true,
				// In UI show results inline view, default false (each value in own line)
				'delay'          => 500,
				// delay for search. default 500
				'auto_focus'     => true,
				// auto focus input, default true
			),
		),
		array(
			'type'             => 'dropdown',
			'heading'          => __( 'Order by', 'soledad' ),
			'value'            => array(
				''                                            => '',
				esc_html__( 'Date', 'soledad' )               => 'date',
				esc_html__( 'ID', 'soledad' )                 => 'id',
				esc_html__( 'Author', 'soledad' )             => 'author',
				esc_html__( 'Title', 'soledad' )              => 'title',
				esc_html__( 'Last modified date', 'soledad' ) => 'modified',
				esc_html__( 'Number of comments', 'soledad' ) => 'comment_count',
				esc_html__( 'Menu order', 'soledad' )         => 'menu_order',
				esc_html__( 'Meta value', 'soledad' )         => 'meta_value',
				esc_html__( 'Meta value number', 'soledad' )  => 'meta_value_num',
				esc_html__( 'Random order', 'soledad' )       => 'rand',
				esc_html__( 'Price', 'soledad' )              => 'price',
			),
			'std'              => '',
			'edit_field_class' => 'vc_col-sm-6',
			'param_name'       => 'orderby',
		),
		array(
			'type'             => 'textfield',
			'heading'          => __( 'Offset', 'soledad' ),
			'value'            => '',
			'param_name'       => 'offset',
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			'type'             => 'dropdown',
			'heading'          => __( 'Query Type', 'soledad' ),
			'value'            => array(
				esc_html__( 'OR', 'soledad' )  => 'or',
				esc_html__( 'AND', 'soledad' ) => 'and',
			),
			'std'              => 'or',
			'param_name'       => 'query_type',
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			'type'             => 'dropdown',
			'heading'          => __( 'Sort order', 'soledad' ),
			'value'            => array(
				esc_html__( 'Inherit', 'soledad' )    => '',
				esc_html__( 'Descending', 'soledad' ) => 'DESC',
				esc_html__( 'Ascending', 'soledad' )  => 'ASC',
			),
			'std'              => 'DESC',
			'param_name'       => 'order',
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			'type'        => 'textfield',
			'heading'     => __( 'Meta Key', 'soledad' ),
			'description' => esc_html__( 'Input meta key for grid ordering.', 'soledad' ),
			'value'       => '',
			'std'         => '',
			'param_name'  => 'meta_key',
		),
	), array(
		array(
			'type'             => 'dropdown',
			'group'            => 'Layout & Design',
			'heading'          => __( 'Products Display', 'soledad' ),
			'value'            => array(
				esc_html__( 'Grid', 'soledad' )     => 'grid',
				esc_html__( 'List', 'soledad' )     => 'list',
				esc_html__( 'Carousel', 'soledad' ) => 'carousel',
			),
			'std'              => 'grid',
			'param_name'       => 'layout',
			'edit_field_class' => 'vc_col-sm-4',
		),
		array(
			'type'             => 'dropdown',
			'group'            => 'Layout & Design',
			'heading'          => __( 'Columns', 'soledad' ),
			'value'            => array(
				esc_html__( '2 Columns', 'soledad' ) => 2,
				esc_html__( '3 Columns', 'soledad' ) => 3,
				esc_html__( '4 Columns', 'soledad' ) => 4,
				esc_html__( '5 Columns', 'soledad' ) => 5,
				esc_html__( '6 Columns', 'soledad' ) => 6,
			),
			'std'              => 3,
			'param_name'       => 'columns',
			'edit_field_class' => 'vc_col-sm-4',
		),
		array(
			'type'             => 'dropdown',
			'group'            => 'Layout & Design',
			'heading'          => __( 'Tablet Columns', 'soledad' ),
			'value'            => array(
				esc_html__( '2 Columns', 'soledad' ) => 2,
				esc_html__( '3 Columns', 'soledad' ) => 3,
				esc_html__( '4 Columns', 'soledad' ) => 4,
				esc_html__( '5 Columns', 'soledad' ) => 5,
				esc_html__( '6 Columns', 'soledad' ) => 6,
			),
			'std'              => 2,
			'param_name'       => 'tablet_columns',
			'edit_field_class' => 'vc_col-sm-4',
		),
		array(
			'type'             => 'dropdown',
			'group'            => 'Layout & Design',
			'heading'          => __( 'Mobile Columns', 'soledad' ),
			'value'            => array(
				esc_html__( '2 Columns', 'soledad' ) => 2,
				esc_html__( '3 Columns', 'soledad' ) => 3,
				esc_html__( '4 Columns', 'soledad' ) => 4,
				esc_html__( '5 Columns', 'soledad' ) => 5,
				esc_html__( '6 Columns', 'soledad' ) => 6,
			),
			'std'              => 1,
			'param_name'       => 'mobile_columns',
			'edit_field_class' => 'vc_col-sm-4',
		),
		array(
			'type'             => 'textfield',
			'group'            => 'Layout & Design',
			'heading'          => __( 'Items per page', 'soledad' ),
			'std'              => '12',
			'param_name'       => 'items_per_page',
			'edit_field_class' => 'vc_col-sm-4',
		),
		array(
			'type'             => 'dropdown',
			'group'            => 'Layout & Design',
			'heading'          => __( 'Paginations', 'soledad' ),
			'value'            => array(
				esc_html__( 'Inherit', 'soledad' )           => '',
				esc_html__( 'Load more button', 'soledad' )  => 'loadmore',
				esc_html__( 'Infinit scrolling', 'soledad' ) => 'infinit',
				esc_html__( 'Links', 'soledad' )             => 'links',
				esc_html__( 'Hidden', 'soledad' )            => 'none',
			),
			'std'              => '',
			'param_name'       => 'pagination',
			'edit_field_class' => 'vc_col-sm-4',
		),

		// Carousel Settings
		array(
			'type'       => 'penci_responsive_sizes',
			'group'      => 'Layout & Design',
			'heading'    => __( 'Scroll per page', 'soledad' ),
			'param_name' => 'scroll_per_page',
			'dependency' => array( 'element' => 'layout', 'value' => array( 'carousel' ) ),
		),

		array(
			'type'        => 'penci_switch',
			'group'       => 'Layout & Design',
			'heading'     => __( 'Show Next Previous Button', 'soledad' ),
			'true_state'  => 'yes',
			'false_state' => 'no',
			'default'     => 'no',
			'std'         => 'no',
			'param_name'  => 'hide_prev_next_buttons',
			'dependency'  => array( 'element' => 'layout', 'value' => array( 'carousel' ) ),
		),

		array(
			'type'        => 'penci_switch',
			'group'       => 'Layout & Design',
			'heading'     => __( 'Show Pagination Control', 'soledad' ),
			'true_state'  => 'yes',
			'false_state' => 'no',
			'default'     => 'no',
			'std'         => 'no',
			'param_name'  => 'hide_pagination_control',
			'dependency'  => array( 'element' => 'layout', 'value' => array( 'carousel' ) ),
		),

		array(
			'type'        => 'penci_switch',
			'group'       => 'Layout & Design',
			'heading'     => __( 'Slider Loop', 'soledad' ),
			'true_state'  => 'yes',
			'false_state' => 'no',
			'default'     => 'no',
			'std'         => 'no',
			'param_name'  => 'wrap',
			'dependency'  => array( 'element' => 'layout', 'value' => array( 'carousel' ) ),
		),

		array(
			'type'        => 'penci_switch',
			'group'       => 'Layout & Design',
			'heading'     => __( 'Slider Autoplay', 'soledad' ),
			'true_state'  => 'yes',
			'false_state' => 'no',
			'default'     => 'no',
			'std'         => 'no',
			'param_name'  => 'autoplay',
			'dependency'  => array( 'element' => 'layout', 'value' => array( 'carousel' ) ),
		),

		array(
			'type'       => 'textfield',
			'group'      => 'Layout & Design',
			'heading'    => __( 'Carousel Speed', 'soledad' ),
			'std'        => '300',
			'param_name' => 'speed',
			'dependency' => array( 'element' => 'layout', 'value' => array( 'carousel' ) ),
		),

		array(
			'type'        => 'penci_switch',
			'group'       => 'Layout & Design',
			'heading'     => __( 'Init carousel on scroll', 'soledad' ),
			'true_state'  => 'yes',
			'false_state' => 'no',
			'default'     => 'no',
			'std'         => 'no',
			'param_name'  => 'scroll_carousel_init',
			'dependency'  => array( 'element' => 'layout', 'value' => array( 'carousel' ) ),
		),
	), array(
		array(
			'type'       => 'dropdown',
			'group'      => 'Product Style',
			'heading'    => __( 'Product Style', 'soledad' ),
			'value'      => array(
				esc_html__( 'Inherit from Theme Settings', 'soledad' ) => 'inherit',
				'Default'                                              => 'standard',
				'Style 1'                                              => 'style-1',
				'Style 2'                                              => 'style-2',
				'Style 3'                                              => 'style-3',
				'Style 4'                                              => 'style-4',
				'Style 5'                                              => 'style-5',
				'Style 6'                                              => 'style-6',
			),
			'std'        => 'style-1',
			'param_name' => 'product_style',
		),
		array(
			'type'       => 'dropdown',
			'group'      => 'Product Style',
			'heading'    => __( 'Image Size', 'soledad' ),
			'value'      => Penci_Vc_Params_Helper::get_list_image_sizes( true ),
			'param_name' => 'img_size',
		),
		array(
			'type'       => 'textfield',
			'group'      => 'Product Style',
			'heading'    => __( 'Custom Image Size', 'soledad' ),
			'value'      => '',
			'param_name' => 'img_custom_size',
		),
		array(
			'type'        => 'penci_switch',
			'group'       => 'Product Style',
			'heading'     => __( 'Sale Countdown', 'soledad' ),
			'true_state'  => 'yes',
			'false_state' => 'no',
			'default'     => 'no',
			'std'         => 'no',
			'param_name'  => 'sale_countdown',
		),
		array(
			'type'        => 'penci_switch',
			'group'       => 'Product Style',
			'heading'     => __( 'Stock Progress Bar', 'soledad' ),
			'true_state'  => 'yes',
			'false_state' => 'no',
			'default'     => 'no',
			'std'         => 'no',
			'param_name'  => 'stock_progress_bar',
		),
		array(
			'type'        => 'penci_switch',
			'group'       => 'Product Style',
			'heading'     => __( 'Product Category', 'soledad' ),
			'true_state'  => 'yes',
			'false_state' => 'no',
			'default'     => 'no',
			'std'         => 'no',
			'param_name'  => 'product_categories',
		),
		array(
			'type'        => 'penci_switch',
			'group'       => 'Product Style',
			'heading'     => __( 'Product Rating', 'soledad' ),
			'true_state'  => 'yes',
			'false_state' => 'no',
			'default'     => 'no',
			'std'         => 'no',
			'param_name'  => 'product_rating',
		),
	), array(
		array(
			'type'             => 'textfield',
			'param_name'       => 'heading_pdc_settings',
			'heading'          => esc_html__( 'Product Style & Color', 'soledad' ),
			'value'            => '',
			'group'            => $group_color,
			'edit_field_class' => 'penci-param-heading-wrapper no-top-margin vc_column vc_col-sm-12',
		),
		array(
			'type'             => 'colorpicker',
			'heading'          => esc_html__( 'Product Title Color', 'soledad' ),
			'param_name'       => 'product_title_color',
			'group'            => $group_color,
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			'type'             => 'penci_responsive_sizes',
			'heading'          => esc_html__( 'Product Title Font Size', 'soledad' ),
			'param_name'       => 'product_title_font_size',
			'group'            => $group_color,
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			'type'             => 'colorpicker',
			'heading'          => esc_html__( 'Product Category Color', 'soledad' ),
			'param_name'       => 'product_category_color',
			'group'            => $group_color,
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			'type'             => 'penci_responsive_sizes',
			'heading'          => esc_html__( 'Product Category Font Size', 'soledad' ),
			'param_name'       => 'product_category_font_size',
			'group'            => $group_color,
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			'type'             => 'colorpicker',
			'heading'          => esc_html__( 'Product Price Color', 'soledad' ),
			'param_name'       => 'product_price_color',
			'group'            => $group_color,
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			'type'             => 'penci_responsive_sizes',
			'heading'          => esc_html__( 'Product Price Font Size', 'soledad' ),
			'param_name'       => 'product_price_font_size',
			'group'            => $group_color,
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			'type'             => 'colorpicker',
			'heading'          => esc_html__( 'Pagination Color', 'soledad' ),
			'param_name'       => 'product_pagination_color',
			'group'            => $group_color,
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			'type'             => 'colorpicker',
			'heading'          => esc_html__( 'Pagination Border Color', 'soledad' ),
			'param_name'       => 'product_pagination_boder_color',
			'group'            => $group_color,
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			'type'             => 'colorpicker',
			'heading'          => esc_html__( 'Pagination Hover Color', 'soledad' ),
			'param_name'       => 'product_pagination_hover_color',
			'group'            => $group_color,
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			'type'             => 'colorpicker',
			'heading'          => esc_html__( 'Pagination Border Hover Color', 'soledad' ),
			'param_name'       => 'product_pagination_border_hover_color',
			'group'            => $group_color,
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			'type'             => 'colorpicker',
			'heading'          => esc_html__( 'Pagination Current Item Color', 'soledad' ),
			'param_name'       => 'product_pagination_current_item_color',
			'group'            => $group_color,
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			'type'             => 'colorpicker',
			'heading'          => esc_html__( 'Pagination Current Item Border Color', 'soledad' ),
			'param_name'       => 'product_pagination_current_item_border_color',
			'group'            => $group_color,
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			'type'             => 'colorpicker',
			'heading'          => esc_html__( 'Pagination Current Background Color', 'soledad' ),
			'param_name'       => 'product_pagination_current_bg_color',
			'group'            => $group_color,
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			'type'             => 'colorpicker',
			'heading'          => esc_html__( 'Pagination View More Background Color', 'soledad' ),
			'param_name'       => 'product_pagination_viewmore_bg_color',
			'group'            => $group_color,
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			'type'             => 'colorpicker',
			'heading'          => esc_html__( 'Pagination View More Hover Background Color', 'soledad' ),
			'param_name'       => 'product_pagination_viewmore_hover_bg_color',
			'group'            => $group_color,
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			'type'             => 'colorpicker',
			'heading'          => esc_html__( 'Pagination View More Text Color', 'soledad' ),
			'param_name'       => 'product_pagination_viewmore_text_color',
			'group'            => $group_color,
			'edit_field_class' => 'vc_col-sm-6',
		),
		array(
			'type'             => 'colorpicker',
			'heading'          => esc_html__( 'Pagination View More Hover Text Color', 'soledad' ),
			'param_name'       => 'product_pagination_viewmore_hover_text_color',
			'group'            => $group_color,
			'edit_field_class' => 'vc_col-sm-6',
		),
	), Penci_Vc_Params_Helper::heading_block_params(), Penci_Vc_Params_Helper::params_heading_typo_color(), Penci_Vc_Params_Helper::extra_params() )
) );
