<?php
declare(strict_types=1);

namespace PhoxTemplates\Includes\App\Http\Controllers;

use PhoxTemplates\Includes\Core\Controllers\AbstractControllers;
use phpDocumentor\Reflection\Types\Mixed_;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use PhoxTemplates\Includes\Core\Service;

class BrandSettings extends AbstractControllers {

    /**
     * send all setting from db
     *
     * @return object
     */
    public function view_settings()
    {

        $this->response->setContent($this->get_settings());

        $this->response->setStatusCode(Response::HTTP_OK);

        $this->response->headers->set('Content-Type', 'application/json');

        $this->set_json_type(true);

        return $this->validated_data_before_send($this->response->getContent());

    }


    /**
     * get general setting from db
     *
     * @return mixed
     */
    public function get_settings($type ='json')
    {
        if($type === 'array') return json_decode( $this->db->fetch_data_json(), true );

        return $this->db->fetch_data_json();

    }

    /**
     * Validate data Before Send
     *
     * @param $content
     * @return Response|void
     */
    public function validated_data_before_send($content)
    {
        if( empty( $content ) ) return $this->response->setContent($this->error_message());

        $ref_data = [
            'logoLinkSwitcher',
            'logoLink',
            'logoDark',
            'logoLight'
        ];

        $data = $this->get_settings('array');

        $filter_data = array_filter($data, function ($key) use ($ref_data) {
            return in_array($key, $ref_data);
        }, ARRAY_FILTER_USE_KEY);

        if(  count($filter_data) !== count($ref_data)  ) return $this->response->setContent($this->error_message('error on data'));

        return $this->response->setContent($content);

    }


    /**
     * save_settings
     * it will call when saving data to db
     *
     * @return Response
     */
    public function save_settings(){

        $this->response->headers->set('Access-Control-Request-Method', 'POST');

        $method_type = $this->request->server->get('REQUEST_METHOD');

        $content = '';

        $error_list = [];

        $default_options_value = $this->get_settings('array');

        if( $method_type === 'POST' ){

            $options = $this->request->request;

            $files = $this->request->files;

            if ( ! empty( $logoLinkSwitcher = (bool)$options->get('logoLinkSwitcher') ) ) {

                //check if it bool

                $default_options_value['logoLinkSwitcher'] = $logoLinkSwitcher;

                $v_url_class = new Service\SafeUrl();

                $v_url_class->sitUrl($options->get('logoLink'));

                $logoLink = $v_url_class->check();

                if( ! $logoLink['state'] ){

                    $error_list ['messages']['logoLink']= $logoLink['message'] ;

                }

                $default_options_value['logoLink'] = $logoLink['url'];


            }

            $logo_files_pram = ['logoDark' => 'logo-dark', 'logoLight' => 'logo-light'];

            $upload_image_class = new Service\UploaderHelper();

            foreach ( $logo_files_pram as $logo_name => $image_name ){

                if( !empty( $logoDark = $files->get($logo_name) ) ){

                    $upload_image_dark = $upload_image_class->uploadImage($logoDark, $image_name);

                    if( ! $upload_image_dark['state'] ){

                        $error_list['messages'][$logo_name] = $upload_image_dark['message'];

                    }

                    $default_options_value[$logo_name] = true;

                }

            }

            //update db
            if ( empty($error_list) ){

                $prepare_data_for_db = json_encode($default_options_value);

                $this->db->update_values($prepare_data_for_db);

                $content = '{"result": "success"}';

            }else{

                $content = $this->error_message( $error_list,Response::HTTP_UNSUPPORTED_MEDIA_TYPE);

            }


        }else{

            $content = $this->error_message('Method Not Allowed',Response::HTTP_METHOD_NOT_ALLOWED);

        }

        return $this->response->setContent($content);

    }

    public function remove_logo(){

        $this->response->headers->set('Access-Control-Request-Method', 'POST');

        $method_type = $this->request->server->get('REQUEST_METHOD');

        $content = '';

        $default_options_value = $this->get_settings('array');

        if( $method_type === 'POST' ){

            $options = $this->request->request;

            if ( ! empty( $brandType = $options->get('brandType') ) ) {

                if( $brandType == 'dark' ){

                    $default_options_value['logoDark'] = false;

                }

                if( $brandType == 'light' ){

                    $default_options_value['logoLight'] = false;


                }

                $prepare_data_for_db = json_encode($default_options_value);

                $this->db->update_values($prepare_data_for_db);

                $content = '{"result": "success"}';

            }

        }else{

            $content = $this->error_message('Method Not Allowed',Response::HTTP_METHOD_NOT_ALLOWED);

        }

        return $this->response->setContent($content);


    }
    /**
     * Front values
     * This data will show on frontend
     *
     * @return array
     */
    public function front_values (): array
    {

        $result = [];

        $section_name = 'wdes_phox_brand';

        $data = $this->get_settings('array');

        $result ['var_name'] = $section_name;

        $result ['values'] = [
            'logo_switcher' => $data['logoLinkSwitcher'],
            'logo_link' => $data['logoLink'],
            'logo_dark' => $data['logoDark'],
            'logo_light' => $data['logoLight'],

        ];

        return $result;
    }

}
