<?php
if ( !function_exists('wdes_current_time') ) :
	/**
	 * Retrieve the current time based on specified type.
	 *
	 * The 'mysql' type will return the time in the format for MySQL DATETIME field.
	 * The 'timestamp' type will return the current timestamp.
	 * Other strings will be interpreted as PHP date formats (e.g. 'Y-m-d').
	 *
	 * @since 1.0.0
	 *
	 * @param string   $type Type of time to retrieve. Accepts 'mysql', 'timestamp', or PHP date
	 *                       format string (e.g. 'Y-m-d').
	 * @param int|bool $gmt  Optional. Whether to use GMT timezone. Default false.
	 * @return int|string Integer if $type is 'timestamp', string otherwise.
	 */
	function wdes_current_time( $type, $gmt = 0 ) {
		switch ( $type ) {
			case 'mysql':
				return ( $gmt ) ? gmdate( 'Y-m-d H:i:s' ) : gmdate( 'Y-m-d H:i:s', ( time() + ( (int)ini_get('date.timezone') * HOUR_IN_SECONDS ) ) );
			case 'timestamp':
				return ( $gmt ) ? time() : time() + ( (int)ini_get('date.timezone') * HOUR_IN_SECONDS );
			default:
				return ( $gmt ) ? date( $type ) : date( $type, time() + ( (int)ini_get('date.timezone') * HOUR_IN_SECONDS ) );
		}
	}

endif;