<?php

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

/**
 * Require Files and initialization libraries
 * 1- require Bootstrap file
 */
require_once __DIR__ .  DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR . 'Core' . DIRECTORY_SEPARATOR . 'Bootstrap.php';

/**
 * Use Classes
 * 1-Database
 */
use PhoxTemplates\Includes\App\Database\Setup As DatabasesClass;

/**
 * Run The Route
 */
new PhoxTemplates\Includes\Core\Http\RoutingProvider();

/**
 * Define addon module configuration parameters.
 * @return array
 */
function phox_templates_config()
{
    return [
        // Display name for your module
        'name' => 'Phox WHMCS Templates',
        // Description displayed within the admin interface
        'description' => 'This module helps you to install Phox WHMCS templates. '
            . '<br/> <strong>Note:</strong> This templates use exclusive with <a href="https://1.envato.market/RDGA9">Phox Theme</a> ',
        // Module author name
        'author' => '<a href="https://whmcsdes.com">WHMCSDES</a>',
        // Default language
        'language' => 'english',
        // Version number
        'version' => '2.0.2',
    ];
}

/**
 * Activate.
 */
function phox_templates_activate()
{
    //Build new table
     $databases_migrations = new DatabasesClass();

    return $databases_migrations->up_db();


}

/**
 * Deactivate.
 *
 * @see https://developers.whmcs.com/advanced/db-interaction/
 *
 * @return array Optional success/failure message
 */
function phox_templates_deactivate()
{
    //Drop Database
    $databases_migrations = new DatabasesClass();
    return $databases_migrations->down_db();
}

/**
 * Admin Output
 *
 * @param $vars
 */
function phox_templates_output($vars) {
    //Template Load By Routing
    print ('<script src="../modules/addons/phox_templates/templates/static/js/main.js"></script>');
    print ('<link rel="stylesheet" href="../modules/addons/phox_templates/templates/static/css/main.css"></link>');
    print ('<link rel="preconnect" href="https://fonts.googleapis.com" />');
    print ('<link rel="preconnect" href="https://fonts.googleapis.com" />');
    print ('<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />');
    print ('<link href="https://fonts.googleapis.com/css2?family=Lato:wght@400;700&display=swap" rel="stylesheet" />');
}

/**
 * Upgrade version
 *
 * @param $vars
 */
function  phox_templates_upgrade($vars){

    $currentlyInstalledVersion = $vars['version'];

    if ($currentlyInstalledVersion < '2.0.0') {
        //Build new table
        $databases_migrations = new DatabasesClass();
        return $databases_migrations->up_db();
    }

}



