<div class="wdes-page-affiliates">
  {if $inactive}

  {include file="$template/includes/alert.tpl" type="danger" msg=$LANG.affiliatesdisabled textcenter=true}

  {else}
  {include file="$template/includes/flashmessage.tpl"}
  <div class="tiles wdes-affiliates-blocks">
    <div class="tile">
      <div class="icon">
        <i class="fad fa-users"></i>
      </div>
      <div class="stat">{$visitors}</div>
      <div class="title">{$LANG.affiliatesclicks}</div>
    </div>
    <div class="tile">
      <div class="icon">
        <i class="fad fa-shopping-cart"></i>
      </div>
      <div class="stat">{$signups}</div>
      <div class="title">{$LANG.affiliatessignups}</div>
    </div>
    <div class="tile">
      <div class="icon">
        <i class="fad fa-chart-bar"></i>
      </div>
      <div class="stat">{$conversionrate}%</div>
      <div class="title">{$LANG.affiliatesconversionrate}</div>
    </div>
  </div>

  <div class="row">
    <div class="col-md-12">
      <table class="table wdes-table-affiliate">
        <tr>
          <td>{$LANG.affiliatesreferallink}</td>
          <td>{$referrallink}</td>
        </tr>
        <tr>
          <td>{$LANG.affiliatescommissionspending}:</td>
          <td>{$pendingcommissions}</td>
        </tr>
        <tr>
          <td>{$LANG.affiliatescommissionsavailable}:</td>
          <td>{$balance}</td>
        </tr>
        <tr>
          <td>{$LANG.affiliateswithdrawn}:</td>
          <td>{$withdrawn}</td>
        </tr>
      </table>
    </div>
  </div>

  {if $withdrawrequestsent}
  <div class="alert alert-success">
    <p>{$LANG.affiliateswithdrawalrequestsuccessful}</p>
  </div>
  {else}
  <p class="text-center">
    <a href="{$smarty.server.PHP_SELF}?action=withdrawrequest" class="btn btn-lg btn-danger{if !$withdrawlevel} disabled" disabled="disabled{/if}">
      <i class="fad fa-university"></i> {$LANG.affiliatesrequestwithdrawal}
    </a>
  </p>
  {if !$withdrawlevel}
  <div class="alert alert-info text-center">
    {lang key="affiliateWithdrawalSummary" amountForWithdrawal=$affiliatePayoutMinimum}
  </div>
  {/if}
  {/if}

  {include file="$template/includes/subheader.tpl" title=$LANG.affiliatesreferals}

  {include file="$template/includes/tablelist.tpl" tableName="AffiliatesList"}
  <script type="text/javascript">
    jQuery(document).ready(function() {
      var table = jQuery('#tableAffiliatesList').removeClass('hidden').DataTable();
            {if $orderby == 'regdate'}
            table.order(0, '{$sort}');
            {elseif $orderby == 'product'}
            table.order(1, '{$sort}');
            {elseif $orderby == 'amount'}
            table.order(2, '{$sort}');
            {elseif $orderby == 'status'}
            table.order(4, '{$sort}');
            {/if}
      table.draw();
      jQuery('#tableLoading').addClass('hidden');
    });
  </script>
  <div class="table-container clearfix">
    <table id="tableAffiliatesList" class="table table-list hidden">
      <thead>
        <tr>
          <th>{$LANG.affiliatessignupdate}</th>
          <th>{$LANG.orderproduct}</th>
          <th>{$LANG.affiliatesamount}</th>
          <th>{$LANG.affiliatescommission}</th>
          <th>{$LANG.affiliatesstatus}</th>
        </tr>
      </thead>
      <tbody>
        {foreach from=$referrals item=referral}
        <tr class="text-center">
          <td><span class="hidden">{$referral.datets}</span>{$referral.date}</td>
          <td>{$referral.service}</td>
          <td data-order="{$referral.amountnum}">{$referral.amountdesc}</td>
          <td data-order="{$referral.commissionnum}">{$referral.commission}</td>
          <td><span class='label status status-{$referral.rawstatus|strtolower}'>{$referral.status}</span></td>
        </tr>
        {/foreach}
      </tbody>
    </table>
    <div class="text-center" id="tableLoading">
      <p><i class="fad fa-spinner fa-spin"></i> {$LANG.loading}</p>
    </div>
  </div>

  {if $affiliatelinkscode}
  {include file="$template/includes/subheader.tpl" title=$LANG.affiliateslinktous}
  <div class="margin-bottom text-center">
    {$affiliatelinkscode}
  </div>
  {/if}

  {/if}
</div>