<?php /**
 * Generate the CSS for the current custom color scheme.
 */
function multicote_wp_custom_colors_css() {

// Logo Margin
$multicote_wp_logo_margin = get_theme_mod('multicote_wp_logo_margin');
if (!empty($multicote_wp_logo_margin)) {
	echo esc_html('.logo { margin-top: '. $multicote_wp_logo_margin .'px !important; }');
}
// Header BG color
$multicote_wp_header_color = get_theme_mod('multicote_wp_header_color');
if (!empty($multicote_wp_header_color)) {
	echo esc_html('header, .sticky, .jquerycssmenu ul li ul { background-color: '. $multicote_wp_header_color .' !important; }');
}
// footer pattern 
$multicote_wp_pattern_footer_img = get_theme_mod('multicote_wp_pattern_footer_img');
if (!empty($multicote_wp_pattern_footer_img)) {
	echo esc_html('footer { background: url('. $multicote_wp_pattern_footer_img .') !important; }');
}
// color link
$multicote_wp_entry_linkcolor = get_theme_mod('multicote_wp_entry_linkcolor');
if (!empty($multicote_wp_entry_linkcolor)) {
    echo esc_html('.p-first-letter p a  { color: '. $multicote_wp_entry_linkcolor .' !important;}');
}
// color menu link
$multicote_wp_header_links_color = get_theme_mod('multicote_wp_header_links_color');
if (!empty($multicote_wp_header_links_color)) {
    echo esc_html('.jquerycssmenu ul li a  { color: '. $multicote_wp_header_links_color .' !important;}');
} 
// 1st main color.
$multicote_wp_main_color1 = get_theme_mod('multicote_wp_main_color1');
if (!empty($multicote_wp_main_color1)) {
    echo stripslashes('.jquerycssmenu ul li.current_page_item > a, .jquerycssmenu ul li.current-menu-ancestor > a, .jquerycssmenu ul li.current-menu-item > a, .jquerycssmenu ul li.current-menu-parent > a, .jquerycssmenu ul li ul li.current_page_item > a, .jquerycssmenu ul li ul li.current-menu-ancestor > a, .jquerycssmenu ul li ul li.current-menu-item > a, .jquerycssmenu ul li ul li.current-menu-parent > a, .jquerycssmenu ul li a:hover, .jquerycssmenu ul li ul li:hover a:hover { border-bottom: 1px solid '. $multicote_wp_main_color1 .' !important;}');
	echo esc_html('a:hover, .popular-words span, .top-social li a, .blog-ex1 .an-read-more a:hover, .review-box-nr i, .review-box-nr, .blog-ex2 .an-read-more a:hover, ul.aut-meta li.name a, div.p-first-letter p:first-child:first-letter, div.feed-info i, .article_list li .an-display-author a, .widget_anthemes_categories li, div.tagcloud span, .widget_archive li, .widget_meta li, #mcTagMap .tagindex h4, #sc_mcTagMap .tagindex h4, ul.aut-meta li.name, ul.product_list_widget li ins, .archive-header h3 strong, .jquerycssmenu ul.carousel-categories li i, .blog-ex1 .an-home-title i, .blog-ex2 .an-home-title i, ul.masonry_list .an-widget-title i, .entry-top i, ul.article_list .an-widget-title i, .jquerycssmenu ul.carousel-categories li:hover a { color: '. $multicote_wp_main_color1 .' !important;}'); //Main color = color
	echo esc_html('.bar-header, .popular-words strong, .searchform2 .buttonicon, .featured-articles .article-category, .blog-ex1 .article-category, .blog-ex2 .article-category, ul.masonry_list .article-category, a.author-nrposts, .related-articles .article-category, .entry-btn, .my-paginated-posts span, .newsletter-form input.newsletter-btn, ul.article_list .article-category, #contactform .sendemail, .social-section, #back-top span, .wp-pagenavi span.current, .wp-pagenavi a:hover, a.add_to_cart_button:hover, .woocommerce span.onsale, ul.meta-icons-home li.sticky-lm, .sticky-lm .tooltiptext, #waveHorizontal1, #waveHorizontal2, #waveHorizontal3 { background-color: '. $multicote_wp_main_color1 .' !important;}'); //Main bg color
	echo esc_html('#mcTagMap .tagindex h4, #sc_mcTagMap .tagindex h4, ul.products li:hover img { border-bottom: 5px solid '. $multicote_wp_main_color1 .' !important;}');
    echo stripslashes('.featured-articles .title-box span a, .blog-ex1 .an-read-more a, .blog-ex1 .an-home-title span a, .blog-ex2 .an-read-more a, .blog-ex2 .an-home-title span a, ul.masonry_list .an-widget-title span a, .related-articles .title-box span a, .single-breadcrumbs li a, .entry-top span a, div.feed-info strong, ul.article_list .an-widget-title span a, .copyright a  { border-bottom: 1px solid '. $multicote_wp_main_color1 .' !important;}');
    echo esc_html('.menu-categories .jquerycssmenu ul li ul { border-top: 3px solid '. $multicote_wp_main_color1 .' !important;}');
    echo esc_html('footer { border-top: 5px solid '. $multicote_wp_main_color1 .' !important;}');
    echo esc_html('.prev-articles { border-top: dashed 5px '. $multicote_wp_main_color1 .' !important;}');
    echo esc_html('.featured-articles .article-category i, .blog-ex1 .article-category i, .blog-ex2 .article-category i, ul.masonry_list .article-category i, .related-articles .article-category i, ul.article_list .article-category i   { border-color: '. $multicote_wp_main_color1 .' transparent '. $multicote_wp_main_color1 .' '. $multicote_wp_main_color1 .' !important;}');
    echo esc_html('.sticky-lm .tooltiptext::after { border-color: transparent transparent '. $multicote_wp_main_color1 .' !important;}');
    echo esc_html('#infinite-articles .sticky .ex2-content, #infinite-articles .sticky .ex1-content, ul#infinite-articles li.sticky { border-bottom: dashed 5px '. $multicote_wp_main_color1 .' !important;}');
}
// 2nd main color.
$multicote_wp_main_color2 = get_theme_mod('multicote_wp_main_color2');
if (!empty($multicote_wp_main_color2)) {
	echo esc_html('.featured-title, .related-title, .single-content h3.title, .my-paginated-posts p a, .sidebar .widget h3.title, .sidebar-middle .widget h3.title, #wp-calendar tbody td#today, .comments h3.comment-reply-title, #commentform #sendemail, form.wpcf7-form input.wpcf7-submit, footer .widget h3.title  { background-color: '. $multicote_wp_main_color2 .' !important; }');
    echo esc_html('.single-content h3.title i, .sidebar .widget h3.title i, .sidebar-middle .widget h3.title i, .comments h3.comment-reply-title i, footer .widget h3.title i { border-color: '. $multicote_wp_main_color2 .' transparent '. $multicote_wp_main_color2 .' '. $multicote_wp_main_color2 .' !important;}');
}
// Thumbs UP color
$multicote_wp_thumbs_up_color = get_theme_mod('multicote_wp_thumbs_up_color');
if (!empty($multicote_wp_thumbs_up_color)) {
	echo esc_html('.thumbs-rating-container .thumbs-rating-up    { color: '. $multicote_wp_thumbs_up_color .' !important; }');
}
// Thumbs DOWN color
$multicote_wp_thumbs_down_color = get_theme_mod('multicote_wp_thumbs_down_color');
if (!empty($multicote_wp_thumbs_down_color)) {
	echo esc_html('.thumbs-rating-container .thumbs-rating-down    { color: '. $multicote_wp_thumbs_down_color .' !important; }');
}
// Background Color
$multicote_wp_color_bg_color = get_theme_mod('multicote_wp_color_bg_color');
if (!empty($multicote_wp_color_bg_color)) {
    echo esc_html('html body  { background-color: '. $multicote_wp_color_bg_color .' !important; }');
}

} ?>