<?php
// ------------------------------------------------------
// ------ Random Reviews  ---------------------------------
// ------ by AnThemes.net -------------------------------
//        http://themeforest.net/user/An-Themes/portfolio
//        http://themeforest.net/user/An-Themes/follow 
// ------------------------------------------------------

class multicote_wp_randreviews extends WP_Widget {
    function __construct() {
      $widget_ops = array('description' => esc_html__('Your site\'s Random Reviews.', 'multicote-wp'));
      parent::__construct(false, $name = ''. esc_html__('Custom: Random Reviews', 'multicote-wp') .'',$widget_ops); 
    }


    function widget($args, $instance) {   
    extract( $args );
    $number = $instance['number'];
    $title = $instance['title'];
?>



<?php echo wp_kses_post($before_widget); ?>
<?php if ( $title ) echo wp_kses_post($before_title) . esc_attr($title) . wp_kses_post($after_title); ?>

<ul class="article_list">
<?php $multicote_wp_anposts = new WP_Query(array('meta_key' => 'taq_review_score', 'ignore_sticky_posts' => 1, 'orderby' => 'rand', 'order' => 'DESC', 'posts_per_page' => esc_attr($number) )); // number to display more / less ?>
<?php $c=0; while ( $multicote_wp_anposts->have_posts() ) : $multicote_wp_anposts->the_post(); ?>

<?php $c++;
if($c == 1) : ?>

  <li><?php if ( has_post_thumbnail()) { ?>
        <div class="article-category"><i></i> <?php $multicote_wp_category = get_the_category(); if ($multicote_wp_category) 
            { echo '<a href="' . get_category_link( $multicote_wp_category[0]->term_id ) . '" class="tiptipBlog" title="' . sprintf( esc_html__( "View all posts in %s", "multicote-wp" ), $multicote_wp_category[0]->name ) . '" ' . '>' . $multicote_wp_category[0]->name.'</a> ';}  ?>
        </div><!-- end .article-category -->     
        <a href="<?php the_permalink(); ?>"> <?php echo the_post_thumbnail('multicote-wp-thumbnail-widget'); ?> </a> 
      <?php } ?> <div class="clear"></div>  

      <div class="an-widget-title">
        <h3 class="article-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
          <?php if(function_exists('taqyeem_get_score')) { ?>
            <?php taqyeem_get_score(); ?>
          <?php } ?>                    
        <span><?php esc_html_e('Written by', 'multicote-wp'); ?> <?php the_author_posts_link(); ?></span> <i class="fas fa-check-circle"></i>
      </div>


  </li>

<?php else : ?> 

  <li>
      <a href="<?php the_permalink(); ?>"> <?php echo the_post_thumbnail('multicote-wp-thumbnail-widget-small'); ?> </a>

      <div class="an-widget-title" <?php if ( has_post_thumbnail()) { ?> style="margin-left:70px;" <?php } ?>>
        <h4 class="article-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
          <?php if(function_exists('taqyeem_get_score')) { ?>
            <?php taqyeem_get_score(); ?>
          <?php } ?>                    
        <span><?php esc_html_e('by', 'multicote-wp'); ?> <?php the_author_posts_link(); ?></span> <i class="fas fa-check-circle"></i>
      </div>
  </li>

<?php endif;?>
<?php endwhile; 
/* Restore original Post Data */
wp_reset_postdata(); ?>
</ul>


<?php echo wp_kses_post($after_widget); ?> 


<?php
    }
    function update($new_instance, $old_instance) {       
    $instance = $old_instance;
    $instance['title'] = strip_tags($new_instance['title']);
    $instance['number'] = strip_tags($new_instance['number']);
    return $instance;
    }

  function form( $instance ) {
    $instance = wp_parse_args( (array) $instance );
?>


        <p>
          <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e( 'Title:', 'multicote-wp' ); ?></label> 
          <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php if( isset($instance['title']) ) echo esc_attr($instance['title']); ?>" />
        </p>

        <p>
          <label for="<?php echo esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e( 'Number of Posts:', 'multicote-wp' ); ?></label>      
          <input class="widefat" id="<?php echo esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php if( isset($instance['number']) ) echo esc_attr($instance['number']); ?>" />
        </p> 

<?php  } }

// register widget
function multicote_wp_randreviews_init_widget () {
    return register_widget('multicote_wp_randreviews');
  }
add_action ('widgets_init', 'multicote_wp_randreviews_init_widget');
?>