<!DOCTYPE HTML>
<html <?php language_attributes(); ?>>
<head>
<?php
    // Logo
    $multicote_wp_logo = get_theme_mod('multicote_wp_logo');
    if (empty($multicote_wp_logo)) { $multicote_wp_logo = get_template_directory_uri().'/images/logo.png'; }

    // Social icons
    $multicote_wp_top_social_icons = get_theme_mod('multicote_wp_top_social_icons');       
    $multicote_wp_topicons_display = get_theme_mod('multicote_wp_topicons_display');
    if (empty($multicote_wp_topicons_display)) { $multicote_wp_topicons_display = 'No'; }

    // Top bar
    $multicote_wp_topbar_display = get_theme_mod('multicote_wp_topbar_display');
    if (empty($multicote_wp_topbar_display)) { $multicote_wp_topbar_display = 'No'; }

    // Popular words
    $multicote_wp_popular_tags_1 = get_theme_mod('multicote_wp_popular_tags_1');
    $multicote_wp_popular_tags_2 = get_theme_mod('multicote_wp_popular_tags_2'); 
    $multicote_wp_popular_tags_3 = get_theme_mod('multicote_wp_popular_tags_3');    
?>
    <!-- Meta Tags -->
    <meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />

    <!-- Mobile Device Meta -->
    <meta name="viewport" content="width=device-width, initial-scale=1"> 

    <!-- Theme output -->
    <?php wp_head(); ?> 

</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>


<!-- Begin Header -->
<header> 

    <?php if ($multicote_wp_topbar_display == 'Yes') { ?>
        <div class="top-navigation">
                <!-- popular words -->
                <div class="popular-words">
                    <?php if (!empty($multicote_wp_popular_tags_1)) { ?><div id="tags1"><strong><?php esc_html_e('Popular tags:', 'multicote-wp'); ?></strong> <?php wp_tag_cloud('number=' .$multicote_wp_popular_tags_1. '&orderby=count&order=DESC'); ?></div><?php } ?>
                    <?php if (!empty($multicote_wp_popular_tags_2)) { ?><div id="tags2"><strong><?php esc_html_e('Popular tags:', 'multicote-wp'); ?></strong> <?php wp_tag_cloud('number=' .$multicote_wp_popular_tags_2. '&orderby=count&order=DESC'); ?></div><?php } ?>
                    <?php if (!empty($multicote_wp_popular_tags_3)) { ?><div id="tags3"><strong><?php esc_html_e('Popular tags:', 'multicote-wp'); ?></strong> <?php wp_tag_cloud('number=' .$multicote_wp_popular_tags_3. '&orderby=count&order=DESC'); ?></div><?php } ?>
                </div>

                <!-- Top social icons. -->
                <?php if ($multicote_wp_topicons_display == 'Yes') { ?>
                    <?php if (!empty($multicote_wp_top_social_icons)) { ?><?php echo wp_kses_post(stripslashes($multicote_wp_top_social_icons)); ?><?php } ?>
                <?php } ?>
        </div><div class="clear"></div>
    <?php } ?>

        <div class="main-header">
            <div class="sticky-on">
                <a href="<?php echo esc_url(home_url( '/' )); ?>"><img class="logo" src="<?php echo esc_url($multicote_wp_logo); ?>" alt="<?php esc_attr(bloginfo('sitename')); ?>" /></a>

                <!-- Navigation Menu -->
                <?php if ( has_nav_menu( 'multicote-wp-primary-menu' ) ) : // Check if there's a menu assigned to the 'Header Navigation' location. ?>
                    <nav id="myjquerymenu" class="jquerycssmenu">
                        <?php  wp_nav_menu( array( 'container' => false, 'items_wrap' => '<ul>%3$s</ul>', 'theme_location' =>   'multicote-wp-primary-menu' ) ); ?>
                    </nav><!-- end #myjquerymenu -->
                <?php endif; // End check for menu. ?>

                <!-- search form get_search_form(); -->
                <?php get_search_form(); ?>
            </div>
            <div class="clear"></div>
        </div><!-- end .main-header -->
        
        <?php if ( has_nav_menu( 'multicote-wp-secondary-menu' ) ) : // Check if there's a menu assigned to the 'Categories Navigation' location. ?>
            <div class="bar-header">
                <div class="wrap-center">
                    <!-- Navigation Menu Categories -->
                    <div class="menu-categories">
                    <nav id="myjquerymenu-cat" class="jquerycssmenu">
                        <?php  wp_nav_menu( array( 'container' => false, 'items_wrap' => '<ul>%3$s</ul>', 'theme_location' =>   'multicote-wp-secondary-menu' ) ); ?>
                    </nav></div><!-- end .menu-categories -->
                </div><!-- end .wrap-center -->
            </div><!-- end .bar-header -->
        <?php endif; // End check for menu. ?>
</header><!-- end #header --> 