<?php
// Exit if accessed directly
if (! defined('ABSPATH')) {
    exit;
}

if (! class_exists('Uxper_Enqueue')) {

    /**
     *  Class Uxper_Enqueue
     */
    class Uxper_Enqueue
    {

        /**
         * The constructor.
         */
        public function __construct()
        {
            add_action('admin_enqueue_scripts', array( $this, 'admin_enqueue'));
            add_action('wp_enqueue_scripts', array( $this, 'template_enqueue'));
            add_action('admin_enqueue_scripts', array( $this, 'template_enqueue'));
        }

        public function admin_enqueue() {

            if( is_rtl() ) {
                wp_enqueue_style(UXPER_CRYPTO_PLUGIN_PREFIX . '-admin', UXPER_CRYPTO_PLUGIN_URL . 'assets/css/rtl/_admin.css', array(), UXPER_CRYPTO_PLUGIN_VER, 'all');
            }else{
                wp_enqueue_style(UXPER_CRYPTO_PLUGIN_PREFIX . '-admin', UXPER_CRYPTO_PLUGIN_URL . 'assets/css/_admin.css', array(), UXPER_CRYPTO_PLUGIN_VER, 'all');
            }

            wp_enqueue_script(UXPER_CRYPTO_PLUGIN_PREFIX . 'admin', UXPER_CRYPTO_PLUGIN_URL . 'assets/js/admin.js', array('jquery'), UXPER_CRYPTO_PLUGIN_VER, true);

            wp_localize_script(UXPER_CRYPTO_PLUGIN_PREFIX . 'admin', 'uxper_admin_vars',
                array(
                    'ajax_url' => UXPER_CRYPTO_AJAX_URL,
                )
            );
            
        }

        public function template_enqueue() {

            wp_enqueue_style('select2', UXPER_CRYPTO_PLUGIN_URL . 'assets/libs/select2/css/select2.min.css', array(), UXPER_CRYPTO_PLUGIN_VER, 'all');

            wp_enqueue_script('select2', UXPER_CRYPTO_PLUGIN_URL . 'assets/libs/select2/js/select2.min.js', array(), UXPER_CRYPTO_PLUGIN_VER, 'all');

            wp_enqueue_style(UXPER_CRYPTO_PLUGIN_PREFIX . '-template', UXPER_CRYPTO_PLUGIN_URL . 'assets/css/_template.css', array(), UXPER_CRYPTO_PLUGIN_VER, 'all');

            wp_enqueue_script('socket-io', UXPER_CRYPTO_PLUGIN_URL . 'assets/js/socket.io.min.js', array('jquery'), UXPER_CRYPTO_PLUGIN_VER, true);

            wp_enqueue_script(UXPER_CRYPTO_PLUGIN_PREFIX . 'template', UXPER_CRYPTO_PLUGIN_URL . 'assets/js/template.js', array('jquery'), UXPER_CRYPTO_PLUGIN_VER, true);
            
        }
    }

    new Uxper_Enqueue();
}
