<?php
/**
 *  Plugin Name: Uxper Crypto
 *  Plugin URI: https://uxper.co/
 *  Description: Uxper Crypto
 *  Version: 1.0.0
 *  Author: Uxper
 *  Author URI: https://uxper.co/
 *  Text Domain: uxper-crypto
 *
 *  @package Uxper Crypto
 *  @author uxper
 *
 **/

if ( !defined('ABSPATH') ) {
    exit; // Exit if accessed directly
}

if ( ! class_exists( 'Uxper_Crypto' ) ) {

	class Uxper_Crypto 
    {

		protected static $instance = null;

		static function instance() 
        {
			if ( null === self::$instance ) {
				self::$instance = new self();
			}

			return self:: $instance;
		}

		public function initialize() 
        {
            $this->define_constants();
            $this->includes();

            add_action('plugins_loaded', array( $this, 'load_textdomain' ) );
		}

		/**
		 *  Define constant
		 **/
		private function define_constants() 
        {
            $plugin_dir_name = dirname(__FILE__);
            $plugin_dir_name = str_replace('\\', '/', $plugin_dir_name);
            $plugin_dir_name = explode('/', $plugin_dir_name);
            $plugin_dir_name = end($plugin_dir_name);

            if ( !defined('UXPER_CRYPTO_PLUGIN_FILE') ) {
                define('UXPER_CRYPTO_PLUGIN_FILE', __FILE__);
            }

            if ( !defined('UXPER_CRYPTO_PLUGIN_NAME') ) {
                define('UXPER_CRYPTO_PLUGIN_NAME', $plugin_dir_name);
            }

            if ( !defined('UXPER_CRYPTO_PLUGIN_DIR') ) {
                define('UXPER_CRYPTO_PLUGIN_DIR', plugin_dir_path(__FILE__));
            }
            if ( !defined('UXPER_CRYPTO_PLUGIN_URL') ) {
                define('UXPER_CRYPTO_PLUGIN_URL', trailingslashit( plugins_url( UXPER_CRYPTO_PLUGIN_NAME ) ) );
            }

            if ( !defined('UXPER_CRYPTO_PLUGIN_PREFIX') ) {
                define('UXPER_CRYPTO_PLUGIN_PREFIX', 'uxper_crypto_');
            }

            if ( !defined('UXPER_CRYPTO_METABOX_PREFIX') ) {
                define('UXPER_CRYPTO_METABOX_PREFIX', 'uxper_crypto_meta_');
            }

            if ( !defined('UXPER_CRYPTO_OPTIONS_NAME') ) {
                define('UXPER_CRYPTO_OPTIONS_NAME', 'uxper_crypto_option');
            }

            if ( !defined('UXPER_CRYPTO_PLUGIN_VER') ) {
                define('UXPER_CRYPTO_PLUGIN_VER', '1.0.0');
            }

            if ( !defined('UXPER_CRYPTO_AJAX_URL') ) {
                $ajax_url = admin_url('admin-ajax.php', 'relative');
                define('UXPER_CRYPTO_AJAX_URL', $ajax_url);
            }
        }

        public function load_textdomain() 
        {
            load_plugin_textdomain( 'uxper-crypto', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
        }

        public function includes() 
        {
            /**
             * Require Base
             */
            require_once UXPER_CRYPTO_PLUGIN_DIR . 'base/base.php';

            /**
             * Require Admin Pages
             */
            require_once UXPER_CRYPTO_PLUGIN_DIR . '/libs/metabox/uxper-framework.php';

            /**
             * Require Admin Pages
             */
            require_once UXPER_CRYPTO_PLUGIN_DIR . 'includes/init.php';
        }

	}

	Uxper_Crypto::instance()->initialize();
}
